<?php
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                   ATTENTION!
 * If you see this message in your browser (Internet Explorer, Mozilla Firefox, Google Chrome, etc.)
 * this means that PHP is not properly installed on your web server. Please refer to the PHP manual
 * for more details: http://php.net/manual/install.php 
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

    include_once dirname(__FILE__) . '/components/startup.php';
    include_once dirname(__FILE__) . '/components/application.php';
    include_once dirname(__FILE__) . '/' . 'authorization.php';


    include_once dirname(__FILE__) . '/' . 'database_engine/pgsql_engine.php';
    include_once dirname(__FILE__) . '/' . 'components/page/page_includes.php';

    function GetConnectionOptions()
    {
        $result = GetGlobalConnectionOptions();
        $result['client_encoding'] = 'utf8';
        GetApplication()->GetUserAuthentication()->applyIdentityToConnectionOptions($result);
        return $result;
    }

    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class administratifs_personnel_cle_departement_scta_cle_empruntPage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Scta Cle Emprunt');
            $this->SetMenuLabel('Scta Cle Emprunt');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"cle_departement"."scta_cle_emprunt"');
            $this->dataset->addFields(
                array(
                    new StringField('actif'),
                    new DateTimeField('date_d_emprunt'),
                    new DateTimeField('date_de_retour'),
                    new IntegerField('depot'),
                    new IntegerField('remboursement_du_depot'),
                    new StringField('rubrique'),
                    new StringField('rubrique_2'),
                    new StringField('utilisateur_note'),
                    new IntegerField('id_cle'),
                    new IntegerField('id_pers'),
                    new IntegerField('id_cle_emprunt', true, true, true),
                    new IntegerField('id_grp_f_sci'),
                    new DateField('date_due'),
                    new IntegerField('archivage'),
                    new IntegerField('num_bureau'),
                    new StringField('num_formulaire'),
                    new StringField('otrs')
                )
            );
            $this->dataset->AddLookupField('id_cle', 'cle_departement.cle_cles', new IntegerField('id'), new IntegerField('boite', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('id_pers', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA2', 'LT2'), 'LT2');
            $this->dataset->AddLookupField('id_grp_f_sci', 'administratifs.grp_faculte_sciences', new IntegerField('id_grp_f_sci'), new StringField('description', false, false, false, false, 'LA3', 'LT3'), 'LT3');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'actif', 'actif', 'Actif'),
                new FilterColumn($this->dataset, 'date_d_emprunt', 'date_d_emprunt', 'Date D Emprunt'),
                new FilterColumn($this->dataset, 'date_de_retour', 'date_de_retour', 'Date De Retour'),
                new FilterColumn($this->dataset, 'depot', 'depot', 'Depot'),
                new FilterColumn($this->dataset, 'remboursement_du_depot', 'remboursement_du_depot', 'Remboursement Du Depot'),
                new FilterColumn($this->dataset, 'rubrique', 'rubrique', 'Rubrique'),
                new FilterColumn($this->dataset, 'rubrique_2', 'rubrique_2', 'Rubrique 2'),
                new FilterColumn($this->dataset, 'utilisateur_note', 'utilisateur_note', 'Utilisateur Note'),
                new FilterColumn($this->dataset, 'id_cle', 'LA1', 'Id Cle'),
                new FilterColumn($this->dataset, 'id_pers', 'LA2', 'Id Pers'),
                new FilterColumn($this->dataset, 'id_cle_emprunt', 'id_cle_emprunt', 'Id Cle Emprunt'),
                new FilterColumn($this->dataset, 'id_grp_f_sci', 'LA3', 'Id Grp F Sci'),
                new FilterColumn($this->dataset, 'date_due', 'date_due', 'Date Due'),
                new FilterColumn($this->dataset, 'archivage', 'archivage', 'Archivage'),
                new FilterColumn($this->dataset, 'num_bureau', 'num_bureau', 'Num Bureau'),
                new FilterColumn($this->dataset, 'num_formulaire', 'num_formulaire', 'Num Formulaire'),
                new FilterColumn($this->dataset, 'otrs', 'otrs', 'Otrs')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['actif'])
                ->addColumn($columns['date_d_emprunt'])
                ->addColumn($columns['date_de_retour'])
                ->addColumn($columns['depot'])
                ->addColumn($columns['remboursement_du_depot'])
                ->addColumn($columns['rubrique'])
                ->addColumn($columns['rubrique_2'])
                ->addColumn($columns['utilisateur_note'])
                ->addColumn($columns['id_cle'])
                ->addColumn($columns['id_pers'])
                ->addColumn($columns['id_cle_emprunt'])
                ->addColumn($columns['id_grp_f_sci'])
                ->addColumn($columns['date_due'])
                ->addColumn($columns['archivage'])
                ->addColumn($columns['num_bureau'])
                ->addColumn($columns['num_formulaire'])
                ->addColumn($columns['otrs']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('date_d_emprunt')
                ->setOptionsFor('date_de_retour')
                ->setOptionsFor('id_cle')
                ->setOptionsFor('id_pers')
                ->setOptionsFor('id_grp_f_sci')
                ->setOptionsFor('date_due');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('actif_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['actif'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('date_d_emprunt_edit', false, 'Y-m-d H:i:s');
            
            $filterBuilder->addColumn(
                $columns['date_d_emprunt'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('date_de_retour_edit', false, 'Y-m-d H:i:s');
            
            $filterBuilder->addColumn(
                $columns['date_de_retour'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('depot_edit');
            
            $filterBuilder->addColumn(
                $columns['depot'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('remboursement_du_depot_edit');
            
            $filterBuilder->addColumn(
                $columns['remboursement_du_depot'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('rubrique_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['rubrique'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('rubrique_2_edit');
            
            $filterBuilder->addColumn(
                $columns['rubrique_2'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('utilisateur_note');
            
            $filterBuilder->addColumn(
                $columns['utilisateur_note'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_cle_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel_cle_departement_scta_cle_emprunt_id_cle_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_cle', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel_cle_departement_scta_cle_emprunt_id_cle_search');
            
            $filterBuilder->addColumn(
                $columns['id_cle'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_pers_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel_cle_departement_scta_cle_emprunt_id_pers_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_pers', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel_cle_departement_scta_cle_emprunt_id_pers_search');
            
            $text_editor = new TextEdit('id_pers');
            
            $filterBuilder->addColumn(
                $columns['id_pers'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_cle_emprunt_edit');
            
            $filterBuilder->addColumn(
                $columns['id_cle_emprunt'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_grp_f_sci_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel_cle_departement_scta_cle_emprunt_id_grp_f_sci_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_grp_f_sci', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel_cle_departement_scta_cle_emprunt_id_grp_f_sci_search');
            
            $text_editor = new TextEdit('id_grp_f_sci');
            
            $filterBuilder->addColumn(
                $columns['id_grp_f_sci'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TimeEdit('date_due_edit', 'H:i:s');
            
            $filterBuilder->addColumn(
                $columns['date_due'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('archivage_edit');
            
            $filterBuilder->addColumn(
                $columns['archivage'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('num_bureau_edit');
            
            $filterBuilder->addColumn(
                $columns['num_bureau'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('num_formulaire_edit');
            
            $filterBuilder->addColumn(
                $columns['num_formulaire'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('otrs');
            
            $filterBuilder->addColumn(
                $columns['otrs'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for actif field
            //
            $column = new TextViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_d_emprunt field
            //
            $column = new DateTimeViewColumn('date_d_emprunt', 'date_d_emprunt', 'Date D Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Date De Retour', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for depot field
            //
            $column = new NumberViewColumn('depot', 'depot', 'Depot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for remboursement_du_depot field
            //
            $column = new NumberViewColumn('remboursement_du_depot', 'remboursement_du_depot', 'Remboursement Du Depot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for rubrique field
            //
            $column = new TextViewColumn('rubrique', 'rubrique', 'Rubrique', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for rubrique_2 field
            //
            $column = new TextViewColumn('rubrique_2', 'rubrique_2', 'Rubrique 2', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for utilisateur_note field
            //
            $column = new TextViewColumn('utilisateur_note', 'utilisateur_note', 'Utilisateur Note', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for boite field
            //
            $column = new NumberViewColumn('id_cle', 'LA1', 'Id Cle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers', 'LA2', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_cle_emprunt field
            //
            $column = new NumberViewColumn('id_cle_emprunt', 'id_cle_emprunt', 'Id Cle Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for description field
            //
            $column = new TextViewColumn('id_grp_f_sci', 'LA3', 'Id Grp F Sci', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_due field
            //
            $column = new DateTimeViewColumn('date_due', 'date_due', 'Date Due', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('H:i:s');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for archivage field
            //
            $column = new NumberViewColumn('archivage', 'archivage', 'Archivage', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for num_bureau field
            //
            $column = new NumberViewColumn('num_bureau', 'num_bureau', 'Num Bureau', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for num_formulaire field
            //
            $column = new NumberViewColumn('num_formulaire', 'num_formulaire', 'Num Formulaire', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for otrs field
            //
            $column = new TextViewColumn('otrs', 'otrs', 'Otrs', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for actif field
            //
            $column = new TextViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_d_emprunt field
            //
            $column = new DateTimeViewColumn('date_d_emprunt', 'date_d_emprunt', 'Date D Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Date De Retour', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for depot field
            //
            $column = new NumberViewColumn('depot', 'depot', 'Depot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for remboursement_du_depot field
            //
            $column = new NumberViewColumn('remboursement_du_depot', 'remboursement_du_depot', 'Remboursement Du Depot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for rubrique field
            //
            $column = new TextViewColumn('rubrique', 'rubrique', 'Rubrique', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for rubrique_2 field
            //
            $column = new TextViewColumn('rubrique_2', 'rubrique_2', 'Rubrique 2', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for utilisateur_note field
            //
            $column = new TextViewColumn('utilisateur_note', 'utilisateur_note', 'Utilisateur Note', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for boite field
            //
            $column = new NumberViewColumn('id_cle', 'LA1', 'Id Cle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers', 'LA2', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_cle_emprunt field
            //
            $column = new NumberViewColumn('id_cle_emprunt', 'id_cle_emprunt', 'Id Cle Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('id_grp_f_sci', 'LA3', 'Id Grp F Sci', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_due field
            //
            $column = new DateTimeViewColumn('date_due', 'date_due', 'Date Due', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('H:i:s');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for archivage field
            //
            $column = new NumberViewColumn('archivage', 'archivage', 'Archivage', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for num_bureau field
            //
            $column = new NumberViewColumn('num_bureau', 'num_bureau', 'Num Bureau', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for num_formulaire field
            //
            $column = new NumberViewColumn('num_formulaire', 'num_formulaire', 'Num Formulaire', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for otrs field
            //
            $column = new TextViewColumn('otrs', 'otrs', 'Otrs', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for actif field
            //
            $editor = new TextEdit('actif_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Actif', 'actif', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_d_emprunt field
            //
            $editor = new DateTimeEdit('date_d_emprunt_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Date D Emprunt', 'date_d_emprunt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_de_retour field
            //
            $editor = new DateTimeEdit('date_de_retour_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Date De Retour', 'date_de_retour', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for depot field
            //
            $editor = new TextEdit('depot_edit');
            $editColumn = new CustomEditColumn('Depot', 'depot', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for remboursement_du_depot field
            //
            $editor = new TextEdit('remboursement_du_depot_edit');
            $editColumn = new CustomEditColumn('Remboursement Du Depot', 'remboursement_du_depot', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for rubrique field
            //
            $editor = new TextEdit('rubrique_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Rubrique', 'rubrique', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for rubrique_2 field
            //
            $editor = new TextEdit('rubrique_2_edit');
            $editColumn = new CustomEditColumn('Rubrique 2', 'rubrique_2', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for utilisateur_note field
            //
            $editor = new TextAreaEdit('utilisateur_note_edit', 50, 8);
            $editColumn = new CustomEditColumn('Utilisateur Note', 'utilisateur_note', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_cle field
            //
            $editor = new DynamicCombobox('id_cle_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"cle_departement"."cle_cles"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new IntegerField('boite'),
                    new StringField('crochet'),
                    new StringField('num_cle'),
                    new StringField('description'),
                    new StringField('no_local'),
                    new StringField('ref_local'),
                    new IntegerField('id_local'),
                    new StringField('nb_total'),
                    new StringField('nb_circulation'),
                    new StringField('nb_disponible')
                )
            );
            $lookupDataset->setOrderByField('boite', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Cle', 'id_cle', 'LA1', 'edit_administratifs_personnel_cle_departement_scta_cle_emprunt_id_cle_search', $editor, $this->dataset, $lookupDataset, 'id', 'boite', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_pers field
            //
            $editor = new DynamicCombobox('id_pers_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Pers', 'id_pers', 'LA2', 'edit_administratifs_personnel_cle_departement_scta_cle_emprunt_id_pers_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_grp_f_sci field
            //
            $editor = new DynamicCombobox('id_grp_f_sci_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."grp_faculte_sciences"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_grp_f_sci', true, true),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('description', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Grp F Sci', 'id_grp_f_sci', 'LA3', 'edit_administratifs_personnel_cle_departement_scta_cle_emprunt_id_grp_f_sci_search', $editor, $this->dataset, $lookupDataset, 'id_grp_f_sci', 'description', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_due field
            //
            $editor = new TimeEdit('date_due_edit', 'H:i:s');
            $editColumn = new CustomEditColumn('Date Due', 'date_due', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for archivage field
            //
            $editor = new TextEdit('archivage_edit');
            $editColumn = new CustomEditColumn('Archivage', 'archivage', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for num_bureau field
            //
            $editor = new TextEdit('num_bureau_edit');
            $editColumn = new CustomEditColumn('Num Bureau', 'num_bureau', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for num_formulaire field
            //
            $editor = new TextEdit('num_formulaire_edit');
            $editColumn = new CustomEditColumn('Num Formulaire', 'num_formulaire', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for otrs field
            //
            $editor = new TextAreaEdit('otrs_edit', 50, 8);
            $editColumn = new CustomEditColumn('Otrs', 'otrs', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for actif field
            //
            $editor = new TextEdit('actif_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Actif', 'actif', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_d_emprunt field
            //
            $editor = new DateTimeEdit('date_d_emprunt_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Date D Emprunt', 'date_d_emprunt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_de_retour field
            //
            $editor = new DateTimeEdit('date_de_retour_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Date De Retour', 'date_de_retour', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for depot field
            //
            $editor = new TextEdit('depot_edit');
            $editColumn = new CustomEditColumn('Depot', 'depot', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for remboursement_du_depot field
            //
            $editor = new TextEdit('remboursement_du_depot_edit');
            $editColumn = new CustomEditColumn('Remboursement Du Depot', 'remboursement_du_depot', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for rubrique field
            //
            $editor = new TextEdit('rubrique_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Rubrique', 'rubrique', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for rubrique_2 field
            //
            $editor = new TextEdit('rubrique_2_edit');
            $editColumn = new CustomEditColumn('Rubrique 2', 'rubrique_2', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for utilisateur_note field
            //
            $editor = new TextAreaEdit('utilisateur_note_edit', 50, 8);
            $editColumn = new CustomEditColumn('Utilisateur Note', 'utilisateur_note', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_cle field
            //
            $editor = new DynamicCombobox('id_cle_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"cle_departement"."cle_cles"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new IntegerField('boite'),
                    new StringField('crochet'),
                    new StringField('num_cle'),
                    new StringField('description'),
                    new StringField('no_local'),
                    new StringField('ref_local'),
                    new IntegerField('id_local'),
                    new StringField('nb_total'),
                    new StringField('nb_circulation'),
                    new StringField('nb_disponible')
                )
            );
            $lookupDataset->setOrderByField('boite', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Cle', 'id_cle', 'LA1', 'multi_edit_administratifs_personnel_cle_departement_scta_cle_emprunt_id_cle_search', $editor, $this->dataset, $lookupDataset, 'id', 'boite', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_pers field
            //
            $editor = new DynamicCombobox('id_pers_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Pers', 'id_pers', 'LA2', 'multi_edit_administratifs_personnel_cle_departement_scta_cle_emprunt_id_pers_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_grp_f_sci field
            //
            $editor = new DynamicCombobox('id_grp_f_sci_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."grp_faculte_sciences"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_grp_f_sci', true, true),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('description', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Grp F Sci', 'id_grp_f_sci', 'LA3', 'multi_edit_administratifs_personnel_cle_departement_scta_cle_emprunt_id_grp_f_sci_search', $editor, $this->dataset, $lookupDataset, 'id_grp_f_sci', 'description', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_due field
            //
            $editor = new TimeEdit('date_due_edit', 'H:i:s');
            $editColumn = new CustomEditColumn('Date Due', 'date_due', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for archivage field
            //
            $editor = new TextEdit('archivage_edit');
            $editColumn = new CustomEditColumn('Archivage', 'archivage', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for num_bureau field
            //
            $editor = new TextEdit('num_bureau_edit');
            $editColumn = new CustomEditColumn('Num Bureau', 'num_bureau', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for num_formulaire field
            //
            $editor = new TextEdit('num_formulaire_edit');
            $editColumn = new CustomEditColumn('Num Formulaire', 'num_formulaire', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for otrs field
            //
            $editor = new TextAreaEdit('otrs_edit', 50, 8);
            $editColumn = new CustomEditColumn('Otrs', 'otrs', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for actif field
            //
            $editor = new TextEdit('actif_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Actif', 'actif', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_d_emprunt field
            //
            $editor = new DateTimeEdit('date_d_emprunt_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Date D Emprunt', 'date_d_emprunt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_de_retour field
            //
            $editor = new DateTimeEdit('date_de_retour_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Date De Retour', 'date_de_retour', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for depot field
            //
            $editor = new TextEdit('depot_edit');
            $editColumn = new CustomEditColumn('Depot', 'depot', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for remboursement_du_depot field
            //
            $editor = new TextEdit('remboursement_du_depot_edit');
            $editColumn = new CustomEditColumn('Remboursement Du Depot', 'remboursement_du_depot', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for rubrique field
            //
            $editor = new TextEdit('rubrique_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Rubrique', 'rubrique', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for rubrique_2 field
            //
            $editor = new TextEdit('rubrique_2_edit');
            $editColumn = new CustomEditColumn('Rubrique 2', 'rubrique_2', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for utilisateur_note field
            //
            $editor = new TextAreaEdit('utilisateur_note_edit', 50, 8);
            $editColumn = new CustomEditColumn('Utilisateur Note', 'utilisateur_note', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_cle field
            //
            $editor = new DynamicCombobox('id_cle_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"cle_departement"."cle_cles"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new IntegerField('boite'),
                    new StringField('crochet'),
                    new StringField('num_cle'),
                    new StringField('description'),
                    new StringField('no_local'),
                    new StringField('ref_local'),
                    new IntegerField('id_local'),
                    new StringField('nb_total'),
                    new StringField('nb_circulation'),
                    new StringField('nb_disponible')
                )
            );
            $lookupDataset->setOrderByField('boite', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Cle', 'id_cle', 'LA1', 'insert_administratifs_personnel_cle_departement_scta_cle_emprunt_id_cle_search', $editor, $this->dataset, $lookupDataset, 'id', 'boite', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_pers field
            //
            $editor = new DynamicCombobox('id_pers_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Pers', 'id_pers', 'LA2', 'insert_administratifs_personnel_cle_departement_scta_cle_emprunt_id_pers_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_grp_f_sci field
            //
            $editor = new DynamicCombobox('id_grp_f_sci_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."grp_faculte_sciences"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_grp_f_sci', true, true),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('description', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Grp F Sci', 'id_grp_f_sci', 'LA3', 'insert_administratifs_personnel_cle_departement_scta_cle_emprunt_id_grp_f_sci_search', $editor, $this->dataset, $lookupDataset, 'id_grp_f_sci', 'description', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_due field
            //
            $editor = new TimeEdit('date_due_edit', 'H:i:s');
            $editColumn = new CustomEditColumn('Date Due', 'date_due', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for archivage field
            //
            $editor = new TextEdit('archivage_edit');
            $editColumn = new CustomEditColumn('Archivage', 'archivage', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for num_bureau field
            //
            $editor = new TextEdit('num_bureau_edit');
            $editColumn = new CustomEditColumn('Num Bureau', 'num_bureau', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for num_formulaire field
            //
            $editor = new TextEdit('num_formulaire_edit');
            $editColumn = new CustomEditColumn('Num Formulaire', 'num_formulaire', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for otrs field
            //
            $editor = new TextAreaEdit('otrs_edit', 50, 8);
            $editColumn = new CustomEditColumn('Otrs', 'otrs', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for actif field
            //
            $column = new TextViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_d_emprunt field
            //
            $column = new DateTimeViewColumn('date_d_emprunt', 'date_d_emprunt', 'Date D Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Date De Retour', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddPrintColumn($column);
            
            //
            // View column for depot field
            //
            $column = new NumberViewColumn('depot', 'depot', 'Depot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for remboursement_du_depot field
            //
            $column = new NumberViewColumn('remboursement_du_depot', 'remboursement_du_depot', 'Remboursement Du Depot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for rubrique field
            //
            $column = new TextViewColumn('rubrique', 'rubrique', 'Rubrique', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for rubrique_2 field
            //
            $column = new TextViewColumn('rubrique_2', 'rubrique_2', 'Rubrique 2', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for utilisateur_note field
            //
            $column = new TextViewColumn('utilisateur_note', 'utilisateur_note', 'Utilisateur Note', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for boite field
            //
            $column = new NumberViewColumn('id_cle', 'LA1', 'Id Cle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers', 'LA2', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_cle_emprunt field
            //
            $column = new NumberViewColumn('id_cle_emprunt', 'id_cle_emprunt', 'Id Cle Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('id_grp_f_sci', 'LA3', 'Id Grp F Sci', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_due field
            //
            $column = new DateTimeViewColumn('date_due', 'date_due', 'Date Due', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('H:i:s');
            $grid->AddPrintColumn($column);
            
            //
            // View column for archivage field
            //
            $column = new NumberViewColumn('archivage', 'archivage', 'Archivage', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for num_bureau field
            //
            $column = new NumberViewColumn('num_bureau', 'num_bureau', 'Num Bureau', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for num_formulaire field
            //
            $column = new NumberViewColumn('num_formulaire', 'num_formulaire', 'Num Formulaire', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for otrs field
            //
            $column = new TextViewColumn('otrs', 'otrs', 'Otrs', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for actif field
            //
            $column = new TextViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_d_emprunt field
            //
            $column = new DateTimeViewColumn('date_d_emprunt', 'date_d_emprunt', 'Date D Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddExportColumn($column);
            
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Date De Retour', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddExportColumn($column);
            
            //
            // View column for depot field
            //
            $column = new NumberViewColumn('depot', 'depot', 'Depot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for remboursement_du_depot field
            //
            $column = new NumberViewColumn('remboursement_du_depot', 'remboursement_du_depot', 'Remboursement Du Depot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for rubrique field
            //
            $column = new TextViewColumn('rubrique', 'rubrique', 'Rubrique', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for rubrique_2 field
            //
            $column = new TextViewColumn('rubrique_2', 'rubrique_2', 'Rubrique 2', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for utilisateur_note field
            //
            $column = new TextViewColumn('utilisateur_note', 'utilisateur_note', 'Utilisateur Note', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for boite field
            //
            $column = new NumberViewColumn('id_cle', 'LA1', 'Id Cle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers', 'LA2', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_cle_emprunt field
            //
            $column = new NumberViewColumn('id_cle_emprunt', 'id_cle_emprunt', 'Id Cle Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('id_grp_f_sci', 'LA3', 'Id Grp F Sci', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_due field
            //
            $column = new DateTimeViewColumn('date_due', 'date_due', 'Date Due', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('H:i:s');
            $grid->AddExportColumn($column);
            
            //
            // View column for archivage field
            //
            $column = new NumberViewColumn('archivage', 'archivage', 'Archivage', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for num_bureau field
            //
            $column = new NumberViewColumn('num_bureau', 'num_bureau', 'Num Bureau', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for num_formulaire field
            //
            $column = new NumberViewColumn('num_formulaire', 'num_formulaire', 'Num Formulaire', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for otrs field
            //
            $column = new TextViewColumn('otrs', 'otrs', 'Otrs', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for actif field
            //
            $column = new TextViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_d_emprunt field
            //
            $column = new DateTimeViewColumn('date_d_emprunt', 'date_d_emprunt', 'Date D Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Date De Retour', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddCompareColumn($column);
            
            //
            // View column for depot field
            //
            $column = new NumberViewColumn('depot', 'depot', 'Depot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for remboursement_du_depot field
            //
            $column = new NumberViewColumn('remboursement_du_depot', 'remboursement_du_depot', 'Remboursement Du Depot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for rubrique field
            //
            $column = new TextViewColumn('rubrique', 'rubrique', 'Rubrique', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for rubrique_2 field
            //
            $column = new TextViewColumn('rubrique_2', 'rubrique_2', 'Rubrique 2', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for utilisateur_note field
            //
            $column = new TextViewColumn('utilisateur_note', 'utilisateur_note', 'Utilisateur Note', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for boite field
            //
            $column = new NumberViewColumn('id_cle', 'LA1', 'Id Cle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers', 'LA2', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('id_grp_f_sci', 'LA3', 'Id Grp F Sci', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_due field
            //
            $column = new DateTimeViewColumn('date_due', 'date_due', 'Date Due', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('H:i:s');
            $grid->AddCompareColumn($column);
            
            //
            // View column for archivage field
            //
            $column = new NumberViewColumn('archivage', 'archivage', 'Archivage', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for num_bureau field
            //
            $column = new NumberViewColumn('num_bureau', 'num_bureau', 'Num Bureau', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for num_formulaire field
            //
            $column = new NumberViewColumn('num_formulaire', 'num_formulaire', 'Num Formulaire', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for otrs field
            //
            $column = new TextViewColumn('otrs', 'otrs', 'Otrs', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(true);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"cle_departement"."cle_cles"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new IntegerField('boite'),
                    new StringField('crochet'),
                    new StringField('num_cle'),
                    new StringField('description'),
                    new StringField('no_local'),
                    new StringField('ref_local'),
                    new IntegerField('id_local'),
                    new StringField('nb_total'),
                    new StringField('nb_circulation'),
                    new StringField('nb_disponible')
                )
            );
            $lookupDataset->setOrderByField('boite', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel_cle_departement_scta_cle_emprunt_id_cle_search', 'id', 'boite', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel_cle_departement_scta_cle_emprunt_id_pers_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."grp_faculte_sciences"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_grp_f_sci', true, true),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('description', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel_cle_departement_scta_cle_emprunt_id_grp_f_sci_search', 'id_grp_f_sci', 'description', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"cle_departement"."cle_cles"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new IntegerField('boite'),
                    new StringField('crochet'),
                    new StringField('num_cle'),
                    new StringField('description'),
                    new StringField('no_local'),
                    new StringField('ref_local'),
                    new IntegerField('id_local'),
                    new StringField('nb_total'),
                    new StringField('nb_circulation'),
                    new StringField('nb_disponible')
                )
            );
            $lookupDataset->setOrderByField('boite', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel_cle_departement_scta_cle_emprunt_id_cle_search', 'id', 'boite', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel_cle_departement_scta_cle_emprunt_id_pers_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."grp_faculte_sciences"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_grp_f_sci', true, true),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('description', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel_cle_departement_scta_cle_emprunt_id_grp_f_sci_search', 'id_grp_f_sci', 'description', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"cle_departement"."cle_cles"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new IntegerField('boite'),
                    new StringField('crochet'),
                    new StringField('num_cle'),
                    new StringField('description'),
                    new StringField('no_local'),
                    new StringField('ref_local'),
                    new IntegerField('id_local'),
                    new StringField('nb_total'),
                    new StringField('nb_circulation'),
                    new StringField('nb_disponible')
                )
            );
            $lookupDataset->setOrderByField('boite', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel_cle_departement_scta_cle_emprunt_id_cle_search', 'id', 'boite', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel_cle_departement_scta_cle_emprunt_id_pers_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."grp_faculte_sciences"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_grp_f_sci', true, true),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('description', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel_cle_departement_scta_cle_emprunt_id_grp_f_sci_search', 'id_grp_f_sci', 'description', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"cle_departement"."cle_cles"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new IntegerField('boite'),
                    new StringField('crochet'),
                    new StringField('num_cle'),
                    new StringField('description'),
                    new StringField('no_local'),
                    new StringField('ref_local'),
                    new IntegerField('id_local'),
                    new StringField('nb_total'),
                    new StringField('nb_circulation'),
                    new StringField('nb_disponible')
                )
            );
            $lookupDataset->setOrderByField('boite', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel_cle_departement_scta_cle_emprunt_id_cle_search', 'id', 'boite', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel_cle_departement_scta_cle_emprunt_id_pers_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."grp_faculte_sciences"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_grp_f_sci', true, true),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('description', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel_cle_departement_scta_cle_emprunt_id_grp_f_sci_search', 'id_grp_f_sci', 'description', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }
    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class administratifs_personnel_materiel_achats_logicielsPage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Achats Logiciels');
            $this->SetMenuLabel('Achats Logiciels');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."achats_logiciels"');
            $this->dataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new IntegerField('rig'),
                    new IntegerField('appel_service'),
                    new IntegerField('id_professeur'),
                    new IntegerField('id_ordinateur'),
                    new IntegerField('id_logiciel'),
                    new StringField('cle_logiciel_numero_serie'),
                    new StringField('commentaires'),
                    new IntegerField('id_professeur_new')
                )
            );
            $this->dataset->AddLookupField('id_professeur_new', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA1', 'LT1'), 'LT1');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'id', 'id', 'Id'),
                new FilterColumn($this->dataset, 'rig', 'rig', 'Rig'),
                new FilterColumn($this->dataset, 'appel_service', 'appel_service', 'Appel Service'),
                new FilterColumn($this->dataset, 'id_professeur', 'id_professeur', 'Id Professeur'),
                new FilterColumn($this->dataset, 'id_ordinateur', 'id_ordinateur', 'Id Ordinateur'),
                new FilterColumn($this->dataset, 'id_logiciel', 'id_logiciel', 'Id Logiciel'),
                new FilterColumn($this->dataset, 'cle_logiciel_numero_serie', 'cle_logiciel_numero_serie', 'Cle Logiciel Numero Serie'),
                new FilterColumn($this->dataset, 'commentaires', 'commentaires', 'Commentaires'),
                new FilterColumn($this->dataset, 'id_professeur_new', 'LA1', 'Id Professeur New')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['id'])
                ->addColumn($columns['rig'])
                ->addColumn($columns['appel_service'])
                ->addColumn($columns['id_professeur'])
                ->addColumn($columns['id_ordinateur'])
                ->addColumn($columns['id_logiciel'])
                ->addColumn($columns['cle_logiciel_numero_serie'])
                ->addColumn($columns['commentaires'])
                ->addColumn($columns['id_professeur_new']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_professeur_new');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('id_edit');
            
            $filterBuilder->addColumn(
                $columns['id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('rig_edit');
            
            $filterBuilder->addColumn(
                $columns['rig'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('appel_service_edit');
            
            $filterBuilder->addColumn(
                $columns['appel_service'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_professeur_edit');
            
            $filterBuilder->addColumn(
                $columns['id_professeur'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_ordinateur_edit');
            
            $filterBuilder->addColumn(
                $columns['id_ordinateur'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_logiciel_edit');
            
            $filterBuilder->addColumn(
                $columns['id_logiciel'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('cle_logiciel_numero_serie_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['cle_logiciel_numero_serie'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('commentaires_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['commentaires'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_professeur_new_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel_materiel_achats_logiciels_id_professeur_new_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_professeur_new', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel_materiel_achats_logiciels_id_professeur_new_search');
            
            $text_editor = new TextEdit('id_professeur_new');
            
            $filterBuilder->addColumn(
                $columns['id_professeur_new'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
    
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for rig field
            //
            $column = new NumberViewColumn('rig', 'rig', 'Rig', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for appel_service field
            //
            $column = new NumberViewColumn('appel_service', 'appel_service', 'Appel Service', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_professeur field
            //
            $column = new NumberViewColumn('id_professeur', 'id_professeur', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_ordinateur field
            //
            $column = new NumberViewColumn('id_ordinateur', 'id_ordinateur', 'Id Ordinateur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_logiciel field
            //
            $column = new NumberViewColumn('id_logiciel', 'id_logiciel', 'Id Logiciel', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for cle_logiciel_numero_serie field
            //
            $column = new TextViewColumn('cle_logiciel_numero_serie', 'cle_logiciel_numero_serie', 'Cle Logiciel Numero Serie', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur_new', 'LA1', 'Id Professeur New', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for rig field
            //
            $column = new NumberViewColumn('rig', 'rig', 'Rig', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for appel_service field
            //
            $column = new NumberViewColumn('appel_service', 'appel_service', 'Appel Service', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_professeur field
            //
            $column = new NumberViewColumn('id_professeur', 'id_professeur', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_ordinateur field
            //
            $column = new NumberViewColumn('id_ordinateur', 'id_ordinateur', 'Id Ordinateur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_logiciel field
            //
            $column = new NumberViewColumn('id_logiciel', 'id_logiciel', 'Id Logiciel', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for cle_logiciel_numero_serie field
            //
            $column = new TextViewColumn('cle_logiciel_numero_serie', 'cle_logiciel_numero_serie', 'Cle Logiciel Numero Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur_new', 'LA1', 'Id Professeur New', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for id field
            //
            $editor = new TextEdit('id_edit');
            $editColumn = new CustomEditColumn('Id', 'id', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for rig field
            //
            $editor = new TextEdit('rig_edit');
            $editColumn = new CustomEditColumn('Rig', 'rig', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for appel_service field
            //
            $editor = new TextEdit('appel_service_edit');
            $editColumn = new CustomEditColumn('Appel Service', 'appel_service', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_professeur field
            //
            $editor = new TextEdit('id_professeur_edit');
            $editColumn = new CustomEditColumn('Id Professeur', 'id_professeur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_ordinateur field
            //
            $editor = new TextEdit('id_ordinateur_edit');
            $editColumn = new CustomEditColumn('Id Ordinateur', 'id_ordinateur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_logiciel field
            //
            $editor = new TextEdit('id_logiciel_edit');
            $editColumn = new CustomEditColumn('Id Logiciel', 'id_logiciel', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for cle_logiciel_numero_serie field
            //
            $editor = new TextEdit('cle_logiciel_numero_serie_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Cle Logiciel Numero Serie', 'cle_logiciel_numero_serie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextEdit('commentaires_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_professeur_new field
            //
            $editor = new DynamicCombobox('id_professeur_new_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Professeur New', 'id_professeur_new', 'LA1', 'edit_administratifs_personnel_materiel_achats_logiciels_id_professeur_new_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for id field
            //
            $editor = new TextEdit('id_edit');
            $editColumn = new CustomEditColumn('Id', 'id', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for rig field
            //
            $editor = new TextEdit('rig_edit');
            $editColumn = new CustomEditColumn('Rig', 'rig', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for appel_service field
            //
            $editor = new TextEdit('appel_service_edit');
            $editColumn = new CustomEditColumn('Appel Service', 'appel_service', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_professeur field
            //
            $editor = new TextEdit('id_professeur_edit');
            $editColumn = new CustomEditColumn('Id Professeur', 'id_professeur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_ordinateur field
            //
            $editor = new TextEdit('id_ordinateur_edit');
            $editColumn = new CustomEditColumn('Id Ordinateur', 'id_ordinateur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_logiciel field
            //
            $editor = new TextEdit('id_logiciel_edit');
            $editColumn = new CustomEditColumn('Id Logiciel', 'id_logiciel', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for cle_logiciel_numero_serie field
            //
            $editor = new TextEdit('cle_logiciel_numero_serie_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Cle Logiciel Numero Serie', 'cle_logiciel_numero_serie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextEdit('commentaires_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_professeur_new field
            //
            $editor = new DynamicCombobox('id_professeur_new_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Professeur New', 'id_professeur_new', 'LA1', 'multi_edit_administratifs_personnel_materiel_achats_logiciels_id_professeur_new_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for id field
            //
            $editor = new TextEdit('id_edit');
            $editColumn = new CustomEditColumn('Id', 'id', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for rig field
            //
            $editor = new TextEdit('rig_edit');
            $editColumn = new CustomEditColumn('Rig', 'rig', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for appel_service field
            //
            $editor = new TextEdit('appel_service_edit');
            $editColumn = new CustomEditColumn('Appel Service', 'appel_service', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_professeur field
            //
            $editor = new TextEdit('id_professeur_edit');
            $editColumn = new CustomEditColumn('Id Professeur', 'id_professeur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_ordinateur field
            //
            $editor = new TextEdit('id_ordinateur_edit');
            $editColumn = new CustomEditColumn('Id Ordinateur', 'id_ordinateur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_logiciel field
            //
            $editor = new TextEdit('id_logiciel_edit');
            $editColumn = new CustomEditColumn('Id Logiciel', 'id_logiciel', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for cle_logiciel_numero_serie field
            //
            $editor = new TextEdit('cle_logiciel_numero_serie_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Cle Logiciel Numero Serie', 'cle_logiciel_numero_serie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextEdit('commentaires_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_professeur_new field
            //
            $editor = new DynamicCombobox('id_professeur_new_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Professeur New', 'id_professeur_new', 'LA1', 'insert_administratifs_personnel_materiel_achats_logiciels_id_professeur_new_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(false && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for rig field
            //
            $column = new NumberViewColumn('rig', 'rig', 'Rig', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for appel_service field
            //
            $column = new NumberViewColumn('appel_service', 'appel_service', 'Appel Service', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_professeur field
            //
            $column = new NumberViewColumn('id_professeur', 'id_professeur', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_ordinateur field
            //
            $column = new NumberViewColumn('id_ordinateur', 'id_ordinateur', 'Id Ordinateur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_logiciel field
            //
            $column = new NumberViewColumn('id_logiciel', 'id_logiciel', 'Id Logiciel', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for cle_logiciel_numero_serie field
            //
            $column = new TextViewColumn('cle_logiciel_numero_serie', 'cle_logiciel_numero_serie', 'Cle Logiciel Numero Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur_new', 'LA1', 'Id Professeur New', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for rig field
            //
            $column = new NumberViewColumn('rig', 'rig', 'Rig', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for appel_service field
            //
            $column = new NumberViewColumn('appel_service', 'appel_service', 'Appel Service', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for id_professeur field
            //
            $column = new NumberViewColumn('id_professeur', 'id_professeur', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for id_ordinateur field
            //
            $column = new NumberViewColumn('id_ordinateur', 'id_ordinateur', 'Id Ordinateur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for id_logiciel field
            //
            $column = new NumberViewColumn('id_logiciel', 'id_logiciel', 'Id Logiciel', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for cle_logiciel_numero_serie field
            //
            $column = new TextViewColumn('cle_logiciel_numero_serie', 'cle_logiciel_numero_serie', 'Cle Logiciel Numero Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur_new', 'LA1', 'Id Professeur New', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for rig field
            //
            $column = new NumberViewColumn('rig', 'rig', 'Rig', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for appel_service field
            //
            $column = new NumberViewColumn('appel_service', 'appel_service', 'Appel Service', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_professeur field
            //
            $column = new NumberViewColumn('id_professeur', 'id_professeur', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_ordinateur field
            //
            $column = new NumberViewColumn('id_ordinateur', 'id_ordinateur', 'Id Ordinateur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_logiciel field
            //
            $column = new NumberViewColumn('id_logiciel', 'id_logiciel', 'Id Logiciel', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for cle_logiciel_numero_serie field
            //
            $column = new TextViewColumn('cle_logiciel_numero_serie', 'cle_logiciel_numero_serie', 'Cle Logiciel Numero Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur_new', 'LA1', 'Id Professeur New', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(false);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(false);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && false);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(false);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(true);
            $this->setAllowedActions(array());
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel_materiel_achats_logiciels_id_professeur_new_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel_materiel_achats_logiciels_id_professeur_new_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel_materiel_achats_logiciels_id_professeur_new_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel_materiel_achats_logiciels_id_professeur_new_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }
    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class administratifs_personnel_materiel_mat_informatiquePage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Mat Informatique');
            $this->SetMenuLabel('Mat Informatique');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_informatique"');
            $this->dataset->addFields(
                array(
                    new IntegerField('id_mat_inf', true, true, true),
                    new IntegerField('id_loc'),
                    new StringField('no_uqam'),
                    new StringField('syst_expl'),
                    new StringField('marque'),
                    new StringField('description'),
                    new IntegerField('id_grp'),
                    new StringField('fournisseur'),
                    new StringField('no_serie'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new StringField('prix'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d'),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new StringField('adresse_ip'),
                    new IntegerField('id_adresse_ip'),
                    new IntegerField('id_pers'),
                    new StringField('disponible'),
                    new IntegerField('disponible_web'),
                    new StringField('local'),
                    new IntegerField('id'),
                    new IntegerField('id_pers_new'),
                    new IntegerField('id_inf', false, false, true)
                )
            );
            $this->dataset->AddLookupField('id_loc', 'administratifs.locals', new IntegerField('id_loc'), new StringField('no_loc', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('id_pers_new', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA2', 'LT2'), 'LT2');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'id_mat_inf', 'id_mat_inf', 'Id Mat Inf'),
                new FilterColumn($this->dataset, 'id_loc', 'LA1', 'Id Loc'),
                new FilterColumn($this->dataset, 'no_uqam', 'no_uqam', 'No Uqam'),
                new FilterColumn($this->dataset, 'syst_expl', 'syst_expl', 'Syst Expl'),
                new FilterColumn($this->dataset, 'marque', 'marque', 'Marque'),
                new FilterColumn($this->dataset, 'description', 'description', 'Description'),
                new FilterColumn($this->dataset, 'id_grp', 'id_grp', 'Id Grp'),
                new FilterColumn($this->dataset, 'fournisseur', 'fournisseur', 'Fournisseur'),
                new FilterColumn($this->dataset, 'no_serie', 'no_serie', 'No Serie'),
                new FilterColumn($this->dataset, 'duree_vie', 'duree_vie', 'Duree Vie'),
                new FilterColumn($this->dataset, 'etat', 'etat', 'Etat'),
                new FilterColumn($this->dataset, 'no_requis', 'no_requis', 'No Requis'),
                new FilterColumn($this->dataset, 'no_comman', 'no_comman', 'No Comman'),
                new FilterColumn($this->dataset, 'prix', 'prix', 'Prix'),
                new FilterColumn($this->dataset, 'date_achat', 'date_achat', 'Date Achat'),
                new FilterColumn($this->dataset, 'date_recept', 'date_recept', 'Date Recept'),
                new FilterColumn($this->dataset, 'date_fin_d', 'date_fin_d', 'Date Fin D'),
                new FilterColumn($this->dataset, 'code_compt', 'code_compt', 'Code Compt'),
                new FilterColumn($this->dataset, 'commentaires', 'commentaires', 'Commentaires'),
                new FilterColumn($this->dataset, 'adresse_ip', 'adresse_ip', 'Adresse Ip'),
                new FilterColumn($this->dataset, 'id_adresse_ip', 'id_adresse_ip', 'Id Adresse Ip'),
                new FilterColumn($this->dataset, 'id_pers', 'id_pers', 'Id Pers'),
                new FilterColumn($this->dataset, 'disponible', 'disponible', 'Disponible'),
                new FilterColumn($this->dataset, 'disponible_web', 'disponible_web', 'Disponible Web'),
                new FilterColumn($this->dataset, 'local', 'local', 'Local'),
                new FilterColumn($this->dataset, 'id', 'id', 'Id'),
                new FilterColumn($this->dataset, 'id_pers_new', 'LA2', 'Id Pers New'),
                new FilterColumn($this->dataset, 'id_inf', 'id_inf', 'Id Inf')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['id_mat_inf'])
                ->addColumn($columns['id_loc'])
                ->addColumn($columns['no_uqam'])
                ->addColumn($columns['syst_expl'])
                ->addColumn($columns['marque'])
                ->addColumn($columns['description'])
                ->addColumn($columns['id_grp'])
                ->addColumn($columns['fournisseur'])
                ->addColumn($columns['no_serie'])
                ->addColumn($columns['duree_vie'])
                ->addColumn($columns['etat'])
                ->addColumn($columns['no_requis'])
                ->addColumn($columns['no_comman'])
                ->addColumn($columns['prix'])
                ->addColumn($columns['date_achat'])
                ->addColumn($columns['date_recept'])
                ->addColumn($columns['date_fin_d'])
                ->addColumn($columns['code_compt'])
                ->addColumn($columns['commentaires'])
                ->addColumn($columns['adresse_ip'])
                ->addColumn($columns['id_adresse_ip'])
                ->addColumn($columns['id_pers'])
                ->addColumn($columns['disponible'])
                ->addColumn($columns['disponible_web'])
                ->addColumn($columns['local'])
                ->addColumn($columns['id'])
                ->addColumn($columns['id_pers_new'])
                ->addColumn($columns['id_inf']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_loc')
                ->setOptionsFor('id_pers_new');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('id_mat_inf_edit');
            
            $filterBuilder->addColumn(
                $columns['id_mat_inf'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel_materiel_mat_informatique_id_loc_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_loc', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel_materiel_mat_informatique_id_loc_search');
            
            $text_editor = new TextEdit('id_loc');
            
            $filterBuilder->addColumn(
                $columns['id_loc'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_uqam');
            
            $filterBuilder->addColumn(
                $columns['no_uqam'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('syst_expl_edit');
            $main_editor->SetMaxLength(40);
            
            $filterBuilder->addColumn(
                $columns['syst_expl'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('marque_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['marque'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('description_edit');
            $main_editor->SetMaxLength(90);
            
            $filterBuilder->addColumn(
                $columns['description'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_grp_edit');
            
            $filterBuilder->addColumn(
                $columns['id_grp'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('fournisseur_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['fournisseur'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_serie_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['no_serie'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('duree_vie_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['duree_vie'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('etat_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['etat'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_requis_edit');
            
            $filterBuilder->addColumn(
                $columns['no_requis'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_comman_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['no_comman'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('prix');
            
            $filterBuilder->addColumn(
                $columns['prix'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('date_achat');
            
            $filterBuilder->addColumn(
                $columns['date_achat'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('date_recept');
            
            $filterBuilder->addColumn(
                $columns['date_recept'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('date_fin_d_edit');
            $main_editor->SetMaxLength(40);
            
            $filterBuilder->addColumn(
                $columns['date_fin_d'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('code_compt_edit');
            
            $filterBuilder->addColumn(
                $columns['code_compt'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('commentaires_edit');
            $main_editor->SetMaxLength(70);
            
            $filterBuilder->addColumn(
                $columns['commentaires'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('adresse_ip_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['adresse_ip'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_adresse_ip_edit');
            
            $filterBuilder->addColumn(
                $columns['id_adresse_ip'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_pers_edit');
            
            $filterBuilder->addColumn(
                $columns['id_pers'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('disponible');
            
            $filterBuilder->addColumn(
                $columns['disponible'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('disponible_web_edit');
            
            $filterBuilder->addColumn(
                $columns['disponible_web'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('local_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['local'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_edit');
            
            $filterBuilder->addColumn(
                $columns['id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_pers_new_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel_materiel_mat_informatique_id_pers_new_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_pers_new', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel_materiel_mat_informatique_id_pers_new_search');
            
            $text_editor = new TextEdit('id_pers_new');
            
            $filterBuilder->addColumn(
                $columns['id_pers_new'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_inf_edit');
            
            $filterBuilder->addColumn(
                $columns['id_inf'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for id_mat_inf field
            //
            $column = new NumberViewColumn('id_mat_inf', 'id_mat_inf', 'Id Mat Inf', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_uqam field
            //
            $column = new TextViewColumn('no_uqam', 'no_uqam', 'No Uqam', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for syst_expl field
            //
            $column = new TextViewColumn('syst_expl', 'syst_expl', 'Syst Expl', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for marque field
            //
            $column = new TextViewColumn('marque', 'marque', 'Marque', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_grp field
            //
            $column = new NumberViewColumn('id_grp', 'id_grp', 'Id Grp', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for fournisseur field
            //
            $column = new TextViewColumn('fournisseur', 'fournisseur', 'Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for duree_vie field
            //
            $column = new TextViewColumn('duree_vie', 'duree_vie', 'Duree Vie', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for etat field
            //
            $column = new TextViewColumn('etat', 'etat', 'Etat', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_requis field
            //
            $column = new NumberViewColumn('no_requis', 'no_requis', 'No Requis', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_comman field
            //
            $column = new TextViewColumn('no_comman', 'no_comman', 'No Comman', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for prix field
            //
            $column = new TextViewColumn('prix', 'prix', 'Prix', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_recept field
            //
            $column = new TextViewColumn('date_recept', 'date_recept', 'Date Recept', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_fin_d field
            //
            $column = new TextViewColumn('date_fin_d', 'date_fin_d', 'Date Fin D', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for code_compt field
            //
            $column = new NumberViewColumn('code_compt', 'code_compt', 'Code Compt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for adresse_ip field
            //
            $column = new TextViewColumn('adresse_ip', 'adresse_ip', 'Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_adresse_ip field
            //
            $column = new NumberViewColumn('id_adresse_ip', 'id_adresse_ip', 'Id Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for disponible field
            //
            $column = new TextViewColumn('disponible', 'disponible', 'Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for disponible_web field
            //
            $column = new NumberViewColumn('disponible_web', 'disponible_web', 'Disponible Web', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for local field
            //
            $column = new TextViewColumn('local', 'local', 'Local', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers_new', 'LA2', 'Id Pers New', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_inf field
            //
            $column = new NumberViewColumn('id_inf', 'id_inf', 'Id Inf', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for id_mat_inf field
            //
            $column = new NumberViewColumn('id_mat_inf', 'id_mat_inf', 'Id Mat Inf', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_uqam field
            //
            $column = new TextViewColumn('no_uqam', 'no_uqam', 'No Uqam', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for syst_expl field
            //
            $column = new TextViewColumn('syst_expl', 'syst_expl', 'Syst Expl', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for marque field
            //
            $column = new TextViewColumn('marque', 'marque', 'Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_grp field
            //
            $column = new NumberViewColumn('id_grp', 'id_grp', 'Id Grp', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for fournisseur field
            //
            $column = new TextViewColumn('fournisseur', 'fournisseur', 'Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for duree_vie field
            //
            $column = new TextViewColumn('duree_vie', 'duree_vie', 'Duree Vie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for etat field
            //
            $column = new TextViewColumn('etat', 'etat', 'Etat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_requis field
            //
            $column = new NumberViewColumn('no_requis', 'no_requis', 'No Requis', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_comman field
            //
            $column = new TextViewColumn('no_comman', 'no_comman', 'No Comman', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for prix field
            //
            $column = new TextViewColumn('prix', 'prix', 'Prix', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_recept field
            //
            $column = new TextViewColumn('date_recept', 'date_recept', 'Date Recept', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_fin_d field
            //
            $column = new TextViewColumn('date_fin_d', 'date_fin_d', 'Date Fin D', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for code_compt field
            //
            $column = new NumberViewColumn('code_compt', 'code_compt', 'Code Compt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for adresse_ip field
            //
            $column = new TextViewColumn('adresse_ip', 'adresse_ip', 'Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_adresse_ip field
            //
            $column = new NumberViewColumn('id_adresse_ip', 'id_adresse_ip', 'Id Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for disponible field
            //
            $column = new TextViewColumn('disponible', 'disponible', 'Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for disponible_web field
            //
            $column = new NumberViewColumn('disponible_web', 'disponible_web', 'Disponible Web', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for local field
            //
            $column = new TextViewColumn('local', 'local', 'Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers_new', 'LA2', 'Id Pers New', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_inf field
            //
            $column = new NumberViewColumn('id_inf', 'id_inf', 'Id Inf', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for id_mat_inf field
            //
            $editor = new TextEdit('id_mat_inf_edit');
            $editColumn = new CustomEditColumn('Id Mat Inf', 'id_mat_inf', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'edit_administratifs_personnel_materiel_mat_informatique_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_uqam field
            //
            $editor = new TextAreaEdit('no_uqam_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Uqam', 'no_uqam', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for syst_expl field
            //
            $editor = new TextEdit('syst_expl_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Syst Expl', 'syst_expl', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for marque field
            //
            $editor = new TextEdit('marque_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Marque', 'marque', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for description field
            //
            $editor = new TextEdit('description_edit');
            $editor->SetMaxLength(90);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_grp field
            //
            $editor = new TextEdit('id_grp_edit');
            $editColumn = new CustomEditColumn('Id Grp', 'id_grp', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for fournisseur field
            //
            $editor = new TextEdit('fournisseur_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Fournisseur', 'fournisseur', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_serie field
            //
            $editor = new TextEdit('no_serie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Serie', 'no_serie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for duree_vie field
            //
            $editor = new TextEdit('duree_vie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Duree Vie', 'duree_vie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for etat field
            //
            $editor = new TextEdit('etat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Etat', 'etat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_requis field
            //
            $editor = new TextEdit('no_requis_edit');
            $editColumn = new CustomEditColumn('No Requis', 'no_requis', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_comman field
            //
            $editor = new TextEdit('no_comman_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Comman', 'no_comman', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for prix field
            //
            $editor = new TextAreaEdit('prix_edit', 50, 8);
            $editColumn = new CustomEditColumn('Prix', 'prix', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_achat field
            //
            $editor = new TextAreaEdit('date_achat_edit', 50, 8);
            $editColumn = new CustomEditColumn('Date Achat', 'date_achat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_recept field
            //
            $editor = new TextAreaEdit('date_recept_edit', 50, 8);
            $editColumn = new CustomEditColumn('Date Recept', 'date_recept', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_fin_d field
            //
            $editor = new TextEdit('date_fin_d_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Date Fin D', 'date_fin_d', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for code_compt field
            //
            $editor = new TextEdit('code_compt_edit');
            $editColumn = new CustomEditColumn('Code Compt', 'code_compt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextEdit('commentaires_edit');
            $editor->SetMaxLength(70);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for adresse_ip field
            //
            $editor = new TextEdit('adresse_ip_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Adresse Ip', 'adresse_ip', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_adresse_ip field
            //
            $editor = new TextEdit('id_adresse_ip_edit');
            $editColumn = new CustomEditColumn('Id Adresse Ip', 'id_adresse_ip', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_pers field
            //
            $editor = new TextEdit('id_pers_edit');
            $editColumn = new CustomEditColumn('Id Pers', 'id_pers', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for disponible field
            //
            $editor = new TextAreaEdit('disponible_edit', 50, 8);
            $editColumn = new CustomEditColumn('Disponible', 'disponible', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for disponible_web field
            //
            $editor = new TextEdit('disponible_web_edit');
            $editColumn = new CustomEditColumn('Disponible Web', 'disponible_web', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for local field
            //
            $editor = new TextEdit('local_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Local', 'local', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_pers_new field
            //
            $editor = new DynamicCombobox('id_pers_new_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Pers New', 'id_pers_new', 'LA2', 'edit_administratifs_personnel_materiel_mat_informatique_id_pers_new_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_inf field
            //
            $editor = new TextEdit('id_inf_edit');
            $editColumn = new CustomEditColumn('Id Inf', 'id_inf', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'multi_edit_administratifs_personnel_materiel_mat_informatique_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_uqam field
            //
            $editor = new TextAreaEdit('no_uqam_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Uqam', 'no_uqam', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for syst_expl field
            //
            $editor = new TextEdit('syst_expl_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Syst Expl', 'syst_expl', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for marque field
            //
            $editor = new TextEdit('marque_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Marque', 'marque', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for description field
            //
            $editor = new TextEdit('description_edit');
            $editor->SetMaxLength(90);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_grp field
            //
            $editor = new TextEdit('id_grp_edit');
            $editColumn = new CustomEditColumn('Id Grp', 'id_grp', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for fournisseur field
            //
            $editor = new TextEdit('fournisseur_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Fournisseur', 'fournisseur', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_serie field
            //
            $editor = new TextEdit('no_serie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Serie', 'no_serie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for duree_vie field
            //
            $editor = new TextEdit('duree_vie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Duree Vie', 'duree_vie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for etat field
            //
            $editor = new TextEdit('etat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Etat', 'etat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_requis field
            //
            $editor = new TextEdit('no_requis_edit');
            $editColumn = new CustomEditColumn('No Requis', 'no_requis', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_comman field
            //
            $editor = new TextEdit('no_comman_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Comman', 'no_comman', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for prix field
            //
            $editor = new TextAreaEdit('prix_edit', 50, 8);
            $editColumn = new CustomEditColumn('Prix', 'prix', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_achat field
            //
            $editor = new TextAreaEdit('date_achat_edit', 50, 8);
            $editColumn = new CustomEditColumn('Date Achat', 'date_achat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_recept field
            //
            $editor = new TextAreaEdit('date_recept_edit', 50, 8);
            $editColumn = new CustomEditColumn('Date Recept', 'date_recept', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_fin_d field
            //
            $editor = new TextEdit('date_fin_d_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Date Fin D', 'date_fin_d', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for code_compt field
            //
            $editor = new TextEdit('code_compt_edit');
            $editColumn = new CustomEditColumn('Code Compt', 'code_compt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextEdit('commentaires_edit');
            $editor->SetMaxLength(70);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for adresse_ip field
            //
            $editor = new TextEdit('adresse_ip_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Adresse Ip', 'adresse_ip', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_adresse_ip field
            //
            $editor = new TextEdit('id_adresse_ip_edit');
            $editColumn = new CustomEditColumn('Id Adresse Ip', 'id_adresse_ip', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_pers field
            //
            $editor = new TextEdit('id_pers_edit');
            $editColumn = new CustomEditColumn('Id Pers', 'id_pers', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for disponible field
            //
            $editor = new TextAreaEdit('disponible_edit', 50, 8);
            $editColumn = new CustomEditColumn('Disponible', 'disponible', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for disponible_web field
            //
            $editor = new TextEdit('disponible_web_edit');
            $editColumn = new CustomEditColumn('Disponible Web', 'disponible_web', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for local field
            //
            $editor = new TextEdit('local_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Local', 'local', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_pers_new field
            //
            $editor = new DynamicCombobox('id_pers_new_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Pers New', 'id_pers_new', 'LA2', 'multi_edit_administratifs_personnel_materiel_mat_informatique_id_pers_new_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_inf field
            //
            $editor = new TextEdit('id_inf_edit');
            $editColumn = new CustomEditColumn('Id Inf', 'id_inf', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for id_mat_inf field
            //
            $editor = new TextEdit('id_mat_inf_edit');
            $editColumn = new CustomEditColumn('Id Mat Inf', 'id_mat_inf', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'insert_administratifs_personnel_materiel_mat_informatique_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_uqam field
            //
            $editor = new TextAreaEdit('no_uqam_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Uqam', 'no_uqam', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for syst_expl field
            //
            $editor = new TextEdit('syst_expl_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Syst Expl', 'syst_expl', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for marque field
            //
            $editor = new TextEdit('marque_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Marque', 'marque', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for description field
            //
            $editor = new TextEdit('description_edit');
            $editor->SetMaxLength(90);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_grp field
            //
            $editor = new TextEdit('id_grp_edit');
            $editColumn = new CustomEditColumn('Id Grp', 'id_grp', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for fournisseur field
            //
            $editor = new TextEdit('fournisseur_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Fournisseur', 'fournisseur', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_serie field
            //
            $editor = new TextEdit('no_serie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Serie', 'no_serie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for duree_vie field
            //
            $editor = new TextEdit('duree_vie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Duree Vie', 'duree_vie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for etat field
            //
            $editor = new TextEdit('etat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Etat', 'etat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_requis field
            //
            $editor = new TextEdit('no_requis_edit');
            $editColumn = new CustomEditColumn('No Requis', 'no_requis', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_comman field
            //
            $editor = new TextEdit('no_comman_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Comman', 'no_comman', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for prix field
            //
            $editor = new TextAreaEdit('prix_edit', 50, 8);
            $editColumn = new CustomEditColumn('Prix', 'prix', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_achat field
            //
            $editor = new TextAreaEdit('date_achat_edit', 50, 8);
            $editColumn = new CustomEditColumn('Date Achat', 'date_achat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_recept field
            //
            $editor = new TextAreaEdit('date_recept_edit', 50, 8);
            $editColumn = new CustomEditColumn('Date Recept', 'date_recept', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_fin_d field
            //
            $editor = new TextEdit('date_fin_d_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Date Fin D', 'date_fin_d', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for code_compt field
            //
            $editor = new TextEdit('code_compt_edit');
            $editColumn = new CustomEditColumn('Code Compt', 'code_compt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextEdit('commentaires_edit');
            $editor->SetMaxLength(70);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for adresse_ip field
            //
            $editor = new TextEdit('adresse_ip_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Adresse Ip', 'adresse_ip', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_adresse_ip field
            //
            $editor = new TextEdit('id_adresse_ip_edit');
            $editColumn = new CustomEditColumn('Id Adresse Ip', 'id_adresse_ip', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_pers field
            //
            $editor = new TextEdit('id_pers_edit');
            $editColumn = new CustomEditColumn('Id Pers', 'id_pers', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for disponible field
            //
            $editor = new TextAreaEdit('disponible_edit', 50, 8);
            $editColumn = new CustomEditColumn('Disponible', 'disponible', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for disponible_web field
            //
            $editor = new TextEdit('disponible_web_edit');
            $editColumn = new CustomEditColumn('Disponible Web', 'disponible_web', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for local field
            //
            $editor = new TextEdit('local_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Local', 'local', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_pers_new field
            //
            $editor = new DynamicCombobox('id_pers_new_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Pers New', 'id_pers_new', 'LA2', 'insert_administratifs_personnel_materiel_mat_informatique_id_pers_new_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_inf field
            //
            $editor = new TextEdit('id_inf_edit');
            $editColumn = new CustomEditColumn('Id Inf', 'id_inf', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for id_mat_inf field
            //
            $column = new NumberViewColumn('id_mat_inf', 'id_mat_inf', 'Id Mat Inf', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_uqam field
            //
            $column = new TextViewColumn('no_uqam', 'no_uqam', 'No Uqam', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for syst_expl field
            //
            $column = new TextViewColumn('syst_expl', 'syst_expl', 'Syst Expl', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for marque field
            //
            $column = new TextViewColumn('marque', 'marque', 'Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_grp field
            //
            $column = new NumberViewColumn('id_grp', 'id_grp', 'Id Grp', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for fournisseur field
            //
            $column = new TextViewColumn('fournisseur', 'fournisseur', 'Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for duree_vie field
            //
            $column = new TextViewColumn('duree_vie', 'duree_vie', 'Duree Vie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for etat field
            //
            $column = new TextViewColumn('etat', 'etat', 'Etat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_requis field
            //
            $column = new NumberViewColumn('no_requis', 'no_requis', 'No Requis', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_comman field
            //
            $column = new TextViewColumn('no_comman', 'no_comman', 'No Comman', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for prix field
            //
            $column = new TextViewColumn('prix', 'prix', 'Prix', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_recept field
            //
            $column = new TextViewColumn('date_recept', 'date_recept', 'Date Recept', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_fin_d field
            //
            $column = new TextViewColumn('date_fin_d', 'date_fin_d', 'Date Fin D', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for code_compt field
            //
            $column = new NumberViewColumn('code_compt', 'code_compt', 'Code Compt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for adresse_ip field
            //
            $column = new TextViewColumn('adresse_ip', 'adresse_ip', 'Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_adresse_ip field
            //
            $column = new NumberViewColumn('id_adresse_ip', 'id_adresse_ip', 'Id Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for disponible field
            //
            $column = new TextViewColumn('disponible', 'disponible', 'Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for disponible_web field
            //
            $column = new NumberViewColumn('disponible_web', 'disponible_web', 'Disponible Web', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for local field
            //
            $column = new TextViewColumn('local', 'local', 'Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers_new', 'LA2', 'Id Pers New', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_inf field
            //
            $column = new NumberViewColumn('id_inf', 'id_inf', 'Id Inf', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for id_mat_inf field
            //
            $column = new NumberViewColumn('id_mat_inf', 'id_mat_inf', 'Id Mat Inf', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_uqam field
            //
            $column = new TextViewColumn('no_uqam', 'no_uqam', 'No Uqam', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for syst_expl field
            //
            $column = new TextViewColumn('syst_expl', 'syst_expl', 'Syst Expl', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for marque field
            //
            $column = new TextViewColumn('marque', 'marque', 'Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_grp field
            //
            $column = new NumberViewColumn('id_grp', 'id_grp', 'Id Grp', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for fournisseur field
            //
            $column = new TextViewColumn('fournisseur', 'fournisseur', 'Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for duree_vie field
            //
            $column = new TextViewColumn('duree_vie', 'duree_vie', 'Duree Vie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for etat field
            //
            $column = new TextViewColumn('etat', 'etat', 'Etat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_requis field
            //
            $column = new NumberViewColumn('no_requis', 'no_requis', 'No Requis', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for no_comman field
            //
            $column = new TextViewColumn('no_comman', 'no_comman', 'No Comman', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for prix field
            //
            $column = new TextViewColumn('prix', 'prix', 'Prix', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_recept field
            //
            $column = new TextViewColumn('date_recept', 'date_recept', 'Date Recept', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_fin_d field
            //
            $column = new TextViewColumn('date_fin_d', 'date_fin_d', 'Date Fin D', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for code_compt field
            //
            $column = new NumberViewColumn('code_compt', 'code_compt', 'Code Compt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for adresse_ip field
            //
            $column = new TextViewColumn('adresse_ip', 'adresse_ip', 'Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_adresse_ip field
            //
            $column = new NumberViewColumn('id_adresse_ip', 'id_adresse_ip', 'Id Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for disponible field
            //
            $column = new TextViewColumn('disponible', 'disponible', 'Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for disponible_web field
            //
            $column = new NumberViewColumn('disponible_web', 'disponible_web', 'Disponible Web', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for local field
            //
            $column = new TextViewColumn('local', 'local', 'Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers_new', 'LA2', 'Id Pers New', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_inf field
            //
            $column = new NumberViewColumn('id_inf', 'id_inf', 'Id Inf', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for id_mat_inf field
            //
            $column = new NumberViewColumn('id_mat_inf', 'id_mat_inf', 'Id Mat Inf', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_uqam field
            //
            $column = new TextViewColumn('no_uqam', 'no_uqam', 'No Uqam', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for syst_expl field
            //
            $column = new TextViewColumn('syst_expl', 'syst_expl', 'Syst Expl', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for marque field
            //
            $column = new TextViewColumn('marque', 'marque', 'Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_grp field
            //
            $column = new NumberViewColumn('id_grp', 'id_grp', 'Id Grp', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for fournisseur field
            //
            $column = new TextViewColumn('fournisseur', 'fournisseur', 'Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for duree_vie field
            //
            $column = new TextViewColumn('duree_vie', 'duree_vie', 'Duree Vie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for etat field
            //
            $column = new TextViewColumn('etat', 'etat', 'Etat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_requis field
            //
            $column = new NumberViewColumn('no_requis', 'no_requis', 'No Requis', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_comman field
            //
            $column = new TextViewColumn('no_comman', 'no_comman', 'No Comman', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for prix field
            //
            $column = new TextViewColumn('prix', 'prix', 'Prix', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_recept field
            //
            $column = new TextViewColumn('date_recept', 'date_recept', 'Date Recept', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_fin_d field
            //
            $column = new TextViewColumn('date_fin_d', 'date_fin_d', 'Date Fin D', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for code_compt field
            //
            $column = new NumberViewColumn('code_compt', 'code_compt', 'Code Compt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for adresse_ip field
            //
            $column = new TextViewColumn('adresse_ip', 'adresse_ip', 'Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_adresse_ip field
            //
            $column = new NumberViewColumn('id_adresse_ip', 'id_adresse_ip', 'Id Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for disponible field
            //
            $column = new TextViewColumn('disponible', 'disponible', 'Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for disponible_web field
            //
            $column = new NumberViewColumn('disponible_web', 'disponible_web', 'Disponible Web', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for local field
            //
            $column = new TextViewColumn('local', 'local', 'Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers_new', 'LA2', 'Id Pers New', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_inf field
            //
            $column = new NumberViewColumn('id_inf', 'id_inf', 'Id Inf', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(true);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel_materiel_mat_informatique_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel_materiel_mat_informatique_id_pers_new_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel_materiel_mat_informatique_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel_materiel_mat_informatique_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel_materiel_mat_informatique_id_pers_new_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel_materiel_mat_informatique_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel_materiel_mat_informatique_id_pers_new_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel_materiel_mat_informatique_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel_materiel_mat_informatique_id_pers_new_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }
    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class administratifs_personnel_materiel_mat_sciPage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Mat Sci');
            $this->SetMenuLabel('Mat Sci');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_sci"');
            $this->dataset->addFields(
                array(
                    new IntegerField('id_mat_sci', true, true, true),
                    new StringField('no_identif', true),
                    new StringField('transaction', true),
                    new StringField('nom_l_e'),
                    new IntegerField('id_equipement'),
                    new StringField('marque'),
                    new StringField('manufacture', true),
                    new StringField('modele'),
                    new StringField('fournisseur'),
                    new StringField('id_fournisseur', true),
                    new StringField('no_serie'),
                    new StringField('caracteristique'),
                    new StringField('utilisation'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new StringField('fonction'),
                    new StringField('utilisateur'),
                    new StringField('cours'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new IntegerField('quantite'),
                    new IntegerField('prix_unitaire'),
                    new IntegerField('cout_total'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d', true),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_charge'),
                    new IntegerField('disponible'),
                    new StringField('disponible_web'),
                    new StringField('documents_facture'),
                    new StringField('document_bon_commande'),
                    new StringField('document_manuel_utilisation'),
                    new StringField('autres_documents'),
                    new IntegerField('id_marque'),
                    new IntegerField('id_manufacturier'),
                    new IntegerField('id_modele'),
                    new IntegerField('id_groupe'),
                    new IntegerField('id_pers')
                )
            );
            $this->dataset->AddLookupField('id_loc', 'administratifs.locals', new IntegerField('id_loc'), new StringField('no_loc', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('id_charge', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA2', 'LT2'), 'LT2');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'id_mat_sci', 'id_mat_sci', 'Id Mat Sci'),
                new FilterColumn($this->dataset, 'no_identif', 'no_identif', 'No Identif'),
                new FilterColumn($this->dataset, 'transaction', 'transaction', 'Transaction'),
                new FilterColumn($this->dataset, 'nom_l_e', 'nom_l_e', 'Nom L E'),
                new FilterColumn($this->dataset, 'id_equipement', 'id_equipement', 'Id Equipement'),
                new FilterColumn($this->dataset, 'marque', 'marque', 'Marque'),
                new FilterColumn($this->dataset, 'id_marque', 'id_marque', 'Id Marque'),
                new FilterColumn($this->dataset, 'manufacture', 'manufacture', 'Manufacture'),
                new FilterColumn($this->dataset, 'id_manufacturier', 'id_manufacturier', 'Id Manufacturier'),
                new FilterColumn($this->dataset, 'modele', 'modele', 'Modele'),
                new FilterColumn($this->dataset, 'id_modele', 'id_modele', 'Id Modele'),
                new FilterColumn($this->dataset, 'fournisseur', 'fournisseur', 'Fournisseur'),
                new FilterColumn($this->dataset, 'id_fournisseur', 'id_fournisseur', 'Id Fournisseur'),
                new FilterColumn($this->dataset, 'no_serie', 'no_serie', 'No Serie'),
                new FilterColumn($this->dataset, 'caracteristique', 'caracteristique', 'Caracteristique'),
                new FilterColumn($this->dataset, 'utilisation', 'utilisation', 'Utilisation'),
                new FilterColumn($this->dataset, 'duree_vie', 'duree_vie', 'Duree Vie'),
                new FilterColumn($this->dataset, 'etat', 'etat', 'Etat'),
                new FilterColumn($this->dataset, 'fonction', 'fonction', 'Fonction'),
                new FilterColumn($this->dataset, 'utilisateur', 'utilisateur', 'Utilisateur'),
                new FilterColumn($this->dataset, 'cours', 'cours', 'Cours'),
                new FilterColumn($this->dataset, 'no_requis', 'no_requis', 'No Requis'),
                new FilterColumn($this->dataset, 'no_comman', 'no_comman', 'No Comman'),
                new FilterColumn($this->dataset, 'quantite', 'quantite', 'Quantite'),
                new FilterColumn($this->dataset, 'prix_unitaire', 'prix_unitaire', 'Prix Unitaire'),
                new FilterColumn($this->dataset, 'cout_total', 'cout_total', 'Cout Total'),
                new FilterColumn($this->dataset, 'date_achat', 'date_achat', 'Date Achat'),
                new FilterColumn($this->dataset, 'date_recept', 'date_recept', 'Date Recept'),
                new FilterColumn($this->dataset, 'date_fin_d', 'date_fin_d', 'Date Fin D'),
                new FilterColumn($this->dataset, 'code_compt', 'code_compt', 'Code Compt'),
                new FilterColumn($this->dataset, 'commentaires', 'commentaires', 'Commentaires'),
                new FilterColumn($this->dataset, 'id_groupe', 'id_groupe', 'Id Groupe'),
                new FilterColumn($this->dataset, 'id_pers', 'id_pers', 'Id Pers'),
                new FilterColumn($this->dataset, 'id_loc', 'LA1', 'Id Loc'),
                new FilterColumn($this->dataset, 'id_charge', 'LA2', 'Id Charge'),
                new FilterColumn($this->dataset, 'disponible', 'disponible', 'Disponible'),
                new FilterColumn($this->dataset, 'disponible_web', 'disponible_web', 'Disponible Web'),
                new FilterColumn($this->dataset, 'documents_facture', 'documents_facture', 'Documents Facture'),
                new FilterColumn($this->dataset, 'document_bon_commande', 'document_bon_commande', 'Document Bon Commande'),
                new FilterColumn($this->dataset, 'document_manuel_utilisation', 'document_manuel_utilisation', 'Document Manuel Utilisation'),
                new FilterColumn($this->dataset, 'autres_documents', 'autres_documents', 'Autres Documents')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['id_mat_sci'])
                ->addColumn($columns['no_identif'])
                ->addColumn($columns['transaction'])
                ->addColumn($columns['nom_l_e'])
                ->addColumn($columns['id_equipement'])
                ->addColumn($columns['marque'])
                ->addColumn($columns['id_marque'])
                ->addColumn($columns['manufacture'])
                ->addColumn($columns['id_manufacturier'])
                ->addColumn($columns['modele'])
                ->addColumn($columns['id_modele'])
                ->addColumn($columns['fournisseur'])
                ->addColumn($columns['id_fournisseur'])
                ->addColumn($columns['no_serie'])
                ->addColumn($columns['caracteristique'])
                ->addColumn($columns['utilisation'])
                ->addColumn($columns['duree_vie'])
                ->addColumn($columns['etat'])
                ->addColumn($columns['fonction'])
                ->addColumn($columns['utilisateur'])
                ->addColumn($columns['cours'])
                ->addColumn($columns['no_requis'])
                ->addColumn($columns['no_comman'])
                ->addColumn($columns['quantite'])
                ->addColumn($columns['prix_unitaire'])
                ->addColumn($columns['cout_total'])
                ->addColumn($columns['date_achat'])
                ->addColumn($columns['date_recept'])
                ->addColumn($columns['date_fin_d'])
                ->addColumn($columns['code_compt'])
                ->addColumn($columns['commentaires'])
                ->addColumn($columns['id_groupe'])
                ->addColumn($columns['id_pers'])
                ->addColumn($columns['id_loc'])
                ->addColumn($columns['id_charge'])
                ->addColumn($columns['disponible'])
                ->addColumn($columns['disponible_web'])
                ->addColumn($columns['documents_facture'])
                ->addColumn($columns['document_bon_commande'])
                ->addColumn($columns['document_manuel_utilisation'])
                ->addColumn($columns['autres_documents']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_loc')
                ->setOptionsFor('id_charge');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('id_mat_sci_edit');
            
            $filterBuilder->addColumn(
                $columns['id_mat_sci'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_identif_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['no_identif'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('transaction_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['transaction'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('nom_l_e_edit');
            $main_editor->SetMaxLength(80);
            
            $filterBuilder->addColumn(
                $columns['nom_l_e'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_equipement_edit');
            
            $filterBuilder->addColumn(
                $columns['id_equipement'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('marque_edit');
            $main_editor->SetMaxLength(30);
            
            $filterBuilder->addColumn(
                $columns['marque'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_marque_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['id_marque'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('manufacture_edit');
            $main_editor->SetMaxLength(40);
            
            $filterBuilder->addColumn(
                $columns['manufacture'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_manufacturier_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['id_manufacturier'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('modele_edit');
            $main_editor->SetMaxLength(30);
            
            $filterBuilder->addColumn(
                $columns['modele'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_modele_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['id_modele'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('fournisseur_edit');
            $main_editor->SetMaxLength(40);
            
            $filterBuilder->addColumn(
                $columns['fournisseur'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_fournisseur_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['id_fournisseur'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_serie_edit');
            $main_editor->SetMaxLength(30);
            
            $filterBuilder->addColumn(
                $columns['no_serie'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('caracteristique_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['caracteristique'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('utilisation_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['utilisation'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('duree_vie_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['duree_vie'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('etat_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['etat'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('fonction_edit');
            $main_editor->SetMaxLength(40);
            
            $filterBuilder->addColumn(
                $columns['fonction'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('utilisateur_edit');
            $main_editor->SetMaxLength(60);
            
            $filterBuilder->addColumn(
                $columns['utilisateur'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('cours_edit');
            $main_editor->SetMaxLength(40);
            
            $filterBuilder->addColumn(
                $columns['cours'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_requis_edit');
            
            $filterBuilder->addColumn(
                $columns['no_requis'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_comman_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['no_comman'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('quantite_edit');
            
            $filterBuilder->addColumn(
                $columns['quantite'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('prix_unitaire_edit');
            
            $filterBuilder->addColumn(
                $columns['prix_unitaire'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('cout_total_edit');
            
            $filterBuilder->addColumn(
                $columns['cout_total'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('date_achat_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['date_achat'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('date_recept_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['date_recept'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('date_fin_d_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['date_fin_d'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('code_compt_edit');
            
            $filterBuilder->addColumn(
                $columns['code_compt'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('commentaires');
            
            $filterBuilder->addColumn(
                $columns['commentaires'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_groupe_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['id_groupe'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_pers_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['id_pers'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel_materiel_mat_sci_id_loc_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_loc', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel_materiel_mat_sci_id_loc_search');
            
            $text_editor = new TextEdit('id_loc');
            
            $filterBuilder->addColumn(
                $columns['id_loc'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_charge_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel_materiel_mat_sci_id_charge_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_charge', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel_materiel_mat_sci_id_charge_search');
            
            $text_editor = new TextEdit('id_charge');
            
            $filterBuilder->addColumn(
                $columns['id_charge'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('disponible_edit');
            
            $filterBuilder->addColumn(
                $columns['disponible'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('disponible_web_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['disponible_web'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('documents_facture_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['documents_facture'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('document_bon_commande_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['document_bon_commande'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('document_manuel_utilisation_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['document_manuel_utilisation'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('autres_documents_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['autres_documents'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for id_mat_sci field
            //
            $column = new NumberViewColumn('id_mat_sci', 'id_mat_sci', 'Id Mat Sci', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_identif field
            //
            $column = new TextViewColumn('no_identif', 'no_identif', 'No Identif', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for transaction field
            //
            $column = new TextViewColumn('transaction', 'transaction', 'Transaction', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom_l_e field
            //
            $column = new TextViewColumn('nom_l_e', 'nom_l_e', 'Nom L E', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_equipement field
            //
            $column = new NumberViewColumn('id_equipement', 'id_equipement', 'Id Equipement', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for marque field
            //
            $column = new TextViewColumn('marque', 'marque', 'Marque', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_marque field
            //
            $column = new TextViewColumn('id_marque', 'id_marque', 'Id Marque', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for manufacture field
            //
            $column = new TextViewColumn('manufacture', 'manufacture', 'Manufacture', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_manufacturier field
            //
            $column = new TextViewColumn('id_manufacturier', 'id_manufacturier', 'Id Manufacturier', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for modele field
            //
            $column = new TextViewColumn('modele', 'modele', 'Modele', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_modele field
            //
            $column = new TextViewColumn('id_modele', 'id_modele', 'Id Modele', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for fournisseur field
            //
            $column = new TextViewColumn('fournisseur', 'fournisseur', 'Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_fournisseur field
            //
            $column = new TextViewColumn('id_fournisseur', 'id_fournisseur', 'Id Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for caracteristique field
            //
            $column = new TextViewColumn('caracteristique', 'caracteristique', 'Caracteristique', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for utilisation field
            //
            $column = new TextViewColumn('utilisation', 'utilisation', 'Utilisation', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for duree_vie field
            //
            $column = new TextViewColumn('duree_vie', 'duree_vie', 'Duree Vie', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for etat field
            //
            $column = new TextViewColumn('etat', 'etat', 'Etat', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for fonction field
            //
            $column = new TextViewColumn('fonction', 'fonction', 'Fonction', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for utilisateur field
            //
            $column = new TextViewColumn('utilisateur', 'utilisateur', 'Utilisateur', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for cours field
            //
            $column = new TextViewColumn('cours', 'cours', 'Cours', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_requis field
            //
            $column = new NumberViewColumn('no_requis', 'no_requis', 'No Requis', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_comman field
            //
            $column = new TextViewColumn('no_comman', 'no_comman', 'No Comman', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for quantite field
            //
            $column = new NumberViewColumn('quantite', 'quantite', 'Quantite', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for prix_unitaire field
            //
            $column = new NumberViewColumn('prix_unitaire', 'prix_unitaire', 'Prix Unitaire', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for cout_total field
            //
            $column = new NumberViewColumn('cout_total', 'cout_total', 'Cout Total', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_recept field
            //
            $column = new TextViewColumn('date_recept', 'date_recept', 'Date Recept', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_fin_d field
            //
            $column = new TextViewColumn('date_fin_d', 'date_fin_d', 'Date Fin D', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for code_compt field
            //
            $column = new NumberViewColumn('code_compt', 'code_compt', 'Code Compt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'id_groupe', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_pers field
            //
            $column = new TextViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_charge', 'LA2', 'Id Charge', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for disponible field
            //
            $column = new NumberViewColumn('disponible', 'disponible', 'Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for disponible_web field
            //
            $column = new TextViewColumn('disponible_web', 'disponible_web', 'Disponible Web', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for documents_facture field
            //
            $column = new TextViewColumn('documents_facture', 'documents_facture', 'Documents Facture', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for document_bon_commande field
            //
            $column = new TextViewColumn('document_bon_commande', 'document_bon_commande', 'Document Bon Commande', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for document_manuel_utilisation field
            //
            $column = new TextViewColumn('document_manuel_utilisation', 'document_manuel_utilisation', 'Document Manuel Utilisation', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for autres_documents field
            //
            $column = new TextViewColumn('autres_documents', 'autres_documents', 'Autres Documents', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for id_mat_sci field
            //
            $column = new NumberViewColumn('id_mat_sci', 'id_mat_sci', 'Id Mat Sci', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_identif field
            //
            $column = new TextViewColumn('no_identif', 'no_identif', 'No Identif', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for transaction field
            //
            $column = new TextViewColumn('transaction', 'transaction', 'Transaction', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom_l_e field
            //
            $column = new TextViewColumn('nom_l_e', 'nom_l_e', 'Nom L E', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_equipement field
            //
            $column = new NumberViewColumn('id_equipement', 'id_equipement', 'Id Equipement', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for marque field
            //
            $column = new TextViewColumn('marque', 'marque', 'Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_marque field
            //
            $column = new TextViewColumn('id_marque', 'id_marque', 'Id Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for manufacture field
            //
            $column = new TextViewColumn('manufacture', 'manufacture', 'Manufacture', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_manufacturier field
            //
            $column = new TextViewColumn('id_manufacturier', 'id_manufacturier', 'Id Manufacturier', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for modele field
            //
            $column = new TextViewColumn('modele', 'modele', 'Modele', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_modele field
            //
            $column = new TextViewColumn('id_modele', 'id_modele', 'Id Modele', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for fournisseur field
            //
            $column = new TextViewColumn('fournisseur', 'fournisseur', 'Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_fournisseur field
            //
            $column = new TextViewColumn('id_fournisseur', 'id_fournisseur', 'Id Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for caracteristique field
            //
            $column = new TextViewColumn('caracteristique', 'caracteristique', 'Caracteristique', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for utilisation field
            //
            $column = new TextViewColumn('utilisation', 'utilisation', 'Utilisation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for duree_vie field
            //
            $column = new TextViewColumn('duree_vie', 'duree_vie', 'Duree Vie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for etat field
            //
            $column = new TextViewColumn('etat', 'etat', 'Etat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for fonction field
            //
            $column = new TextViewColumn('fonction', 'fonction', 'Fonction', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for utilisateur field
            //
            $column = new TextViewColumn('utilisateur', 'utilisateur', 'Utilisateur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for cours field
            //
            $column = new TextViewColumn('cours', 'cours', 'Cours', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_requis field
            //
            $column = new NumberViewColumn('no_requis', 'no_requis', 'No Requis', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_comman field
            //
            $column = new TextViewColumn('no_comman', 'no_comman', 'No Comman', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for quantite field
            //
            $column = new NumberViewColumn('quantite', 'quantite', 'Quantite', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for prix_unitaire field
            //
            $column = new NumberViewColumn('prix_unitaire', 'prix_unitaire', 'Prix Unitaire', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for cout_total field
            //
            $column = new NumberViewColumn('cout_total', 'cout_total', 'Cout Total', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_recept field
            //
            $column = new TextViewColumn('date_recept', 'date_recept', 'Date Recept', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_fin_d field
            //
            $column = new TextViewColumn('date_fin_d', 'date_fin_d', 'Date Fin D', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for code_compt field
            //
            $column = new NumberViewColumn('code_compt', 'code_compt', 'Code Compt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'id_groupe', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new TextViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_charge', 'LA2', 'Id Charge', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for disponible field
            //
            $column = new NumberViewColumn('disponible', 'disponible', 'Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for disponible_web field
            //
            $column = new TextViewColumn('disponible_web', 'disponible_web', 'Disponible Web', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for documents_facture field
            //
            $column = new TextViewColumn('documents_facture', 'documents_facture', 'Documents Facture', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for document_bon_commande field
            //
            $column = new TextViewColumn('document_bon_commande', 'document_bon_commande', 'Document Bon Commande', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for document_manuel_utilisation field
            //
            $column = new TextViewColumn('document_manuel_utilisation', 'document_manuel_utilisation', 'Document Manuel Utilisation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for autres_documents field
            //
            $column = new TextViewColumn('autres_documents', 'autres_documents', 'Autres Documents', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for no_identif field
            //
            $editor = new TextEdit('no_identif_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('No Identif', 'no_identif', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for transaction field
            //
            $editor = new TextEdit('transaction_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Transaction', 'transaction', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for nom_l_e field
            //
            $editor = new TextEdit('nom_l_e_edit');
            $editor->SetMaxLength(80);
            $editColumn = new CustomEditColumn('Nom L E', 'nom_l_e', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_equipement field
            //
            $editor = new TextEdit('id_equipement_edit');
            $editColumn = new CustomEditColumn('Id Equipement', 'id_equipement', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for marque field
            //
            $editor = new TextEdit('marque_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Marque', 'marque', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_marque field
            //
            $editor = new TextEdit('id_marque_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Marque', 'id_marque', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for manufacture field
            //
            $editor = new TextEdit('manufacture_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Manufacture', 'manufacture', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_manufacturier field
            //
            $editor = new TextEdit('id_manufacturier_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Manufacturier', 'id_manufacturier', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for modele field
            //
            $editor = new TextEdit('modele_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Modele', 'modele', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_modele field
            //
            $editor = new TextEdit('id_modele_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Modele', 'id_modele', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for fournisseur field
            //
            $editor = new TextEdit('fournisseur_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Fournisseur', 'fournisseur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_fournisseur field
            //
            $editor = new TextEdit('id_fournisseur_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Fournisseur', 'id_fournisseur', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_serie field
            //
            $editor = new TextEdit('no_serie_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('No Serie', 'no_serie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for caracteristique field
            //
            $editor = new TextEdit('caracteristique_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Caracteristique', 'caracteristique', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for utilisation field
            //
            $editor = new TextEdit('utilisation_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Utilisation', 'utilisation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for duree_vie field
            //
            $editor = new TextEdit('duree_vie_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Duree Vie', 'duree_vie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for etat field
            //
            $editor = new TextEdit('etat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Etat', 'etat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for fonction field
            //
            $editor = new TextEdit('fonction_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Fonction', 'fonction', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for utilisateur field
            //
            $editor = new TextEdit('utilisateur_edit');
            $editor->SetMaxLength(60);
            $editColumn = new CustomEditColumn('Utilisateur', 'utilisateur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for cours field
            //
            $editor = new TextEdit('cours_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Cours', 'cours', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_requis field
            //
            $editor = new TextEdit('no_requis_edit');
            $editColumn = new CustomEditColumn('No Requis', 'no_requis', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_comman field
            //
            $editor = new TextEdit('no_comman_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('No Comman', 'no_comman', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for quantite field
            //
            $editor = new TextEdit('quantite_edit');
            $editColumn = new CustomEditColumn('Quantite', 'quantite', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for prix_unitaire field
            //
            $editor = new TextEdit('prix_unitaire_edit');
            $editColumn = new CustomEditColumn('Prix Unitaire', 'prix_unitaire', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for cout_total field
            //
            $editor = new TextEdit('cout_total_edit');
            $editColumn = new CustomEditColumn('Cout Total', 'cout_total', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_achat field
            //
            $editor = new TextEdit('date_achat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Achat', 'date_achat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_recept field
            //
            $editor = new TextEdit('date_recept_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Recept', 'date_recept', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_fin_d field
            //
            $editor = new TextEdit('date_fin_d_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Fin D', 'date_fin_d', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for code_compt field
            //
            $editor = new TextEdit('code_compt_edit');
            $editColumn = new CustomEditColumn('Code Compt', 'code_compt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextAreaEdit('commentaires_edit', 50, 8);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_groupe field
            //
            $editor = new TextEdit('id_groupe_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Groupe', 'id_groupe', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_pers field
            //
            $editor = new TextEdit('id_pers_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Pers', 'id_pers', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'edit_administratifs_personnel_materiel_mat_sci_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_charge field
            //
            $editor = new DynamicCombobox('id_charge_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Charge', 'id_charge', 'LA2', 'edit_administratifs_personnel_materiel_mat_sci_id_charge_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for disponible field
            //
            $editor = new TextEdit('disponible_edit');
            $editColumn = new CustomEditColumn('Disponible', 'disponible', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for disponible_web field
            //
            $editor = new TextEdit('disponible_web_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Disponible Web', 'disponible_web', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for documents_facture field
            //
            $editor = new TextEdit('documents_facture_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Documents Facture', 'documents_facture', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for document_bon_commande field
            //
            $editor = new TextEdit('document_bon_commande_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Document Bon Commande', 'document_bon_commande', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for document_manuel_utilisation field
            //
            $editor = new TextEdit('document_manuel_utilisation_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Document Manuel Utilisation', 'document_manuel_utilisation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for autres_documents field
            //
            $editor = new TextEdit('autres_documents_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Autres Documents', 'autres_documents', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for no_identif field
            //
            $editor = new TextEdit('no_identif_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('No Identif', 'no_identif', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for transaction field
            //
            $editor = new TextEdit('transaction_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Transaction', 'transaction', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for nom_l_e field
            //
            $editor = new TextEdit('nom_l_e_edit');
            $editor->SetMaxLength(80);
            $editColumn = new CustomEditColumn('Nom L E', 'nom_l_e', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_equipement field
            //
            $editor = new TextEdit('id_equipement_edit');
            $editColumn = new CustomEditColumn('Id Equipement', 'id_equipement', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for marque field
            //
            $editor = new TextEdit('marque_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Marque', 'marque', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_marque field
            //
            $editor = new TextEdit('id_marque_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Marque', 'id_marque', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for manufacture field
            //
            $editor = new TextEdit('manufacture_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Manufacture', 'manufacture', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_manufacturier field
            //
            $editor = new TextEdit('id_manufacturier_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Manufacturier', 'id_manufacturier', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for modele field
            //
            $editor = new TextEdit('modele_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Modele', 'modele', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_modele field
            //
            $editor = new TextEdit('id_modele_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Modele', 'id_modele', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for fournisseur field
            //
            $editor = new TextEdit('fournisseur_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Fournisseur', 'fournisseur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_fournisseur field
            //
            $editor = new TextEdit('id_fournisseur_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Fournisseur', 'id_fournisseur', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_serie field
            //
            $editor = new TextEdit('no_serie_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('No Serie', 'no_serie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for caracteristique field
            //
            $editor = new TextEdit('caracteristique_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Caracteristique', 'caracteristique', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for utilisation field
            //
            $editor = new TextEdit('utilisation_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Utilisation', 'utilisation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for duree_vie field
            //
            $editor = new TextEdit('duree_vie_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Duree Vie', 'duree_vie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for etat field
            //
            $editor = new TextEdit('etat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Etat', 'etat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for fonction field
            //
            $editor = new TextEdit('fonction_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Fonction', 'fonction', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for utilisateur field
            //
            $editor = new TextEdit('utilisateur_edit');
            $editor->SetMaxLength(60);
            $editColumn = new CustomEditColumn('Utilisateur', 'utilisateur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for cours field
            //
            $editor = new TextEdit('cours_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Cours', 'cours', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_requis field
            //
            $editor = new TextEdit('no_requis_edit');
            $editColumn = new CustomEditColumn('No Requis', 'no_requis', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_comman field
            //
            $editor = new TextEdit('no_comman_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('No Comman', 'no_comman', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for quantite field
            //
            $editor = new TextEdit('quantite_edit');
            $editColumn = new CustomEditColumn('Quantite', 'quantite', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for prix_unitaire field
            //
            $editor = new TextEdit('prix_unitaire_edit');
            $editColumn = new CustomEditColumn('Prix Unitaire', 'prix_unitaire', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for cout_total field
            //
            $editor = new TextEdit('cout_total_edit');
            $editColumn = new CustomEditColumn('Cout Total', 'cout_total', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_achat field
            //
            $editor = new TextEdit('date_achat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Achat', 'date_achat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_recept field
            //
            $editor = new TextEdit('date_recept_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Recept', 'date_recept', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_fin_d field
            //
            $editor = new TextEdit('date_fin_d_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Fin D', 'date_fin_d', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for code_compt field
            //
            $editor = new TextEdit('code_compt_edit');
            $editColumn = new CustomEditColumn('Code Compt', 'code_compt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextAreaEdit('commentaires_edit', 50, 8);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_groupe field
            //
            $editor = new TextEdit('id_groupe_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Groupe', 'id_groupe', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_pers field
            //
            $editor = new TextEdit('id_pers_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Pers', 'id_pers', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'multi_edit_administratifs_personnel_materiel_mat_sci_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_charge field
            //
            $editor = new DynamicCombobox('id_charge_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Charge', 'id_charge', 'LA2', 'multi_edit_administratifs_personnel_materiel_mat_sci_id_charge_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for disponible field
            //
            $editor = new TextEdit('disponible_edit');
            $editColumn = new CustomEditColumn('Disponible', 'disponible', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for disponible_web field
            //
            $editor = new TextEdit('disponible_web_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Disponible Web', 'disponible_web', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for documents_facture field
            //
            $editor = new TextEdit('documents_facture_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Documents Facture', 'documents_facture', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for document_bon_commande field
            //
            $editor = new TextEdit('document_bon_commande_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Document Bon Commande', 'document_bon_commande', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for document_manuel_utilisation field
            //
            $editor = new TextEdit('document_manuel_utilisation_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Document Manuel Utilisation', 'document_manuel_utilisation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for autres_documents field
            //
            $editor = new TextEdit('autres_documents_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Autres Documents', 'autres_documents', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for no_identif field
            //
            $editor = new TextEdit('no_identif_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('No Identif', 'no_identif', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for transaction field
            //
            $editor = new TextEdit('transaction_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Transaction', 'transaction', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for nom_l_e field
            //
            $editor = new TextEdit('nom_l_e_edit');
            $editor->SetMaxLength(80);
            $editColumn = new CustomEditColumn('Nom L E', 'nom_l_e', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_equipement field
            //
            $editor = new TextEdit('id_equipement_edit');
            $editColumn = new CustomEditColumn('Id Equipement', 'id_equipement', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for marque field
            //
            $editor = new TextEdit('marque_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Marque', 'marque', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_marque field
            //
            $editor = new TextEdit('id_marque_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Marque', 'id_marque', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for manufacture field
            //
            $editor = new TextEdit('manufacture_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Manufacture', 'manufacture', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_manufacturier field
            //
            $editor = new TextEdit('id_manufacturier_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Manufacturier', 'id_manufacturier', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for modele field
            //
            $editor = new TextEdit('modele_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Modele', 'modele', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_modele field
            //
            $editor = new TextEdit('id_modele_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Modele', 'id_modele', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for fournisseur field
            //
            $editor = new TextEdit('fournisseur_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Fournisseur', 'fournisseur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_fournisseur field
            //
            $editor = new TextEdit('id_fournisseur_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Fournisseur', 'id_fournisseur', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_serie field
            //
            $editor = new TextEdit('no_serie_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('No Serie', 'no_serie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for caracteristique field
            //
            $editor = new TextEdit('caracteristique_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Caracteristique', 'caracteristique', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for utilisation field
            //
            $editor = new TextEdit('utilisation_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Utilisation', 'utilisation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for duree_vie field
            //
            $editor = new TextEdit('duree_vie_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Duree Vie', 'duree_vie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for etat field
            //
            $editor = new TextEdit('etat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Etat', 'etat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for fonction field
            //
            $editor = new TextEdit('fonction_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Fonction', 'fonction', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for utilisateur field
            //
            $editor = new TextEdit('utilisateur_edit');
            $editor->SetMaxLength(60);
            $editColumn = new CustomEditColumn('Utilisateur', 'utilisateur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for cours field
            //
            $editor = new TextEdit('cours_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Cours', 'cours', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_requis field
            //
            $editor = new TextEdit('no_requis_edit');
            $editColumn = new CustomEditColumn('No Requis', 'no_requis', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_comman field
            //
            $editor = new TextEdit('no_comman_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('No Comman', 'no_comman', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for quantite field
            //
            $editor = new TextEdit('quantite_edit');
            $editColumn = new CustomEditColumn('Quantite', 'quantite', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for prix_unitaire field
            //
            $editor = new TextEdit('prix_unitaire_edit');
            $editColumn = new CustomEditColumn('Prix Unitaire', 'prix_unitaire', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for cout_total field
            //
            $editor = new TextEdit('cout_total_edit');
            $editColumn = new CustomEditColumn('Cout Total', 'cout_total', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_achat field
            //
            $editor = new TextEdit('date_achat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Achat', 'date_achat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_recept field
            //
            $editor = new TextEdit('date_recept_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Recept', 'date_recept', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_fin_d field
            //
            $editor = new TextEdit('date_fin_d_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Fin D', 'date_fin_d', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for code_compt field
            //
            $editor = new TextEdit('code_compt_edit');
            $editColumn = new CustomEditColumn('Code Compt', 'code_compt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextAreaEdit('commentaires_edit', 50, 8);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_groupe field
            //
            $editor = new TextEdit('id_groupe_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Groupe', 'id_groupe', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_pers field
            //
            $editor = new TextEdit('id_pers_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Pers', 'id_pers', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'insert_administratifs_personnel_materiel_mat_sci_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_charge field
            //
            $editor = new DynamicCombobox('id_charge_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Charge', 'id_charge', 'LA2', 'insert_administratifs_personnel_materiel_mat_sci_id_charge_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for disponible field
            //
            $editor = new TextEdit('disponible_edit');
            $editColumn = new CustomEditColumn('Disponible', 'disponible', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for disponible_web field
            //
            $editor = new TextEdit('disponible_web_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Disponible Web', 'disponible_web', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for documents_facture field
            //
            $editor = new TextEdit('documents_facture_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Documents Facture', 'documents_facture', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for document_bon_commande field
            //
            $editor = new TextEdit('document_bon_commande_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Document Bon Commande', 'document_bon_commande', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for document_manuel_utilisation field
            //
            $editor = new TextEdit('document_manuel_utilisation_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Document Manuel Utilisation', 'document_manuel_utilisation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for autres_documents field
            //
            $editor = new TextEdit('autres_documents_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Autres Documents', 'autres_documents', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for id_mat_sci field
            //
            $column = new NumberViewColumn('id_mat_sci', 'id_mat_sci', 'Id Mat Sci', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_identif field
            //
            $column = new TextViewColumn('no_identif', 'no_identif', 'No Identif', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for transaction field
            //
            $column = new TextViewColumn('transaction', 'transaction', 'Transaction', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom_l_e field
            //
            $column = new TextViewColumn('nom_l_e', 'nom_l_e', 'Nom L E', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_equipement field
            //
            $column = new NumberViewColumn('id_equipement', 'id_equipement', 'Id Equipement', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for marque field
            //
            $column = new TextViewColumn('marque', 'marque', 'Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_marque field
            //
            $column = new TextViewColumn('id_marque', 'id_marque', 'Id Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for manufacture field
            //
            $column = new TextViewColumn('manufacture', 'manufacture', 'Manufacture', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_manufacturier field
            //
            $column = new TextViewColumn('id_manufacturier', 'id_manufacturier', 'Id Manufacturier', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for modele field
            //
            $column = new TextViewColumn('modele', 'modele', 'Modele', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_modele field
            //
            $column = new TextViewColumn('id_modele', 'id_modele', 'Id Modele', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for fournisseur field
            //
            $column = new TextViewColumn('fournisseur', 'fournisseur', 'Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_fournisseur field
            //
            $column = new TextViewColumn('id_fournisseur', 'id_fournisseur', 'Id Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for caracteristique field
            //
            $column = new TextViewColumn('caracteristique', 'caracteristique', 'Caracteristique', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for utilisation field
            //
            $column = new TextViewColumn('utilisation', 'utilisation', 'Utilisation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for duree_vie field
            //
            $column = new TextViewColumn('duree_vie', 'duree_vie', 'Duree Vie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for etat field
            //
            $column = new TextViewColumn('etat', 'etat', 'Etat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for fonction field
            //
            $column = new TextViewColumn('fonction', 'fonction', 'Fonction', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for utilisateur field
            //
            $column = new TextViewColumn('utilisateur', 'utilisateur', 'Utilisateur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for cours field
            //
            $column = new TextViewColumn('cours', 'cours', 'Cours', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_requis field
            //
            $column = new NumberViewColumn('no_requis', 'no_requis', 'No Requis', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_comman field
            //
            $column = new TextViewColumn('no_comman', 'no_comman', 'No Comman', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for quantite field
            //
            $column = new NumberViewColumn('quantite', 'quantite', 'Quantite', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for prix_unitaire field
            //
            $column = new NumberViewColumn('prix_unitaire', 'prix_unitaire', 'Prix Unitaire', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for cout_total field
            //
            $column = new NumberViewColumn('cout_total', 'cout_total', 'Cout Total', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_recept field
            //
            $column = new TextViewColumn('date_recept', 'date_recept', 'Date Recept', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_fin_d field
            //
            $column = new TextViewColumn('date_fin_d', 'date_fin_d', 'Date Fin D', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for code_compt field
            //
            $column = new NumberViewColumn('code_compt', 'code_compt', 'Code Compt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'id_groupe', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new TextViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_charge', 'LA2', 'Id Charge', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for disponible field
            //
            $column = new NumberViewColumn('disponible', 'disponible', 'Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for disponible_web field
            //
            $column = new TextViewColumn('disponible_web', 'disponible_web', 'Disponible Web', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for documents_facture field
            //
            $column = new TextViewColumn('documents_facture', 'documents_facture', 'Documents Facture', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for document_bon_commande field
            //
            $column = new TextViewColumn('document_bon_commande', 'document_bon_commande', 'Document Bon Commande', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for document_manuel_utilisation field
            //
            $column = new TextViewColumn('document_manuel_utilisation', 'document_manuel_utilisation', 'Document Manuel Utilisation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for autres_documents field
            //
            $column = new TextViewColumn('autres_documents', 'autres_documents', 'Autres Documents', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for id_mat_sci field
            //
            $column = new NumberViewColumn('id_mat_sci', 'id_mat_sci', 'Id Mat Sci', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for no_identif field
            //
            $column = new TextViewColumn('no_identif', 'no_identif', 'No Identif', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for transaction field
            //
            $column = new TextViewColumn('transaction', 'transaction', 'Transaction', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom_l_e field
            //
            $column = new TextViewColumn('nom_l_e', 'nom_l_e', 'Nom L E', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_equipement field
            //
            $column = new NumberViewColumn('id_equipement', 'id_equipement', 'Id Equipement', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for marque field
            //
            $column = new TextViewColumn('marque', 'marque', 'Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_marque field
            //
            $column = new TextViewColumn('id_marque', 'id_marque', 'Id Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for manufacture field
            //
            $column = new TextViewColumn('manufacture', 'manufacture', 'Manufacture', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_manufacturier field
            //
            $column = new TextViewColumn('id_manufacturier', 'id_manufacturier', 'Id Manufacturier', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for modele field
            //
            $column = new TextViewColumn('modele', 'modele', 'Modele', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_modele field
            //
            $column = new TextViewColumn('id_modele', 'id_modele', 'Id Modele', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for fournisseur field
            //
            $column = new TextViewColumn('fournisseur', 'fournisseur', 'Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_fournisseur field
            //
            $column = new TextViewColumn('id_fournisseur', 'id_fournisseur', 'Id Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for caracteristique field
            //
            $column = new TextViewColumn('caracteristique', 'caracteristique', 'Caracteristique', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for utilisation field
            //
            $column = new TextViewColumn('utilisation', 'utilisation', 'Utilisation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for duree_vie field
            //
            $column = new TextViewColumn('duree_vie', 'duree_vie', 'Duree Vie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for etat field
            //
            $column = new TextViewColumn('etat', 'etat', 'Etat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for fonction field
            //
            $column = new TextViewColumn('fonction', 'fonction', 'Fonction', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for utilisateur field
            //
            $column = new TextViewColumn('utilisateur', 'utilisateur', 'Utilisateur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for cours field
            //
            $column = new TextViewColumn('cours', 'cours', 'Cours', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_requis field
            //
            $column = new NumberViewColumn('no_requis', 'no_requis', 'No Requis', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for no_comman field
            //
            $column = new TextViewColumn('no_comman', 'no_comman', 'No Comman', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for quantite field
            //
            $column = new NumberViewColumn('quantite', 'quantite', 'Quantite', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for prix_unitaire field
            //
            $column = new NumberViewColumn('prix_unitaire', 'prix_unitaire', 'Prix Unitaire', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for cout_total field
            //
            $column = new NumberViewColumn('cout_total', 'cout_total', 'Cout Total', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_recept field
            //
            $column = new TextViewColumn('date_recept', 'date_recept', 'Date Recept', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_fin_d field
            //
            $column = new TextViewColumn('date_fin_d', 'date_fin_d', 'Date Fin D', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for code_compt field
            //
            $column = new NumberViewColumn('code_compt', 'code_compt', 'Code Compt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'id_groupe', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new TextViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_charge', 'LA2', 'Id Charge', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for disponible field
            //
            $column = new NumberViewColumn('disponible', 'disponible', 'Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for disponible_web field
            //
            $column = new TextViewColumn('disponible_web', 'disponible_web', 'Disponible Web', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for documents_facture field
            //
            $column = new TextViewColumn('documents_facture', 'documents_facture', 'Documents Facture', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for document_bon_commande field
            //
            $column = new TextViewColumn('document_bon_commande', 'document_bon_commande', 'Document Bon Commande', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for document_manuel_utilisation field
            //
            $column = new TextViewColumn('document_manuel_utilisation', 'document_manuel_utilisation', 'Document Manuel Utilisation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for autres_documents field
            //
            $column = new TextViewColumn('autres_documents', 'autres_documents', 'Autres Documents', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for no_identif field
            //
            $column = new TextViewColumn('no_identif', 'no_identif', 'No Identif', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for transaction field
            //
            $column = new TextViewColumn('transaction', 'transaction', 'Transaction', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom_l_e field
            //
            $column = new TextViewColumn('nom_l_e', 'nom_l_e', 'Nom L E', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_equipement field
            //
            $column = new NumberViewColumn('id_equipement', 'id_equipement', 'Id Equipement', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for marque field
            //
            $column = new TextViewColumn('marque', 'marque', 'Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_marque field
            //
            $column = new TextViewColumn('id_marque', 'id_marque', 'Id Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for manufacture field
            //
            $column = new TextViewColumn('manufacture', 'manufacture', 'Manufacture', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_manufacturier field
            //
            $column = new TextViewColumn('id_manufacturier', 'id_manufacturier', 'Id Manufacturier', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for modele field
            //
            $column = new TextViewColumn('modele', 'modele', 'Modele', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_modele field
            //
            $column = new TextViewColumn('id_modele', 'id_modele', 'Id Modele', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for fournisseur field
            //
            $column = new TextViewColumn('fournisseur', 'fournisseur', 'Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_fournisseur field
            //
            $column = new TextViewColumn('id_fournisseur', 'id_fournisseur', 'Id Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for caracteristique field
            //
            $column = new TextViewColumn('caracteristique', 'caracteristique', 'Caracteristique', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for utilisation field
            //
            $column = new TextViewColumn('utilisation', 'utilisation', 'Utilisation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for duree_vie field
            //
            $column = new TextViewColumn('duree_vie', 'duree_vie', 'Duree Vie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for etat field
            //
            $column = new TextViewColumn('etat', 'etat', 'Etat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for fonction field
            //
            $column = new TextViewColumn('fonction', 'fonction', 'Fonction', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for utilisateur field
            //
            $column = new TextViewColumn('utilisateur', 'utilisateur', 'Utilisateur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for cours field
            //
            $column = new TextViewColumn('cours', 'cours', 'Cours', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_requis field
            //
            $column = new NumberViewColumn('no_requis', 'no_requis', 'No Requis', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_comman field
            //
            $column = new TextViewColumn('no_comman', 'no_comman', 'No Comman', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for quantite field
            //
            $column = new NumberViewColumn('quantite', 'quantite', 'Quantite', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for prix_unitaire field
            //
            $column = new NumberViewColumn('prix_unitaire', 'prix_unitaire', 'Prix Unitaire', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for cout_total field
            //
            $column = new NumberViewColumn('cout_total', 'cout_total', 'Cout Total', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_recept field
            //
            $column = new TextViewColumn('date_recept', 'date_recept', 'Date Recept', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_fin_d field
            //
            $column = new TextViewColumn('date_fin_d', 'date_fin_d', 'Date Fin D', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for code_compt field
            //
            $column = new NumberViewColumn('code_compt', 'code_compt', 'Code Compt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'id_groupe', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new TextViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_charge', 'LA2', 'Id Charge', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for disponible field
            //
            $column = new NumberViewColumn('disponible', 'disponible', 'Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for disponible_web field
            //
            $column = new TextViewColumn('disponible_web', 'disponible_web', 'Disponible Web', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for documents_facture field
            //
            $column = new TextViewColumn('documents_facture', 'documents_facture', 'Documents Facture', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for document_bon_commande field
            //
            $column = new TextViewColumn('document_bon_commande', 'document_bon_commande', 'Document Bon Commande', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for document_manuel_utilisation field
            //
            $column = new TextViewColumn('document_manuel_utilisation', 'document_manuel_utilisation', 'Document Manuel Utilisation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for autres_documents field
            //
            $column = new TextViewColumn('autres_documents', 'autres_documents', 'Autres Documents', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(true);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel_materiel_mat_sci_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel_materiel_mat_sci_id_charge_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel_materiel_mat_sci_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel_materiel_mat_sci_id_charge_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel_materiel_mat_sci_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel_materiel_mat_sci_id_charge_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel_materiel_mat_sci_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel_materiel_mat_sci_id_charge_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }
    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class administratifs_personnel_materiel_surplusPage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Surplus');
            $this->SetMenuLabel('Surplus en tant que membre personnel.');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."surplus"');
            $this->dataset->addFields(
                array(
                    new IntegerField('no_lot', true, true),
                    new StringField('no_uqam', true),
                    new StringField('description'),
                    new StringField('no_serie', true),
                    new StringField('date_envoie', true),
                    new IntegerField('id_personnel'),
                    new IntegerField('id_professeur')
                )
            );
            $this->dataset->AddLookupField('id_personnel', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('id_professeur', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA2', 'LT2'), 'LT2');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'no_lot', 'no_lot', 'No Lot'),
                new FilterColumn($this->dataset, 'no_uqam', 'no_uqam', 'No Uqam'),
                new FilterColumn($this->dataset, 'description', 'description', 'Description'),
                new FilterColumn($this->dataset, 'no_serie', 'no_serie', 'No Serie'),
                new FilterColumn($this->dataset, 'date_envoie', 'date_envoie', 'Date Envoie'),
                new FilterColumn($this->dataset, 'id_personnel', 'LA1', 'Id Personnel'),
                new FilterColumn($this->dataset, 'id_professeur', 'LA2', 'Id Professeur')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['no_lot'])
                ->addColumn($columns['no_uqam'])
                ->addColumn($columns['description'])
                ->addColumn($columns['no_serie'])
                ->addColumn($columns['date_envoie'])
                ->addColumn($columns['id_personnel'])
                ->addColumn($columns['id_professeur']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_personnel')
                ->setOptionsFor('id_professeur');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('no_lot_edit');
            
            $filterBuilder->addColumn(
                $columns['no_lot'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_uqam_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['no_uqam'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('description_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['description'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_serie_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['no_serie'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('date_envoie_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['date_envoie'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_personnel_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel_materiel_surplus_id_personnel_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_personnel', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel_materiel_surplus_id_personnel_search');
            
            $text_editor = new TextEdit('id_personnel');
            
            $filterBuilder->addColumn(
                $columns['id_personnel'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_professeur_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel_materiel_surplus_id_professeur_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_professeur', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel_materiel_surplus_id_professeur_search');
            
            $text_editor = new TextEdit('id_professeur');
            
            $filterBuilder->addColumn(
                $columns['id_professeur'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for no_lot field
            //
            $column = new NumberViewColumn('no_lot', 'no_lot', 'No Lot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_uqam field
            //
            $column = new TextViewColumn('no_uqam', 'no_uqam', 'No Uqam', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_envoie field
            //
            $column = new TextViewColumn('date_envoie', 'date_envoie', 'Date Envoie', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_personnel', 'LA1', 'Id Personnel', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur', 'LA2', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for no_lot field
            //
            $column = new NumberViewColumn('no_lot', 'no_lot', 'No Lot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_uqam field
            //
            $column = new TextViewColumn('no_uqam', 'no_uqam', 'No Uqam', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_envoie field
            //
            $column = new TextViewColumn('date_envoie', 'date_envoie', 'Date Envoie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_personnel', 'LA1', 'Id Personnel', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur', 'LA2', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for no_lot field
            //
            $editor = new TextEdit('no_lot_edit');
            $editColumn = new CustomEditColumn('No Lot', 'no_lot', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_uqam field
            //
            $editor = new TextEdit('no_uqam_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('No Uqam', 'no_uqam', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for description field
            //
            $editor = new TextEdit('description_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_serie field
            //
            $editor = new TextEdit('no_serie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Serie', 'no_serie', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_envoie field
            //
            $editor = new TextEdit('date_envoie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Envoie', 'date_envoie', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_personnel field
            //
            $editor = new DynamicCombobox('id_personnel_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Personnel', 'id_personnel', 'LA1', 'edit_administratifs_personnel_materiel_surplus_id_personnel_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_professeur field
            //
            $editor = new DynamicCombobox('id_professeur_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Professeur', 'id_professeur', 'LA2', 'edit_administratifs_personnel_materiel_surplus_id_professeur_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for no_uqam field
            //
            $editor = new TextEdit('no_uqam_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('No Uqam', 'no_uqam', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for description field
            //
            $editor = new TextEdit('description_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_serie field
            //
            $editor = new TextEdit('no_serie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Serie', 'no_serie', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_envoie field
            //
            $editor = new TextEdit('date_envoie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Envoie', 'date_envoie', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_personnel field
            //
            $editor = new DynamicCombobox('id_personnel_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Personnel', 'id_personnel', 'LA1', 'multi_edit_administratifs_personnel_materiel_surplus_id_personnel_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_professeur field
            //
            $editor = new DynamicCombobox('id_professeur_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Professeur', 'id_professeur', 'LA2', 'multi_edit_administratifs_personnel_materiel_surplus_id_professeur_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for no_lot field
            //
            $editor = new TextEdit('no_lot_edit');
            $editColumn = new CustomEditColumn('No Lot', 'no_lot', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_uqam field
            //
            $editor = new TextEdit('no_uqam_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('No Uqam', 'no_uqam', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for description field
            //
            $editor = new TextEdit('description_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_serie field
            //
            $editor = new TextEdit('no_serie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Serie', 'no_serie', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_envoie field
            //
            $editor = new TextEdit('date_envoie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Envoie', 'date_envoie', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_personnel field
            //
            $editor = new DynamicCombobox('id_personnel_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Personnel', 'id_personnel', 'LA1', 'insert_administratifs_personnel_materiel_surplus_id_personnel_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_professeur field
            //
            $editor = new DynamicCombobox('id_professeur_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Professeur', 'id_professeur', 'LA2', 'insert_administratifs_personnel_materiel_surplus_id_professeur_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for no_lot field
            //
            $column = new NumberViewColumn('no_lot', 'no_lot', 'No Lot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_uqam field
            //
            $column = new TextViewColumn('no_uqam', 'no_uqam', 'No Uqam', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_envoie field
            //
            $column = new TextViewColumn('date_envoie', 'date_envoie', 'Date Envoie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_personnel', 'LA1', 'Id Personnel', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur', 'LA2', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for no_lot field
            //
            $column = new NumberViewColumn('no_lot', 'no_lot', 'No Lot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for no_uqam field
            //
            $column = new TextViewColumn('no_uqam', 'no_uqam', 'No Uqam', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_envoie field
            //
            $column = new TextViewColumn('date_envoie', 'date_envoie', 'Date Envoie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_personnel', 'LA1', 'Id Personnel', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur', 'LA2', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for no_lot field
            //
            $column = new NumberViewColumn('no_lot', 'no_lot', 'No Lot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_uqam field
            //
            $column = new TextViewColumn('no_uqam', 'no_uqam', 'No Uqam', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_envoie field
            //
            $column = new TextViewColumn('date_envoie', 'date_envoie', 'Date Envoie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_personnel', 'LA1', 'Id Personnel', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur', 'LA2', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(true);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel_materiel_surplus_id_personnel_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel_materiel_surplus_id_professeur_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel_materiel_surplus_id_personnel_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel_materiel_surplus_id_professeur_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel_materiel_surplus_id_personnel_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel_materiel_surplus_id_professeur_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel_materiel_surplus_id_personnel_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel_materiel_surplus_id_professeur_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }
    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class administratifs_personnel_materiel_surplus01Page extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Surplus');
            $this->SetMenuLabel('Surplus en tant que prof');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."surplus"');
            $this->dataset->addFields(
                array(
                    new IntegerField('no_lot', true, true),
                    new StringField('no_uqam', true),
                    new StringField('description'),
                    new StringField('no_serie', true),
                    new StringField('date_envoie', true),
                    new IntegerField('id_personnel'),
                    new IntegerField('id_professeur')
                )
            );
            $this->dataset->AddLookupField('id_personnel', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('id_professeur', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA2', 'LT2'), 'LT2');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'no_lot', 'no_lot', 'No Lot'),
                new FilterColumn($this->dataset, 'no_uqam', 'no_uqam', 'No Uqam'),
                new FilterColumn($this->dataset, 'description', 'description', 'Description'),
                new FilterColumn($this->dataset, 'no_serie', 'no_serie', 'No Serie'),
                new FilterColumn($this->dataset, 'date_envoie', 'date_envoie', 'Date Envoie'),
                new FilterColumn($this->dataset, 'id_personnel', 'LA1', 'Id Personnel'),
                new FilterColumn($this->dataset, 'id_professeur', 'LA2', 'Id Professeur')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['no_lot'])
                ->addColumn($columns['no_uqam'])
                ->addColumn($columns['description'])
                ->addColumn($columns['no_serie'])
                ->addColumn($columns['date_envoie'])
                ->addColumn($columns['id_personnel'])
                ->addColumn($columns['id_professeur']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_personnel')
                ->setOptionsFor('id_professeur');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('no_lot_edit');
            
            $filterBuilder->addColumn(
                $columns['no_lot'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_uqam_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['no_uqam'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('description_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['description'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_serie_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['no_serie'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('date_envoie_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['date_envoie'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_personnel_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel_materiel_surplus01_id_personnel_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_personnel', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel_materiel_surplus01_id_personnel_search');
            
            $text_editor = new TextEdit('id_personnel');
            
            $filterBuilder->addColumn(
                $columns['id_personnel'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_professeur_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel_materiel_surplus01_id_professeur_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_professeur', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel_materiel_surplus01_id_professeur_search');
            
            $text_editor = new TextEdit('id_professeur');
            
            $filterBuilder->addColumn(
                $columns['id_professeur'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for no_lot field
            //
            $column = new NumberViewColumn('no_lot', 'no_lot', 'No Lot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_uqam field
            //
            $column = new TextViewColumn('no_uqam', 'no_uqam', 'No Uqam', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_envoie field
            //
            $column = new TextViewColumn('date_envoie', 'date_envoie', 'Date Envoie', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_personnel', 'LA1', 'Id Personnel', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur', 'LA2', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for no_lot field
            //
            $column = new NumberViewColumn('no_lot', 'no_lot', 'No Lot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_uqam field
            //
            $column = new TextViewColumn('no_uqam', 'no_uqam', 'No Uqam', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_envoie field
            //
            $column = new TextViewColumn('date_envoie', 'date_envoie', 'Date Envoie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_personnel', 'LA1', 'Id Personnel', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur', 'LA2', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for no_lot field
            //
            $editor = new TextEdit('no_lot_edit');
            $editColumn = new CustomEditColumn('No Lot', 'no_lot', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_uqam field
            //
            $editor = new TextEdit('no_uqam_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('No Uqam', 'no_uqam', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for description field
            //
            $editor = new TextEdit('description_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_serie field
            //
            $editor = new TextEdit('no_serie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Serie', 'no_serie', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_envoie field
            //
            $editor = new TextEdit('date_envoie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Envoie', 'date_envoie', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_personnel field
            //
            $editor = new DynamicCombobox('id_personnel_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Personnel', 'id_personnel', 'LA1', 'edit_administratifs_personnel_materiel_surplus01_id_personnel_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_professeur field
            //
            $editor = new DynamicCombobox('id_professeur_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Professeur', 'id_professeur', 'LA2', 'edit_administratifs_personnel_materiel_surplus01_id_professeur_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for no_uqam field
            //
            $editor = new TextEdit('no_uqam_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('No Uqam', 'no_uqam', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for description field
            //
            $editor = new TextEdit('description_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_serie field
            //
            $editor = new TextEdit('no_serie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Serie', 'no_serie', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_envoie field
            //
            $editor = new TextEdit('date_envoie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Envoie', 'date_envoie', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_personnel field
            //
            $editor = new DynamicCombobox('id_personnel_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Personnel', 'id_personnel', 'LA1', 'multi_edit_administratifs_personnel_materiel_surplus01_id_personnel_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_professeur field
            //
            $editor = new DynamicCombobox('id_professeur_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Professeur', 'id_professeur', 'LA2', 'multi_edit_administratifs_personnel_materiel_surplus01_id_professeur_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for no_lot field
            //
            $editor = new TextEdit('no_lot_edit');
            $editColumn = new CustomEditColumn('No Lot', 'no_lot', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_uqam field
            //
            $editor = new TextEdit('no_uqam_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('No Uqam', 'no_uqam', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for description field
            //
            $editor = new TextEdit('description_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_serie field
            //
            $editor = new TextEdit('no_serie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Serie', 'no_serie', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_envoie field
            //
            $editor = new TextEdit('date_envoie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Envoie', 'date_envoie', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_personnel field
            //
            $editor = new DynamicCombobox('id_personnel_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Personnel', 'id_personnel', 'LA1', 'insert_administratifs_personnel_materiel_surplus01_id_personnel_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_professeur field
            //
            $editor = new DynamicCombobox('id_professeur_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Professeur', 'id_professeur', 'LA2', 'insert_administratifs_personnel_materiel_surplus01_id_professeur_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for no_lot field
            //
            $column = new NumberViewColumn('no_lot', 'no_lot', 'No Lot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_uqam field
            //
            $column = new TextViewColumn('no_uqam', 'no_uqam', 'No Uqam', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_envoie field
            //
            $column = new TextViewColumn('date_envoie', 'date_envoie', 'Date Envoie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_personnel', 'LA1', 'Id Personnel', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur', 'LA2', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for no_lot field
            //
            $column = new NumberViewColumn('no_lot', 'no_lot', 'No Lot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for no_uqam field
            //
            $column = new TextViewColumn('no_uqam', 'no_uqam', 'No Uqam', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_envoie field
            //
            $column = new TextViewColumn('date_envoie', 'date_envoie', 'Date Envoie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_personnel', 'LA1', 'Id Personnel', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur', 'LA2', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for no_lot field
            //
            $column = new NumberViewColumn('no_lot', 'no_lot', 'No Lot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_uqam field
            //
            $column = new TextViewColumn('no_uqam', 'no_uqam', 'No Uqam', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_envoie field
            //
            $column = new TextViewColumn('date_envoie', 'date_envoie', 'Date Envoie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_personnel', 'LA1', 'Id Personnel', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur', 'LA2', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(true);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel_materiel_surplus01_id_personnel_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel_materiel_surplus01_id_professeur_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel_materiel_surplus01_id_personnel_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel_materiel_surplus01_id_professeur_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel_materiel_surplus01_id_personnel_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel_materiel_surplus01_id_professeur_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel_materiel_surplus01_id_personnel_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel_materiel_surplus01_id_professeur_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }
    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class administratifs_personnel_reservation_reservation_materiel_informatiquePage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Reservation Materiel Informatique');
            $this->SetMenuLabel('Réserv Mat Info - Etudiant');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"reservation"."reservation_materiel_informatique"');
            $this->dataset->addFields(
                array(
                    new IntegerField('id_reserv_info', true, true, true),
                    new IntegerField('id_mat_info', true),
                    new DateField('date_emprunt'),
                    new DateField('date_de_retour'),
                    new StringField('commentaires'),
                    new IntegerField('id_personne_reservation'),
                    new IntegerField('id_professeur_responsable'),
                    new IntegerField('id_etudiant'),
                    new StringField('justification_emprunt'),
                    new StringField('documents'),
                    new StringField('otrs')
                )
            );
            $this->dataset->AddLookupField('id_mat_info', 'materiel.mat_informatique', new IntegerField('id_mat_inf'), new IntegerField('id_loc', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('id_personne_reservation', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA2', 'LT2'), 'LT2');
            $this->dataset->AddLookupField('id_etudiant', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA3', 'LT3'), 'LT3');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'id_reserv_info', 'id_reserv_info', 'Id Reserv Info'),
                new FilterColumn($this->dataset, 'id_mat_info', 'LA1', 'Id Mat Info'),
                new FilterColumn($this->dataset, 'date_emprunt', 'date_emprunt', 'Date Emprunt'),
                new FilterColumn($this->dataset, 'date_de_retour', 'date_de_retour', 'Date De Retour'),
                new FilterColumn($this->dataset, 'commentaires', 'commentaires', 'Commentaires'),
                new FilterColumn($this->dataset, 'id_personne_reservation', 'LA2', 'Id Personne Reservation'),
                new FilterColumn($this->dataset, 'id_professeur_responsable', 'id_professeur_responsable', 'Id Professeur Responsable'),
                new FilterColumn($this->dataset, 'id_etudiant', 'LA3', 'Id Etudiant'),
                new FilterColumn($this->dataset, 'justification_emprunt', 'justification_emprunt', 'Justification Emprunt'),
                new FilterColumn($this->dataset, 'documents', 'documents', 'Documents'),
                new FilterColumn($this->dataset, 'otrs', 'otrs', 'Otrs')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['id_reserv_info'])
                ->addColumn($columns['id_mat_info'])
                ->addColumn($columns['date_emprunt'])
                ->addColumn($columns['date_de_retour'])
                ->addColumn($columns['commentaires'])
                ->addColumn($columns['id_personne_reservation'])
                ->addColumn($columns['id_professeur_responsable'])
                ->addColumn($columns['id_etudiant'])
                ->addColumn($columns['justification_emprunt'])
                ->addColumn($columns['documents'])
                ->addColumn($columns['otrs']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_mat_info')
                ->setOptionsFor('date_emprunt')
                ->setOptionsFor('date_de_retour')
                ->setOptionsFor('id_personne_reservation')
                ->setOptionsFor('id_etudiant');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('id_reserv_info_edit');
            
            $filterBuilder->addColumn(
                $columns['id_reserv_info'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_mat_info_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel_reservation_reservation_materiel_informatique_id_mat_info_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_mat_info', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel_reservation_reservation_materiel_informatique_id_mat_info_search');
            
            $filterBuilder->addColumn(
                $columns['id_mat_info'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('date_emprunt_edit', false, 'Y-m-d');
            
            $filterBuilder->addColumn(
                $columns['date_emprunt'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('date_de_retour_edit', false, 'Y-m-d');
            
            $filterBuilder->addColumn(
                $columns['date_de_retour'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('commentaires_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['commentaires'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_personne_reservation_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel_reservation_reservation_materiel_informatique_id_personne_reservation_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_personne_reservation', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel_reservation_reservation_materiel_informatique_id_personne_reservation_search');
            
            $text_editor = new TextEdit('id_personne_reservation');
            
            $filterBuilder->addColumn(
                $columns['id_personne_reservation'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_professeur_responsable_edit');
            
            $filterBuilder->addColumn(
                $columns['id_professeur_responsable'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_etudiant_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel_reservation_reservation_materiel_informatique_id_etudiant_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_etudiant', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel_reservation_reservation_materiel_informatique_id_etudiant_search');
            
            $text_editor = new TextEdit('id_etudiant');
            
            $filterBuilder->addColumn(
                $columns['id_etudiant'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('justification_emprunt_edit');
            $main_editor->SetMaxLength(40);
            
            $filterBuilder->addColumn(
                $columns['justification_emprunt'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('documents');
            
            $filterBuilder->addColumn(
                $columns['documents'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('otrs');
            
            $filterBuilder->addColumn(
                $columns['otrs'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for id_reserv_info field
            //
            $column = new NumberViewColumn('id_reserv_info', 'id_reserv_info', 'Id Reserv Info', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_loc field
            //
            $column = new NumberViewColumn('id_mat_info', 'LA1', 'Id Mat Info', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_emprunt field
            //
            $column = new DateTimeViewColumn('date_emprunt', 'date_emprunt', 'Date Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Date De Retour', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_personne_reservation', 'LA2', 'Id Personne Reservation', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_professeur_responsable field
            //
            $column = new NumberViewColumn('id_professeur_responsable', 'id_professeur_responsable', 'Id Professeur Responsable', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_etudiant', 'LA3', 'Id Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for justification_emprunt field
            //
            $column = new TextViewColumn('justification_emprunt', 'justification_emprunt', 'Justification Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for documents field
            //
            $column = new TextViewColumn('documents', 'documents', 'Documents', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for otrs field
            //
            $column = new TextViewColumn('otrs', 'otrs', 'Otrs', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for id_reserv_info field
            //
            $column = new NumberViewColumn('id_reserv_info', 'id_reserv_info', 'Id Reserv Info', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_loc field
            //
            $column = new NumberViewColumn('id_mat_info', 'LA1', 'Id Mat Info', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_emprunt field
            //
            $column = new DateTimeViewColumn('date_emprunt', 'date_emprunt', 'Date Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Date De Retour', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_personne_reservation', 'LA2', 'Id Personne Reservation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_professeur_responsable field
            //
            $column = new NumberViewColumn('id_professeur_responsable', 'id_professeur_responsable', 'Id Professeur Responsable', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_etudiant', 'LA3', 'Id Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for justification_emprunt field
            //
            $column = new TextViewColumn('justification_emprunt', 'justification_emprunt', 'Justification Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for documents field
            //
            $column = new TextViewColumn('documents', 'documents', 'Documents', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for otrs field
            //
            $column = new TextViewColumn('otrs', 'otrs', 'Otrs', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for id_mat_info field
            //
            $editor = new DynamicCombobox('id_mat_info_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_informatique"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_mat_inf', true, true, true),
                    new IntegerField('id_loc'),
                    new StringField('no_uqam'),
                    new StringField('syst_expl'),
                    new StringField('marque'),
                    new StringField('description'),
                    new IntegerField('id_grp'),
                    new StringField('fournisseur'),
                    new StringField('no_serie'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new StringField('prix'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d'),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new StringField('adresse_ip'),
                    new IntegerField('id_adresse_ip'),
                    new IntegerField('id_pers'),
                    new StringField('disponible'),
                    new IntegerField('disponible_web'),
                    new StringField('local'),
                    new IntegerField('id'),
                    new IntegerField('id_pers_new'),
                    new IntegerField('id_inf', false, false, true)
                )
            );
            $lookupDataset->setOrderByField('id_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Mat Info', 'id_mat_info', 'LA1', 'edit_administratifs_personnel_reservation_reservation_materiel_informatique_id_mat_info_search', $editor, $this->dataset, $lookupDataset, 'id_mat_inf', 'id_loc', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_emprunt field
            //
            $editor = new DateTimeEdit('date_emprunt_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Date Emprunt', 'date_emprunt', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_de_retour field
            //
            $editor = new DateTimeEdit('date_de_retour_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Date De Retour', 'date_de_retour', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextEdit('commentaires_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_personne_reservation field
            //
            $editor = new DynamicCombobox('id_personne_reservation_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Personne Reservation', 'id_personne_reservation', 'LA2', 'edit_administratifs_personnel_reservation_reservation_materiel_informatique_id_personne_reservation_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_professeur_responsable field
            //
            $editor = new TextEdit('id_professeur_responsable_edit');
            $editColumn = new CustomEditColumn('Id Professeur Responsable', 'id_professeur_responsable', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_etudiant field
            //
            $editor = new DynamicCombobox('id_etudiant_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Etudiant', 'id_etudiant', 'LA3', 'edit_administratifs_personnel_reservation_reservation_materiel_informatique_id_etudiant_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for justification_emprunt field
            //
            $editor = new TextEdit('justification_emprunt_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Justification Emprunt', 'justification_emprunt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for documents field
            //
            $editor = new TextAreaEdit('documents_edit', 50, 8);
            $editColumn = new CustomEditColumn('Documents', 'documents', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for otrs field
            //
            $editor = new TextAreaEdit('otrs_edit', 50, 8);
            $editColumn = new CustomEditColumn('Otrs', 'otrs', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for id_mat_info field
            //
            $editor = new DynamicCombobox('id_mat_info_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_informatique"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_mat_inf', true, true, true),
                    new IntegerField('id_loc'),
                    new StringField('no_uqam'),
                    new StringField('syst_expl'),
                    new StringField('marque'),
                    new StringField('description'),
                    new IntegerField('id_grp'),
                    new StringField('fournisseur'),
                    new StringField('no_serie'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new StringField('prix'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d'),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new StringField('adresse_ip'),
                    new IntegerField('id_adresse_ip'),
                    new IntegerField('id_pers'),
                    new StringField('disponible'),
                    new IntegerField('disponible_web'),
                    new StringField('local'),
                    new IntegerField('id'),
                    new IntegerField('id_pers_new'),
                    new IntegerField('id_inf', false, false, true)
                )
            );
            $lookupDataset->setOrderByField('id_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Mat Info', 'id_mat_info', 'LA1', 'multi_edit_administratifs_personnel_reservation_reservation_materiel_informatique_id_mat_info_search', $editor, $this->dataset, $lookupDataset, 'id_mat_inf', 'id_loc', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_emprunt field
            //
            $editor = new DateTimeEdit('date_emprunt_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Date Emprunt', 'date_emprunt', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_de_retour field
            //
            $editor = new DateTimeEdit('date_de_retour_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Date De Retour', 'date_de_retour', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextEdit('commentaires_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_personne_reservation field
            //
            $editor = new DynamicCombobox('id_personne_reservation_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Personne Reservation', 'id_personne_reservation', 'LA2', 'multi_edit_administratifs_personnel_reservation_reservation_materiel_informatique_id_personne_reservation_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_professeur_responsable field
            //
            $editor = new TextEdit('id_professeur_responsable_edit');
            $editColumn = new CustomEditColumn('Id Professeur Responsable', 'id_professeur_responsable', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_etudiant field
            //
            $editor = new DynamicCombobox('id_etudiant_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Etudiant', 'id_etudiant', 'LA3', 'multi_edit_administratifs_personnel_reservation_reservation_materiel_informatique_id_etudiant_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for justification_emprunt field
            //
            $editor = new TextEdit('justification_emprunt_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Justification Emprunt', 'justification_emprunt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for documents field
            //
            $editor = new TextAreaEdit('documents_edit', 50, 8);
            $editColumn = new CustomEditColumn('Documents', 'documents', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for otrs field
            //
            $editor = new TextAreaEdit('otrs_edit', 50, 8);
            $editColumn = new CustomEditColumn('Otrs', 'otrs', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for id_mat_info field
            //
            $editor = new DynamicCombobox('id_mat_info_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_informatique"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_mat_inf', true, true, true),
                    new IntegerField('id_loc'),
                    new StringField('no_uqam'),
                    new StringField('syst_expl'),
                    new StringField('marque'),
                    new StringField('description'),
                    new IntegerField('id_grp'),
                    new StringField('fournisseur'),
                    new StringField('no_serie'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new StringField('prix'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d'),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new StringField('adresse_ip'),
                    new IntegerField('id_adresse_ip'),
                    new IntegerField('id_pers'),
                    new StringField('disponible'),
                    new IntegerField('disponible_web'),
                    new StringField('local'),
                    new IntegerField('id'),
                    new IntegerField('id_pers_new'),
                    new IntegerField('id_inf', false, false, true)
                )
            );
            $lookupDataset->setOrderByField('id_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Mat Info', 'id_mat_info', 'LA1', 'insert_administratifs_personnel_reservation_reservation_materiel_informatique_id_mat_info_search', $editor, $this->dataset, $lookupDataset, 'id_mat_inf', 'id_loc', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_emprunt field
            //
            $editor = new DateTimeEdit('date_emprunt_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Date Emprunt', 'date_emprunt', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_de_retour field
            //
            $editor = new DateTimeEdit('date_de_retour_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Date De Retour', 'date_de_retour', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextEdit('commentaires_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_personne_reservation field
            //
            $editor = new DynamicCombobox('id_personne_reservation_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Personne Reservation', 'id_personne_reservation', 'LA2', 'insert_administratifs_personnel_reservation_reservation_materiel_informatique_id_personne_reservation_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_professeur_responsable field
            //
            $editor = new TextEdit('id_professeur_responsable_edit');
            $editColumn = new CustomEditColumn('Id Professeur Responsable', 'id_professeur_responsable', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_etudiant field
            //
            $editor = new DynamicCombobox('id_etudiant_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Etudiant', 'id_etudiant', 'LA3', 'insert_administratifs_personnel_reservation_reservation_materiel_informatique_id_etudiant_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for justification_emprunt field
            //
            $editor = new TextEdit('justification_emprunt_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Justification Emprunt', 'justification_emprunt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for documents field
            //
            $editor = new TextAreaEdit('documents_edit', 50, 8);
            $editColumn = new CustomEditColumn('Documents', 'documents', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for otrs field
            //
            $editor = new TextAreaEdit('otrs_edit', 50, 8);
            $editColumn = new CustomEditColumn('Otrs', 'otrs', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for id_reserv_info field
            //
            $column = new NumberViewColumn('id_reserv_info', 'id_reserv_info', 'Id Reserv Info', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_loc field
            //
            $column = new NumberViewColumn('id_mat_info', 'LA1', 'Id Mat Info', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_emprunt field
            //
            $column = new DateTimeViewColumn('date_emprunt', 'date_emprunt', 'Date Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Date De Retour', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddPrintColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_personne_reservation', 'LA2', 'Id Personne Reservation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_professeur_responsable field
            //
            $column = new NumberViewColumn('id_professeur_responsable', 'id_professeur_responsable', 'Id Professeur Responsable', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_etudiant', 'LA3', 'Id Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for justification_emprunt field
            //
            $column = new TextViewColumn('justification_emprunt', 'justification_emprunt', 'Justification Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for documents field
            //
            $column = new TextViewColumn('documents', 'documents', 'Documents', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for otrs field
            //
            $column = new TextViewColumn('otrs', 'otrs', 'Otrs', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for id_reserv_info field
            //
            $column = new NumberViewColumn('id_reserv_info', 'id_reserv_info', 'Id Reserv Info', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for id_loc field
            //
            $column = new NumberViewColumn('id_mat_info', 'LA1', 'Id Mat Info', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for date_emprunt field
            //
            $column = new DateTimeViewColumn('date_emprunt', 'date_emprunt', 'Date Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddExportColumn($column);
            
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Date De Retour', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddExportColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_personne_reservation', 'LA2', 'Id Personne Reservation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_professeur_responsable field
            //
            $column = new NumberViewColumn('id_professeur_responsable', 'id_professeur_responsable', 'Id Professeur Responsable', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_etudiant', 'LA3', 'Id Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for justification_emprunt field
            //
            $column = new TextViewColumn('justification_emprunt', 'justification_emprunt', 'Justification Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for documents field
            //
            $column = new TextViewColumn('documents', 'documents', 'Documents', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for otrs field
            //
            $column = new TextViewColumn('otrs', 'otrs', 'Otrs', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for id_loc field
            //
            $column = new NumberViewColumn('id_mat_info', 'LA1', 'Id Mat Info', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_emprunt field
            //
            $column = new DateTimeViewColumn('date_emprunt', 'date_emprunt', 'Date Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Date De Retour', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddCompareColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_personne_reservation', 'LA2', 'Id Personne Reservation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_professeur_responsable field
            //
            $column = new NumberViewColumn('id_professeur_responsable', 'id_professeur_responsable', 'Id Professeur Responsable', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_etudiant', 'LA3', 'Id Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for justification_emprunt field
            //
            $column = new TextViewColumn('justification_emprunt', 'justification_emprunt', 'Justification Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for documents field
            //
            $column = new TextViewColumn('documents', 'documents', 'Documents', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for otrs field
            //
            $column = new TextViewColumn('otrs', 'otrs', 'Otrs', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(true);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_informatique"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_mat_inf', true, true, true),
                    new IntegerField('id_loc'),
                    new StringField('no_uqam'),
                    new StringField('syst_expl'),
                    new StringField('marque'),
                    new StringField('description'),
                    new IntegerField('id_grp'),
                    new StringField('fournisseur'),
                    new StringField('no_serie'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new StringField('prix'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d'),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new StringField('adresse_ip'),
                    new IntegerField('id_adresse_ip'),
                    new IntegerField('id_pers'),
                    new StringField('disponible'),
                    new IntegerField('disponible_web'),
                    new StringField('local'),
                    new IntegerField('id'),
                    new IntegerField('id_pers_new'),
                    new IntegerField('id_inf', false, false, true)
                )
            );
            $lookupDataset->setOrderByField('id_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel_reservation_reservation_materiel_informatique_id_mat_info_search', 'id_mat_inf', 'id_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel_reservation_reservation_materiel_informatique_id_personne_reservation_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel_reservation_reservation_materiel_informatique_id_etudiant_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_informatique"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_mat_inf', true, true, true),
                    new IntegerField('id_loc'),
                    new StringField('no_uqam'),
                    new StringField('syst_expl'),
                    new StringField('marque'),
                    new StringField('description'),
                    new IntegerField('id_grp'),
                    new StringField('fournisseur'),
                    new StringField('no_serie'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new StringField('prix'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d'),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new StringField('adresse_ip'),
                    new IntegerField('id_adresse_ip'),
                    new IntegerField('id_pers'),
                    new StringField('disponible'),
                    new IntegerField('disponible_web'),
                    new StringField('local'),
                    new IntegerField('id'),
                    new IntegerField('id_pers_new'),
                    new IntegerField('id_inf', false, false, true)
                )
            );
            $lookupDataset->setOrderByField('id_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel_reservation_reservation_materiel_informatique_id_mat_info_search', 'id_mat_inf', 'id_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel_reservation_reservation_materiel_informatique_id_personne_reservation_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel_reservation_reservation_materiel_informatique_id_etudiant_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_informatique"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_mat_inf', true, true, true),
                    new IntegerField('id_loc'),
                    new StringField('no_uqam'),
                    new StringField('syst_expl'),
                    new StringField('marque'),
                    new StringField('description'),
                    new IntegerField('id_grp'),
                    new StringField('fournisseur'),
                    new StringField('no_serie'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new StringField('prix'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d'),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new StringField('adresse_ip'),
                    new IntegerField('id_adresse_ip'),
                    new IntegerField('id_pers'),
                    new StringField('disponible'),
                    new IntegerField('disponible_web'),
                    new StringField('local'),
                    new IntegerField('id'),
                    new IntegerField('id_pers_new'),
                    new IntegerField('id_inf', false, false, true)
                )
            );
            $lookupDataset->setOrderByField('id_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel_reservation_reservation_materiel_informatique_id_mat_info_search', 'id_mat_inf', 'id_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel_reservation_reservation_materiel_informatique_id_personne_reservation_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel_reservation_reservation_materiel_informatique_id_etudiant_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_informatique"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_mat_inf', true, true, true),
                    new IntegerField('id_loc'),
                    new StringField('no_uqam'),
                    new StringField('syst_expl'),
                    new StringField('marque'),
                    new StringField('description'),
                    new IntegerField('id_grp'),
                    new StringField('fournisseur'),
                    new StringField('no_serie'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new StringField('prix'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d'),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new StringField('adresse_ip'),
                    new IntegerField('id_adresse_ip'),
                    new IntegerField('id_pers'),
                    new StringField('disponible'),
                    new IntegerField('disponible_web'),
                    new StringField('local'),
                    new IntegerField('id'),
                    new IntegerField('id_pers_new'),
                    new IntegerField('id_inf', false, false, true)
                )
            );
            $lookupDataset->setOrderByField('id_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel_reservation_reservation_materiel_informatique_id_mat_info_search', 'id_mat_inf', 'id_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel_reservation_reservation_materiel_informatique_id_personne_reservation_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel_reservation_reservation_materiel_informatique_id_etudiant_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }
    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class administratifs_personnel_reservation_reservation_materiel_informatique01Page extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Reservation Materiel Informatique');
            $this->SetMenuLabel('Reservation Mat Info - Personnel');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"reservation"."reservation_materiel_informatique"');
            $this->dataset->addFields(
                array(
                    new IntegerField('id_reserv_info', true, true, true),
                    new IntegerField('id_mat_info', true),
                    new DateField('date_emprunt'),
                    new DateField('date_de_retour'),
                    new StringField('commentaires'),
                    new IntegerField('id_personne_reservation'),
                    new IntegerField('id_professeur_responsable'),
                    new IntegerField('id_etudiant'),
                    new StringField('justification_emprunt'),
                    new StringField('documents'),
                    new StringField('otrs')
                )
            );
            $this->dataset->AddLookupField('id_mat_info', 'materiel.mat_informatique', new IntegerField('id_mat_inf'), new IntegerField('id_loc', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('id_personne_reservation', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA2', 'LT2'), 'LT2');
            $this->dataset->AddLookupField('id_etudiant', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA3', 'LT3'), 'LT3');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'id_reserv_info', 'id_reserv_info', 'Id Reserv Info'),
                new FilterColumn($this->dataset, 'id_mat_info', 'LA1', 'Id Mat Info'),
                new FilterColumn($this->dataset, 'date_emprunt', 'date_emprunt', 'Date Emprunt'),
                new FilterColumn($this->dataset, 'date_de_retour', 'date_de_retour', 'Date De Retour'),
                new FilterColumn($this->dataset, 'commentaires', 'commentaires', 'Commentaires'),
                new FilterColumn($this->dataset, 'id_personne_reservation', 'LA2', 'Id Personne Reservation'),
                new FilterColumn($this->dataset, 'id_professeur_responsable', 'id_professeur_responsable', 'Id Professeur Responsable'),
                new FilterColumn($this->dataset, 'id_etudiant', 'LA3', 'Id Etudiant'),
                new FilterColumn($this->dataset, 'justification_emprunt', 'justification_emprunt', 'Justification Emprunt'),
                new FilterColumn($this->dataset, 'documents', 'documents', 'Documents'),
                new FilterColumn($this->dataset, 'otrs', 'otrs', 'Otrs')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['id_reserv_info'])
                ->addColumn($columns['id_mat_info'])
                ->addColumn($columns['date_emprunt'])
                ->addColumn($columns['date_de_retour'])
                ->addColumn($columns['commentaires'])
                ->addColumn($columns['id_personne_reservation'])
                ->addColumn($columns['id_professeur_responsable'])
                ->addColumn($columns['id_etudiant'])
                ->addColumn($columns['justification_emprunt'])
                ->addColumn($columns['documents'])
                ->addColumn($columns['otrs']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_mat_info')
                ->setOptionsFor('date_emprunt')
                ->setOptionsFor('date_de_retour')
                ->setOptionsFor('id_personne_reservation')
                ->setOptionsFor('id_etudiant');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('id_reserv_info_edit');
            
            $filterBuilder->addColumn(
                $columns['id_reserv_info'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_mat_info_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel_reservation_reservation_materiel_informatique01_id_mat_info_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_mat_info', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel_reservation_reservation_materiel_informatique01_id_mat_info_search');
            
            $filterBuilder->addColumn(
                $columns['id_mat_info'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('date_emprunt_edit', false, 'Y-m-d');
            
            $filterBuilder->addColumn(
                $columns['date_emprunt'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('date_de_retour_edit', false, 'Y-m-d');
            
            $filterBuilder->addColumn(
                $columns['date_de_retour'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('commentaires_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['commentaires'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_personne_reservation_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel_reservation_reservation_materiel_informatique01_id_personne_reservation_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_personne_reservation', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel_reservation_reservation_materiel_informatique01_id_personne_reservation_search');
            
            $text_editor = new TextEdit('id_personne_reservation');
            
            $filterBuilder->addColumn(
                $columns['id_personne_reservation'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_professeur_responsable_edit');
            
            $filterBuilder->addColumn(
                $columns['id_professeur_responsable'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_etudiant_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel_reservation_reservation_materiel_informatique01_id_etudiant_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_etudiant', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel_reservation_reservation_materiel_informatique01_id_etudiant_search');
            
            $text_editor = new TextEdit('id_etudiant');
            
            $filterBuilder->addColumn(
                $columns['id_etudiant'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('justification_emprunt_edit');
            $main_editor->SetMaxLength(40);
            
            $filterBuilder->addColumn(
                $columns['justification_emprunt'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('documents');
            
            $filterBuilder->addColumn(
                $columns['documents'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('otrs');
            
            $filterBuilder->addColumn(
                $columns['otrs'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for id_reserv_info field
            //
            $column = new NumberViewColumn('id_reserv_info', 'id_reserv_info', 'Id Reserv Info', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_loc field
            //
            $column = new NumberViewColumn('id_mat_info', 'LA1', 'Id Mat Info', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_emprunt field
            //
            $column = new DateTimeViewColumn('date_emprunt', 'date_emprunt', 'Date Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Date De Retour', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_personne_reservation', 'LA2', 'Id Personne Reservation', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_professeur_responsable field
            //
            $column = new NumberViewColumn('id_professeur_responsable', 'id_professeur_responsable', 'Id Professeur Responsable', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_etudiant', 'LA3', 'Id Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for justification_emprunt field
            //
            $column = new TextViewColumn('justification_emprunt', 'justification_emprunt', 'Justification Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for documents field
            //
            $column = new TextViewColumn('documents', 'documents', 'Documents', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for otrs field
            //
            $column = new TextViewColumn('otrs', 'otrs', 'Otrs', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for id_reserv_info field
            //
            $column = new NumberViewColumn('id_reserv_info', 'id_reserv_info', 'Id Reserv Info', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_loc field
            //
            $column = new NumberViewColumn('id_mat_info', 'LA1', 'Id Mat Info', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_emprunt field
            //
            $column = new DateTimeViewColumn('date_emprunt', 'date_emprunt', 'Date Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Date De Retour', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_personne_reservation', 'LA2', 'Id Personne Reservation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_professeur_responsable field
            //
            $column = new NumberViewColumn('id_professeur_responsable', 'id_professeur_responsable', 'Id Professeur Responsable', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_etudiant', 'LA3', 'Id Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for justification_emprunt field
            //
            $column = new TextViewColumn('justification_emprunt', 'justification_emprunt', 'Justification Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for documents field
            //
            $column = new TextViewColumn('documents', 'documents', 'Documents', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for otrs field
            //
            $column = new TextViewColumn('otrs', 'otrs', 'Otrs', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for id_mat_info field
            //
            $editor = new DynamicCombobox('id_mat_info_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_informatique"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_mat_inf', true, true, true),
                    new IntegerField('id_loc'),
                    new StringField('no_uqam'),
                    new StringField('syst_expl'),
                    new StringField('marque'),
                    new StringField('description'),
                    new IntegerField('id_grp'),
                    new StringField('fournisseur'),
                    new StringField('no_serie'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new StringField('prix'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d'),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new StringField('adresse_ip'),
                    new IntegerField('id_adresse_ip'),
                    new IntegerField('id_pers'),
                    new StringField('disponible'),
                    new IntegerField('disponible_web'),
                    new StringField('local'),
                    new IntegerField('id'),
                    new IntegerField('id_pers_new'),
                    new IntegerField('id_inf', false, false, true)
                )
            );
            $lookupDataset->setOrderByField('id_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Mat Info', 'id_mat_info', 'LA1', 'edit_administratifs_personnel_reservation_reservation_materiel_informatique01_id_mat_info_search', $editor, $this->dataset, $lookupDataset, 'id_mat_inf', 'id_loc', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_emprunt field
            //
            $editor = new DateTimeEdit('date_emprunt_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Date Emprunt', 'date_emprunt', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_de_retour field
            //
            $editor = new DateTimeEdit('date_de_retour_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Date De Retour', 'date_de_retour', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextEdit('commentaires_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_personne_reservation field
            //
            $editor = new DynamicCombobox('id_personne_reservation_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Personne Reservation', 'id_personne_reservation', 'LA2', 'edit_administratifs_personnel_reservation_reservation_materiel_informatique01_id_personne_reservation_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_professeur_responsable field
            //
            $editor = new TextEdit('id_professeur_responsable_edit');
            $editColumn = new CustomEditColumn('Id Professeur Responsable', 'id_professeur_responsable', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_etudiant field
            //
            $editor = new DynamicCombobox('id_etudiant_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Etudiant', 'id_etudiant', 'LA3', 'edit_administratifs_personnel_reservation_reservation_materiel_informatique01_id_etudiant_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for justification_emprunt field
            //
            $editor = new TextEdit('justification_emprunt_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Justification Emprunt', 'justification_emprunt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for documents field
            //
            $editor = new TextAreaEdit('documents_edit', 50, 8);
            $editColumn = new CustomEditColumn('Documents', 'documents', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for otrs field
            //
            $editor = new TextAreaEdit('otrs_edit', 50, 8);
            $editColumn = new CustomEditColumn('Otrs', 'otrs', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for id_mat_info field
            //
            $editor = new DynamicCombobox('id_mat_info_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_informatique"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_mat_inf', true, true, true),
                    new IntegerField('id_loc'),
                    new StringField('no_uqam'),
                    new StringField('syst_expl'),
                    new StringField('marque'),
                    new StringField('description'),
                    new IntegerField('id_grp'),
                    new StringField('fournisseur'),
                    new StringField('no_serie'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new StringField('prix'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d'),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new StringField('adresse_ip'),
                    new IntegerField('id_adresse_ip'),
                    new IntegerField('id_pers'),
                    new StringField('disponible'),
                    new IntegerField('disponible_web'),
                    new StringField('local'),
                    new IntegerField('id'),
                    new IntegerField('id_pers_new'),
                    new IntegerField('id_inf', false, false, true)
                )
            );
            $lookupDataset->setOrderByField('id_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Mat Info', 'id_mat_info', 'LA1', 'multi_edit_administratifs_personnel_reservation_reservation_materiel_informatique01_id_mat_info_search', $editor, $this->dataset, $lookupDataset, 'id_mat_inf', 'id_loc', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_emprunt field
            //
            $editor = new DateTimeEdit('date_emprunt_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Date Emprunt', 'date_emprunt', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_de_retour field
            //
            $editor = new DateTimeEdit('date_de_retour_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Date De Retour', 'date_de_retour', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextEdit('commentaires_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_personne_reservation field
            //
            $editor = new DynamicCombobox('id_personne_reservation_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Personne Reservation', 'id_personne_reservation', 'LA2', 'multi_edit_administratifs_personnel_reservation_reservation_materiel_informatique01_id_personne_reservation_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_professeur_responsable field
            //
            $editor = new TextEdit('id_professeur_responsable_edit');
            $editColumn = new CustomEditColumn('Id Professeur Responsable', 'id_professeur_responsable', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_etudiant field
            //
            $editor = new DynamicCombobox('id_etudiant_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Etudiant', 'id_etudiant', 'LA3', 'multi_edit_administratifs_personnel_reservation_reservation_materiel_informatique01_id_etudiant_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for justification_emprunt field
            //
            $editor = new TextEdit('justification_emprunt_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Justification Emprunt', 'justification_emprunt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for documents field
            //
            $editor = new TextAreaEdit('documents_edit', 50, 8);
            $editColumn = new CustomEditColumn('Documents', 'documents', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for otrs field
            //
            $editor = new TextAreaEdit('otrs_edit', 50, 8);
            $editColumn = new CustomEditColumn('Otrs', 'otrs', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for id_mat_info field
            //
            $editor = new DynamicCombobox('id_mat_info_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_informatique"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_mat_inf', true, true, true),
                    new IntegerField('id_loc'),
                    new StringField('no_uqam'),
                    new StringField('syst_expl'),
                    new StringField('marque'),
                    new StringField('description'),
                    new IntegerField('id_grp'),
                    new StringField('fournisseur'),
                    new StringField('no_serie'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new StringField('prix'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d'),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new StringField('adresse_ip'),
                    new IntegerField('id_adresse_ip'),
                    new IntegerField('id_pers'),
                    new StringField('disponible'),
                    new IntegerField('disponible_web'),
                    new StringField('local'),
                    new IntegerField('id'),
                    new IntegerField('id_pers_new'),
                    new IntegerField('id_inf', false, false, true)
                )
            );
            $lookupDataset->setOrderByField('id_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Mat Info', 'id_mat_info', 'LA1', 'insert_administratifs_personnel_reservation_reservation_materiel_informatique01_id_mat_info_search', $editor, $this->dataset, $lookupDataset, 'id_mat_inf', 'id_loc', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_emprunt field
            //
            $editor = new DateTimeEdit('date_emprunt_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Date Emprunt', 'date_emprunt', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_de_retour field
            //
            $editor = new DateTimeEdit('date_de_retour_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Date De Retour', 'date_de_retour', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextEdit('commentaires_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_personne_reservation field
            //
            $editor = new DynamicCombobox('id_personne_reservation_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Personne Reservation', 'id_personne_reservation', 'LA2', 'insert_administratifs_personnel_reservation_reservation_materiel_informatique01_id_personne_reservation_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_professeur_responsable field
            //
            $editor = new TextEdit('id_professeur_responsable_edit');
            $editColumn = new CustomEditColumn('Id Professeur Responsable', 'id_professeur_responsable', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_etudiant field
            //
            $editor = new DynamicCombobox('id_etudiant_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Etudiant', 'id_etudiant', 'LA3', 'insert_administratifs_personnel_reservation_reservation_materiel_informatique01_id_etudiant_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for justification_emprunt field
            //
            $editor = new TextEdit('justification_emprunt_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Justification Emprunt', 'justification_emprunt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for documents field
            //
            $editor = new TextAreaEdit('documents_edit', 50, 8);
            $editColumn = new CustomEditColumn('Documents', 'documents', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for otrs field
            //
            $editor = new TextAreaEdit('otrs_edit', 50, 8);
            $editColumn = new CustomEditColumn('Otrs', 'otrs', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for id_reserv_info field
            //
            $column = new NumberViewColumn('id_reserv_info', 'id_reserv_info', 'Id Reserv Info', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_loc field
            //
            $column = new NumberViewColumn('id_mat_info', 'LA1', 'Id Mat Info', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_emprunt field
            //
            $column = new DateTimeViewColumn('date_emprunt', 'date_emprunt', 'Date Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Date De Retour', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddPrintColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_personne_reservation', 'LA2', 'Id Personne Reservation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_professeur_responsable field
            //
            $column = new NumberViewColumn('id_professeur_responsable', 'id_professeur_responsable', 'Id Professeur Responsable', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_etudiant', 'LA3', 'Id Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for justification_emprunt field
            //
            $column = new TextViewColumn('justification_emprunt', 'justification_emprunt', 'Justification Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for documents field
            //
            $column = new TextViewColumn('documents', 'documents', 'Documents', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for otrs field
            //
            $column = new TextViewColumn('otrs', 'otrs', 'Otrs', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for id_reserv_info field
            //
            $column = new NumberViewColumn('id_reserv_info', 'id_reserv_info', 'Id Reserv Info', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for id_loc field
            //
            $column = new NumberViewColumn('id_mat_info', 'LA1', 'Id Mat Info', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for date_emprunt field
            //
            $column = new DateTimeViewColumn('date_emprunt', 'date_emprunt', 'Date Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddExportColumn($column);
            
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Date De Retour', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddExportColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_personne_reservation', 'LA2', 'Id Personne Reservation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_professeur_responsable field
            //
            $column = new NumberViewColumn('id_professeur_responsable', 'id_professeur_responsable', 'Id Professeur Responsable', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_etudiant', 'LA3', 'Id Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for justification_emprunt field
            //
            $column = new TextViewColumn('justification_emprunt', 'justification_emprunt', 'Justification Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for documents field
            //
            $column = new TextViewColumn('documents', 'documents', 'Documents', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for otrs field
            //
            $column = new TextViewColumn('otrs', 'otrs', 'Otrs', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for id_loc field
            //
            $column = new NumberViewColumn('id_mat_info', 'LA1', 'Id Mat Info', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_emprunt field
            //
            $column = new DateTimeViewColumn('date_emprunt', 'date_emprunt', 'Date Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Date De Retour', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddCompareColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_personne_reservation', 'LA2', 'Id Personne Reservation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_professeur_responsable field
            //
            $column = new NumberViewColumn('id_professeur_responsable', 'id_professeur_responsable', 'Id Professeur Responsable', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_etudiant', 'LA3', 'Id Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for justification_emprunt field
            //
            $column = new TextViewColumn('justification_emprunt', 'justification_emprunt', 'Justification Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for documents field
            //
            $column = new TextViewColumn('documents', 'documents', 'Documents', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for otrs field
            //
            $column = new TextViewColumn('otrs', 'otrs', 'Otrs', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(true);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_informatique"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_mat_inf', true, true, true),
                    new IntegerField('id_loc'),
                    new StringField('no_uqam'),
                    new StringField('syst_expl'),
                    new StringField('marque'),
                    new StringField('description'),
                    new IntegerField('id_grp'),
                    new StringField('fournisseur'),
                    new StringField('no_serie'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new StringField('prix'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d'),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new StringField('adresse_ip'),
                    new IntegerField('id_adresse_ip'),
                    new IntegerField('id_pers'),
                    new StringField('disponible'),
                    new IntegerField('disponible_web'),
                    new StringField('local'),
                    new IntegerField('id'),
                    new IntegerField('id_pers_new'),
                    new IntegerField('id_inf', false, false, true)
                )
            );
            $lookupDataset->setOrderByField('id_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel_reservation_reservation_materiel_informatique01_id_mat_info_search', 'id_mat_inf', 'id_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel_reservation_reservation_materiel_informatique01_id_personne_reservation_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel_reservation_reservation_materiel_informatique01_id_etudiant_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_informatique"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_mat_inf', true, true, true),
                    new IntegerField('id_loc'),
                    new StringField('no_uqam'),
                    new StringField('syst_expl'),
                    new StringField('marque'),
                    new StringField('description'),
                    new IntegerField('id_grp'),
                    new StringField('fournisseur'),
                    new StringField('no_serie'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new StringField('prix'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d'),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new StringField('adresse_ip'),
                    new IntegerField('id_adresse_ip'),
                    new IntegerField('id_pers'),
                    new StringField('disponible'),
                    new IntegerField('disponible_web'),
                    new StringField('local'),
                    new IntegerField('id'),
                    new IntegerField('id_pers_new'),
                    new IntegerField('id_inf', false, false, true)
                )
            );
            $lookupDataset->setOrderByField('id_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel_reservation_reservation_materiel_informatique01_id_mat_info_search', 'id_mat_inf', 'id_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel_reservation_reservation_materiel_informatique01_id_personne_reservation_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel_reservation_reservation_materiel_informatique01_id_etudiant_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_informatique"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_mat_inf', true, true, true),
                    new IntegerField('id_loc'),
                    new StringField('no_uqam'),
                    new StringField('syst_expl'),
                    new StringField('marque'),
                    new StringField('description'),
                    new IntegerField('id_grp'),
                    new StringField('fournisseur'),
                    new StringField('no_serie'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new StringField('prix'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d'),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new StringField('adresse_ip'),
                    new IntegerField('id_adresse_ip'),
                    new IntegerField('id_pers'),
                    new StringField('disponible'),
                    new IntegerField('disponible_web'),
                    new StringField('local'),
                    new IntegerField('id'),
                    new IntegerField('id_pers_new'),
                    new IntegerField('id_inf', false, false, true)
                )
            );
            $lookupDataset->setOrderByField('id_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel_reservation_reservation_materiel_informatique01_id_mat_info_search', 'id_mat_inf', 'id_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel_reservation_reservation_materiel_informatique01_id_personne_reservation_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel_reservation_reservation_materiel_informatique01_id_etudiant_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_informatique"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_mat_inf', true, true, true),
                    new IntegerField('id_loc'),
                    new StringField('no_uqam'),
                    new StringField('syst_expl'),
                    new StringField('marque'),
                    new StringField('description'),
                    new IntegerField('id_grp'),
                    new StringField('fournisseur'),
                    new StringField('no_serie'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new StringField('prix'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d'),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new StringField('adresse_ip'),
                    new IntegerField('id_adresse_ip'),
                    new IntegerField('id_pers'),
                    new StringField('disponible'),
                    new IntegerField('disponible_web'),
                    new StringField('local'),
                    new IntegerField('id'),
                    new IntegerField('id_pers_new'),
                    new IntegerField('id_inf', false, false, true)
                )
            );
            $lookupDataset->setOrderByField('id_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel_reservation_reservation_materiel_informatique01_id_mat_info_search', 'id_mat_inf', 'id_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel_reservation_reservation_materiel_informatique01_id_personne_reservation_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel_reservation_reservation_materiel_informatique01_id_etudiant_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }
    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class administratifs_personnel_reservation_reservation_materiel_scientifiquePage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Reservation Materiel Scientifique');
            $this->SetMenuLabel('Reservation Materie Sci - Etudiant');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"reservation"."reservation_materiel_scientifique"');
            $this->dataset->addFields(
                array(
                    new IntegerField('id_reserv_sci', true, true, true),
                    new IntegerField('id_mat_sci', true),
                    new DateField('date_emprunt', true),
                    new DateField('date_de_retour', true),
                    new StringField('commentaires', true),
                    new IntegerField('id_personne_reservation', true),
                    new IntegerField('id_professeur_responsable', true),
                    new IntegerField('id_etudiant', true),
                    new StringField('justification_emprunt')
                )
            );
            $this->dataset->AddLookupField('id_mat_sci', 'materiel.mat_sci', new IntegerField('id_mat_sci'), new StringField('no_identif', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('id_personne_reservation', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA2', 'LT2'), 'LT2');
            $this->dataset->AddLookupField('id_etudiant', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA3', 'LT3'), 'LT3');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'id_reserv_sci', 'id_reserv_sci', 'Id Reserv Sci'),
                new FilterColumn($this->dataset, 'id_mat_sci', 'LA1', 'Id Mat Sci'),
                new FilterColumn($this->dataset, 'date_emprunt', 'date_emprunt', 'Date Emprunt'),
                new FilterColumn($this->dataset, 'date_de_retour', 'date_de_retour', 'Date De Retour'),
                new FilterColumn($this->dataset, 'commentaires', 'commentaires', 'Commentaires'),
                new FilterColumn($this->dataset, 'id_personne_reservation', 'LA2', 'Id Personne Reservation'),
                new FilterColumn($this->dataset, 'id_professeur_responsable', 'id_professeur_responsable', 'Id Professeur Responsable'),
                new FilterColumn($this->dataset, 'id_etudiant', 'LA3', 'Id Etudiant'),
                new FilterColumn($this->dataset, 'justification_emprunt', 'justification_emprunt', 'Justification Emprunt')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['id_reserv_sci'])
                ->addColumn($columns['id_mat_sci'])
                ->addColumn($columns['date_emprunt'])
                ->addColumn($columns['date_de_retour'])
                ->addColumn($columns['commentaires'])
                ->addColumn($columns['id_personne_reservation'])
                ->addColumn($columns['id_professeur_responsable'])
                ->addColumn($columns['id_etudiant'])
                ->addColumn($columns['justification_emprunt']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_mat_sci')
                ->setOptionsFor('date_emprunt')
                ->setOptionsFor('date_de_retour')
                ->setOptionsFor('id_personne_reservation')
                ->setOptionsFor('id_etudiant');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('id_reserv_sci_edit');
            
            $filterBuilder->addColumn(
                $columns['id_reserv_sci'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_mat_sci_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel_reservation_reservation_materiel_scientifique_id_mat_sci_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_mat_sci', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel_reservation_reservation_materiel_scientifique_id_mat_sci_search');
            
            $text_editor = new TextEdit('id_mat_sci');
            
            $filterBuilder->addColumn(
                $columns['id_mat_sci'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('date_emprunt_edit', false, 'Y-m-d');
            
            $filterBuilder->addColumn(
                $columns['date_emprunt'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('date_de_retour_edit', false, 'Y-m-d');
            
            $filterBuilder->addColumn(
                $columns['date_de_retour'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('commentaires_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['commentaires'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_personne_reservation_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel_reservation_reservation_materiel_scientifique_id_personne_reservation_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_personne_reservation', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel_reservation_reservation_materiel_scientifique_id_personne_reservation_search');
            
            $text_editor = new TextEdit('id_personne_reservation');
            
            $filterBuilder->addColumn(
                $columns['id_personne_reservation'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_professeur_responsable_edit');
            
            $filterBuilder->addColumn(
                $columns['id_professeur_responsable'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_etudiant_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel_reservation_reservation_materiel_scientifique_id_etudiant_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_etudiant', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel_reservation_reservation_materiel_scientifique_id_etudiant_search');
            
            $text_editor = new TextEdit('id_etudiant');
            
            $filterBuilder->addColumn(
                $columns['id_etudiant'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('justification_emprunt_edit');
            $main_editor->SetMaxLength(40);
            
            $filterBuilder->addColumn(
                $columns['justification_emprunt'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for id_reserv_sci field
            //
            $column = new NumberViewColumn('id_reserv_sci', 'id_reserv_sci', 'Id Reserv Sci', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_identif field
            //
            $column = new TextViewColumn('id_mat_sci', 'LA1', 'Id Mat Sci', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_emprunt field
            //
            $column = new DateTimeViewColumn('date_emprunt', 'date_emprunt', 'Date Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Date De Retour', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_personne_reservation', 'LA2', 'Id Personne Reservation', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_professeur_responsable field
            //
            $column = new NumberViewColumn('id_professeur_responsable', 'id_professeur_responsable', 'Id Professeur Responsable', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_etudiant', 'LA3', 'Id Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for justification_emprunt field
            //
            $column = new TextViewColumn('justification_emprunt', 'justification_emprunt', 'Justification Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for id_reserv_sci field
            //
            $column = new NumberViewColumn('id_reserv_sci', 'id_reserv_sci', 'Id Reserv Sci', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_identif field
            //
            $column = new TextViewColumn('id_mat_sci', 'LA1', 'Id Mat Sci', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_emprunt field
            //
            $column = new DateTimeViewColumn('date_emprunt', 'date_emprunt', 'Date Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Date De Retour', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_personne_reservation', 'LA2', 'Id Personne Reservation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_professeur_responsable field
            //
            $column = new NumberViewColumn('id_professeur_responsable', 'id_professeur_responsable', 'Id Professeur Responsable', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_etudiant', 'LA3', 'Id Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for justification_emprunt field
            //
            $column = new TextViewColumn('justification_emprunt', 'justification_emprunt', 'Justification Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for id_mat_sci field
            //
            $editor = new DynamicCombobox('id_mat_sci_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_sci"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_mat_sci', true, true, true),
                    new StringField('no_identif', true),
                    new StringField('transaction', true),
                    new StringField('nom_l_e'),
                    new IntegerField('id_equipement'),
                    new StringField('marque'),
                    new StringField('manufacture', true),
                    new StringField('modele'),
                    new StringField('fournisseur'),
                    new StringField('id_fournisseur', true),
                    new StringField('no_serie'),
                    new StringField('caracteristique'),
                    new StringField('utilisation'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new StringField('fonction'),
                    new StringField('utilisateur'),
                    new StringField('cours'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new IntegerField('quantite'),
                    new IntegerField('prix_unitaire'),
                    new IntegerField('cout_total'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d', true),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_charge'),
                    new IntegerField('disponible'),
                    new StringField('disponible_web'),
                    new StringField('documents_facture'),
                    new StringField('document_bon_commande'),
                    new StringField('document_manuel_utilisation'),
                    new StringField('autres_documents'),
                    new IntegerField('id_marque'),
                    new IntegerField('id_manufacturier'),
                    new IntegerField('id_modele'),
                    new IntegerField('id_groupe'),
                    new IntegerField('id_pers')
                )
            );
            $lookupDataset->setOrderByField('no_identif', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Mat Sci', 'id_mat_sci', 'LA1', 'edit_administratifs_personnel_reservation_reservation_materiel_scientifique_id_mat_sci_search', $editor, $this->dataset, $lookupDataset, 'id_mat_sci', 'no_identif', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_emprunt field
            //
            $editor = new DateTimeEdit('date_emprunt_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Date Emprunt', 'date_emprunt', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_de_retour field
            //
            $editor = new DateTimeEdit('date_de_retour_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Date De Retour', 'date_de_retour', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextEdit('commentaires_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_personne_reservation field
            //
            $editor = new DynamicCombobox('id_personne_reservation_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Personne Reservation', 'id_personne_reservation', 'LA2', 'edit_administratifs_personnel_reservation_reservation_materiel_scientifique_id_personne_reservation_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_professeur_responsable field
            //
            $editor = new TextEdit('id_professeur_responsable_edit');
            $editColumn = new CustomEditColumn('Id Professeur Responsable', 'id_professeur_responsable', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_etudiant field
            //
            $editor = new DynamicCombobox('id_etudiant_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Etudiant', 'id_etudiant', 'LA3', 'edit_administratifs_personnel_reservation_reservation_materiel_scientifique_id_etudiant_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for justification_emprunt field
            //
            $editor = new TextEdit('justification_emprunt_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Justification Emprunt', 'justification_emprunt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for id_mat_sci field
            //
            $editor = new DynamicCombobox('id_mat_sci_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_sci"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_mat_sci', true, true, true),
                    new StringField('no_identif', true),
                    new StringField('transaction', true),
                    new StringField('nom_l_e'),
                    new IntegerField('id_equipement'),
                    new StringField('marque'),
                    new StringField('manufacture', true),
                    new StringField('modele'),
                    new StringField('fournisseur'),
                    new StringField('id_fournisseur', true),
                    new StringField('no_serie'),
                    new StringField('caracteristique'),
                    new StringField('utilisation'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new StringField('fonction'),
                    new StringField('utilisateur'),
                    new StringField('cours'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new IntegerField('quantite'),
                    new IntegerField('prix_unitaire'),
                    new IntegerField('cout_total'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d', true),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_charge'),
                    new IntegerField('disponible'),
                    new StringField('disponible_web'),
                    new StringField('documents_facture'),
                    new StringField('document_bon_commande'),
                    new StringField('document_manuel_utilisation'),
                    new StringField('autres_documents'),
                    new IntegerField('id_marque'),
                    new IntegerField('id_manufacturier'),
                    new IntegerField('id_modele'),
                    new IntegerField('id_groupe'),
                    new IntegerField('id_pers')
                )
            );
            $lookupDataset->setOrderByField('no_identif', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Mat Sci', 'id_mat_sci', 'LA1', 'multi_edit_administratifs_personnel_reservation_reservation_materiel_scientifique_id_mat_sci_search', $editor, $this->dataset, $lookupDataset, 'id_mat_sci', 'no_identif', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_emprunt field
            //
            $editor = new DateTimeEdit('date_emprunt_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Date Emprunt', 'date_emprunt', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_de_retour field
            //
            $editor = new DateTimeEdit('date_de_retour_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Date De Retour', 'date_de_retour', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextEdit('commentaires_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_personne_reservation field
            //
            $editor = new DynamicCombobox('id_personne_reservation_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Personne Reservation', 'id_personne_reservation', 'LA2', 'multi_edit_administratifs_personnel_reservation_reservation_materiel_scientifique_id_personne_reservation_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_professeur_responsable field
            //
            $editor = new TextEdit('id_professeur_responsable_edit');
            $editColumn = new CustomEditColumn('Id Professeur Responsable', 'id_professeur_responsable', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_etudiant field
            //
            $editor = new DynamicCombobox('id_etudiant_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Etudiant', 'id_etudiant', 'LA3', 'multi_edit_administratifs_personnel_reservation_reservation_materiel_scientifique_id_etudiant_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for justification_emprunt field
            //
            $editor = new TextEdit('justification_emprunt_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Justification Emprunt', 'justification_emprunt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for id_mat_sci field
            //
            $editor = new DynamicCombobox('id_mat_sci_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_sci"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_mat_sci', true, true, true),
                    new StringField('no_identif', true),
                    new StringField('transaction', true),
                    new StringField('nom_l_e'),
                    new IntegerField('id_equipement'),
                    new StringField('marque'),
                    new StringField('manufacture', true),
                    new StringField('modele'),
                    new StringField('fournisseur'),
                    new StringField('id_fournisseur', true),
                    new StringField('no_serie'),
                    new StringField('caracteristique'),
                    new StringField('utilisation'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new StringField('fonction'),
                    new StringField('utilisateur'),
                    new StringField('cours'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new IntegerField('quantite'),
                    new IntegerField('prix_unitaire'),
                    new IntegerField('cout_total'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d', true),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_charge'),
                    new IntegerField('disponible'),
                    new StringField('disponible_web'),
                    new StringField('documents_facture'),
                    new StringField('document_bon_commande'),
                    new StringField('document_manuel_utilisation'),
                    new StringField('autres_documents'),
                    new IntegerField('id_marque'),
                    new IntegerField('id_manufacturier'),
                    new IntegerField('id_modele'),
                    new IntegerField('id_groupe'),
                    new IntegerField('id_pers')
                )
            );
            $lookupDataset->setOrderByField('no_identif', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Mat Sci', 'id_mat_sci', 'LA1', 'insert_administratifs_personnel_reservation_reservation_materiel_scientifique_id_mat_sci_search', $editor, $this->dataset, $lookupDataset, 'id_mat_sci', 'no_identif', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_emprunt field
            //
            $editor = new DateTimeEdit('date_emprunt_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Date Emprunt', 'date_emprunt', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_de_retour field
            //
            $editor = new DateTimeEdit('date_de_retour_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Date De Retour', 'date_de_retour', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextEdit('commentaires_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_personne_reservation field
            //
            $editor = new DynamicCombobox('id_personne_reservation_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Personne Reservation', 'id_personne_reservation', 'LA2', 'insert_administratifs_personnel_reservation_reservation_materiel_scientifique_id_personne_reservation_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_professeur_responsable field
            //
            $editor = new TextEdit('id_professeur_responsable_edit');
            $editColumn = new CustomEditColumn('Id Professeur Responsable', 'id_professeur_responsable', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_etudiant field
            //
            $editor = new DynamicCombobox('id_etudiant_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Etudiant', 'id_etudiant', 'LA3', 'insert_administratifs_personnel_reservation_reservation_materiel_scientifique_id_etudiant_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for justification_emprunt field
            //
            $editor = new TextEdit('justification_emprunt_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Justification Emprunt', 'justification_emprunt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for id_reserv_sci field
            //
            $column = new NumberViewColumn('id_reserv_sci', 'id_reserv_sci', 'Id Reserv Sci', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_identif field
            //
            $column = new TextViewColumn('id_mat_sci', 'LA1', 'Id Mat Sci', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_emprunt field
            //
            $column = new DateTimeViewColumn('date_emprunt', 'date_emprunt', 'Date Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Date De Retour', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddPrintColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_personne_reservation', 'LA2', 'Id Personne Reservation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_professeur_responsable field
            //
            $column = new NumberViewColumn('id_professeur_responsable', 'id_professeur_responsable', 'Id Professeur Responsable', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_etudiant', 'LA3', 'Id Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for justification_emprunt field
            //
            $column = new TextViewColumn('justification_emprunt', 'justification_emprunt', 'Justification Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for id_reserv_sci field
            //
            $column = new NumberViewColumn('id_reserv_sci', 'id_reserv_sci', 'Id Reserv Sci', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for no_identif field
            //
            $column = new TextViewColumn('id_mat_sci', 'LA1', 'Id Mat Sci', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_emprunt field
            //
            $column = new DateTimeViewColumn('date_emprunt', 'date_emprunt', 'Date Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddExportColumn($column);
            
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Date De Retour', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddExportColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_personne_reservation', 'LA2', 'Id Personne Reservation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_professeur_responsable field
            //
            $column = new NumberViewColumn('id_professeur_responsable', 'id_professeur_responsable', 'Id Professeur Responsable', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_etudiant', 'LA3', 'Id Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for justification_emprunt field
            //
            $column = new TextViewColumn('justification_emprunt', 'justification_emprunt', 'Justification Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for no_identif field
            //
            $column = new TextViewColumn('id_mat_sci', 'LA1', 'Id Mat Sci', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_emprunt field
            //
            $column = new DateTimeViewColumn('date_emprunt', 'date_emprunt', 'Date Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Date De Retour', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddCompareColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_personne_reservation', 'LA2', 'Id Personne Reservation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_professeur_responsable field
            //
            $column = new NumberViewColumn('id_professeur_responsable', 'id_professeur_responsable', 'Id Professeur Responsable', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_etudiant', 'LA3', 'Id Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for justification_emprunt field
            //
            $column = new TextViewColumn('justification_emprunt', 'justification_emprunt', 'Justification Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(true);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_sci"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_mat_sci', true, true, true),
                    new StringField('no_identif', true),
                    new StringField('transaction', true),
                    new StringField('nom_l_e'),
                    new IntegerField('id_equipement'),
                    new StringField('marque'),
                    new StringField('manufacture', true),
                    new StringField('modele'),
                    new StringField('fournisseur'),
                    new StringField('id_fournisseur', true),
                    new StringField('no_serie'),
                    new StringField('caracteristique'),
                    new StringField('utilisation'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new StringField('fonction'),
                    new StringField('utilisateur'),
                    new StringField('cours'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new IntegerField('quantite'),
                    new IntegerField('prix_unitaire'),
                    new IntegerField('cout_total'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d', true),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_charge'),
                    new IntegerField('disponible'),
                    new StringField('disponible_web'),
                    new StringField('documents_facture'),
                    new StringField('document_bon_commande'),
                    new StringField('document_manuel_utilisation'),
                    new StringField('autres_documents'),
                    new IntegerField('id_marque'),
                    new IntegerField('id_manufacturier'),
                    new IntegerField('id_modele'),
                    new IntegerField('id_groupe'),
                    new IntegerField('id_pers')
                )
            );
            $lookupDataset->setOrderByField('no_identif', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel_reservation_reservation_materiel_scientifique_id_mat_sci_search', 'id_mat_sci', 'no_identif', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel_reservation_reservation_materiel_scientifique_id_personne_reservation_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel_reservation_reservation_materiel_scientifique_id_etudiant_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_sci"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_mat_sci', true, true, true),
                    new StringField('no_identif', true),
                    new StringField('transaction', true),
                    new StringField('nom_l_e'),
                    new IntegerField('id_equipement'),
                    new StringField('marque'),
                    new StringField('manufacture', true),
                    new StringField('modele'),
                    new StringField('fournisseur'),
                    new StringField('id_fournisseur', true),
                    new StringField('no_serie'),
                    new StringField('caracteristique'),
                    new StringField('utilisation'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new StringField('fonction'),
                    new StringField('utilisateur'),
                    new StringField('cours'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new IntegerField('quantite'),
                    new IntegerField('prix_unitaire'),
                    new IntegerField('cout_total'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d', true),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_charge'),
                    new IntegerField('disponible'),
                    new StringField('disponible_web'),
                    new StringField('documents_facture'),
                    new StringField('document_bon_commande'),
                    new StringField('document_manuel_utilisation'),
                    new StringField('autres_documents'),
                    new IntegerField('id_marque'),
                    new IntegerField('id_manufacturier'),
                    new IntegerField('id_modele'),
                    new IntegerField('id_groupe'),
                    new IntegerField('id_pers')
                )
            );
            $lookupDataset->setOrderByField('no_identif', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel_reservation_reservation_materiel_scientifique_id_mat_sci_search', 'id_mat_sci', 'no_identif', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel_reservation_reservation_materiel_scientifique_id_personne_reservation_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel_reservation_reservation_materiel_scientifique_id_etudiant_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_sci"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_mat_sci', true, true, true),
                    new StringField('no_identif', true),
                    new StringField('transaction', true),
                    new StringField('nom_l_e'),
                    new IntegerField('id_equipement'),
                    new StringField('marque'),
                    new StringField('manufacture', true),
                    new StringField('modele'),
                    new StringField('fournisseur'),
                    new StringField('id_fournisseur', true),
                    new StringField('no_serie'),
                    new StringField('caracteristique'),
                    new StringField('utilisation'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new StringField('fonction'),
                    new StringField('utilisateur'),
                    new StringField('cours'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new IntegerField('quantite'),
                    new IntegerField('prix_unitaire'),
                    new IntegerField('cout_total'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d', true),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_charge'),
                    new IntegerField('disponible'),
                    new StringField('disponible_web'),
                    new StringField('documents_facture'),
                    new StringField('document_bon_commande'),
                    new StringField('document_manuel_utilisation'),
                    new StringField('autres_documents'),
                    new IntegerField('id_marque'),
                    new IntegerField('id_manufacturier'),
                    new IntegerField('id_modele'),
                    new IntegerField('id_groupe'),
                    new IntegerField('id_pers')
                )
            );
            $lookupDataset->setOrderByField('no_identif', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel_reservation_reservation_materiel_scientifique_id_mat_sci_search', 'id_mat_sci', 'no_identif', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel_reservation_reservation_materiel_scientifique_id_personne_reservation_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel_reservation_reservation_materiel_scientifique_id_etudiant_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_sci"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_mat_sci', true, true, true),
                    new StringField('no_identif', true),
                    new StringField('transaction', true),
                    new StringField('nom_l_e'),
                    new IntegerField('id_equipement'),
                    new StringField('marque'),
                    new StringField('manufacture', true),
                    new StringField('modele'),
                    new StringField('fournisseur'),
                    new StringField('id_fournisseur', true),
                    new StringField('no_serie'),
                    new StringField('caracteristique'),
                    new StringField('utilisation'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new StringField('fonction'),
                    new StringField('utilisateur'),
                    new StringField('cours'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new IntegerField('quantite'),
                    new IntegerField('prix_unitaire'),
                    new IntegerField('cout_total'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d', true),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_charge'),
                    new IntegerField('disponible'),
                    new StringField('disponible_web'),
                    new StringField('documents_facture'),
                    new StringField('document_bon_commande'),
                    new StringField('document_manuel_utilisation'),
                    new StringField('autres_documents'),
                    new IntegerField('id_marque'),
                    new IntegerField('id_manufacturier'),
                    new IntegerField('id_modele'),
                    new IntegerField('id_groupe'),
                    new IntegerField('id_pers')
                )
            );
            $lookupDataset->setOrderByField('no_identif', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel_reservation_reservation_materiel_scientifique_id_mat_sci_search', 'id_mat_sci', 'no_identif', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel_reservation_reservation_materiel_scientifique_id_personne_reservation_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel_reservation_reservation_materiel_scientifique_id_etudiant_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }
    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class administratifs_personnel_reservation_reservation_materiel_scientifique01Page extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Reservation Materiel Scientifique');
            $this->SetMenuLabel('Reservation Mat Sci - Personnel');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"reservation"."reservation_materiel_scientifique"');
            $this->dataset->addFields(
                array(
                    new IntegerField('id_reserv_sci', true, true, true),
                    new IntegerField('id_mat_sci', true),
                    new DateField('date_emprunt', true),
                    new DateField('date_de_retour', true),
                    new StringField('commentaires', true),
                    new IntegerField('id_personne_reservation', true),
                    new IntegerField('id_professeur_responsable', true),
                    new IntegerField('id_etudiant', true),
                    new StringField('justification_emprunt')
                )
            );
            $this->dataset->AddLookupField('id_mat_sci', 'materiel.mat_sci', new IntegerField('id_mat_sci'), new StringField('no_identif', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('id_personne_reservation', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA2', 'LT2'), 'LT2');
            $this->dataset->AddLookupField('id_etudiant', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA3', 'LT3'), 'LT3');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'id_reserv_sci', 'id_reserv_sci', 'Id Reserv Sci'),
                new FilterColumn($this->dataset, 'id_mat_sci', 'LA1', 'Id Mat Sci'),
                new FilterColumn($this->dataset, 'date_emprunt', 'date_emprunt', 'Date Emprunt'),
                new FilterColumn($this->dataset, 'date_de_retour', 'date_de_retour', 'Date De Retour'),
                new FilterColumn($this->dataset, 'commentaires', 'commentaires', 'Commentaires'),
                new FilterColumn($this->dataset, 'id_personne_reservation', 'LA2', 'Id Personne Reservation'),
                new FilterColumn($this->dataset, 'id_professeur_responsable', 'id_professeur_responsable', 'Id Professeur Responsable'),
                new FilterColumn($this->dataset, 'id_etudiant', 'LA3', 'Id Etudiant'),
                new FilterColumn($this->dataset, 'justification_emprunt', 'justification_emprunt', 'Justification Emprunt')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['id_reserv_sci'])
                ->addColumn($columns['id_mat_sci'])
                ->addColumn($columns['date_emprunt'])
                ->addColumn($columns['date_de_retour'])
                ->addColumn($columns['commentaires'])
                ->addColumn($columns['id_personne_reservation'])
                ->addColumn($columns['id_professeur_responsable'])
                ->addColumn($columns['id_etudiant'])
                ->addColumn($columns['justification_emprunt']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_mat_sci')
                ->setOptionsFor('date_emprunt')
                ->setOptionsFor('date_de_retour')
                ->setOptionsFor('id_personne_reservation')
                ->setOptionsFor('id_etudiant');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('id_reserv_sci_edit');
            
            $filterBuilder->addColumn(
                $columns['id_reserv_sci'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_mat_sci_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel_reservation_reservation_materiel_scientifique01_id_mat_sci_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_mat_sci', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel_reservation_reservation_materiel_scientifique01_id_mat_sci_search');
            
            $text_editor = new TextEdit('id_mat_sci');
            
            $filterBuilder->addColumn(
                $columns['id_mat_sci'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('date_emprunt_edit', false, 'Y-m-d');
            
            $filterBuilder->addColumn(
                $columns['date_emprunt'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('date_de_retour_edit', false, 'Y-m-d');
            
            $filterBuilder->addColumn(
                $columns['date_de_retour'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('commentaires_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['commentaires'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
