<?php

include_once dirname(__FILE__) . '/' . 'phpgen_settings.php';
include_once dirname(__FILE__) . '/' . 'components/application.php';
include_once dirname(__FILE__) . '/' . 'components/security/permission_set.php';
include_once dirname(__FILE__) . '/' . 'components/security/user_authentication/table_based_user_authentication.php';
include_once dirname(__FILE__) . '/' . 'components/security/grant_manager/table_based_user_grant_manager.php';
include_once dirname(__FILE__) . '/' . 'components/security/table_based_user_manager.php';
include_once dirname(__FILE__) . '/' . 'components/security/user_identity_storage/user_identity_session_storage.php';
include_once dirname(__FILE__) . '/' . 'components/security/recaptcha.php';
include_once dirname(__FILE__) . '/' . 'database_engine/pgsql_engine.php';



$dataSourceRecordPermissions = array();

$tableCaptions = array('cle_departement.scta_cle_emprunt' => 'Emprunts courants',
'cle_departement.scta_cle_emprunt.administratifs.personnel' => 'Emprunts courants->Personnel',
'cle_departement.scta_cle_emprunt.cle_departement.cle_cles' => 'Emprunts courants->Cle Cles',
'cle_departement.scta_cle_emprunt01' => 'Emprunts archivés',
'cle_departement.cle_cles' => 'Clés',
'cle_departement.cle_cles.cle_departement.scta_cle_emprunt' => 'Clés->Scta Cle Emprunt',
'administratifs.locals' => 'Locaux',
'administratifs.locals.administratifs.personnel' => 'Locaux->Personnel',
'administratifs.locals.cle_departement.cle_cles' => 'Locaux->Cle Cles',
'administratifs.locals.materiel.ipadresse' => 'Locaux->Ipadresse',
'administratifs.locals.materiel.mat_informatique' => 'Locaux->Mat Informatique',
'administratifs.locals.materiel.mat_sci' => 'Locaux->Mat Sci',
'administratifs.locaux_departement' => 'Locaux',
'administratifs.personnel' => 'Autres',
'administratifs.personnel.cle_departement.scta_cle_emprunt' => 'Autres->Scta Cle Emprunt',
'administratifs.personnel.materiel.achats_logiciels' => 'Autres->Achats Logiciels',
'administratifs.personnel.materiel.mat_informatique' => 'Autres->Mat Informatique',
'administratifs.personnel.materiel.mat_sci' => 'Autres->Mat Sci',
'administratifs.personnel.materiel.surplus' => 'Autres->Surplus en tant que membre personnel.',
'administratifs.personnel.materiel.surplus01' => 'Autres->Surplus en tant que prof',
'administratifs.personnel.reservation.reservation_materiel_informatique' => 'Autres->Réserv Mat Info - Etudiant',
'administratifs.personnel.reservation.reservation_materiel_informatique01' => 'Autres->Reservation Mat Info - Personnel',
'administratifs.personnel.reservation.reservation_materiel_scientifique' => 'Autres->Reservation Materie Sci - Etudiant',
'administratifs.personnel.reservation.reservation_materiel_scientifique01' => 'Autres->Reservation Mat Sci - Personnel',
'nomcomplet' => 'Nomcomplet',
'cle_local' => 'Cle Local',
'Query01' => 'Query01',
'local_scta_cle_emprunt' => 'Local Scta Cle Emprunt',
'cle_departement.scta_cle_emprunt_archive_vue' => 'Scta Cle Emprunt Archive Vue',
'cle_departement.scta_cle_emprunt_courant' => 'Scta Cle Emprunt Courant',
'cle_departement.emprunt_archive' => 'Emprunt Archive',
'cle_departement.emprunt_courant' => 'Emprunt Courant',
'cle_departement.emprunt_courant_v2' => 'Emprunt Courant V2',
'administratifs.personnel01' => 'Personnel',
'administratifs.personnel01.administratifs.imprimante_poster_tmp' => 'Personnel->Imprimante Poster Tmp',
'administratifs.personnel01.administratifs.imprimante_poster_tmp01' => 'Personnel->Imprimante Poster Tmp',
'administratifs.personnel01.administratifs.journal' => 'Personnel->Journal',
'administratifs.personnel01.administratifs.personnel' => 'Personnel->Personnel',
'administratifs.personnel01.cle_departement.scta_cle_emprunt' => 'Personnel->Scta Cle Emprunt',
'administratifs.personnel01.materiel.achats_logiciels' => 'Personnel->Achats Logiciels',
'administratifs.personnel01.materiel.commandes' => 'Personnel->Commandes',
'administratifs.personnel01.materiel.mat_informatique' => 'Personnel->Mat Informatique',
'administratifs.personnel01.materiel.mat_sci' => 'Personnel->Mat Sci',
'administratifs.personnel01.materiel.mat_sci01' => 'Personnel->Mat Sci',
'administratifs.personnel01.materiel.surplus' => 'Personnel->Surplus',
'administratifs.personnel01.materiel.surplus01' => 'Personnel->Surplus',
'administratifs.personnel01.reservation.reservation_materiel_informatique' => 'Personnel->Reservation Materiel Informatique',
'administratifs.personnel01.reservation.reservation_materiel_informatique01' => 'Personnel->Reservation Materiel Informatique',
'administratifs.personnel01.reservation.reservation_materiel_informatique02' => 'Personnel->Reservation Materiel Informatique',
'administratifs.personnel01.reservation.reservation_materiel_scientifique' => 'Personnel->Reservation Materiel Scientifique',
'administratifs.personnel01.reservation.reservation_materiel_scientifique01' => 'Personnel->Reservation Materiel Scientifique',
'administratifs.groupe' => 'Groupe',
'administratifs.groupe.administratifs.personnel' => 'Groupe->Personnel',
'administratifs.groupe.materiel.mat_sci' => 'Groupe->Mat Sci',
'administratifs.etat' => 'Etat',
'administratifs.statut' => 'Statut',
'administratifs.statut.administratifs.personnel' => 'Statut->Personnel',
'administratifs.sigle' => 'Programme',
'administratifs.sigle.administratifs.personnel' => 'Programme->Personnel',
'programme_desc' => 'Programme Desc',
'administratifs.nom_complet_view' => 'Nom Complet View');

$usersTableInfo = array(
    'TableName' => 'administratifs.phpgen_users_scta',
    'UserId' => 'user_id',
    'UserName' => 'user_name',
    'Password' => 'user_password',
    'Email' => 'user_email',
    'UserToken' => 'user_token',
    'UserStatus' => 'user_status'
);

function EncryptPassword($password, &$result)
{

}

function VerifyPassword($enteredPassword, $encryptedPassword, &$result)
{

}

function BeforeUserRegistration($userName, $email, $password, &$allowRegistration, &$errorMessage)
{

}    

function AfterUserRegistration($userName, $email)
{

}    

function PasswordResetRequest($userName, $email)
{

}

function PasswordResetComplete($userName, $email)
{

}

function VerifyPasswordStrength($password, &$result, &$passwordRuleMessage) 
{

}

function CreatePasswordHasher()
{
    $hasher = CreateHasher('SHA256');
    if ($hasher instanceof CustomStringHasher) {
        $hasher->OnEncryptPassword->AddListener('EncryptPassword');
        $hasher->OnVerifyPassword->AddListener('VerifyPassword');
    }
    return $hasher;
}

function CreateGrantManager() 
{
    global $tableCaptions;
    global $usersTableInfo;
    
    $userPermsTableInfo = array('TableName' => 'administratifs.phpgen_user_scta_perm', 'UserId' => 'user_id', 'PageName' => 'page_name', 'Grant' => 'perm_name');
    
    return new TableBasedUserGrantManager(PgConnectionFactory::getInstance(), GetGlobalConnectionOptions(),
        $usersTableInfo, $userPermsTableInfo, $tableCaptions, false);
}

function CreateTableBasedUserManager() 
{
    global $usersTableInfo;

    $userManager = new TableBasedUserManager(PgConnectionFactory::getInstance(), GetGlobalConnectionOptions(), 
        $usersTableInfo, CreatePasswordHasher(), true);
    $userManager->OnVerifyPasswordStrength->AddListener('VerifyPasswordStrength');

    return $userManager;
}

function GetReCaptcha($formId) 
{
    return null;
}

function SetUpUserAuthorization() 
{
    global $dataSourceRecordPermissions;

    $hasher = CreatePasswordHasher();

    $grantManager = CreateGrantManager();

    $userAuthentication = new TableBasedUserAuthentication(new UserIdentitySessionStorage(), false, $hasher, CreateTableBasedUserManager(), true, false, true);

    GetApplication()->SetUserAuthentication($userAuthentication);
    GetApplication()->SetUserGrantManager($grantManager);
    GetApplication()->SetDataSourceRecordPermissionRetrieveStrategy(new HardCodedDataSourceRecordPermissionRetrieveStrategy($dataSourceRecordPermissions));
}
