<?php
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                   ATTENTION!
 * If you see this message in your browser (Internet Explorer, Mozilla Firefox, Google Chrome, etc.)
 * this means that PHP is not properly installed on your web server. Please refer to the PHP manual
 * for more details: http://php.net/manual/install.php 
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

    include_once dirname(__FILE__) . '/components/startup.php';
    include_once dirname(__FILE__) . '/components/application.php';
    include_once dirname(__FILE__) . '/' . 'authorization.php';


    include_once dirname(__FILE__) . '/' . 'database_engine/pgsql_engine.php';
    include_once dirname(__FILE__) . '/' . 'components/page/page_includes.php';

    function GetConnectionOptions()
    {
        $result = GetGlobalConnectionOptions();
        $result['client_encoding'] = 'utf8';
        GetApplication()->GetUserAuthentication()->applyIdentityToConnectionOptions($result);
        return $result;
    }

    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class administratifs_locals_administratifs_personnelPage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Personnel');
            $this->SetMenuLabel('Personnel');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $this->dataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $this->dataset->AddLookupField('id_loc', 'administratifs.locals', new IntegerField('id_loc'), new StringField('no_loc', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('id_statut', 'administratifs.statut', new IntegerField('id_statut'), new StringField('nom_statut', false, false, false, false, 'LA2', 'LT2'), 'LT2');
            $this->dataset->AddLookupField('id_groupe', 'administratifs.groupe', new IntegerField('id_groupe'), new StringField('nom_groupe', false, false, false, false, 'LA3', 'LT3'), 'LT3');
            $this->dataset->AddLookupField('num_sigle', 'administratifs.sigle', new IntegerField('num_sigle'), new StringField('sigle_programme', false, false, false, false, 'LA4', 'LT4'), 'LT4');
            $this->dataset->AddLookupField('id_prof_reponsables', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA5', 'LT5'), 'LT5');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'nom', 'nom', 'Nom'),
                new FilterColumn($this->dataset, 'prenom', 'prenom', 'Prenom'),
                new FilterColumn($this->dataset, 'no_tel_trav', 'no_tel_trav', 'No Tel Trav'),
                new FilterColumn($this->dataset, 'no_tel_mais', 'no_tel_mais', 'No Tel Mais'),
                new FilterColumn($this->dataset, 'id_loc', 'LA1', 'Id Loc'),
                new FilterColumn($this->dataset, 'id_statut', 'LA2', 'Id Statut'),
                new FilterColumn($this->dataset, 'id_groupe', 'LA3', 'Id Groupe'),
                new FilterColumn($this->dataset, 'sujets', 'sujets', 'Sujets'),
                new FilterColumn($this->dataset, 'id_pers', 'id_pers', 'Id Pers'),
                new FilterColumn($this->dataset, 'num_sigle', 'LA4', 'Num Sigle'),
                new FilterColumn($this->dataset, 'courriel', 'courriel', 'Courriel'),
                new FilterColumn($this->dataset, 'code_perm', 'code_perm', 'Code Perm'),
                new FilterColumn($this->dataset, 'actif', 'actif', 'Actif'),
                new FilterColumn($this->dataset, 'codems', 'codems', 'Codems'),
                new FilterColumn($this->dataset, 'id_prof_reponsables', 'LA5', 'Id Prof Reponsables')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['nom'])
                ->addColumn($columns['prenom'])
                ->addColumn($columns['no_tel_trav'])
                ->addColumn($columns['no_tel_mais'])
                ->addColumn($columns['id_loc'])
                ->addColumn($columns['id_statut'])
                ->addColumn($columns['id_groupe'])
                ->addColumn($columns['sujets'])
                ->addColumn($columns['id_pers'])
                ->addColumn($columns['num_sigle'])
                ->addColumn($columns['courriel'])
                ->addColumn($columns['code_perm'])
                ->addColumn($columns['actif'])
                ->addColumn($columns['codems'])
                ->addColumn($columns['id_prof_reponsables']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_loc')
                ->setOptionsFor('id_statut')
                ->setOptionsFor('id_groupe')
                ->setOptionsFor('num_sigle')
                ->setOptionsFor('id_prof_reponsables');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('nom_edit');
            
            $filterBuilder->addColumn(
                $columns['nom'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('prenom_edit');
            $main_editor->SetMaxLength(30);
            
            $filterBuilder->addColumn(
                $columns['prenom'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_tel_trav');
            
            $filterBuilder->addColumn(
                $columns['no_tel_trav'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_tel_mais');
            
            $filterBuilder->addColumn(
                $columns['no_tel_mais'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_locals_administratifs_personnel_id_loc_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_loc', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_locals_administratifs_personnel_id_loc_search');
            
            $text_editor = new TextEdit('id_loc');
            
            $filterBuilder->addColumn(
                $columns['id_loc'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_statut_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_locals_administratifs_personnel_id_statut_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_statut', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_locals_administratifs_personnel_id_statut_search');
            
            $text_editor = new TextEdit('id_statut');
            
            $filterBuilder->addColumn(
                $columns['id_statut'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_groupe_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_locals_administratifs_personnel_id_groupe_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_groupe', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_locals_administratifs_personnel_id_groupe_search');
            
            $text_editor = new TextEdit('id_groupe');
            
            $filterBuilder->addColumn(
                $columns['id_groupe'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('sujets');
            
            $filterBuilder->addColumn(
                $columns['sujets'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_pers_edit');
            
            $filterBuilder->addColumn(
                $columns['id_pers'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('num_sigle_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_locals_administratifs_personnel_num_sigle_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('num_sigle', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_locals_administratifs_personnel_num_sigle_search');
            
            $filterBuilder->addColumn(
                $columns['num_sigle'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('courriel');
            
            $filterBuilder->addColumn(
                $columns['courriel'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('code_perm_edit');
            $main_editor->SetMaxLength(30);
            
            $filterBuilder->addColumn(
                $columns['code_perm'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('actif_edit');
            
            $filterBuilder->addColumn(
                $columns['actif'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('codems');
            
            $filterBuilder->addColumn(
                $columns['codems'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_prof_reponsables_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_locals_administratifs_personnel_id_prof_reponsables_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_prof_reponsables', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_locals_administratifs_personnel_id_prof_reponsables_search');
            
            $text_editor = new TextEdit('id_prof_reponsables');
            
            $filterBuilder->addColumn(
                $columns['id_prof_reponsables'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('nom', 'nom', 'Nom', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for prenom field
            //
            $column = new TextViewColumn('prenom', 'prenom', 'Prenom', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_tel_trav field
            //
            $column = new TextViewColumn('no_tel_trav', 'no_tel_trav', 'No Tel Trav', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_tel_mais field
            //
            $column = new TextViewColumn('no_tel_mais', 'no_tel_mais', 'No Tel Mais', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom_statut field
            //
            $column = new TextViewColumn('id_statut', 'LA2', 'Id Statut', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'LA3', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for sujets field
            //
            $column = new TextViewColumn('sujets', 'sujets', 'Sujets', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for sigle_programme field
            //
            $column = new NumberViewColumn('num_sigle', 'LA4', 'Num Sigle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for courriel field
            //
            $column = new TextViewColumn('courriel', 'courriel', 'Courriel', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for code_perm field
            //
            $column = new TextViewColumn('code_perm', 'code_perm', 'Code Perm', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for actif field
            //
            $column = new NumberViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for codems field
            //
            $column = new TextViewColumn('codems', 'codems', 'Codems', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_prof_reponsables', 'LA5', 'Id Prof Reponsables', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('nom', 'nom', 'Nom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for prenom field
            //
            $column = new TextViewColumn('prenom', 'prenom', 'Prenom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_tel_trav field
            //
            $column = new TextViewColumn('no_tel_trav', 'no_tel_trav', 'No Tel Trav', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_tel_mais field
            //
            $column = new TextViewColumn('no_tel_mais', 'no_tel_mais', 'No Tel Mais', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom_statut field
            //
            $column = new TextViewColumn('id_statut', 'LA2', 'Id Statut', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'LA3', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for sujets field
            //
            $column = new TextViewColumn('sujets', 'sujets', 'Sujets', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for sigle_programme field
            //
            $column = new NumberViewColumn('num_sigle', 'LA4', 'Num Sigle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for courriel field
            //
            $column = new TextViewColumn('courriel', 'courriel', 'Courriel', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for code_perm field
            //
            $column = new TextViewColumn('code_perm', 'code_perm', 'Code Perm', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for actif field
            //
            $column = new NumberViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for codems field
            //
            $column = new TextViewColumn('codems', 'codems', 'Codems', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_prof_reponsables', 'LA5', 'Id Prof Reponsables', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for nom field
            //
            $editor = new TextEdit('nom_edit');
            $editColumn = new CustomEditColumn('Nom', 'nom', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for prenom field
            //
            $editor = new TextEdit('prenom_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Prenom', 'prenom', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_tel_trav field
            //
            $editor = new TextAreaEdit('no_tel_trav_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Tel Trav', 'no_tel_trav', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_tel_mais field
            //
            $editor = new TextAreaEdit('no_tel_mais_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Tel Mais', 'no_tel_mais', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'edit_administratifs_locals_administratifs_personnel_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_statut field
            //
            $editor = new DynamicCombobox('id_statut_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."statut"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_statut', true, true, true),
                    new StringField('nom_statut', true)
                )
            );
            $lookupDataset->setOrderByField('nom_statut', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Statut', 'id_statut', 'LA2', 'edit_administratifs_locals_administratifs_personnel_id_statut_search', $editor, $this->dataset, $lookupDataset, 'id_statut', 'nom_statut', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_groupe field
            //
            $editor = new DynamicCombobox('id_groupe_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Groupe', 'id_groupe', 'LA3', 'edit_administratifs_locals_administratifs_personnel_id_groupe_search', $editor, $this->dataset, $lookupDataset, 'id_groupe', 'nom_groupe', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for sujets field
            //
            $editor = new TextAreaEdit('sujets_edit', 50, 8);
            $editColumn = new CustomEditColumn('Sujets', 'sujets', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for num_sigle field
            //
            $editor = new DynamicCombobox('num_sigle_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Num Sigle', 'num_sigle', 'LA4', 'edit_administratifs_locals_administratifs_personnel_num_sigle_search', $editor, $this->dataset, $lookupDataset, 'num_sigle', 'sigle_programme', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for courriel field
            //
            $editor = new TextAreaEdit('courriel_edit', 50, 8);
            $editColumn = new CustomEditColumn('Courriel', 'courriel', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for code_perm field
            //
            $editor = new TextEdit('code_perm_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Code Perm', 'code_perm', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for actif field
            //
            $editor = new TextEdit('actif_edit');
            $editColumn = new CustomEditColumn('Actif', 'actif', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for codems field
            //
            $editor = new TextAreaEdit('codems_edit', 50, 8);
            $editColumn = new CustomEditColumn('Codems', 'codems', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_prof_reponsables field
            //
            $editor = new DynamicCombobox('id_prof_reponsables_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Prof Reponsables', 'id_prof_reponsables', 'LA5', 'edit_administratifs_locals_administratifs_personnel_id_prof_reponsables_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for nom field
            //
            $editor = new TextEdit('nom_edit');
            $editColumn = new CustomEditColumn('Nom', 'nom', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for prenom field
            //
            $editor = new TextEdit('prenom_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Prenom', 'prenom', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_tel_trav field
            //
            $editor = new TextAreaEdit('no_tel_trav_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Tel Trav', 'no_tel_trav', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_tel_mais field
            //
            $editor = new TextAreaEdit('no_tel_mais_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Tel Mais', 'no_tel_mais', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'multi_edit_administratifs_locals_administratifs_personnel_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_statut field
            //
            $editor = new DynamicCombobox('id_statut_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."statut"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_statut', true, true, true),
                    new StringField('nom_statut', true)
                )
            );
            $lookupDataset->setOrderByField('nom_statut', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Statut', 'id_statut', 'LA2', 'multi_edit_administratifs_locals_administratifs_personnel_id_statut_search', $editor, $this->dataset, $lookupDataset, 'id_statut', 'nom_statut', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_groupe field
            //
            $editor = new DynamicCombobox('id_groupe_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Groupe', 'id_groupe', 'LA3', 'multi_edit_administratifs_locals_administratifs_personnel_id_groupe_search', $editor, $this->dataset, $lookupDataset, 'id_groupe', 'nom_groupe', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for sujets field
            //
            $editor = new TextAreaEdit('sujets_edit', 50, 8);
            $editColumn = new CustomEditColumn('Sujets', 'sujets', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for num_sigle field
            //
            $editor = new DynamicCombobox('num_sigle_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Num Sigle', 'num_sigle', 'LA4', 'multi_edit_administratifs_locals_administratifs_personnel_num_sigle_search', $editor, $this->dataset, $lookupDataset, 'num_sigle', 'sigle_programme', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for courriel field
            //
            $editor = new TextAreaEdit('courriel_edit', 50, 8);
            $editColumn = new CustomEditColumn('Courriel', 'courriel', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for code_perm field
            //
            $editor = new TextEdit('code_perm_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Code Perm', 'code_perm', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for actif field
            //
            $editor = new TextEdit('actif_edit');
            $editColumn = new CustomEditColumn('Actif', 'actif', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for codems field
            //
            $editor = new TextAreaEdit('codems_edit', 50, 8);
            $editColumn = new CustomEditColumn('Codems', 'codems', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_prof_reponsables field
            //
            $editor = new DynamicCombobox('id_prof_reponsables_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Prof Reponsables', 'id_prof_reponsables', 'LA5', 'multi_edit_administratifs_locals_administratifs_personnel_id_prof_reponsables_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for nom field
            //
            $editor = new TextEdit('nom_edit');
            $editColumn = new CustomEditColumn('Nom', 'nom', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for prenom field
            //
            $editor = new TextEdit('prenom_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Prenom', 'prenom', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_tel_trav field
            //
            $editor = new TextAreaEdit('no_tel_trav_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Tel Trav', 'no_tel_trav', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_tel_mais field
            //
            $editor = new TextAreaEdit('no_tel_mais_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Tel Mais', 'no_tel_mais', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'insert_administratifs_locals_administratifs_personnel_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_statut field
            //
            $editor = new DynamicCombobox('id_statut_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."statut"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_statut', true, true, true),
                    new StringField('nom_statut', true)
                )
            );
            $lookupDataset->setOrderByField('nom_statut', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Statut', 'id_statut', 'LA2', 'insert_administratifs_locals_administratifs_personnel_id_statut_search', $editor, $this->dataset, $lookupDataset, 'id_statut', 'nom_statut', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_groupe field
            //
            $editor = new DynamicCombobox('id_groupe_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Groupe', 'id_groupe', 'LA3', 'insert_administratifs_locals_administratifs_personnel_id_groupe_search', $editor, $this->dataset, $lookupDataset, 'id_groupe', 'nom_groupe', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for sujets field
            //
            $editor = new TextAreaEdit('sujets_edit', 50, 8);
            $editColumn = new CustomEditColumn('Sujets', 'sujets', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for num_sigle field
            //
            $editor = new DynamicCombobox('num_sigle_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Num Sigle', 'num_sigle', 'LA4', 'insert_administratifs_locals_administratifs_personnel_num_sigle_search', $editor, $this->dataset, $lookupDataset, 'num_sigle', 'sigle_programme', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for courriel field
            //
            $editor = new TextAreaEdit('courriel_edit', 50, 8);
            $editColumn = new CustomEditColumn('Courriel', 'courriel', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for code_perm field
            //
            $editor = new TextEdit('code_perm_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Code Perm', 'code_perm', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for actif field
            //
            $editor = new TextEdit('actif_edit');
            $editColumn = new CustomEditColumn('Actif', 'actif', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for codems field
            //
            $editor = new TextAreaEdit('codems_edit', 50, 8);
            $editColumn = new CustomEditColumn('Codems', 'codems', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_prof_reponsables field
            //
            $editor = new DynamicCombobox('id_prof_reponsables_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Prof Reponsables', 'id_prof_reponsables', 'LA5', 'insert_administratifs_locals_administratifs_personnel_id_prof_reponsables_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('nom', 'nom', 'Nom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for prenom field
            //
            $column = new TextViewColumn('prenom', 'prenom', 'Prenom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_tel_trav field
            //
            $column = new TextViewColumn('no_tel_trav', 'no_tel_trav', 'No Tel Trav', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_tel_mais field
            //
            $column = new TextViewColumn('no_tel_mais', 'no_tel_mais', 'No Tel Mais', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom_statut field
            //
            $column = new TextViewColumn('id_statut', 'LA2', 'Id Statut', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'LA3', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for sujets field
            //
            $column = new TextViewColumn('sujets', 'sujets', 'Sujets', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for sigle_programme field
            //
            $column = new NumberViewColumn('num_sigle', 'LA4', 'Num Sigle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for courriel field
            //
            $column = new TextViewColumn('courriel', 'courriel', 'Courriel', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for code_perm field
            //
            $column = new TextViewColumn('code_perm', 'code_perm', 'Code Perm', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for actif field
            //
            $column = new NumberViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for codems field
            //
            $column = new TextViewColumn('codems', 'codems', 'Codems', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_prof_reponsables', 'LA5', 'Id Prof Reponsables', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('nom', 'nom', 'Nom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for prenom field
            //
            $column = new TextViewColumn('prenom', 'prenom', 'Prenom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_tel_trav field
            //
            $column = new TextViewColumn('no_tel_trav', 'no_tel_trav', 'No Tel Trav', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_tel_mais field
            //
            $column = new TextViewColumn('no_tel_mais', 'no_tel_mais', 'No Tel Mais', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom_statut field
            //
            $column = new TextViewColumn('id_statut', 'LA2', 'Id Statut', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'LA3', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for sujets field
            //
            $column = new TextViewColumn('sujets', 'sujets', 'Sujets', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for sigle_programme field
            //
            $column = new NumberViewColumn('num_sigle', 'LA4', 'Num Sigle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for courriel field
            //
            $column = new TextViewColumn('courriel', 'courriel', 'Courriel', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for code_perm field
            //
            $column = new TextViewColumn('code_perm', 'code_perm', 'Code Perm', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for actif field
            //
            $column = new NumberViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for codems field
            //
            $column = new TextViewColumn('codems', 'codems', 'Codems', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_prof_reponsables', 'LA5', 'Id Prof Reponsables', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('nom', 'nom', 'Nom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for prenom field
            //
            $column = new TextViewColumn('prenom', 'prenom', 'Prenom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_tel_trav field
            //
            $column = new TextViewColumn('no_tel_trav', 'no_tel_trav', 'No Tel Trav', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_tel_mais field
            //
            $column = new TextViewColumn('no_tel_mais', 'no_tel_mais', 'No Tel Mais', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom_statut field
            //
            $column = new TextViewColumn('id_statut', 'LA2', 'Id Statut', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'LA3', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for sujets field
            //
            $column = new TextViewColumn('sujets', 'sujets', 'Sujets', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for sigle_programme field
            //
            $column = new NumberViewColumn('num_sigle', 'LA4', 'Num Sigle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for courriel field
            //
            $column = new TextViewColumn('courriel', 'courriel', 'Courriel', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for code_perm field
            //
            $column = new TextViewColumn('code_perm', 'code_perm', 'Code Perm', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for actif field
            //
            $column = new NumberViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for codems field
            //
            $column = new TextViewColumn('codems', 'codems', 'Codems', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_prof_reponsables', 'LA5', 'Id Prof Reponsables', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(true);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_locals_administratifs_personnel_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."statut"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_statut', true, true, true),
                    new StringField('nom_statut', true)
                )
            );
            $lookupDataset->setOrderByField('nom_statut', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_locals_administratifs_personnel_id_statut_search', 'id_statut', 'nom_statut', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_locals_administratifs_personnel_id_groupe_search', 'id_groupe', 'nom_groupe', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_locals_administratifs_personnel_num_sigle_search', 'num_sigle', 'sigle_programme', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_locals_administratifs_personnel_id_prof_reponsables_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_locals_administratifs_personnel_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."statut"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_statut', true, true, true),
                    new StringField('nom_statut', true)
                )
            );
            $lookupDataset->setOrderByField('nom_statut', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_locals_administratifs_personnel_id_statut_search', 'id_statut', 'nom_statut', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_locals_administratifs_personnel_id_groupe_search', 'id_groupe', 'nom_groupe', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_locals_administratifs_personnel_id_groupe_search', 'id_groupe', 'nom_groupe', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_locals_administratifs_personnel_num_sigle_search', 'num_sigle', 'sigle_programme', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_locals_administratifs_personnel_num_sigle_search', 'num_sigle', 'sigle_programme', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_locals_administratifs_personnel_id_prof_reponsables_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_locals_administratifs_personnel_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."statut"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_statut', true, true, true),
                    new StringField('nom_statut', true)
                )
            );
            $lookupDataset->setOrderByField('nom_statut', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_locals_administratifs_personnel_id_statut_search', 'id_statut', 'nom_statut', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_locals_administratifs_personnel_id_groupe_search', 'id_groupe', 'nom_groupe', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_locals_administratifs_personnel_num_sigle_search', 'num_sigle', 'sigle_programme', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_locals_administratifs_personnel_id_prof_reponsables_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_locals_administratifs_personnel_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."statut"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_statut', true, true, true),
                    new StringField('nom_statut', true)
                )
            );
            $lookupDataset->setOrderByField('nom_statut', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_locals_administratifs_personnel_id_statut_search', 'id_statut', 'nom_statut', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_locals_administratifs_personnel_id_groupe_search', 'id_groupe', 'nom_groupe', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_locals_administratifs_personnel_num_sigle_search', 'num_sigle', 'sigle_programme', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_locals_administratifs_personnel_id_prof_reponsables_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }
    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class administratifs_locals_cle_departement_cle_clesPage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Cle Cles');
            $this->SetMenuLabel('Cle Cles');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"cle_departement"."cle_cles"');
            $this->dataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new IntegerField('boite'),
                    new StringField('crochet'),
                    new StringField('num_cle'),
                    new StringField('description'),
                    new StringField('no_local'),
                    new StringField('ref_local'),
                    new IntegerField('id_local'),
                    new StringField('nb_total'),
                    new StringField('nb_circulation'),
                    new StringField('nb_disponible')
                )
            );
            $this->dataset->AddLookupField('id_local', 'administratifs.locals', new IntegerField('id_loc'), new StringField('no_loc', false, false, false, false, 'LA1', 'LT1'), 'LT1');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'id', 'id', 'Id'),
                new FilterColumn($this->dataset, 'boite', 'boite', 'Boite'),
                new FilterColumn($this->dataset, 'crochet', 'crochet', 'Crochet'),
                new FilterColumn($this->dataset, 'num_cle', 'num_cle', 'Num Cle'),
                new FilterColumn($this->dataset, 'description', 'description', 'Description'),
                new FilterColumn($this->dataset, 'no_local', 'no_local', 'No Local'),
                new FilterColumn($this->dataset, 'ref_local', 'ref_local', 'Ref Local'),
                new FilterColumn($this->dataset, 'id_local', 'LA1', 'Id Local'),
                new FilterColumn($this->dataset, 'nb_total', 'nb_total', 'Nb Total'),
                new FilterColumn($this->dataset, 'nb_circulation', 'nb_circulation', 'Nb Circulation'),
                new FilterColumn($this->dataset, 'nb_disponible', 'nb_disponible', 'Nb Disponible')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['id'])
                ->addColumn($columns['boite'])
                ->addColumn($columns['crochet'])
                ->addColumn($columns['num_cle'])
                ->addColumn($columns['description'])
                ->addColumn($columns['no_local'])
                ->addColumn($columns['ref_local'])
                ->addColumn($columns['id_local'])
                ->addColumn($columns['nb_total'])
                ->addColumn($columns['nb_circulation'])
                ->addColumn($columns['nb_disponible']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_local');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('id_edit');
            
            $filterBuilder->addColumn(
                $columns['id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('boite_edit');
            
            $filterBuilder->addColumn(
                $columns['boite'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('crochet_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['crochet'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('num_cle_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['num_cle'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('description_edit');
            $main_editor->SetMaxLength(90);
            
            $filterBuilder->addColumn(
                $columns['description'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_local_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['no_local'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('ref_local_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['ref_local'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_local_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_locals_cle_departement_cle_cles_id_local_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_local', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_locals_cle_departement_cle_cles_id_local_search');
            
            $text_editor = new TextEdit('id_local');
            
            $filterBuilder->addColumn(
                $columns['id_local'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('nb_total_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['nb_total'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('nb_circulation_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['nb_circulation'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('nb_disponible_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['nb_disponible'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for boite field
            //
            $column = new NumberViewColumn('boite', 'boite', 'Boite', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for crochet field
            //
            $column = new TextViewColumn('crochet', 'crochet', 'Crochet', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for num_cle field
            //
            $column = new TextViewColumn('num_cle', 'num_cle', 'Num Cle', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_local field
            //
            $column = new TextViewColumn('no_local', 'no_local', 'No Local', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for ref_local field
            //
            $column = new TextViewColumn('ref_local', 'ref_local', 'Ref Local', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_local', 'LA1', 'Id Local', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nb_total field
            //
            $column = new TextViewColumn('nb_total', 'nb_total', 'Nb Total', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nb_circulation field
            //
            $column = new TextViewColumn('nb_circulation', 'nb_circulation', 'Nb Circulation', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nb_disponible field
            //
            $column = new TextViewColumn('nb_disponible', 'nb_disponible', 'Nb Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for boite field
            //
            $column = new NumberViewColumn('boite', 'boite', 'Boite', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for crochet field
            //
            $column = new TextViewColumn('crochet', 'crochet', 'Crochet', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for num_cle field
            //
            $column = new TextViewColumn('num_cle', 'num_cle', 'Num Cle', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_local field
            //
            $column = new TextViewColumn('no_local', 'no_local', 'No Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for ref_local field
            //
            $column = new TextViewColumn('ref_local', 'ref_local', 'Ref Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_local', 'LA1', 'Id Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nb_total field
            //
            $column = new TextViewColumn('nb_total', 'nb_total', 'Nb Total', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nb_circulation field
            //
            $column = new TextViewColumn('nb_circulation', 'nb_circulation', 'Nb Circulation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nb_disponible field
            //
            $column = new TextViewColumn('nb_disponible', 'nb_disponible', 'Nb Disponible', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for id field
            //
            $editor = new TextEdit('id_edit');
            $editColumn = new CustomEditColumn('Id', 'id', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for boite field
            //
            $editor = new TextEdit('boite_edit');
            $editColumn = new CustomEditColumn('Boite', 'boite', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for crochet field
            //
            $editor = new TextEdit('crochet_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Crochet', 'crochet', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for num_cle field
            //
            $editor = new TextEdit('num_cle_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Num Cle', 'num_cle', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for description field
            //
            $editor = new TextEdit('description_edit');
            $editor->SetMaxLength(90);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_local field
            //
            $editor = new TextEdit('no_local_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Local', 'no_local', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for ref_local field
            //
            $editor = new TextEdit('ref_local_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Ref Local', 'ref_local', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_local field
            //
            $editor = new DynamicCombobox('id_local_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Local', 'id_local', 'LA1', 'edit_administratifs_locals_cle_departement_cle_cles_id_local_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for nb_total field
            //
            $editor = new TextEdit('nb_total_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Nb Total', 'nb_total', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for nb_circulation field
            //
            $editor = new TextEdit('nb_circulation_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Nb Circulation', 'nb_circulation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for nb_disponible field
            //
            $editor = new TextEdit('nb_disponible_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Nb Disponible', 'nb_disponible', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for boite field
            //
            $editor = new TextEdit('boite_edit');
            $editColumn = new CustomEditColumn('Boite', 'boite', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for crochet field
            //
            $editor = new TextEdit('crochet_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Crochet', 'crochet', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for num_cle field
            //
            $editor = new TextEdit('num_cle_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Num Cle', 'num_cle', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for description field
            //
            $editor = new TextEdit('description_edit');
            $editor->SetMaxLength(90);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_local field
            //
            $editor = new TextEdit('no_local_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Local', 'no_local', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for ref_local field
            //
            $editor = new TextEdit('ref_local_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Ref Local', 'ref_local', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_local field
            //
            $editor = new DynamicCombobox('id_local_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Local', 'id_local', 'LA1', 'multi_edit_administratifs_locals_cle_departement_cle_cles_id_local_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for nb_total field
            //
            $editor = new TextEdit('nb_total_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Nb Total', 'nb_total', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for nb_circulation field
            //
            $editor = new TextEdit('nb_circulation_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Nb Circulation', 'nb_circulation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for nb_disponible field
            //
            $editor = new TextEdit('nb_disponible_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Nb Disponible', 'nb_disponible', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for id field
            //
            $editor = new TextEdit('id_edit');
            $editColumn = new CustomEditColumn('Id', 'id', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for boite field
            //
            $editor = new TextEdit('boite_edit');
            $editColumn = new CustomEditColumn('Boite', 'boite', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for crochet field
            //
            $editor = new TextEdit('crochet_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Crochet', 'crochet', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for num_cle field
            //
            $editor = new TextEdit('num_cle_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Num Cle', 'num_cle', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for description field
            //
            $editor = new TextEdit('description_edit');
            $editor->SetMaxLength(90);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_local field
            //
            $editor = new TextEdit('no_local_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Local', 'no_local', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for ref_local field
            //
            $editor = new TextEdit('ref_local_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Ref Local', 'ref_local', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_local field
            //
            $editor = new DynamicCombobox('id_local_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Local', 'id_local', 'LA1', 'insert_administratifs_locals_cle_departement_cle_cles_id_local_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for nb_total field
            //
            $editor = new TextEdit('nb_total_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Nb Total', 'nb_total', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for nb_circulation field
            //
            $editor = new TextEdit('nb_circulation_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Nb Circulation', 'nb_circulation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for nb_disponible field
            //
            $editor = new TextEdit('nb_disponible_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Nb Disponible', 'nb_disponible', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for boite field
            //
            $column = new NumberViewColumn('boite', 'boite', 'Boite', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for crochet field
            //
            $column = new TextViewColumn('crochet', 'crochet', 'Crochet', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for num_cle field
            //
            $column = new TextViewColumn('num_cle', 'num_cle', 'Num Cle', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_local field
            //
            $column = new TextViewColumn('no_local', 'no_local', 'No Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for ref_local field
            //
            $column = new TextViewColumn('ref_local', 'ref_local', 'Ref Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_local', 'LA1', 'Id Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nb_total field
            //
            $column = new TextViewColumn('nb_total', 'nb_total', 'Nb Total', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nb_circulation field
            //
            $column = new TextViewColumn('nb_circulation', 'nb_circulation', 'Nb Circulation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nb_disponible field
            //
            $column = new TextViewColumn('nb_disponible', 'nb_disponible', 'Nb Disponible', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for boite field
            //
            $column = new NumberViewColumn('boite', 'boite', 'Boite', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for crochet field
            //
            $column = new TextViewColumn('crochet', 'crochet', 'Crochet', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for num_cle field
            //
            $column = new TextViewColumn('num_cle', 'num_cle', 'Num Cle', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_local field
            //
            $column = new TextViewColumn('no_local', 'no_local', 'No Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for ref_local field
            //
            $column = new TextViewColumn('ref_local', 'ref_local', 'Ref Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_local', 'LA1', 'Id Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nb_total field
            //
            $column = new TextViewColumn('nb_total', 'nb_total', 'Nb Total', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nb_circulation field
            //
            $column = new TextViewColumn('nb_circulation', 'nb_circulation', 'Nb Circulation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nb_disponible field
            //
            $column = new TextViewColumn('nb_disponible', 'nb_disponible', 'Nb Disponible', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for boite field
            //
            $column = new NumberViewColumn('boite', 'boite', 'Boite', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for crochet field
            //
            $column = new TextViewColumn('crochet', 'crochet', 'Crochet', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for num_cle field
            //
            $column = new TextViewColumn('num_cle', 'num_cle', 'Num Cle', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_local field
            //
            $column = new TextViewColumn('no_local', 'no_local', 'No Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for ref_local field
            //
            $column = new TextViewColumn('ref_local', 'ref_local', 'Ref Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_local', 'LA1', 'Id Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nb_total field
            //
            $column = new TextViewColumn('nb_total', 'nb_total', 'Nb Total', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nb_circulation field
            //
            $column = new TextViewColumn('nb_circulation', 'nb_circulation', 'Nb Circulation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nb_disponible field
            //
            $column = new TextViewColumn('nb_disponible', 'nb_disponible', 'Nb Disponible', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(true);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_locals_cle_departement_cle_cles_id_local_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_locals_cle_departement_cle_cles_id_local_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_locals_cle_departement_cle_cles_id_local_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_locals_cle_departement_cle_cles_id_local_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }
    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class administratifs_locals_materiel_ipadressePage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Ipadresse');
            $this->SetMenuLabel('Ipadresse');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."ipadresse"');
            $this->dataset->addFields(
                array(
                    new StringField('ip', true),
                    new StringField('mac', true),
                    new StringField('local', true),
                    new IntegerField('id_local'),
                    new StringField('prise', true),
                    new StringField('hub_port', true),
                    new StringField('responsable', true),
                    new StringField('type'),
                    new StringField('identite'),
                    new StringField('dns'),
                    new StringField('non_fonctionnel'),
                    new IntegerField('id_ip', true, true, true)
                )
            );
            $this->dataset->AddLookupField('id_local', 'administratifs.locals', new IntegerField('id_loc'), new StringField('no_loc', false, false, false, false, 'LA1', 'LT1'), 'LT1');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'ip', 'ip', 'Ip'),
                new FilterColumn($this->dataset, 'mac', 'mac', 'Mac'),
                new FilterColumn($this->dataset, 'local', 'local', 'Local'),
                new FilterColumn($this->dataset, 'id_local', 'LA1', 'Id Local'),
                new FilterColumn($this->dataset, 'prise', 'prise', 'Prise'),
                new FilterColumn($this->dataset, 'hub_port', 'hub_port', 'Hub Port'),
                new FilterColumn($this->dataset, 'responsable', 'responsable', 'Responsable'),
                new FilterColumn($this->dataset, 'type', 'type', 'Type'),
                new FilterColumn($this->dataset, 'identite', 'identite', 'Identite'),
                new FilterColumn($this->dataset, 'dns', 'dns', 'Dns'),
                new FilterColumn($this->dataset, 'non_fonctionnel', 'non_fonctionnel', 'Non Fonctionnel'),
                new FilterColumn($this->dataset, 'id_ip', 'id_ip', 'Id Ip')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['ip'])
                ->addColumn($columns['mac'])
                ->addColumn($columns['local'])
                ->addColumn($columns['id_local'])
                ->addColumn($columns['prise'])
                ->addColumn($columns['hub_port'])
                ->addColumn($columns['responsable'])
                ->addColumn($columns['type'])
                ->addColumn($columns['identite'])
                ->addColumn($columns['dns'])
                ->addColumn($columns['non_fonctionnel'])
                ->addColumn($columns['id_ip']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_local');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('ip_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['ip'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('mac_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['mac'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('local_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['local'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_local_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_locals_materiel_ipadresse_id_local_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_local', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_locals_materiel_ipadresse_id_local_search');
            
            $text_editor = new TextEdit('id_local');
            
            $filterBuilder->addColumn(
                $columns['id_local'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('prise_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['prise'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('hub_port_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['hub_port'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('responsable_edit');
            $main_editor->SetMaxLength(40);
            
            $filterBuilder->addColumn(
                $columns['responsable'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('type_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['type'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('identite_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['identite'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('dns_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['dns'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('non_fonctionnel_edit');
            
            $filterBuilder->addColumn(
                $columns['non_fonctionnel'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_ip_edit');
            
            $filterBuilder->addColumn(
                $columns['id_ip'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for ip field
            //
            $column = new TextViewColumn('ip', 'ip', 'Ip', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for mac field
            //
            $column = new TextViewColumn('mac', 'mac', 'Mac', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for local field
            //
            $column = new TextViewColumn('local', 'local', 'Local', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_local', 'LA1', 'Id Local', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for prise field
            //
            $column = new TextViewColumn('prise', 'prise', 'Prise', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for hub_port field
            //
            $column = new TextViewColumn('hub_port', 'hub_port', 'Hub Port', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for responsable field
            //
            $column = new TextViewColumn('responsable', 'responsable', 'Responsable', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for type field
            //
            $column = new TextViewColumn('type', 'type', 'Type', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for identite field
            //
            $column = new TextViewColumn('identite', 'identite', 'Identite', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for dns field
            //
            $column = new TextViewColumn('dns', 'dns', 'Dns', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for non_fonctionnel field
            //
            $column = new TextViewColumn('non_fonctionnel', 'non_fonctionnel', 'Non Fonctionnel', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_ip field
            //
            $column = new NumberViewColumn('id_ip', 'id_ip', 'Id Ip', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for ip field
            //
            $column = new TextViewColumn('ip', 'ip', 'Ip', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for mac field
            //
            $column = new TextViewColumn('mac', 'mac', 'Mac', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for local field
            //
            $column = new TextViewColumn('local', 'local', 'Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_local', 'LA1', 'Id Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for prise field
            //
            $column = new TextViewColumn('prise', 'prise', 'Prise', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for hub_port field
            //
            $column = new TextViewColumn('hub_port', 'hub_port', 'Hub Port', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for responsable field
            //
            $column = new TextViewColumn('responsable', 'responsable', 'Responsable', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for type field
            //
            $column = new TextViewColumn('type', 'type', 'Type', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for identite field
            //
            $column = new TextViewColumn('identite', 'identite', 'Identite', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for dns field
            //
            $column = new TextViewColumn('dns', 'dns', 'Dns', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for non_fonctionnel field
            //
            $column = new TextViewColumn('non_fonctionnel', 'non_fonctionnel', 'Non Fonctionnel', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_ip field
            //
            $column = new NumberViewColumn('id_ip', 'id_ip', 'Id Ip', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for ip field
            //
            $editor = new TextEdit('ip_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Ip', 'ip', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for mac field
            //
            $editor = new TextEdit('mac_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Mac', 'mac', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for local field
            //
            $editor = new TextEdit('local_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Local', 'local', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_local field
            //
            $editor = new DynamicCombobox('id_local_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Local', 'id_local', 'LA1', 'edit_administratifs_locals_materiel_ipadresse_id_local_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for prise field
            //
            $editor = new TextEdit('prise_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Prise', 'prise', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for hub_port field
            //
            $editor = new TextEdit('hub_port_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Hub Port', 'hub_port', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for responsable field
            //
            $editor = new TextEdit('responsable_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Responsable', 'responsable', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for type field
            //
            $editor = new TextEdit('type_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Type', 'type', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for identite field
            //
            $editor = new TextEdit('identite_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Identite', 'identite', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for dns field
            //
            $editor = new TextEdit('dns_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Dns', 'dns', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for non_fonctionnel field
            //
            $editor = new TextEdit('non_fonctionnel_edit');
            $editColumn = new CustomEditColumn('Non Fonctionnel', 'non_fonctionnel', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for ip field
            //
            $editor = new TextEdit('ip_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Ip', 'ip', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for mac field
            //
            $editor = new TextEdit('mac_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Mac', 'mac', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for local field
            //
            $editor = new TextEdit('local_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Local', 'local', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_local field
            //
            $editor = new DynamicCombobox('id_local_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Local', 'id_local', 'LA1', 'multi_edit_administratifs_locals_materiel_ipadresse_id_local_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for prise field
            //
            $editor = new TextEdit('prise_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Prise', 'prise', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for hub_port field
            //
            $editor = new TextEdit('hub_port_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Hub Port', 'hub_port', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for responsable field
            //
            $editor = new TextEdit('responsable_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Responsable', 'responsable', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for type field
            //
            $editor = new TextEdit('type_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Type', 'type', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for identite field
            //
            $editor = new TextEdit('identite_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Identite', 'identite', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for dns field
            //
            $editor = new TextEdit('dns_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Dns', 'dns', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for non_fonctionnel field
            //
            $editor = new TextEdit('non_fonctionnel_edit');
            $editColumn = new CustomEditColumn('Non Fonctionnel', 'non_fonctionnel', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for ip field
            //
            $editor = new TextEdit('ip_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Ip', 'ip', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for mac field
            //
            $editor = new TextEdit('mac_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Mac', 'mac', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for local field
            //
            $editor = new TextEdit('local_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Local', 'local', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_local field
            //
            $editor = new DynamicCombobox('id_local_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Local', 'id_local', 'LA1', 'insert_administratifs_locals_materiel_ipadresse_id_local_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for prise field
            //
            $editor = new TextEdit('prise_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Prise', 'prise', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for hub_port field
            //
            $editor = new TextEdit('hub_port_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Hub Port', 'hub_port', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for responsable field
            //
            $editor = new TextEdit('responsable_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Responsable', 'responsable', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for type field
            //
            $editor = new TextEdit('type_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Type', 'type', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for identite field
            //
            $editor = new TextEdit('identite_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Identite', 'identite', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for dns field
            //
            $editor = new TextEdit('dns_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Dns', 'dns', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for non_fonctionnel field
            //
            $editor = new TextEdit('non_fonctionnel_edit');
            $editColumn = new CustomEditColumn('Non Fonctionnel', 'non_fonctionnel', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for ip field
            //
            $column = new TextViewColumn('ip', 'ip', 'Ip', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for mac field
            //
            $column = new TextViewColumn('mac', 'mac', 'Mac', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for local field
            //
            $column = new TextViewColumn('local', 'local', 'Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_local', 'LA1', 'Id Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for prise field
            //
            $column = new TextViewColumn('prise', 'prise', 'Prise', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for hub_port field
            //
            $column = new TextViewColumn('hub_port', 'hub_port', 'Hub Port', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for responsable field
            //
            $column = new TextViewColumn('responsable', 'responsable', 'Responsable', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for type field
            //
            $column = new TextViewColumn('type', 'type', 'Type', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for identite field
            //
            $column = new TextViewColumn('identite', 'identite', 'Identite', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for dns field
            //
            $column = new TextViewColumn('dns', 'dns', 'Dns', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for non_fonctionnel field
            //
            $column = new TextViewColumn('non_fonctionnel', 'non_fonctionnel', 'Non Fonctionnel', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_ip field
            //
            $column = new NumberViewColumn('id_ip', 'id_ip', 'Id Ip', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for ip field
            //
            $column = new TextViewColumn('ip', 'ip', 'Ip', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for mac field
            //
            $column = new TextViewColumn('mac', 'mac', 'Mac', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for local field
            //
            $column = new TextViewColumn('local', 'local', 'Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_local', 'LA1', 'Id Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for prise field
            //
            $column = new TextViewColumn('prise', 'prise', 'Prise', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for hub_port field
            //
            $column = new TextViewColumn('hub_port', 'hub_port', 'Hub Port', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for responsable field
            //
            $column = new TextViewColumn('responsable', 'responsable', 'Responsable', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for type field
            //
            $column = new TextViewColumn('type', 'type', 'Type', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for identite field
            //
            $column = new TextViewColumn('identite', 'identite', 'Identite', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for dns field
            //
            $column = new TextViewColumn('dns', 'dns', 'Dns', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for non_fonctionnel field
            //
            $column = new TextViewColumn('non_fonctionnel', 'non_fonctionnel', 'Non Fonctionnel', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_ip field
            //
            $column = new NumberViewColumn('id_ip', 'id_ip', 'Id Ip', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for ip field
            //
            $column = new TextViewColumn('ip', 'ip', 'Ip', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for mac field
            //
            $column = new TextViewColumn('mac', 'mac', 'Mac', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for local field
            //
            $column = new TextViewColumn('local', 'local', 'Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_local', 'LA1', 'Id Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for prise field
            //
            $column = new TextViewColumn('prise', 'prise', 'Prise', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for hub_port field
            //
            $column = new TextViewColumn('hub_port', 'hub_port', 'Hub Port', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for responsable field
            //
            $column = new TextViewColumn('responsable', 'responsable', 'Responsable', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for type field
            //
            $column = new TextViewColumn('type', 'type', 'Type', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for identite field
            //
            $column = new TextViewColumn('identite', 'identite', 'Identite', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for dns field
            //
            $column = new TextViewColumn('dns', 'dns', 'Dns', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for non_fonctionnel field
            //
            $column = new TextViewColumn('non_fonctionnel', 'non_fonctionnel', 'Non Fonctionnel', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(true);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_locals_materiel_ipadresse_id_local_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_locals_materiel_ipadresse_id_local_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_locals_materiel_ipadresse_id_local_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_locals_materiel_ipadresse_id_local_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }
    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class administratifs_locals_materiel_mat_informatiquePage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Mat Informatique');
            $this->SetMenuLabel('Mat Informatique');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_informatique"');
            $this->dataset->addFields(
                array(
                    new IntegerField('id_mat_inf', true, true, true),
                    new IntegerField('id_loc'),
                    new StringField('no_uqam'),
                    new StringField('syst_expl'),
                    new StringField('marque'),
                    new StringField('description'),
                    new IntegerField('id_grp'),
                    new StringField('fournisseur'),
                    new StringField('no_serie'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new StringField('prix'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d'),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new StringField('adresse_ip'),
                    new IntegerField('id_adresse_ip'),
                    new IntegerField('id_pers'),
                    new StringField('disponible'),
                    new IntegerField('disponible_web'),
                    new StringField('local'),
                    new IntegerField('id'),
                    new IntegerField('id_pers_new'),
                    new IntegerField('id_inf', false, false, true)
                )
            );
            $this->dataset->AddLookupField('id_loc', 'administratifs.locals', new IntegerField('id_loc'), new StringField('no_loc', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('id_pers_new', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA2', 'LT2'), 'LT2');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'id_mat_inf', 'id_mat_inf', 'Id Mat Inf'),
                new FilterColumn($this->dataset, 'id_loc', 'LA1', 'Id Loc'),
                new FilterColumn($this->dataset, 'no_uqam', 'no_uqam', 'No Uqam'),
                new FilterColumn($this->dataset, 'syst_expl', 'syst_expl', 'Syst Expl'),
                new FilterColumn($this->dataset, 'marque', 'marque', 'Marque'),
                new FilterColumn($this->dataset, 'description', 'description', 'Description'),
                new FilterColumn($this->dataset, 'id_grp', 'id_grp', 'Id Grp'),
                new FilterColumn($this->dataset, 'fournisseur', 'fournisseur', 'Fournisseur'),
                new FilterColumn($this->dataset, 'no_serie', 'no_serie', 'No Serie'),
                new FilterColumn($this->dataset, 'duree_vie', 'duree_vie', 'Duree Vie'),
                new FilterColumn($this->dataset, 'etat', 'etat', 'Etat'),
                new FilterColumn($this->dataset, 'no_requis', 'no_requis', 'No Requis'),
                new FilterColumn($this->dataset, 'no_comman', 'no_comman', 'No Comman'),
                new FilterColumn($this->dataset, 'prix', 'prix', 'Prix'),
                new FilterColumn($this->dataset, 'date_achat', 'date_achat', 'Date Achat'),
                new FilterColumn($this->dataset, 'date_recept', 'date_recept', 'Date Recept'),
                new FilterColumn($this->dataset, 'date_fin_d', 'date_fin_d', 'Date Fin D'),
                new FilterColumn($this->dataset, 'code_compt', 'code_compt', 'Code Compt'),
                new FilterColumn($this->dataset, 'commentaires', 'commentaires', 'Commentaires'),
                new FilterColumn($this->dataset, 'adresse_ip', 'adresse_ip', 'Adresse Ip'),
                new FilterColumn($this->dataset, 'id_adresse_ip', 'id_adresse_ip', 'Id Adresse Ip'),
                new FilterColumn($this->dataset, 'id_pers', 'id_pers', 'Id Pers'),
                new FilterColumn($this->dataset, 'disponible', 'disponible', 'Disponible'),
                new FilterColumn($this->dataset, 'disponible_web', 'disponible_web', 'Disponible Web'),
                new FilterColumn($this->dataset, 'local', 'local', 'Local'),
                new FilterColumn($this->dataset, 'id', 'id', 'Id'),
                new FilterColumn($this->dataset, 'id_pers_new', 'LA2', 'Id Pers New'),
                new FilterColumn($this->dataset, 'id_inf', 'id_inf', 'Id Inf')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['id_mat_inf'])
                ->addColumn($columns['id_loc'])
                ->addColumn($columns['no_uqam'])
                ->addColumn($columns['syst_expl'])
                ->addColumn($columns['marque'])
                ->addColumn($columns['description'])
                ->addColumn($columns['id_grp'])
                ->addColumn($columns['fournisseur'])
                ->addColumn($columns['no_serie'])
                ->addColumn($columns['duree_vie'])
                ->addColumn($columns['etat'])
                ->addColumn($columns['no_requis'])
                ->addColumn($columns['no_comman'])
                ->addColumn($columns['prix'])
                ->addColumn($columns['date_achat'])
                ->addColumn($columns['date_recept'])
                ->addColumn($columns['date_fin_d'])
                ->addColumn($columns['code_compt'])
                ->addColumn($columns['commentaires'])
                ->addColumn($columns['adresse_ip'])
                ->addColumn($columns['id_adresse_ip'])
                ->addColumn($columns['id_pers'])
                ->addColumn($columns['disponible'])
                ->addColumn($columns['disponible_web'])
                ->addColumn($columns['local'])
                ->addColumn($columns['id'])
                ->addColumn($columns['id_pers_new'])
                ->addColumn($columns['id_inf']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_loc')
                ->setOptionsFor('id_pers_new');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('id_mat_inf_edit');
            
            $filterBuilder->addColumn(
                $columns['id_mat_inf'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_locals_materiel_mat_informatique_id_loc_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_loc', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_locals_materiel_mat_informatique_id_loc_search');
            
            $text_editor = new TextEdit('id_loc');
            
            $filterBuilder->addColumn(
                $columns['id_loc'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_uqam');
            
            $filterBuilder->addColumn(
                $columns['no_uqam'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('syst_expl_edit');
            $main_editor->SetMaxLength(40);
            
            $filterBuilder->addColumn(
                $columns['syst_expl'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('marque_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['marque'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('description_edit');
            $main_editor->SetMaxLength(90);
            
            $filterBuilder->addColumn(
                $columns['description'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_grp_edit');
            
            $filterBuilder->addColumn(
                $columns['id_grp'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('fournisseur_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['fournisseur'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_serie_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['no_serie'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('duree_vie_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['duree_vie'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('etat_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['etat'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_requis_edit');
            
            $filterBuilder->addColumn(
                $columns['no_requis'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_comman_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['no_comman'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('prix');
            
            $filterBuilder->addColumn(
                $columns['prix'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('date_achat');
            
            $filterBuilder->addColumn(
                $columns['date_achat'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('date_recept');
            
            $filterBuilder->addColumn(
                $columns['date_recept'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('date_fin_d_edit');
            $main_editor->SetMaxLength(40);
            
            $filterBuilder->addColumn(
                $columns['date_fin_d'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('code_compt_edit');
            
            $filterBuilder->addColumn(
                $columns['code_compt'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('commentaires_edit');
            $main_editor->SetMaxLength(70);
            
            $filterBuilder->addColumn(
                $columns['commentaires'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('adresse_ip_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['adresse_ip'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_adresse_ip_edit');
            
            $filterBuilder->addColumn(
                $columns['id_adresse_ip'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_pers_edit');
            
            $filterBuilder->addColumn(
                $columns['id_pers'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('disponible');
            
            $filterBuilder->addColumn(
                $columns['disponible'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('disponible_web_edit');
            
            $filterBuilder->addColumn(
                $columns['disponible_web'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('local_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['local'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_edit');
            
            $filterBuilder->addColumn(
                $columns['id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_pers_new_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_locals_materiel_mat_informatique_id_pers_new_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_pers_new', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_locals_materiel_mat_informatique_id_pers_new_search');
            
            $text_editor = new TextEdit('id_pers_new');
            
            $filterBuilder->addColumn(
                $columns['id_pers_new'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_inf_edit');
            
            $filterBuilder->addColumn(
                $columns['id_inf'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for id_mat_inf field
            //
            $column = new NumberViewColumn('id_mat_inf', 'id_mat_inf', 'Id Mat Inf', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_uqam field
            //
            $column = new TextViewColumn('no_uqam', 'no_uqam', 'No Uqam', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for syst_expl field
            //
            $column = new TextViewColumn('syst_expl', 'syst_expl', 'Syst Expl', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for marque field
            //
            $column = new TextViewColumn('marque', 'marque', 'Marque', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_grp field
            //
            $column = new NumberViewColumn('id_grp', 'id_grp', 'Id Grp', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for fournisseur field
            //
            $column = new TextViewColumn('fournisseur', 'fournisseur', 'Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for duree_vie field
            //
            $column = new TextViewColumn('duree_vie', 'duree_vie', 'Duree Vie', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for etat field
            //
            $column = new TextViewColumn('etat', 'etat', 'Etat', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_requis field
            //
            $column = new NumberViewColumn('no_requis', 'no_requis', 'No Requis', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_comman field
            //
            $column = new TextViewColumn('no_comman', 'no_comman', 'No Comman', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for prix field
            //
            $column = new TextViewColumn('prix', 'prix', 'Prix', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_recept field
            //
            $column = new TextViewColumn('date_recept', 'date_recept', 'Date Recept', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_fin_d field
            //
            $column = new TextViewColumn('date_fin_d', 'date_fin_d', 'Date Fin D', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for code_compt field
            //
            $column = new NumberViewColumn('code_compt', 'code_compt', 'Code Compt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for adresse_ip field
            //
            $column = new TextViewColumn('adresse_ip', 'adresse_ip', 'Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_adresse_ip field
            //
            $column = new NumberViewColumn('id_adresse_ip', 'id_adresse_ip', 'Id Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for disponible field
            //
            $column = new TextViewColumn('disponible', 'disponible', 'Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for disponible_web field
            //
            $column = new NumberViewColumn('disponible_web', 'disponible_web', 'Disponible Web', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for local field
            //
            $column = new TextViewColumn('local', 'local', 'Local', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers_new', 'LA2', 'Id Pers New', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_inf field
            //
            $column = new NumberViewColumn('id_inf', 'id_inf', 'Id Inf', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for id_mat_inf field
            //
            $column = new NumberViewColumn('id_mat_inf', 'id_mat_inf', 'Id Mat Inf', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_uqam field
            //
            $column = new TextViewColumn('no_uqam', 'no_uqam', 'No Uqam', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for syst_expl field
            //
            $column = new TextViewColumn('syst_expl', 'syst_expl', 'Syst Expl', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for marque field
            //
            $column = new TextViewColumn('marque', 'marque', 'Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_grp field
            //
            $column = new NumberViewColumn('id_grp', 'id_grp', 'Id Grp', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for fournisseur field
            //
            $column = new TextViewColumn('fournisseur', 'fournisseur', 'Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for duree_vie field
            //
            $column = new TextViewColumn('duree_vie', 'duree_vie', 'Duree Vie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for etat field
            //
            $column = new TextViewColumn('etat', 'etat', 'Etat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_requis field
            //
            $column = new NumberViewColumn('no_requis', 'no_requis', 'No Requis', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_comman field
            //
            $column = new TextViewColumn('no_comman', 'no_comman', 'No Comman', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for prix field
            //
            $column = new TextViewColumn('prix', 'prix', 'Prix', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_recept field
            //
            $column = new TextViewColumn('date_recept', 'date_recept', 'Date Recept', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_fin_d field
            //
            $column = new TextViewColumn('date_fin_d', 'date_fin_d', 'Date Fin D', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for code_compt field
            //
            $column = new NumberViewColumn('code_compt', 'code_compt', 'Code Compt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for adresse_ip field
            //
            $column = new TextViewColumn('adresse_ip', 'adresse_ip', 'Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_adresse_ip field
            //
            $column = new NumberViewColumn('id_adresse_ip', 'id_adresse_ip', 'Id Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for disponible field
            //
            $column = new TextViewColumn('disponible', 'disponible', 'Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for disponible_web field
            //
            $column = new NumberViewColumn('disponible_web', 'disponible_web', 'Disponible Web', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for local field
            //
            $column = new TextViewColumn('local', 'local', 'Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers_new', 'LA2', 'Id Pers New', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_inf field
            //
            $column = new NumberViewColumn('id_inf', 'id_inf', 'Id Inf', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for id_mat_inf field
            //
            $editor = new TextEdit('id_mat_inf_edit');
            $editColumn = new CustomEditColumn('Id Mat Inf', 'id_mat_inf', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'edit_administratifs_locals_materiel_mat_informatique_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_uqam field
            //
            $editor = new TextAreaEdit('no_uqam_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Uqam', 'no_uqam', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for syst_expl field
            //
            $editor = new TextEdit('syst_expl_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Syst Expl', 'syst_expl', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for marque field
            //
            $editor = new TextEdit('marque_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Marque', 'marque', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for description field
            //
            $editor = new TextEdit('description_edit');
            $editor->SetMaxLength(90);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_grp field
            //
            $editor = new TextEdit('id_grp_edit');
            $editColumn = new CustomEditColumn('Id Grp', 'id_grp', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for fournisseur field
            //
            $editor = new TextEdit('fournisseur_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Fournisseur', 'fournisseur', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_serie field
            //
            $editor = new TextEdit('no_serie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Serie', 'no_serie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for duree_vie field
            //
            $editor = new TextEdit('duree_vie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Duree Vie', 'duree_vie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for etat field
            //
            $editor = new TextEdit('etat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Etat', 'etat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_requis field
            //
            $editor = new TextEdit('no_requis_edit');
            $editColumn = new CustomEditColumn('No Requis', 'no_requis', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_comman field
            //
            $editor = new TextEdit('no_comman_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Comman', 'no_comman', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for prix field
            //
            $editor = new TextAreaEdit('prix_edit', 50, 8);
            $editColumn = new CustomEditColumn('Prix', 'prix', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_achat field
            //
            $editor = new TextAreaEdit('date_achat_edit', 50, 8);
            $editColumn = new CustomEditColumn('Date Achat', 'date_achat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_recept field
            //
            $editor = new TextAreaEdit('date_recept_edit', 50, 8);
            $editColumn = new CustomEditColumn('Date Recept', 'date_recept', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_fin_d field
            //
            $editor = new TextEdit('date_fin_d_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Date Fin D', 'date_fin_d', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for code_compt field
            //
            $editor = new TextEdit('code_compt_edit');
            $editColumn = new CustomEditColumn('Code Compt', 'code_compt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextEdit('commentaires_edit');
            $editor->SetMaxLength(70);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for adresse_ip field
            //
            $editor = new TextEdit('adresse_ip_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Adresse Ip', 'adresse_ip', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_adresse_ip field
            //
            $editor = new TextEdit('id_adresse_ip_edit');
            $editColumn = new CustomEditColumn('Id Adresse Ip', 'id_adresse_ip', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_pers field
            //
            $editor = new TextEdit('id_pers_edit');
            $editColumn = new CustomEditColumn('Id Pers', 'id_pers', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for disponible field
            //
            $editor = new TextAreaEdit('disponible_edit', 50, 8);
            $editColumn = new CustomEditColumn('Disponible', 'disponible', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for disponible_web field
            //
            $editor = new TextEdit('disponible_web_edit');
            $editColumn = new CustomEditColumn('Disponible Web', 'disponible_web', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for local field
            //
            $editor = new TextEdit('local_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Local', 'local', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_pers_new field
            //
            $editor = new DynamicCombobox('id_pers_new_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Pers New', 'id_pers_new', 'LA2', 'edit_administratifs_locals_materiel_mat_informatique_id_pers_new_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_inf field
            //
            $editor = new TextEdit('id_inf_edit');
            $editColumn = new CustomEditColumn('Id Inf', 'id_inf', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'multi_edit_administratifs_locals_materiel_mat_informatique_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_uqam field
            //
            $editor = new TextAreaEdit('no_uqam_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Uqam', 'no_uqam', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for syst_expl field
            //
            $editor = new TextEdit('syst_expl_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Syst Expl', 'syst_expl', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for marque field
            //
            $editor = new TextEdit('marque_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Marque', 'marque', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for description field
            //
            $editor = new TextEdit('description_edit');
            $editor->SetMaxLength(90);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_grp field
            //
            $editor = new TextEdit('id_grp_edit');
            $editColumn = new CustomEditColumn('Id Grp', 'id_grp', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for fournisseur field
            //
            $editor = new TextEdit('fournisseur_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Fournisseur', 'fournisseur', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_serie field
            //
            $editor = new TextEdit('no_serie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Serie', 'no_serie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for duree_vie field
            //
            $editor = new TextEdit('duree_vie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Duree Vie', 'duree_vie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for etat field
            //
            $editor = new TextEdit('etat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Etat', 'etat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_requis field
            //
            $editor = new TextEdit('no_requis_edit');
            $editColumn = new CustomEditColumn('No Requis', 'no_requis', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_comman field
            //
            $editor = new TextEdit('no_comman_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Comman', 'no_comman', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for prix field
            //
            $editor = new TextAreaEdit('prix_edit', 50, 8);
            $editColumn = new CustomEditColumn('Prix', 'prix', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_achat field
            //
            $editor = new TextAreaEdit('date_achat_edit', 50, 8);
            $editColumn = new CustomEditColumn('Date Achat', 'date_achat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_recept field
            //
            $editor = new TextAreaEdit('date_recept_edit', 50, 8);
            $editColumn = new CustomEditColumn('Date Recept', 'date_recept', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_fin_d field
            //
            $editor = new TextEdit('date_fin_d_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Date Fin D', 'date_fin_d', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for code_compt field
            //
            $editor = new TextEdit('code_compt_edit');
            $editColumn = new CustomEditColumn('Code Compt', 'code_compt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextEdit('commentaires_edit');
            $editor->SetMaxLength(70);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for adresse_ip field
            //
            $editor = new TextEdit('adresse_ip_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Adresse Ip', 'adresse_ip', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_adresse_ip field
            //
            $editor = new TextEdit('id_adresse_ip_edit');
            $editColumn = new CustomEditColumn('Id Adresse Ip', 'id_adresse_ip', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_pers field
            //
            $editor = new TextEdit('id_pers_edit');
            $editColumn = new CustomEditColumn('Id Pers', 'id_pers', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for disponible field
            //
            $editor = new TextAreaEdit('disponible_edit', 50, 8);
            $editColumn = new CustomEditColumn('Disponible', 'disponible', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for disponible_web field
            //
            $editor = new TextEdit('disponible_web_edit');
            $editColumn = new CustomEditColumn('Disponible Web', 'disponible_web', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for local field
            //
            $editor = new TextEdit('local_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Local', 'local', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_pers_new field
            //
            $editor = new DynamicCombobox('id_pers_new_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Pers New', 'id_pers_new', 'LA2', 'multi_edit_administratifs_locals_materiel_mat_informatique_id_pers_new_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_inf field
            //
            $editor = new TextEdit('id_inf_edit');
            $editColumn = new CustomEditColumn('Id Inf', 'id_inf', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for id_mat_inf field
            //
            $editor = new TextEdit('id_mat_inf_edit');
            $editColumn = new CustomEditColumn('Id Mat Inf', 'id_mat_inf', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'insert_administratifs_locals_materiel_mat_informatique_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_uqam field
            //
            $editor = new TextAreaEdit('no_uqam_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Uqam', 'no_uqam', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for syst_expl field
            //
            $editor = new TextEdit('syst_expl_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Syst Expl', 'syst_expl', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for marque field
            //
            $editor = new TextEdit('marque_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Marque', 'marque', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for description field
            //
            $editor = new TextEdit('description_edit');
            $editor->SetMaxLength(90);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_grp field
            //
            $editor = new TextEdit('id_grp_edit');
            $editColumn = new CustomEditColumn('Id Grp', 'id_grp', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for fournisseur field
            //
            $editor = new TextEdit('fournisseur_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Fournisseur', 'fournisseur', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_serie field
            //
            $editor = new TextEdit('no_serie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Serie', 'no_serie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for duree_vie field
            //
            $editor = new TextEdit('duree_vie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Duree Vie', 'duree_vie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for etat field
            //
            $editor = new TextEdit('etat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Etat', 'etat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_requis field
            //
            $editor = new TextEdit('no_requis_edit');
            $editColumn = new CustomEditColumn('No Requis', 'no_requis', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_comman field
            //
            $editor = new TextEdit('no_comman_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Comman', 'no_comman', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for prix field
            //
            $editor = new TextAreaEdit('prix_edit', 50, 8);
            $editColumn = new CustomEditColumn('Prix', 'prix', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_achat field
            //
            $editor = new TextAreaEdit('date_achat_edit', 50, 8);
            $editColumn = new CustomEditColumn('Date Achat', 'date_achat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_recept field
            //
            $editor = new TextAreaEdit('date_recept_edit', 50, 8);
            $editColumn = new CustomEditColumn('Date Recept', 'date_recept', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_fin_d field
            //
            $editor = new TextEdit('date_fin_d_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Date Fin D', 'date_fin_d', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for code_compt field
            //
            $editor = new TextEdit('code_compt_edit');
            $editColumn = new CustomEditColumn('Code Compt', 'code_compt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextEdit('commentaires_edit');
            $editor->SetMaxLength(70);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for adresse_ip field
            //
            $editor = new TextEdit('adresse_ip_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Adresse Ip', 'adresse_ip', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_adresse_ip field
            //
            $editor = new TextEdit('id_adresse_ip_edit');
            $editColumn = new CustomEditColumn('Id Adresse Ip', 'id_adresse_ip', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_pers field
            //
            $editor = new TextEdit('id_pers_edit');
            $editColumn = new CustomEditColumn('Id Pers', 'id_pers', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for disponible field
            //
            $editor = new TextAreaEdit('disponible_edit', 50, 8);
            $editColumn = new CustomEditColumn('Disponible', 'disponible', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for disponible_web field
            //
            $editor = new TextEdit('disponible_web_edit');
            $editColumn = new CustomEditColumn('Disponible Web', 'disponible_web', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for local field
            //
            $editor = new TextEdit('local_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Local', 'local', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_pers_new field
            //
            $editor = new DynamicCombobox('id_pers_new_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Pers New', 'id_pers_new', 'LA2', 'insert_administratifs_locals_materiel_mat_informatique_id_pers_new_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_inf field
            //
            $editor = new TextEdit('id_inf_edit');
            $editColumn = new CustomEditColumn('Id Inf', 'id_inf', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for id_mat_inf field
            //
            $column = new NumberViewColumn('id_mat_inf', 'id_mat_inf', 'Id Mat Inf', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_uqam field
            //
            $column = new TextViewColumn('no_uqam', 'no_uqam', 'No Uqam', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for syst_expl field
            //
            $column = new TextViewColumn('syst_expl', 'syst_expl', 'Syst Expl', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for marque field
            //
            $column = new TextViewColumn('marque', 'marque', 'Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_grp field
            //
            $column = new NumberViewColumn('id_grp', 'id_grp', 'Id Grp', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for fournisseur field
            //
            $column = new TextViewColumn('fournisseur', 'fournisseur', 'Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for duree_vie field
            //
            $column = new TextViewColumn('duree_vie', 'duree_vie', 'Duree Vie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for etat field
            //
            $column = new TextViewColumn('etat', 'etat', 'Etat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_requis field
            //
            $column = new NumberViewColumn('no_requis', 'no_requis', 'No Requis', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_comman field
            //
            $column = new TextViewColumn('no_comman', 'no_comman', 'No Comman', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for prix field
            //
            $column = new TextViewColumn('prix', 'prix', 'Prix', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_recept field
            //
            $column = new TextViewColumn('date_recept', 'date_recept', 'Date Recept', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_fin_d field
            //
            $column = new TextViewColumn('date_fin_d', 'date_fin_d', 'Date Fin D', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for code_compt field
            //
            $column = new NumberViewColumn('code_compt', 'code_compt', 'Code Compt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for adresse_ip field
            //
            $column = new TextViewColumn('adresse_ip', 'adresse_ip', 'Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_adresse_ip field
            //
            $column = new NumberViewColumn('id_adresse_ip', 'id_adresse_ip', 'Id Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for disponible field
            //
            $column = new TextViewColumn('disponible', 'disponible', 'Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for disponible_web field
            //
            $column = new NumberViewColumn('disponible_web', 'disponible_web', 'Disponible Web', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for local field
            //
            $column = new TextViewColumn('local', 'local', 'Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers_new', 'LA2', 'Id Pers New', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_inf field
            //
            $column = new NumberViewColumn('id_inf', 'id_inf', 'Id Inf', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for id_mat_inf field
            //
            $column = new NumberViewColumn('id_mat_inf', 'id_mat_inf', 'Id Mat Inf', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_uqam field
            //
            $column = new TextViewColumn('no_uqam', 'no_uqam', 'No Uqam', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for syst_expl field
            //
            $column = new TextViewColumn('syst_expl', 'syst_expl', 'Syst Expl', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for marque field
            //
            $column = new TextViewColumn('marque', 'marque', 'Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_grp field
            //
            $column = new NumberViewColumn('id_grp', 'id_grp', 'Id Grp', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for fournisseur field
            //
            $column = new TextViewColumn('fournisseur', 'fournisseur', 'Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for duree_vie field
            //
            $column = new TextViewColumn('duree_vie', 'duree_vie', 'Duree Vie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for etat field
            //
            $column = new TextViewColumn('etat', 'etat', 'Etat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_requis field
            //
            $column = new NumberViewColumn('no_requis', 'no_requis', 'No Requis', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for no_comman field
            //
            $column = new TextViewColumn('no_comman', 'no_comman', 'No Comman', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for prix field
            //
            $column = new TextViewColumn('prix', 'prix', 'Prix', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_recept field
            //
            $column = new TextViewColumn('date_recept', 'date_recept', 'Date Recept', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_fin_d field
            //
            $column = new TextViewColumn('date_fin_d', 'date_fin_d', 'Date Fin D', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for code_compt field
            //
            $column = new NumberViewColumn('code_compt', 'code_compt', 'Code Compt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for adresse_ip field
            //
            $column = new TextViewColumn('adresse_ip', 'adresse_ip', 'Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_adresse_ip field
            //
            $column = new NumberViewColumn('id_adresse_ip', 'id_adresse_ip', 'Id Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for disponible field
            //
            $column = new TextViewColumn('disponible', 'disponible', 'Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for disponible_web field
            //
            $column = new NumberViewColumn('disponible_web', 'disponible_web', 'Disponible Web', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for local field
            //
            $column = new TextViewColumn('local', 'local', 'Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers_new', 'LA2', 'Id Pers New', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_inf field
            //
            $column = new NumberViewColumn('id_inf', 'id_inf', 'Id Inf', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for id_mat_inf field
            //
            $column = new NumberViewColumn('id_mat_inf', 'id_mat_inf', 'Id Mat Inf', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_uqam field
            //
            $column = new TextViewColumn('no_uqam', 'no_uqam', 'No Uqam', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for syst_expl field
            //
            $column = new TextViewColumn('syst_expl', 'syst_expl', 'Syst Expl', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for marque field
            //
            $column = new TextViewColumn('marque', 'marque', 'Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_grp field
            //
            $column = new NumberViewColumn('id_grp', 'id_grp', 'Id Grp', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for fournisseur field
            //
            $column = new TextViewColumn('fournisseur', 'fournisseur', 'Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for duree_vie field
            //
            $column = new TextViewColumn('duree_vie', 'duree_vie', 'Duree Vie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for etat field
            //
            $column = new TextViewColumn('etat', 'etat', 'Etat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_requis field
            //
            $column = new NumberViewColumn('no_requis', 'no_requis', 'No Requis', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_comman field
            //
            $column = new TextViewColumn('no_comman', 'no_comman', 'No Comman', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for prix field
            //
            $column = new TextViewColumn('prix', 'prix', 'Prix', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_recept field
            //
            $column = new TextViewColumn('date_recept', 'date_recept', 'Date Recept', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_fin_d field
            //
            $column = new TextViewColumn('date_fin_d', 'date_fin_d', 'Date Fin D', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for code_compt field
            //
            $column = new NumberViewColumn('code_compt', 'code_compt', 'Code Compt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for adresse_ip field
            //
            $column = new TextViewColumn('adresse_ip', 'adresse_ip', 'Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_adresse_ip field
            //
            $column = new NumberViewColumn('id_adresse_ip', 'id_adresse_ip', 'Id Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for disponible field
            //
            $column = new TextViewColumn('disponible', 'disponible', 'Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for disponible_web field
            //
            $column = new NumberViewColumn('disponible_web', 'disponible_web', 'Disponible Web', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for local field
            //
            $column = new TextViewColumn('local', 'local', 'Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers_new', 'LA2', 'Id Pers New', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_inf field
            //
            $column = new NumberViewColumn('id_inf', 'id_inf', 'Id Inf', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(true);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_locals_materiel_mat_informatique_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_locals_materiel_mat_informatique_id_pers_new_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_locals_materiel_mat_informatique_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_locals_materiel_mat_informatique_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_locals_materiel_mat_informatique_id_pers_new_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_locals_materiel_mat_informatique_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_locals_materiel_mat_informatique_id_pers_new_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_locals_materiel_mat_informatique_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_locals_materiel_mat_informatique_id_pers_new_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }
    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class administratifs_locals_materiel_mat_sciPage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Mat Sci');
            $this->SetMenuLabel('Mat Sci');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_sci"');
            $this->dataset->addFields(
                array(
                    new IntegerField('id_mat_sci', true, true, true),
                    new StringField('no_identif', true),
                    new StringField('transaction', true),
                    new StringField('nom_l_e'),
                    new IntegerField('id_equipement'),
                    new StringField('marque'),
                    new StringField('manufacture', true),
                    new StringField('modele'),
                    new StringField('fournisseur'),
                    new StringField('id_fournisseur', true),
                    new StringField('no_serie'),
                    new StringField('caracteristique'),
                    new StringField('utilisation'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new StringField('fonction'),
                    new StringField('utilisateur'),
                    new StringField('cours'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new IntegerField('quantite'),
                    new IntegerField('prix_unitaire'),
                    new IntegerField('cout_total'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d', true),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_charge'),
                    new IntegerField('disponible'),
                    new StringField('disponible_web'),
                    new StringField('documents_facture'),
                    new StringField('document_bon_commande'),
                    new StringField('document_manuel_utilisation'),
                    new StringField('autres_documents'),
                    new IntegerField('id_marque'),
                    new IntegerField('id_manufacturier'),
                    new IntegerField('id_modele'),
                    new IntegerField('id_groupe'),
                    new IntegerField('id_pers')
                )
            );
            $this->dataset->AddLookupField('id_loc', 'administratifs.locals', new IntegerField('id_loc'), new StringField('no_loc', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('id_charge', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA2', 'LT2'), 'LT2');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'id_mat_sci', 'id_mat_sci', 'Id Mat Sci'),
                new FilterColumn($this->dataset, 'no_identif', 'no_identif', 'No Identif'),
                new FilterColumn($this->dataset, 'transaction', 'transaction', 'Transaction'),
                new FilterColumn($this->dataset, 'nom_l_e', 'nom_l_e', 'Nom L E'),
                new FilterColumn($this->dataset, 'id_equipement', 'id_equipement', 'Id Equipement'),
                new FilterColumn($this->dataset, 'marque', 'marque', 'Marque'),
                new FilterColumn($this->dataset, 'id_marque', 'id_marque', 'Id Marque'),
                new FilterColumn($this->dataset, 'manufacture', 'manufacture', 'Manufacture'),
                new FilterColumn($this->dataset, 'id_manufacturier', 'id_manufacturier', 'Id Manufacturier'),
                new FilterColumn($this->dataset, 'modele', 'modele', 'Modele'),
                new FilterColumn($this->dataset, 'id_modele', 'id_modele', 'Id Modele'),
                new FilterColumn($this->dataset, 'fournisseur', 'fournisseur', 'Fournisseur'),
                new FilterColumn($this->dataset, 'id_fournisseur', 'id_fournisseur', 'Id Fournisseur'),
                new FilterColumn($this->dataset, 'no_serie', 'no_serie', 'No Serie'),
                new FilterColumn($this->dataset, 'caracteristique', 'caracteristique', 'Caracteristique'),
                new FilterColumn($this->dataset, 'utilisation', 'utilisation', 'Utilisation'),
                new FilterColumn($this->dataset, 'duree_vie', 'duree_vie', 'Duree Vie'),
                new FilterColumn($this->dataset, 'etat', 'etat', 'Etat'),
                new FilterColumn($this->dataset, 'fonction', 'fonction', 'Fonction'),
                new FilterColumn($this->dataset, 'utilisateur', 'utilisateur', 'Utilisateur'),
                new FilterColumn($this->dataset, 'cours', 'cours', 'Cours'),
                new FilterColumn($this->dataset, 'no_requis', 'no_requis', 'No Requis'),
                new FilterColumn($this->dataset, 'no_comman', 'no_comman', 'No Comman'),
                new FilterColumn($this->dataset, 'quantite', 'quantite', 'Quantite'),
                new FilterColumn($this->dataset, 'prix_unitaire', 'prix_unitaire', 'Prix Unitaire'),
                new FilterColumn($this->dataset, 'cout_total', 'cout_total', 'Cout Total'),
                new FilterColumn($this->dataset, 'date_achat', 'date_achat', 'Date Achat'),
                new FilterColumn($this->dataset, 'date_recept', 'date_recept', 'Date Recept'),
                new FilterColumn($this->dataset, 'date_fin_d', 'date_fin_d', 'Date Fin D'),
                new FilterColumn($this->dataset, 'code_compt', 'code_compt', 'Code Compt'),
                new FilterColumn($this->dataset, 'commentaires', 'commentaires', 'Commentaires'),
                new FilterColumn($this->dataset, 'id_groupe', 'id_groupe', 'Id Groupe'),
                new FilterColumn($this->dataset, 'id_pers', 'id_pers', 'Id Pers'),
                new FilterColumn($this->dataset, 'id_loc', 'LA1', 'Id Loc'),
                new FilterColumn($this->dataset, 'id_charge', 'LA2', 'Id Charge'),
                new FilterColumn($this->dataset, 'disponible', 'disponible', 'Disponible'),
                new FilterColumn($this->dataset, 'disponible_web', 'disponible_web', 'Disponible Web'),
                new FilterColumn($this->dataset, 'documents_facture', 'documents_facture', 'Documents Facture'),
                new FilterColumn($this->dataset, 'document_bon_commande', 'document_bon_commande', 'Document Bon Commande'),
                new FilterColumn($this->dataset, 'document_manuel_utilisation', 'document_manuel_utilisation', 'Document Manuel Utilisation'),
                new FilterColumn($this->dataset, 'autres_documents', 'autres_documents', 'Autres Documents')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['id_mat_sci'])
                ->addColumn($columns['no_identif'])
                ->addColumn($columns['transaction'])
                ->addColumn($columns['nom_l_e'])
                ->addColumn($columns['id_equipement'])
                ->addColumn($columns['marque'])
                ->addColumn($columns['id_marque'])
                ->addColumn($columns['manufacture'])
                ->addColumn($columns['id_manufacturier'])
                ->addColumn($columns['modele'])
                ->addColumn($columns['id_modele'])
                ->addColumn($columns['fournisseur'])
                ->addColumn($columns['id_fournisseur'])
                ->addColumn($columns['no_serie'])
                ->addColumn($columns['caracteristique'])
                ->addColumn($columns['utilisation'])
                ->addColumn($columns['duree_vie'])
                ->addColumn($columns['etat'])
                ->addColumn($columns['fonction'])
                ->addColumn($columns['utilisateur'])
                ->addColumn($columns['cours'])
                ->addColumn($columns['no_requis'])
                ->addColumn($columns['no_comman'])
                ->addColumn($columns['quantite'])
                ->addColumn($columns['prix_unitaire'])
                ->addColumn($columns['cout_total'])
                ->addColumn($columns['date_achat'])
                ->addColumn($columns['date_recept'])
                ->addColumn($columns['date_fin_d'])
                ->addColumn($columns['code_compt'])
                ->addColumn($columns['commentaires'])
                ->addColumn($columns['id_groupe'])
                ->addColumn($columns['id_pers'])
                ->addColumn($columns['id_loc'])
                ->addColumn($columns['id_charge'])
                ->addColumn($columns['disponible'])
                ->addColumn($columns['disponible_web'])
                ->addColumn($columns['documents_facture'])
                ->addColumn($columns['document_bon_commande'])
                ->addColumn($columns['document_manuel_utilisation'])
                ->addColumn($columns['autres_documents']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_loc')
                ->setOptionsFor('id_charge');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('id_mat_sci_edit');
            
            $filterBuilder->addColumn(
                $columns['id_mat_sci'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_identif_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['no_identif'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('transaction_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['transaction'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('nom_l_e_edit');
            $main_editor->SetMaxLength(80);
            
            $filterBuilder->addColumn(
                $columns['nom_l_e'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_equipement_edit');
            
            $filterBuilder->addColumn(
                $columns['id_equipement'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('marque_edit');
            $main_editor->SetMaxLength(30);
            
            $filterBuilder->addColumn(
                $columns['marque'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_marque_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['id_marque'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('manufacture_edit');
            $main_editor->SetMaxLength(40);
            
            $filterBuilder->addColumn(
                $columns['manufacture'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_manufacturier_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['id_manufacturier'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('modele_edit');
            $main_editor->SetMaxLength(30);
            
            $filterBuilder->addColumn(
                $columns['modele'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_modele_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['id_modele'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('fournisseur_edit');
            $main_editor->SetMaxLength(40);
            
            $filterBuilder->addColumn(
                $columns['fournisseur'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_fournisseur_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['id_fournisseur'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_serie_edit');
            $main_editor->SetMaxLength(30);
            
            $filterBuilder->addColumn(
                $columns['no_serie'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('caracteristique_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['caracteristique'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('utilisation_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['utilisation'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('duree_vie_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['duree_vie'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('etat_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['etat'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('fonction_edit');
            $main_editor->SetMaxLength(40);
            
            $filterBuilder->addColumn(
                $columns['fonction'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('utilisateur_edit');
            $main_editor->SetMaxLength(60);
            
            $filterBuilder->addColumn(
                $columns['utilisateur'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('cours_edit');
            $main_editor->SetMaxLength(40);
            
            $filterBuilder->addColumn(
                $columns['cours'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_requis_edit');
            
            $filterBuilder->addColumn(
                $columns['no_requis'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_comman_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['no_comman'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('quantite_edit');
            
            $filterBuilder->addColumn(
                $columns['quantite'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('prix_unitaire_edit');
            
            $filterBuilder->addColumn(
                $columns['prix_unitaire'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('cout_total_edit');
            
            $filterBuilder->addColumn(
                $columns['cout_total'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('date_achat_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['date_achat'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('date_recept_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['date_recept'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('date_fin_d_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['date_fin_d'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('code_compt_edit');
            
            $filterBuilder->addColumn(
                $columns['code_compt'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('commentaires');
            
            $filterBuilder->addColumn(
                $columns['commentaires'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_groupe_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['id_groupe'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_pers_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['id_pers'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_locals_materiel_mat_sci_id_loc_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_loc', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_locals_materiel_mat_sci_id_loc_search');
            
            $text_editor = new TextEdit('id_loc');
            
            $filterBuilder->addColumn(
                $columns['id_loc'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_charge_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_locals_materiel_mat_sci_id_charge_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_charge', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_locals_materiel_mat_sci_id_charge_search');
            
            $text_editor = new TextEdit('id_charge');
            
            $filterBuilder->addColumn(
                $columns['id_charge'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('disponible_edit');
            
            $filterBuilder->addColumn(
                $columns['disponible'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('disponible_web_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['disponible_web'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('documents_facture_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['documents_facture'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('document_bon_commande_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['document_bon_commande'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('document_manuel_utilisation_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['document_manuel_utilisation'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('autres_documents_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['autres_documents'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for id_mat_sci field
            //
            $column = new NumberViewColumn('id_mat_sci', 'id_mat_sci', 'Id Mat Sci', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_identif field
            //
            $column = new TextViewColumn('no_identif', 'no_identif', 'No Identif', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for transaction field
            //
            $column = new TextViewColumn('transaction', 'transaction', 'Transaction', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom_l_e field
            //
            $column = new TextViewColumn('nom_l_e', 'nom_l_e', 'Nom L E', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_equipement field
            //
            $column = new NumberViewColumn('id_equipement', 'id_equipement', 'Id Equipement', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for marque field
            //
            $column = new TextViewColumn('marque', 'marque', 'Marque', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_marque field
            //
            $column = new TextViewColumn('id_marque', 'id_marque', 'Id Marque', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for manufacture field
            //
            $column = new TextViewColumn('manufacture', 'manufacture', 'Manufacture', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_manufacturier field
            //
            $column = new TextViewColumn('id_manufacturier', 'id_manufacturier', 'Id Manufacturier', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for modele field
            //
            $column = new TextViewColumn('modele', 'modele', 'Modele', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_modele field
            //
            $column = new TextViewColumn('id_modele', 'id_modele', 'Id Modele', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for fournisseur field
            //
            $column = new TextViewColumn('fournisseur', 'fournisseur', 'Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_fournisseur field
            //
            $column = new TextViewColumn('id_fournisseur', 'id_fournisseur', 'Id Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for caracteristique field
            //
            $column = new TextViewColumn('caracteristique', 'caracteristique', 'Caracteristique', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for utilisation field
            //
            $column = new TextViewColumn('utilisation', 'utilisation', 'Utilisation', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for duree_vie field
            //
            $column = new TextViewColumn('duree_vie', 'duree_vie', 'Duree Vie', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for etat field
            //
            $column = new TextViewColumn('etat', 'etat', 'Etat', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for fonction field
            //
            $column = new TextViewColumn('fonction', 'fonction', 'Fonction', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for utilisateur field
            //
            $column = new TextViewColumn('utilisateur', 'utilisateur', 'Utilisateur', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for cours field
            //
            $column = new TextViewColumn('cours', 'cours', 'Cours', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_requis field
            //
            $column = new NumberViewColumn('no_requis', 'no_requis', 'No Requis', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_comman field
            //
            $column = new TextViewColumn('no_comman', 'no_comman', 'No Comman', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for quantite field
            //
            $column = new NumberViewColumn('quantite', 'quantite', 'Quantite', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for prix_unitaire field
            //
            $column = new NumberViewColumn('prix_unitaire', 'prix_unitaire', 'Prix Unitaire', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for cout_total field
            //
            $column = new NumberViewColumn('cout_total', 'cout_total', 'Cout Total', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_recept field
            //
            $column = new TextViewColumn('date_recept', 'date_recept', 'Date Recept', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_fin_d field
            //
            $column = new TextViewColumn('date_fin_d', 'date_fin_d', 'Date Fin D', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for code_compt field
            //
            $column = new NumberViewColumn('code_compt', 'code_compt', 'Code Compt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'id_groupe', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_pers field
            //
            $column = new TextViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_charge', 'LA2', 'Id Charge', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for disponible field
            //
            $column = new NumberViewColumn('disponible', 'disponible', 'Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for disponible_web field
            //
            $column = new TextViewColumn('disponible_web', 'disponible_web', 'Disponible Web', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for documents_facture field
            //
            $column = new TextViewColumn('documents_facture', 'documents_facture', 'Documents Facture', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for document_bon_commande field
            //
            $column = new TextViewColumn('document_bon_commande', 'document_bon_commande', 'Document Bon Commande', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for document_manuel_utilisation field
            //
            $column = new TextViewColumn('document_manuel_utilisation', 'document_manuel_utilisation', 'Document Manuel Utilisation', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for autres_documents field
            //
            $column = new TextViewColumn('autres_documents', 'autres_documents', 'Autres Documents', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for id_mat_sci field
            //
            $column = new NumberViewColumn('id_mat_sci', 'id_mat_sci', 'Id Mat Sci', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_identif field
            //
            $column = new TextViewColumn('no_identif', 'no_identif', 'No Identif', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for transaction field
            //
            $column = new TextViewColumn('transaction', 'transaction', 'Transaction', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom_l_e field
            //
            $column = new TextViewColumn('nom_l_e', 'nom_l_e', 'Nom L E', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_equipement field
            //
            $column = new NumberViewColumn('id_equipement', 'id_equipement', 'Id Equipement', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for marque field
            //
            $column = new TextViewColumn('marque', 'marque', 'Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_marque field
            //
            $column = new TextViewColumn('id_marque', 'id_marque', 'Id Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for manufacture field
            //
            $column = new TextViewColumn('manufacture', 'manufacture', 'Manufacture', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_manufacturier field
            //
            $column = new TextViewColumn('id_manufacturier', 'id_manufacturier', 'Id Manufacturier', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for modele field
            //
            $column = new TextViewColumn('modele', 'modele', 'Modele', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_modele field
            //
            $column = new TextViewColumn('id_modele', 'id_modele', 'Id Modele', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for fournisseur field
            //
            $column = new TextViewColumn('fournisseur', 'fournisseur', 'Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_fournisseur field
            //
            $column = new TextViewColumn('id_fournisseur', 'id_fournisseur', 'Id Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for caracteristique field
            //
            $column = new TextViewColumn('caracteristique', 'caracteristique', 'Caracteristique', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for utilisation field
            //
            $column = new TextViewColumn('utilisation', 'utilisation', 'Utilisation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for duree_vie field
            //
            $column = new TextViewColumn('duree_vie', 'duree_vie', 'Duree Vie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for etat field
            //
            $column = new TextViewColumn('etat', 'etat', 'Etat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for fonction field
            //
            $column = new TextViewColumn('fonction', 'fonction', 'Fonction', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for utilisateur field
            //
            $column = new TextViewColumn('utilisateur', 'utilisateur', 'Utilisateur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for cours field
            //
            $column = new TextViewColumn('cours', 'cours', 'Cours', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_requis field
            //
            $column = new NumberViewColumn('no_requis', 'no_requis', 'No Requis', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_comman field
            //
            $column = new TextViewColumn('no_comman', 'no_comman', 'No Comman', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for quantite field
            //
            $column = new NumberViewColumn('quantite', 'quantite', 'Quantite', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for prix_unitaire field
            //
            $column = new NumberViewColumn('prix_unitaire', 'prix_unitaire', 'Prix Unitaire', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for cout_total field
            //
            $column = new NumberViewColumn('cout_total', 'cout_total', 'Cout Total', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_recept field
            //
            $column = new TextViewColumn('date_recept', 'date_recept', 'Date Recept', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_fin_d field
            //
            $column = new TextViewColumn('date_fin_d', 'date_fin_d', 'Date Fin D', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for code_compt field
            //
            $column = new NumberViewColumn('code_compt', 'code_compt', 'Code Compt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'id_groupe', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new TextViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_charge', 'LA2', 'Id Charge', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for disponible field
            //
            $column = new NumberViewColumn('disponible', 'disponible', 'Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for disponible_web field
            //
            $column = new TextViewColumn('disponible_web', 'disponible_web', 'Disponible Web', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for documents_facture field
            //
            $column = new TextViewColumn('documents_facture', 'documents_facture', 'Documents Facture', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for document_bon_commande field
            //
            $column = new TextViewColumn('document_bon_commande', 'document_bon_commande', 'Document Bon Commande', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for document_manuel_utilisation field
            //
            $column = new TextViewColumn('document_manuel_utilisation', 'document_manuel_utilisation', 'Document Manuel Utilisation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for autres_documents field
            //
            $column = new TextViewColumn('autres_documents', 'autres_documents', 'Autres Documents', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for no_identif field
            //
            $editor = new TextEdit('no_identif_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('No Identif', 'no_identif', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for transaction field
            //
            $editor = new TextEdit('transaction_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Transaction', 'transaction', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for nom_l_e field
            //
            $editor = new TextEdit('nom_l_e_edit');
            $editor->SetMaxLength(80);
            $editColumn = new CustomEditColumn('Nom L E', 'nom_l_e', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_equipement field
            //
            $editor = new TextEdit('id_equipement_edit');
            $editColumn = new CustomEditColumn('Id Equipement', 'id_equipement', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for marque field
            //
            $editor = new TextEdit('marque_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Marque', 'marque', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_marque field
            //
            $editor = new TextEdit('id_marque_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Marque', 'id_marque', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for manufacture field
            //
            $editor = new TextEdit('manufacture_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Manufacture', 'manufacture', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_manufacturier field
            //
            $editor = new TextEdit('id_manufacturier_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Manufacturier', 'id_manufacturier', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for modele field
            //
            $editor = new TextEdit('modele_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Modele', 'modele', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_modele field
            //
            $editor = new TextEdit('id_modele_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Modele', 'id_modele', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for fournisseur field
            //
            $editor = new TextEdit('fournisseur_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Fournisseur', 'fournisseur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_fournisseur field
            //
            $editor = new TextEdit('id_fournisseur_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Fournisseur', 'id_fournisseur', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_serie field
            //
            $editor = new TextEdit('no_serie_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('No Serie', 'no_serie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for caracteristique field
            //
            $editor = new TextEdit('caracteristique_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Caracteristique', 'caracteristique', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for utilisation field
            //
            $editor = new TextEdit('utilisation_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Utilisation', 'utilisation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for duree_vie field
            //
            $editor = new TextEdit('duree_vie_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Duree Vie', 'duree_vie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for etat field
            //
            $editor = new TextEdit('etat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Etat', 'etat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for fonction field
            //
            $editor = new TextEdit('fonction_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Fonction', 'fonction', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for utilisateur field
            //
            $editor = new TextEdit('utilisateur_edit');
            $editor->SetMaxLength(60);
            $editColumn = new CustomEditColumn('Utilisateur', 'utilisateur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for cours field
            //
            $editor = new TextEdit('cours_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Cours', 'cours', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_requis field
            //
            $editor = new TextEdit('no_requis_edit');
            $editColumn = new CustomEditColumn('No Requis', 'no_requis', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_comman field
            //
            $editor = new TextEdit('no_comman_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('No Comman', 'no_comman', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for quantite field
            //
            $editor = new TextEdit('quantite_edit');
            $editColumn = new CustomEditColumn('Quantite', 'quantite', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for prix_unitaire field
            //
            $editor = new TextEdit('prix_unitaire_edit');
            $editColumn = new CustomEditColumn('Prix Unitaire', 'prix_unitaire', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for cout_total field
            //
            $editor = new TextEdit('cout_total_edit');
            $editColumn = new CustomEditColumn('Cout Total', 'cout_total', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_achat field
            //
            $editor = new TextEdit('date_achat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Achat', 'date_achat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_recept field
            //
            $editor = new TextEdit('date_recept_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Recept', 'date_recept', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_fin_d field
            //
            $editor = new TextEdit('date_fin_d_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Fin D', 'date_fin_d', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for code_compt field
            //
            $editor = new TextEdit('code_compt_edit');
            $editColumn = new CustomEditColumn('Code Compt', 'code_compt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextAreaEdit('commentaires_edit', 50, 8);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_groupe field
            //
            $editor = new TextEdit('id_groupe_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Groupe', 'id_groupe', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_pers field
            //
            $editor = new TextEdit('id_pers_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Pers', 'id_pers', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'edit_administratifs_locals_materiel_mat_sci_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_charge field
            //
            $editor = new DynamicCombobox('id_charge_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Charge', 'id_charge', 'LA2', 'edit_administratifs_locals_materiel_mat_sci_id_charge_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for disponible field
            //
            $editor = new TextEdit('disponible_edit');
            $editColumn = new CustomEditColumn('Disponible', 'disponible', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for disponible_web field
            //
            $editor = new TextEdit('disponible_web_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Disponible Web', 'disponible_web', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for documents_facture field
            //
            $editor = new TextEdit('documents_facture_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Documents Facture', 'documents_facture', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for document_bon_commande field
            //
            $editor = new TextEdit('document_bon_commande_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Document Bon Commande', 'document_bon_commande', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for document_manuel_utilisation field
            //
            $editor = new TextEdit('document_manuel_utilisation_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Document Manuel Utilisation', 'document_manuel_utilisation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for autres_documents field
            //
            $editor = new TextEdit('autres_documents_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Autres Documents', 'autres_documents', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for no_identif field
            //
            $editor = new TextEdit('no_identif_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('No Identif', 'no_identif', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for transaction field
            //
            $editor = new TextEdit('transaction_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Transaction', 'transaction', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for nom_l_e field
            //
            $editor = new TextEdit('nom_l_e_edit');
            $editor->SetMaxLength(80);
            $editColumn = new CustomEditColumn('Nom L E', 'nom_l_e', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_equipement field
            //
            $editor = new TextEdit('id_equipement_edit');
            $editColumn = new CustomEditColumn('Id Equipement', 'id_equipement', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for marque field
            //
            $editor = new TextEdit('marque_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Marque', 'marque', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_marque field
            //
            $editor = new TextEdit('id_marque_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Marque', 'id_marque', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for manufacture field
            //
            $editor = new TextEdit('manufacture_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Manufacture', 'manufacture', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_manufacturier field
            //
            $editor = new TextEdit('id_manufacturier_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Manufacturier', 'id_manufacturier', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for modele field
            //
            $editor = new TextEdit('modele_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Modele', 'modele', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_modele field
            //
            $editor = new TextEdit('id_modele_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Modele', 'id_modele', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for fournisseur field
            //
            $editor = new TextEdit('fournisseur_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Fournisseur', 'fournisseur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_fournisseur field
            //
            $editor = new TextEdit('id_fournisseur_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Fournisseur', 'id_fournisseur', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_serie field
            //
            $editor = new TextEdit('no_serie_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('No Serie', 'no_serie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for caracteristique field
            //
            $editor = new TextEdit('caracteristique_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Caracteristique', 'caracteristique', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for utilisation field
            //
            $editor = new TextEdit('utilisation_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Utilisation', 'utilisation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for duree_vie field
            //
            $editor = new TextEdit('duree_vie_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Duree Vie', 'duree_vie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for etat field
            //
            $editor = new TextEdit('etat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Etat', 'etat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for fonction field
            //
            $editor = new TextEdit('fonction_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Fonction', 'fonction', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for utilisateur field
            //
            $editor = new TextEdit('utilisateur_edit');
            $editor->SetMaxLength(60);
            $editColumn = new CustomEditColumn('Utilisateur', 'utilisateur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for cours field
            //
            $editor = new TextEdit('cours_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Cours', 'cours', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_requis field
            //
            $editor = new TextEdit('no_requis_edit');
            $editColumn = new CustomEditColumn('No Requis', 'no_requis', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_comman field
            //
            $editor = new TextEdit('no_comman_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('No Comman', 'no_comman', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for quantite field
            //
            $editor = new TextEdit('quantite_edit');
            $editColumn = new CustomEditColumn('Quantite', 'quantite', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for prix_unitaire field
            //
            $editor = new TextEdit('prix_unitaire_edit');
            $editColumn = new CustomEditColumn('Prix Unitaire', 'prix_unitaire', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for cout_total field
            //
            $editor = new TextEdit('cout_total_edit');
            $editColumn = new CustomEditColumn('Cout Total', 'cout_total', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_achat field
            //
            $editor = new TextEdit('date_achat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Achat', 'date_achat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_recept field
            //
            $editor = new TextEdit('date_recept_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Recept', 'date_recept', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_fin_d field
            //
            $editor = new TextEdit('date_fin_d_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Fin D', 'date_fin_d', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for code_compt field
            //
            $editor = new TextEdit('code_compt_edit');
            $editColumn = new CustomEditColumn('Code Compt', 'code_compt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextAreaEdit('commentaires_edit', 50, 8);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_groupe field
            //
            $editor = new TextEdit('id_groupe_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Groupe', 'id_groupe', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_pers field
            //
            $editor = new TextEdit('id_pers_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Pers', 'id_pers', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'multi_edit_administratifs_locals_materiel_mat_sci_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_charge field
            //
            $editor = new DynamicCombobox('id_charge_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Charge', 'id_charge', 'LA2', 'multi_edit_administratifs_locals_materiel_mat_sci_id_charge_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for disponible field
            //
            $editor = new TextEdit('disponible_edit');
            $editColumn = new CustomEditColumn('Disponible', 'disponible', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for disponible_web field
            //
            $editor = new TextEdit('disponible_web_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Disponible Web', 'disponible_web', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for documents_facture field
            //
            $editor = new TextEdit('documents_facture_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Documents Facture', 'documents_facture', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for document_bon_commande field
            //
            $editor = new TextEdit('document_bon_commande_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Document Bon Commande', 'document_bon_commande', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for document_manuel_utilisation field
            //
            $editor = new TextEdit('document_manuel_utilisation_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Document Manuel Utilisation', 'document_manuel_utilisation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for autres_documents field
            //
            $editor = new TextEdit('autres_documents_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Autres Documents', 'autres_documents', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for no_identif field
            //
            $editor = new TextEdit('no_identif_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('No Identif', 'no_identif', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for transaction field
            //
            $editor = new TextEdit('transaction_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Transaction', 'transaction', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for nom_l_e field
            //
            $editor = new TextEdit('nom_l_e_edit');
            $editor->SetMaxLength(80);
            $editColumn = new CustomEditColumn('Nom L E', 'nom_l_e', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_equipement field
            //
            $editor = new TextEdit('id_equipement_edit');
            $editColumn = new CustomEditColumn('Id Equipement', 'id_equipement', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for marque field
            //
            $editor = new TextEdit('marque_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Marque', 'marque', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_marque field
            //
            $editor = new TextEdit('id_marque_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Marque', 'id_marque', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for manufacture field
            //
            $editor = new TextEdit('manufacture_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Manufacture', 'manufacture', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_manufacturier field
            //
            $editor = new TextEdit('id_manufacturier_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Manufacturier', 'id_manufacturier', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for modele field
            //
            $editor = new TextEdit('modele_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Modele', 'modele', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_modele field
            //
            $editor = new TextEdit('id_modele_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Modele', 'id_modele', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for fournisseur field
            //
            $editor = new TextEdit('fournisseur_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Fournisseur', 'fournisseur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_fournisseur field
            //
            $editor = new TextEdit('id_fournisseur_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Fournisseur', 'id_fournisseur', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_serie field
            //
            $editor = new TextEdit('no_serie_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('No Serie', 'no_serie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for caracteristique field
            //
            $editor = new TextEdit('caracteristique_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Caracteristique', 'caracteristique', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for utilisation field
            //
            $editor = new TextEdit('utilisation_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Utilisation', 'utilisation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for duree_vie field
            //
            $editor = new TextEdit('duree_vie_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Duree Vie', 'duree_vie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for etat field
            //
            $editor = new TextEdit('etat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Etat', 'etat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for fonction field
            //
            $editor = new TextEdit('fonction_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Fonction', 'fonction', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for utilisateur field
            //
            $editor = new TextEdit('utilisateur_edit');
            $editor->SetMaxLength(60);
            $editColumn = new CustomEditColumn('Utilisateur', 'utilisateur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for cours field
            //
            $editor = new TextEdit('cours_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Cours', 'cours', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_requis field
            //
            $editor = new TextEdit('no_requis_edit');
            $editColumn = new CustomEditColumn('No Requis', 'no_requis', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_comman field
            //
            $editor = new TextEdit('no_comman_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('No Comman', 'no_comman', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for quantite field
            //
            $editor = new TextEdit('quantite_edit');
            $editColumn = new CustomEditColumn('Quantite', 'quantite', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for prix_unitaire field
            //
            $editor = new TextEdit('prix_unitaire_edit');
            $editColumn = new CustomEditColumn('Prix Unitaire', 'prix_unitaire', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for cout_total field
            //
            $editor = new TextEdit('cout_total_edit');
            $editColumn = new CustomEditColumn('Cout Total', 'cout_total', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_achat field
            //
            $editor = new TextEdit('date_achat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Achat', 'date_achat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_recept field
            //
            $editor = new TextEdit('date_recept_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Recept', 'date_recept', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_fin_d field
            //
            $editor = new TextEdit('date_fin_d_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Fin D', 'date_fin_d', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for code_compt field
            //
            $editor = new TextEdit('code_compt_edit');
            $editColumn = new CustomEditColumn('Code Compt', 'code_compt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextAreaEdit('commentaires_edit', 50, 8);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_groupe field
            //
            $editor = new TextEdit('id_groupe_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Groupe', 'id_groupe', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_pers field
            //
            $editor = new TextEdit('id_pers_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Pers', 'id_pers', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'insert_administratifs_locals_materiel_mat_sci_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_charge field
            //
            $editor = new DynamicCombobox('id_charge_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Charge', 'id_charge', 'LA2', 'insert_administratifs_locals_materiel_mat_sci_id_charge_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for disponible field
            //
            $editor = new TextEdit('disponible_edit');
            $editColumn = new CustomEditColumn('Disponible', 'disponible', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for disponible_web field
            //
            $editor = new TextEdit('disponible_web_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Disponible Web', 'disponible_web', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for documents_facture field
            //
            $editor = new TextEdit('documents_facture_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Documents Facture', 'documents_facture', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for document_bon_commande field
            //
            $editor = new TextEdit('document_bon_commande_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Document Bon Commande', 'document_bon_commande', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for document_manuel_utilisation field
            //
            $editor = new TextEdit('document_manuel_utilisation_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Document Manuel Utilisation', 'document_manuel_utilisation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for autres_documents field
            //
            $editor = new TextEdit('autres_documents_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Autres Documents', 'autres_documents', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for id_mat_sci field
            //
            $column = new NumberViewColumn('id_mat_sci', 'id_mat_sci', 'Id Mat Sci', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_identif field
            //
            $column = new TextViewColumn('no_identif', 'no_identif', 'No Identif', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for transaction field
            //
            $column = new TextViewColumn('transaction', 'transaction', 'Transaction', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom_l_e field
            //
            $column = new TextViewColumn('nom_l_e', 'nom_l_e', 'Nom L E', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_equipement field
            //
            $column = new NumberViewColumn('id_equipement', 'id_equipement', 'Id Equipement', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for marque field
            //
            $column = new TextViewColumn('marque', 'marque', 'Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_marque field
            //
            $column = new TextViewColumn('id_marque', 'id_marque', 'Id Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for manufacture field
            //
            $column = new TextViewColumn('manufacture', 'manufacture', 'Manufacture', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_manufacturier field
            //
            $column = new TextViewColumn('id_manufacturier', 'id_manufacturier', 'Id Manufacturier', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for modele field
            //
            $column = new TextViewColumn('modele', 'modele', 'Modele', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_modele field
            //
            $column = new TextViewColumn('id_modele', 'id_modele', 'Id Modele', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for fournisseur field
            //
            $column = new TextViewColumn('fournisseur', 'fournisseur', 'Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_fournisseur field
            //
            $column = new TextViewColumn('id_fournisseur', 'id_fournisseur', 'Id Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for caracteristique field
            //
            $column = new TextViewColumn('caracteristique', 'caracteristique', 'Caracteristique', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for utilisation field
            //
            $column = new TextViewColumn('utilisation', 'utilisation', 'Utilisation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for duree_vie field
            //
            $column = new TextViewColumn('duree_vie', 'duree_vie', 'Duree Vie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for etat field
            //
            $column = new TextViewColumn('etat', 'etat', 'Etat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for fonction field
            //
            $column = new TextViewColumn('fonction', 'fonction', 'Fonction', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for utilisateur field
            //
            $column = new TextViewColumn('utilisateur', 'utilisateur', 'Utilisateur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for cours field
            //
            $column = new TextViewColumn('cours', 'cours', 'Cours', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_requis field
            //
            $column = new NumberViewColumn('no_requis', 'no_requis', 'No Requis', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_comman field
            //
            $column = new TextViewColumn('no_comman', 'no_comman', 'No Comman', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for quantite field
            //
            $column = new NumberViewColumn('quantite', 'quantite', 'Quantite', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for prix_unitaire field
            //
            $column = new NumberViewColumn('prix_unitaire', 'prix_unitaire', 'Prix Unitaire', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for cout_total field
            //
            $column = new NumberViewColumn('cout_total', 'cout_total', 'Cout Total', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_recept field
            //
            $column = new TextViewColumn('date_recept', 'date_recept', 'Date Recept', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_fin_d field
            //
            $column = new TextViewColumn('date_fin_d', 'date_fin_d', 'Date Fin D', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for code_compt field
            //
            $column = new NumberViewColumn('code_compt', 'code_compt', 'Code Compt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'id_groupe', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new TextViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_charge', 'LA2', 'Id Charge', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for disponible field
            //
            $column = new NumberViewColumn('disponible', 'disponible', 'Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for disponible_web field
            //
            $column = new TextViewColumn('disponible_web', 'disponible_web', 'Disponible Web', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for documents_facture field
            //
            $column = new TextViewColumn('documents_facture', 'documents_facture', 'Documents Facture', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for document_bon_commande field
            //
            $column = new TextViewColumn('document_bon_commande', 'document_bon_commande', 'Document Bon Commande', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for document_manuel_utilisation field
            //
            $column = new TextViewColumn('document_manuel_utilisation', 'document_manuel_utilisation', 'Document Manuel Utilisation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for autres_documents field
            //
            $column = new TextViewColumn('autres_documents', 'autres_documents', 'Autres Documents', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for id_mat_sci field
            //
            $column = new NumberViewColumn('id_mat_sci', 'id_mat_sci', 'Id Mat Sci', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for no_identif field
            //
            $column = new TextViewColumn('no_identif', 'no_identif', 'No Identif', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for transaction field
            //
            $column = new TextViewColumn('transaction', 'transaction', 'Transaction', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom_l_e field
            //
            $column = new TextViewColumn('nom_l_e', 'nom_l_e', 'Nom L E', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_equipement field
            //
            $column = new NumberViewColumn('id_equipement', 'id_equipement', 'Id Equipement', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for marque field
            //
            $column = new TextViewColumn('marque', 'marque', 'Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_marque field
            //
            $column = new TextViewColumn('id_marque', 'id_marque', 'Id Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for manufacture field
            //
            $column = new TextViewColumn('manufacture', 'manufacture', 'Manufacture', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_manufacturier field
            //
            $column = new TextViewColumn('id_manufacturier', 'id_manufacturier', 'Id Manufacturier', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for modele field
            //
            $column = new TextViewColumn('modele', 'modele', 'Modele', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_modele field
            //
            $column = new TextViewColumn('id_modele', 'id_modele', 'Id Modele', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for fournisseur field
            //
            $column = new TextViewColumn('fournisseur', 'fournisseur', 'Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_fournisseur field
            //
            $column = new TextViewColumn('id_fournisseur', 'id_fournisseur', 'Id Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for caracteristique field
            //
            $column = new TextViewColumn('caracteristique', 'caracteristique', 'Caracteristique', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for utilisation field
            //
            $column = new TextViewColumn('utilisation', 'utilisation', 'Utilisation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for duree_vie field
            //
            $column = new TextViewColumn('duree_vie', 'duree_vie', 'Duree Vie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for etat field
            //
            $column = new TextViewColumn('etat', 'etat', 'Etat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for fonction field
            //
            $column = new TextViewColumn('fonction', 'fonction', 'Fonction', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for utilisateur field
            //
            $column = new TextViewColumn('utilisateur', 'utilisateur', 'Utilisateur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for cours field
            //
            $column = new TextViewColumn('cours', 'cours', 'Cours', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_requis field
            //
            $column = new NumberViewColumn('no_requis', 'no_requis', 'No Requis', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for no_comman field
            //
            $column = new TextViewColumn('no_comman', 'no_comman', 'No Comman', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for quantite field
            //
            $column = new NumberViewColumn('quantite', 'quantite', 'Quantite', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for prix_unitaire field
            //
            $column = new NumberViewColumn('prix_unitaire', 'prix_unitaire', 'Prix Unitaire', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for cout_total field
            //
            $column = new NumberViewColumn('cout_total', 'cout_total', 'Cout Total', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_recept field
            //
            $column = new TextViewColumn('date_recept', 'date_recept', 'Date Recept', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_fin_d field
            //
            $column = new TextViewColumn('date_fin_d', 'date_fin_d', 'Date Fin D', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for code_compt field
            //
            $column = new NumberViewColumn('code_compt', 'code_compt', 'Code Compt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'id_groupe', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new TextViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_charge', 'LA2', 'Id Charge', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for disponible field
            //
            $column = new NumberViewColumn('disponible', 'disponible', 'Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for disponible_web field
            //
            $column = new TextViewColumn('disponible_web', 'disponible_web', 'Disponible Web', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for documents_facture field
            //
            $column = new TextViewColumn('documents_facture', 'documents_facture', 'Documents Facture', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for document_bon_commande field
            //
            $column = new TextViewColumn('document_bon_commande', 'document_bon_commande', 'Document Bon Commande', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for document_manuel_utilisation field
            //
            $column = new TextViewColumn('document_manuel_utilisation', 'document_manuel_utilisation', 'Document Manuel Utilisation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for autres_documents field
            //
            $column = new TextViewColumn('autres_documents', 'autres_documents', 'Autres Documents', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for no_identif field
            //
            $column = new TextViewColumn('no_identif', 'no_identif', 'No Identif', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for transaction field
            //
            $column = new TextViewColumn('transaction', 'transaction', 'Transaction', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom_l_e field
            //
            $column = new TextViewColumn('nom_l_e', 'nom_l_e', 'Nom L E', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_equipement field
            //
            $column = new NumberViewColumn('id_equipement', 'id_equipement', 'Id Equipement', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for marque field
            //
            $column = new TextViewColumn('marque', 'marque', 'Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_marque field
            //
            $column = new TextViewColumn('id_marque', 'id_marque', 'Id Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for manufacture field
            //
            $column = new TextViewColumn('manufacture', 'manufacture', 'Manufacture', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_manufacturier field
            //
            $column = new TextViewColumn('id_manufacturier', 'id_manufacturier', 'Id Manufacturier', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for modele field
            //
            $column = new TextViewColumn('modele', 'modele', 'Modele', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_modele field
            //
            $column = new TextViewColumn('id_modele', 'id_modele', 'Id Modele', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for fournisseur field
            //
            $column = new TextViewColumn('fournisseur', 'fournisseur', 'Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_fournisseur field
            //
            $column = new TextViewColumn('id_fournisseur', 'id_fournisseur', 'Id Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for caracteristique field
            //
            $column = new TextViewColumn('caracteristique', 'caracteristique', 'Caracteristique', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for utilisation field
            //
            $column = new TextViewColumn('utilisation', 'utilisation', 'Utilisation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for duree_vie field
            //
            $column = new TextViewColumn('duree_vie', 'duree_vie', 'Duree Vie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for etat field
            //
            $column = new TextViewColumn('etat', 'etat', 'Etat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for fonction field
            //
            $column = new TextViewColumn('fonction', 'fonction', 'Fonction', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for utilisateur field
            //
            $column = new TextViewColumn('utilisateur', 'utilisateur', 'Utilisateur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for cours field
            //
            $column = new TextViewColumn('cours', 'cours', 'Cours', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_requis field
            //
            $column = new NumberViewColumn('no_requis', 'no_requis', 'No Requis', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_comman field
            //
            $column = new TextViewColumn('no_comman', 'no_comman', 'No Comman', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for quantite field
            //
            $column = new NumberViewColumn('quantite', 'quantite', 'Quantite', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for prix_unitaire field
            //
            $column = new NumberViewColumn('prix_unitaire', 'prix_unitaire', 'Prix Unitaire', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for cout_total field
            //
            $column = new NumberViewColumn('cout_total', 'cout_total', 'Cout Total', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_recept field
            //
            $column = new TextViewColumn('date_recept', 'date_recept', 'Date Recept', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_fin_d field
            //
            $column = new TextViewColumn('date_fin_d', 'date_fin_d', 'Date Fin D', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for code_compt field
            //
            $column = new NumberViewColumn('code_compt', 'code_compt', 'Code Compt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'id_groupe', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new TextViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_charge', 'LA2', 'Id Charge', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for disponible field
            //
            $column = new NumberViewColumn('disponible', 'disponible', 'Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for disponible_web field
            //
            $column = new TextViewColumn('disponible_web', 'disponible_web', 'Disponible Web', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for documents_facture field
            //
            $column = new TextViewColumn('documents_facture', 'documents_facture', 'Documents Facture', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for document_bon_commande field
            //
            $column = new TextViewColumn('document_bon_commande', 'document_bon_commande', 'Document Bon Commande', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for document_manuel_utilisation field
            //
            $column = new TextViewColumn('document_manuel_utilisation', 'document_manuel_utilisation', 'Document Manuel Utilisation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for autres_documents field
            //
            $column = new TextViewColumn('autres_documents', 'autres_documents', 'Autres Documents', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(true);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_locals_materiel_mat_sci_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_locals_materiel_mat_sci_id_charge_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_locals_materiel_mat_sci_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_locals_materiel_mat_sci_id_charge_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_locals_materiel_mat_sci_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_locals_materiel_mat_sci_id_charge_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_locals_materiel_mat_sci_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_locals_materiel_mat_sci_id_charge_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }
    
    // OnBeforePageExecute event handler
    
    
    
    class administratifs_localsPage extends Page
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Locaux');
            $this->SetMenuLabel('Locaux');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $this->dataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $this->dataset->AddLookupField('id_resp', '(select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */)', new IntegerField('id_pers'), new StringField('nom_complet', false, false, false, false, 'LA1', 'LT1'), 'LT1');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'id_loc', 'id_loc', 'Id Loc'),
                new FilterColumn($this->dataset, 'no_loc', 'no_loc', 'No Local'),
                new FilterColumn($this->dataset, 'unite', 'unite', 'Unite'),
                new FilterColumn($this->dataset, 'no_plc_tot', 'no_plc_tot', 'Total Places'),
                new FilterColumn($this->dataset, 'no_plc_dsp', 'no_plc_dsp', 'Places Disponibles'),
                new FilterColumn($this->dataset, 'no_plc_occ', 'no_plc_occ', 'Places Occupées'),
                new FilterColumn($this->dataset, 'fonction', 'fonction', 'Fonction'),
                new FilterColumn($this->dataset, 'type_lab', 'type_lab', 'Type Lab'),
                new FilterColumn($this->dataset, 'util_lab', 'util_lab', 'Util Lab'),
                new FilterColumn($this->dataset, 'id_resp', 'LA1', 'Utilisateurs'),
                new FilterColumn($this->dataset, 'description', 'description', 'Description'),
                new FilterColumn($this->dataset, 'nom_loc', 'nom_loc', 'Note Local'),
                new FilterColumn($this->dataset, 'nom_resp', 'nom_resp', 'Resp Loc'),
                new FilterColumn($this->dataset, 'type_occ', 'type_occ', 'Type Util'),
                new FilterColumn($this->dataset, 'taux_occ', 'taux_occ', 'Taux Occ'),
                new FilterColumn($this->dataset, 'sup_plan', 'sup_plan', 'Sup Plan'),
                new FilterColumn($this->dataset, 'geom', 'geom', 'Geom')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['no_loc'])
                ->addColumn($columns['unite'])
                ->addColumn($columns['no_plc_tot'])
                ->addColumn($columns['no_plc_dsp'])
                ->addColumn($columns['no_plc_occ'])
                ->addColumn($columns['fonction'])
                ->addColumn($columns['type_lab'])
                ->addColumn($columns['util_lab'])
                ->addColumn($columns['id_resp'])
                ->addColumn($columns['description'])
                ->addColumn($columns['nom_loc'])
                ->addColumn($columns['nom_resp'])
                ->addColumn($columns['type_occ']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_resp');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('no_loc_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['no_loc'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('unite_edit');
            $main_editor->SetMaxLength(30);
            
            $filterBuilder->addColumn(
                $columns['unite'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_plc_tot_edit');
            
            $filterBuilder->addColumn(
                $columns['no_plc_tot'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_plc_dsp_edit');
            
            $filterBuilder->addColumn(
                $columns['no_plc_dsp'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_plc_occ_edit');
            
            $filterBuilder->addColumn(
                $columns['no_plc_occ'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('fonction_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['fonction'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('type_lab_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['type_lab'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('util_lab_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['util_lab'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_resp_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_locals_id_resp_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_resp', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_locals_id_resp_search');
            
            $filterBuilder->addColumn(
                $columns['id_resp'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('description_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['description'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('nom_loc_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['nom_loc'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('nom_resp_edit');
            $main_editor->SetMaxLength(30);
            
            $filterBuilder->addColumn(
                $columns['nom_resp'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('type_occ_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['type_occ'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            if (GetCurrentUserPermissionsForPage('administratifs.locals.administratifs.personnel')->HasViewGrant() && $withDetails)
            {
            //
            // View column for administratifs_locals_administratifs_personnel detail
            //
            $column = new DetailColumn(array('id_loc'), 'administratifs.locals.administratifs.personnel', 'administratifs_locals_administratifs_personnel_handler', $this->dataset, 'Personnel');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            }
            
            if (GetCurrentUserPermissionsForPage('administratifs.locals.cle_departement.cle_cles')->HasViewGrant() && $withDetails)
            {
            //
            // View column for administratifs_locals_cle_departement_cle_cles detail
            //
            $column = new DetailColumn(array('id_loc'), 'administratifs.locals.cle_departement.cle_cles', 'administratifs_locals_cle_departement_cle_cles_handler', $this->dataset, 'Cle Cles');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            }
            
            if (GetCurrentUserPermissionsForPage('administratifs.locals.materiel.ipadresse')->HasViewGrant() && $withDetails)
            {
            //
            // View column for administratifs_locals_materiel_ipadresse detail
            //
            $column = new DetailColumn(array('id_loc'), 'administratifs.locals.materiel.ipadresse', 'administratifs_locals_materiel_ipadresse_handler', $this->dataset, 'Ipadresse');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            }
            
            if (GetCurrentUserPermissionsForPage('administratifs.locals.materiel.mat_informatique')->HasViewGrant() && $withDetails)
            {
            //
            // View column for administratifs_locals_materiel_mat_informatique detail
            //
            $column = new DetailColumn(array('id_loc'), 'administratifs.locals.materiel.mat_informatique', 'administratifs_locals_materiel_mat_informatique_handler', $this->dataset, 'Mat Informatique');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            }
            
            if (GetCurrentUserPermissionsForPage('administratifs.locals.materiel.mat_sci')->HasViewGrant() && $withDetails)
            {
            //
            // View column for administratifs_locals_materiel_mat_sci detail
            //
            $column = new DetailColumn(array('id_loc'), 'administratifs.locals.materiel.mat_sci', 'administratifs_locals_materiel_mat_sci_handler', $this->dataset, 'Mat Sci');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            }
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('no_loc', 'no_loc', 'No Local', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for unite field
            //
            $column = new TextViewColumn('unite', 'unite', 'Unite', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_plc_tot field
            //
            $column = new NumberViewColumn('no_plc_tot', 'no_plc_tot', 'Total Places', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_plc_dsp field
            //
            $column = new NumberViewColumn('no_plc_dsp', 'no_plc_dsp', 'Places Disponibles', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_plc_occ field
            //
            $column = new NumberViewColumn('no_plc_occ', 'no_plc_occ', 'Places Occupées', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for fonction field
            //
            $column = new TextViewColumn('fonction', 'fonction', 'Fonction', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for type_lab field
            //
            $column = new TextViewColumn('type_lab', 'type_lab', 'Type Lab', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for util_lab field
            //
            $column = new TextViewColumn('util_lab', 'util_lab', 'Util Lab', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom_complet field
            //
            $column = new TextViewColumn('id_resp', 'LA1', 'Utilisateurs', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom_loc field
            //
            $column = new TextViewColumn('nom_loc', 'nom_loc', 'Note Local', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom_resp field
            //
            $column = new TextViewColumn('nom_resp', 'nom_resp', 'Resp Loc', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for type_occ field
            //
            $column = new TextViewColumn('type_occ', 'type_occ', 'Type Util', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('no_loc', 'no_loc', 'No Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for unite field
            //
            $column = new TextViewColumn('unite', 'unite', 'Unite', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_plc_tot field
            //
            $column = new NumberViewColumn('no_plc_tot', 'no_plc_tot', 'Total Places', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_plc_dsp field
            //
            $column = new NumberViewColumn('no_plc_dsp', 'no_plc_dsp', 'Places Disponibles', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_plc_occ field
            //
            $column = new NumberViewColumn('no_plc_occ', 'no_plc_occ', 'Places Occupées', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for fonction field
            //
            $column = new TextViewColumn('fonction', 'fonction', 'Fonction', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for type_lab field
            //
            $column = new TextViewColumn('type_lab', 'type_lab', 'Type Lab', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for util_lab field
            //
            $column = new TextViewColumn('util_lab', 'util_lab', 'Util Lab', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom_complet field
            //
            $column = new TextViewColumn('id_resp', 'LA1', 'Utilisateurs', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom_loc field
            //
            $column = new TextViewColumn('nom_loc', 'nom_loc', 'Note Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom_resp field
            //
            $column = new TextViewColumn('nom_resp', 'nom_resp', 'Resp Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for type_occ field
            //
            $column = new TextViewColumn('type_occ', 'type_occ', 'Type Util', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for no_loc field
            //
            $editor = new TextEdit('no_loc_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('No Local', 'no_loc', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for unite field
            //
            $editor = new TextEdit('unite_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Unite', 'unite', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_plc_tot field
            //
            $editor = new TextEdit('no_plc_tot_edit');
            $editColumn = new CustomEditColumn('Total Places', 'no_plc_tot', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_plc_dsp field
            //
            $editor = new TextEdit('no_plc_dsp_edit');
            $editColumn = new CustomEditColumn('Places Disponibles', 'no_plc_dsp', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_plc_occ field
            //
            $editor = new TextEdit('no_plc_occ_edit');
            $editColumn = new CustomEditColumn('Places Occupées', 'no_plc_occ', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for fonction field
            //
            $editor = new TextEdit('fonction_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Fonction', 'fonction', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for type_lab field
            //
            $editor = new TextEdit('type_lab_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Type Lab', 'type_lab', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for util_lab field
            //
            $editor = new TextEdit('util_lab_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Util Lab', 'util_lab', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_resp field
            //
            $editor = new DynamicCombobox('id_resp_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Utilisateurs', 'id_resp', 'LA1', 'edit_administratifs_locals_id_resp_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom_complet', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for description field
            //
            $editor = new TextEdit('description_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for nom_loc field
            //
            $editor = new TextEdit('nom_loc_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Note Local', 'nom_loc', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for nom_resp field
            //
            $editor = new TextEdit('nom_resp_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Resp Loc', 'nom_resp', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for type_occ field
            //
            $editor = new TextEdit('type_occ_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Type Util', 'type_occ', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for no_loc field
            //
            $editor = new TextEdit('no_loc_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('No Local', 'no_loc', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for unite field
            //
            $editor = new TextEdit('unite_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Unite', 'unite', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_plc_tot field
            //
            $editor = new TextEdit('no_plc_tot_edit');
            $editColumn = new CustomEditColumn('Total Places', 'no_plc_tot', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_plc_dsp field
            //
            $editor = new TextEdit('no_plc_dsp_edit');
            $editColumn = new CustomEditColumn('Places Disponibles', 'no_plc_dsp', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_plc_occ field
            //
            $editor = new TextEdit('no_plc_occ_edit');
            $editColumn = new CustomEditColumn('Places Occupées', 'no_plc_occ', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for fonction field
            //
            $editor = new TextEdit('fonction_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Fonction', 'fonction', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for type_lab field
            //
            $editor = new TextEdit('type_lab_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Type Lab', 'type_lab', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for util_lab field
            //
            $editor = new TextEdit('util_lab_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Util Lab', 'util_lab', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_resp field
            //
            $editor = new DynamicCombobox('id_resp_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Utilisateurs', 'id_resp', 'LA1', 'multi_edit_administratifs_locals_id_resp_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom_complet', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for description field
            //
            $editor = new TextEdit('description_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for nom_loc field
            //
            $editor = new TextEdit('nom_loc_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Note Local', 'nom_loc', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for nom_resp field
            //
            $editor = new TextEdit('nom_resp_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Resp Loc', 'nom_resp', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for type_occ field
            //
            $editor = new TextEdit('type_occ_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Type Util', 'type_occ', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for no_loc field
            //
            $editor = new TextEdit('no_loc_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('No Local', 'no_loc', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for unite field
            //
            $editor = new TextEdit('unite_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Unite', 'unite', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_plc_tot field
            //
            $editor = new TextEdit('no_plc_tot_edit');
            $editColumn = new CustomEditColumn('Total Places', 'no_plc_tot', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_plc_dsp field
            //
            $editor = new TextEdit('no_plc_dsp_edit');
            $editColumn = new CustomEditColumn('Places Disponibles', 'no_plc_dsp', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_plc_occ field
            //
            $editor = new TextEdit('no_plc_occ_edit');
            $editColumn = new CustomEditColumn('Places Occupées', 'no_plc_occ', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for fonction field
            //
            $editor = new TextEdit('fonction_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Fonction', 'fonction', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for type_lab field
            //
            $editor = new TextEdit('type_lab_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Type Lab', 'type_lab', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for util_lab field
            //
            $editor = new TextEdit('util_lab_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Util Lab', 'util_lab', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_resp field
            //
            $editor = new DynamicCombobox('id_resp_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Utilisateurs', 'id_resp', 'LA1', 'insert_administratifs_locals_id_resp_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom_complet', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for description field
            //
            $editor = new TextEdit('description_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for nom_loc field
            //
            $editor = new TextEdit('nom_loc_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Note Local', 'nom_loc', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for nom_resp field
            //
            $editor = new TextEdit('nom_resp_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Resp Loc', 'nom_resp', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for type_occ field
            //
            $editor = new TextEdit('type_occ_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Type Util', 'type_occ', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('no_loc', 'no_loc', 'No Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for unite field
            //
            $column = new TextViewColumn('unite', 'unite', 'Unite', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_plc_tot field
            //
            $column = new NumberViewColumn('no_plc_tot', 'no_plc_tot', 'Total Places', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_plc_dsp field
            //
            $column = new NumberViewColumn('no_plc_dsp', 'no_plc_dsp', 'Places Disponibles', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_plc_occ field
            //
            $column = new NumberViewColumn('no_plc_occ', 'no_plc_occ', 'Places Occupées', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for fonction field
            //
            $column = new TextViewColumn('fonction', 'fonction', 'Fonction', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for type_lab field
            //
            $column = new TextViewColumn('type_lab', 'type_lab', 'Type Lab', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for util_lab field
            //
            $column = new TextViewColumn('util_lab', 'util_lab', 'Util Lab', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom_complet field
            //
            $column = new TextViewColumn('id_resp', 'LA1', 'Utilisateurs', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom_loc field
            //
            $column = new TextViewColumn('nom_loc', 'nom_loc', 'Note Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom_resp field
            //
            $column = new TextViewColumn('nom_resp', 'nom_resp', 'Resp Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for type_occ field
            //
            $column = new TextViewColumn('type_occ', 'type_occ', 'Type Util', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('no_loc', 'no_loc', 'No Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for unite field
            //
            $column = new TextViewColumn('unite', 'unite', 'Unite', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_plc_tot field
            //
            $column = new NumberViewColumn('no_plc_tot', 'no_plc_tot', 'Total Places', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for no_plc_dsp field
            //
            $column = new NumberViewColumn('no_plc_dsp', 'no_plc_dsp', 'Places Disponibles', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for no_plc_occ field
            //
            $column = new NumberViewColumn('no_plc_occ', 'no_plc_occ', 'Places Occupées', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for fonction field
            //
            $column = new TextViewColumn('fonction', 'fonction', 'Fonction', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for type_lab field
            //
            $column = new TextViewColumn('type_lab', 'type_lab', 'Type Lab', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for util_lab field
            //
            $column = new TextViewColumn('util_lab', 'util_lab', 'Util Lab', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom_complet field
            //
            $column = new TextViewColumn('id_resp', 'LA1', 'Utilisateurs', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom_loc field
            //
            $column = new TextViewColumn('nom_loc', 'nom_loc', 'Note Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom_resp field
            //
            $column = new TextViewColumn('nom_resp', 'nom_resp', 'Resp Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for type_occ field
            //
            $column = new TextViewColumn('type_occ', 'type_occ', 'Type Util', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('no_loc', 'no_loc', 'No Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for unite field
            //
            $column = new TextViewColumn('unite', 'unite', 'Unite', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_plc_tot field
            //
            $column = new NumberViewColumn('no_plc_tot', 'no_plc_tot', 'Total Places', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_plc_dsp field
            //
            $column = new NumberViewColumn('no_plc_dsp', 'no_plc_dsp', 'Places Disponibles', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_plc_occ field
            //
            $column = new NumberViewColumn('no_plc_occ', 'no_plc_occ', 'Places Occupées', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for fonction field
            //
            $column = new TextViewColumn('fonction', 'fonction', 'Fonction', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for type_lab field
            //
            $column = new TextViewColumn('type_lab', 'type_lab', 'Type Lab', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for util_lab field
            //
            $column = new TextViewColumn('util_lab', 'util_lab', 'Util Lab', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom_complet field
            //
            $column = new TextViewColumn('id_resp', 'LA1', 'Utilisateurs', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom_loc field
            //
            $column = new TextViewColumn('nom_loc', 'nom_loc', 'Note Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom_resp field
            //
            $column = new TextViewColumn('nom_resp', 'nom_resp', 'Resp Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for type_occ field
            //
            $column = new TextViewColumn('type_occ', 'type_occ', 'Type Util', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function CreateMasterDetailRecordGrid()
        {
            $result = new Grid($this, $this->dataset);
            
            $this->AddFieldColumns($result, false);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            
            $result->SetAllowDeleteSelected(false);
            $result->SetShowUpdateLink(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(false);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $this->setupGridColumnGroup($result);
            $this->attachGridEventHandlers($result);
            
            return $result;
        }
        
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(true);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $detailPage = new administratifs_locals_administratifs_personnelPage('administratifs_locals_administratifs_personnel', $this, array('id_loc'), array('id_loc'), $this->GetForeignKeyFields(), $this->CreateMasterDetailRecordGrid(), $this->dataset, GetCurrentUserPermissionsForPage('administratifs.locals.administratifs.personnel'), 'UTF-8');
            $detailPage->SetRecordPermission(GetCurrentUserRecordPermissionsForDataSource('administratifs.locals.administratifs.personnel'));
            $detailPage->SetHttpHandlerName('administratifs_locals_administratifs_personnel_handler');
            $handler = new PageHTTPHandler('administratifs_locals_administratifs_personnel_handler', $detailPage);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $detailPage = new administratifs_locals_cle_departement_cle_clesPage('administratifs_locals_cle_departement_cle_cles', $this, array('id_local'), array('id_loc'), $this->GetForeignKeyFields(), $this->CreateMasterDetailRecordGrid(), $this->dataset, GetCurrentUserPermissionsForPage('administratifs.locals.cle_departement.cle_cles'), 'UTF-8');
            $detailPage->SetRecordPermission(GetCurrentUserRecordPermissionsForDataSource('administratifs.locals.cle_departement.cle_cles'));
            $detailPage->SetHttpHandlerName('administratifs_locals_cle_departement_cle_cles_handler');
            $handler = new PageHTTPHandler('administratifs_locals_cle_departement_cle_cles_handler', $detailPage);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $detailPage = new administratifs_locals_materiel_ipadressePage('administratifs_locals_materiel_ipadresse', $this, array('id_local'), array('id_loc'), $this->GetForeignKeyFields(), $this->CreateMasterDetailRecordGrid(), $this->dataset, GetCurrentUserPermissionsForPage('administratifs.locals.materiel.ipadresse'), 'UTF-8');
            $detailPage->SetRecordPermission(GetCurrentUserRecordPermissionsForDataSource('administratifs.locals.materiel.ipadresse'));
            $detailPage->SetHttpHandlerName('administratifs_locals_materiel_ipadresse_handler');
            $handler = new PageHTTPHandler('administratifs_locals_materiel_ipadresse_handler', $detailPage);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $detailPage = new administratifs_locals_materiel_mat_informatiquePage('administratifs_locals_materiel_mat_informatique', $this, array('id_loc'), array('id_loc'), $this->GetForeignKeyFields(), $this->CreateMasterDetailRecordGrid(), $this->dataset, GetCurrentUserPermissionsForPage('administratifs.locals.materiel.mat_informatique'), 'UTF-8');
            $detailPage->SetRecordPermission(GetCurrentUserRecordPermissionsForDataSource('administratifs.locals.materiel.mat_informatique'));
            $detailPage->SetHttpHandlerName('administratifs_locals_materiel_mat_informatique_handler');
            $handler = new PageHTTPHandler('administratifs_locals_materiel_mat_informatique_handler', $detailPage);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $detailPage = new administratifs_locals_materiel_mat_sciPage('administratifs_locals_materiel_mat_sci', $this, array('id_loc'), array('id_loc'), $this->GetForeignKeyFields(), $this->CreateMasterDetailRecordGrid(), $this->dataset, GetCurrentUserPermissionsForPage('administratifs.locals.materiel.mat_sci'), 'UTF-8');
            $detailPage->SetRecordPermission(GetCurrentUserRecordPermissionsForDataSource('administratifs.locals.materiel.mat_sci'));
            $detailPage->SetHttpHandlerName('administratifs_locals_materiel_mat_sci_handler');
            $handler = new PageHTTPHandler('administratifs_locals_materiel_mat_sci_handler', $detailPage);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_locals_id_resp_search', 'id_pers', 'nom_complet', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_locals_id_resp_search', 'id_pers', 'nom_complet', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_locals_id_resp_search', 'id_pers', 'nom_complet', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_locals_id_resp_search', 'id_pers', 'nom_complet', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }

    SetUpUserAuthorization();

    try
    {
        $Page = new administratifs_localsPage("administratifs_locals", "locals.php", GetCurrentUserPermissionsForPage("administratifs.locals"), 'UTF-8');
        $Page->SetRecordPermission(GetCurrentUserRecordPermissionsForDataSource("administratifs.locals"));
        GetApplication()->SetMainPage($Page);
        GetApplication()->Run();
    }
    catch(Exception $e)
    {
        ShowErrorPage($e);
    }
	
