<?php
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                   ATTENTION!
 * If you see this message in your browser (Internet Explorer, Mozilla Firefox, Google Chrome, etc.)
 * this means that PHP is not properly installed on your web server. Please refer to the PHP manual
 * for more details: http://php.net/manual/install.php 
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

    include_once dirname(__FILE__) . '/components/startup.php';
    include_once dirname(__FILE__) . '/components/application.php';
    include_once dirname(__FILE__) . '/' . 'authorization.php';


    include_once dirname(__FILE__) . '/' . 'database_engine/pgsql_engine.php';
    include_once dirname(__FILE__) . '/' . 'components/page/page_includes.php';

    function GetConnectionOptions()
    {
        $result = GetGlobalConnectionOptions();
        $result['client_encoding'] = 'utf8';
        GetApplication()->GetUserAuthentication()->applyIdentityToConnectionOptions($result);
        return $result;
    }

    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class administratifs_locaux_departementPage extends Page
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Locaux');
            $this->SetMenuLabel('Locaux');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locaux_departement"');
            $this->dataset->addFields(
                array(
                    new StringField('no_loc', false, true),
                    new StringField('nom_loc'),
                    new StringField('unite'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new StringField('nom_resp'),
                    new IntegerField('id_resp'),
                    new StringField('type_occ'),
                    new IntegerField('nbr_places'),
                    new IntegerField('places_libres'),
                    new IntegerField('places_occup'),
                    new IntegerField('taux_occ')
                )
            );
            $this->dataset->AddLookupField('id_resp', '(select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */)', new IntegerField('id_pers'), new StringField('nom_complet', false, false, false, false, 'LA1', 'LT1'), 'LT1');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'no_loc', 'no_loc', 'No Loc'),
                new FilterColumn($this->dataset, 'nom_loc', 'nom_loc', 'Note Loc'),
                new FilterColumn($this->dataset, 'unite', 'unite', 'Unite'),
                new FilterColumn($this->dataset, 'fonction', 'fonction', 'Fonction'),
                new FilterColumn($this->dataset, 'type_lab', 'type_lab', 'Type Lab'),
                new FilterColumn($this->dataset, 'util_lab', 'util_lab', 'Util Lab'),
                new FilterColumn($this->dataset, 'nom_resp', 'nom_resp', 'Resp Loc'),
                new FilterColumn($this->dataset, 'id_resp', 'LA1', 'Utilisateurs'),
                new FilterColumn($this->dataset, 'type_occ', 'type_occ', 'Type Util'),
                new FilterColumn($this->dataset, 'taux_occ', 'taux_occ', 'Taux Occ'),
                new FilterColumn($this->dataset, 'nbr_places', 'nbr_places', 'Nbr Places'),
                new FilterColumn($this->dataset, 'places_libres', 'places_libres', 'Places Libres'),
                new FilterColumn($this->dataset, 'places_occup', 'places_occup', 'Places Occup')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['no_loc'])
                ->addColumn($columns['nom_loc'])
                ->addColumn($columns['unite'])
                ->addColumn($columns['fonction'])
                ->addColumn($columns['type_lab'])
                ->addColumn($columns['util_lab'])
                ->addColumn($columns['nom_resp'])
                ->addColumn($columns['id_resp'])
                ->addColumn($columns['type_occ'])
                ->addColumn($columns['taux_occ'])
                ->addColumn($columns['nbr_places'])
                ->addColumn($columns['places_libres'])
                ->addColumn($columns['places_occup']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_resp');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('no_loc_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['no_loc'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('nom_loc_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['nom_loc'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('unite_edit');
            $main_editor->SetMaxLength(30);
            
            $filterBuilder->addColumn(
                $columns['unite'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('fonction_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['fonction'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('type_lab_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['type_lab'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('util_lab_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['util_lab'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('nom_resp_edit');
            $main_editor->SetMaxLength(30);
            
            $filterBuilder->addColumn(
                $columns['nom_resp'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_resp_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_locaux_departement_id_resp_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_resp', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_locaux_departement_id_resp_search');
            
            $filterBuilder->addColumn(
                $columns['id_resp'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('type_occ_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['type_occ'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('taux_occ_edit');
            
            $filterBuilder->addColumn(
                $columns['taux_occ'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('nbr_places_edit');
            
            $filterBuilder->addColumn(
                $columns['nbr_places'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('places_libres_edit');
            
            $filterBuilder->addColumn(
                $columns['places_libres'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('places_occup_edit');
            
            $filterBuilder->addColumn(
                $columns['places_occup'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('no_loc', 'no_loc', 'No Loc', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom_loc field
            //
            $column = new TextViewColumn('nom_loc', 'nom_loc', 'Note Loc', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for unite field
            //
            $column = new TextViewColumn('unite', 'unite', 'Unite', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for fonction field
            //
            $column = new TextViewColumn('fonction', 'fonction', 'Fonction', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for type_lab field
            //
            $column = new TextViewColumn('type_lab', 'type_lab', 'Type Lab', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for util_lab field
            //
            $column = new TextViewColumn('util_lab', 'util_lab', 'Util Lab', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom_resp field
            //
            $column = new TextViewColumn('nom_resp', 'nom_resp', 'Resp Loc', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom_complet field
            //
            $column = new TextViewColumn('id_resp', 'LA1', 'Utilisateurs', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for type_occ field
            //
            $column = new TextViewColumn('type_occ', 'type_occ', 'Type Util', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for taux_occ field
            //
            $column = new NumberViewColumn('taux_occ', 'taux_occ', 'Taux Occ', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nbr_places field
            //
            $column = new NumberViewColumn('nbr_places', 'nbr_places', 'Nbr Places', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for places_libres field
            //
            $column = new NumberViewColumn('places_libres', 'places_libres', 'Places Libres', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for places_occup field
            //
            $column = new NumberViewColumn('places_occup', 'places_occup', 'Places Occup', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('no_loc', 'no_loc', 'No Loc', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom_loc field
            //
            $column = new TextViewColumn('nom_loc', 'nom_loc', 'Note Loc', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for unite field
            //
            $column = new TextViewColumn('unite', 'unite', 'Unite', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for fonction field
            //
            $column = new TextViewColumn('fonction', 'fonction', 'Fonction', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for type_lab field
            //
            $column = new TextViewColumn('type_lab', 'type_lab', 'Type Lab', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for util_lab field
            //
            $column = new TextViewColumn('util_lab', 'util_lab', 'Util Lab', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom_resp field
            //
            $column = new TextViewColumn('nom_resp', 'nom_resp', 'Resp Loc', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom_complet field
            //
            $column = new TextViewColumn('id_resp', 'LA1', 'Utilisateurs', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for type_occ field
            //
            $column = new TextViewColumn('type_occ', 'type_occ', 'Type Util', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for taux_occ field
            //
            $column = new NumberViewColumn('taux_occ', 'taux_occ', 'Taux Occ', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nbr_places field
            //
            $column = new NumberViewColumn('nbr_places', 'nbr_places', 'Nbr Places', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for places_libres field
            //
            $column = new NumberViewColumn('places_libres', 'places_libres', 'Places Libres', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for places_occup field
            //
            $column = new NumberViewColumn('places_occup', 'places_occup', 'Places Occup', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for no_loc field
            //
            $editor = new TextEdit('no_loc_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('No Loc', 'no_loc', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for nom_loc field
            //
            $editor = new TextEdit('nom_loc_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Note Loc', 'nom_loc', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for unite field
            //
            $editor = new TextEdit('unite_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Unite', 'unite', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for fonction field
            //
            $editor = new TextEdit('fonction_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Fonction', 'fonction', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for type_lab field
            //
            $editor = new TextEdit('type_lab_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Type Lab', 'type_lab', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for util_lab field
            //
            $editor = new TextEdit('util_lab_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Util Lab', 'util_lab', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for nom_resp field
            //
            $editor = new TextEdit('nom_resp_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Resp Loc', 'nom_resp', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_resp field
            //
            $editor = new DynamicCombobox('id_resp_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Utilisateurs', 'id_resp', 'LA1', 'edit_administratifs_locaux_departement_id_resp_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom_complet', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for type_occ field
            //
            $editor = new TextEdit('type_occ_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Type Util', 'type_occ', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for taux_occ field
            //
            $editor = new TextEdit('taux_occ_edit');
            $editColumn = new CustomEditColumn('Taux Occ', 'taux_occ', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for nbr_places field
            //
            $editor = new TextEdit('nbr_places_edit');
            $editColumn = new CustomEditColumn('Nbr Places', 'nbr_places', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for places_libres field
            //
            $editor = new TextEdit('places_libres_edit');
            $editColumn = new CustomEditColumn('Places Libres', 'places_libres', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for places_occup field
            //
            $editor = new TextEdit('places_occup_edit');
            $editColumn = new CustomEditColumn('Places Occup', 'places_occup', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for nom_loc field
            //
            $editor = new TextEdit('nom_loc_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Note Loc', 'nom_loc', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for unite field
            //
            $editor = new TextEdit('unite_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Unite', 'unite', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for fonction field
            //
            $editor = new TextEdit('fonction_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Fonction', 'fonction', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for type_lab field
            //
            $editor = new TextEdit('type_lab_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Type Lab', 'type_lab', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for util_lab field
            //
            $editor = new TextEdit('util_lab_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Util Lab', 'util_lab', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for nom_resp field
            //
            $editor = new TextEdit('nom_resp_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Resp Loc', 'nom_resp', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_resp field
            //
            $editor = new DynamicCombobox('id_resp_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Utilisateurs', 'id_resp', 'LA1', 'multi_edit_administratifs_locaux_departement_id_resp_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom_complet', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for type_occ field
            //
            $editor = new TextEdit('type_occ_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Type Util', 'type_occ', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for taux_occ field
            //
            $editor = new TextEdit('taux_occ_edit');
            $editColumn = new CustomEditColumn('Taux Occ', 'taux_occ', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for nbr_places field
            //
            $editor = new TextEdit('nbr_places_edit');
            $editColumn = new CustomEditColumn('Nbr Places', 'nbr_places', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for places_libres field
            //
            $editor = new TextEdit('places_libres_edit');
            $editColumn = new CustomEditColumn('Places Libres', 'places_libres', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for places_occup field
            //
            $editor = new TextEdit('places_occup_edit');
            $editColumn = new CustomEditColumn('Places Occup', 'places_occup', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for no_loc field
            //
            $editor = new TextEdit('no_loc_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('No Loc', 'no_loc', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for nom_loc field
            //
            $editor = new TextEdit('nom_loc_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Note Loc', 'nom_loc', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for unite field
            //
            $editor = new TextEdit('unite_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Unite', 'unite', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for fonction field
            //
            $editor = new TextEdit('fonction_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Fonction', 'fonction', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for type_lab field
            //
            $editor = new TextEdit('type_lab_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Type Lab', 'type_lab', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for util_lab field
            //
            $editor = new TextEdit('util_lab_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Util Lab', 'util_lab', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for nom_resp field
            //
            $editor = new TextEdit('nom_resp_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Resp Loc', 'nom_resp', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_resp field
            //
            $editor = new DynamicCombobox('id_resp_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Utilisateurs', 'id_resp', 'LA1', 'insert_administratifs_locaux_departement_id_resp_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom_complet', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for type_occ field
            //
            $editor = new TextEdit('type_occ_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Type Util', 'type_occ', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for taux_occ field
            //
            $editor = new TextEdit('taux_occ_edit');
            $editColumn = new CustomEditColumn('Taux Occ', 'taux_occ', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for nbr_places field
            //
            $editor = new TextEdit('nbr_places_edit');
            $editColumn = new CustomEditColumn('Nbr Places', 'nbr_places', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for places_libres field
            //
            $editor = new TextEdit('places_libres_edit');
            $editColumn = new CustomEditColumn('Places Libres', 'places_libres', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for places_occup field
            //
            $editor = new TextEdit('places_occup_edit');
            $editColumn = new CustomEditColumn('Places Occup', 'places_occup', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('no_loc', 'no_loc', 'No Loc', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom_loc field
            //
            $column = new TextViewColumn('nom_loc', 'nom_loc', 'Note Loc', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for unite field
            //
            $column = new TextViewColumn('unite', 'unite', 'Unite', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for fonction field
            //
            $column = new TextViewColumn('fonction', 'fonction', 'Fonction', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for type_lab field
            //
            $column = new TextViewColumn('type_lab', 'type_lab', 'Type Lab', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for util_lab field
            //
            $column = new TextViewColumn('util_lab', 'util_lab', 'Util Lab', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom_resp field
            //
            $column = new TextViewColumn('nom_resp', 'nom_resp', 'Resp Loc', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom_complet field
            //
            $column = new TextViewColumn('id_resp', 'LA1', 'Utilisateurs', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for type_occ field
            //
            $column = new TextViewColumn('type_occ', 'type_occ', 'Type Util', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for taux_occ field
            //
            $column = new NumberViewColumn('taux_occ', 'taux_occ', 'Taux Occ', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for nbr_places field
            //
            $column = new NumberViewColumn('nbr_places', 'nbr_places', 'Nbr Places', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for places_libres field
            //
            $column = new NumberViewColumn('places_libres', 'places_libres', 'Places Libres', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for places_occup field
            //
            $column = new NumberViewColumn('places_occup', 'places_occup', 'Places Occup', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('no_loc', 'no_loc', 'No Loc', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom_loc field
            //
            $column = new TextViewColumn('nom_loc', 'nom_loc', 'Note Loc', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for unite field
            //
            $column = new TextViewColumn('unite', 'unite', 'Unite', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for fonction field
            //
            $column = new TextViewColumn('fonction', 'fonction', 'Fonction', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for type_lab field
            //
            $column = new TextViewColumn('type_lab', 'type_lab', 'Type Lab', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for util_lab field
            //
            $column = new TextViewColumn('util_lab', 'util_lab', 'Util Lab', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom_resp field
            //
            $column = new TextViewColumn('nom_resp', 'nom_resp', 'Resp Loc', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom_complet field
            //
            $column = new TextViewColumn('id_resp', 'LA1', 'Utilisateurs', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for type_occ field
            //
            $column = new TextViewColumn('type_occ', 'type_occ', 'Type Util', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for taux_occ field
            //
            $column = new NumberViewColumn('taux_occ', 'taux_occ', 'Taux Occ', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for nbr_places field
            //
            $column = new NumberViewColumn('nbr_places', 'nbr_places', 'Nbr Places', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for places_libres field
            //
            $column = new NumberViewColumn('places_libres', 'places_libres', 'Places Libres', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for places_occup field
            //
            $column = new NumberViewColumn('places_occup', 'places_occup', 'Places Occup', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('no_loc', 'no_loc', 'No Loc', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom_loc field
            //
            $column = new TextViewColumn('nom_loc', 'nom_loc', 'Note Loc', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for unite field
            //
            $column = new TextViewColumn('unite', 'unite', 'Unite', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for fonction field
            //
            $column = new TextViewColumn('fonction', 'fonction', 'Fonction', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for type_lab field
            //
            $column = new TextViewColumn('type_lab', 'type_lab', 'Type Lab', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for util_lab field
            //
            $column = new TextViewColumn('util_lab', 'util_lab', 'Util Lab', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom_resp field
            //
            $column = new TextViewColumn('nom_resp', 'nom_resp', 'Resp Loc', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom_complet field
            //
            $column = new TextViewColumn('id_resp', 'LA1', 'Utilisateurs', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for type_occ field
            //
            $column = new TextViewColumn('type_occ', 'type_occ', 'Type Util', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for taux_occ field
            //
            $column = new NumberViewColumn('taux_occ', 'taux_occ', 'Taux Occ', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for nbr_places field
            //
            $column = new NumberViewColumn('nbr_places', 'nbr_places', 'Nbr Places', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for places_libres field
            //
            $column = new NumberViewColumn('places_libres', 'places_libres', 'Places Libres', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for places_occup field
            //
            $column = new NumberViewColumn('places_occup', 'places_occup', 'Places Occup', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(true);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_locaux_departement_id_resp_search', 'id_pers', 'nom_complet', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_locaux_departement_id_resp_search', 'id_pers', 'nom_complet', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_locaux_departement_id_resp_search', 'id_pers', 'nom_complet', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_locaux_departement_id_resp_search', 'id_pers', 'nom_complet', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }

    SetUpUserAuthorization();

    try
    {
        $Page = new administratifs_locaux_departementPage("administratifs_locaux_departement", "locaux_departement.php", GetCurrentUserPermissionsForPage("administratifs.locaux_departement"), 'UTF-8');
        $Page->SetRecordPermission(GetCurrentUserRecordPermissionsForDataSource("administratifs.locaux_departement"));
        GetApplication()->SetMainPage($Page);
        GetApplication()->Run();
    }
    catch(Exception $e)
    {
        ShowErrorPage($e);
    }
	
