<?php
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                   ATTENTION!
 * If you see this message in your browser (Internet Explorer, Mozilla Firefox, Google Chrome, etc.)
 * this means that PHP is not properly installed on your web server. Please refer to the PHP manual
 * for more details: http://php.net/manual/install.php 
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

    include_once dirname(__FILE__) . '/components/startup.php';
    include_once dirname(__FILE__) . '/components/application.php';
    include_once dirname(__FILE__) . '/' . 'authorization.php';


    include_once dirname(__FILE__) . '/' . 'database_engine/pgsql_engine.php';
    include_once dirname(__FILE__) . '/' . 'components/page/page_includes.php';

    function GetConnectionOptions()
    {
        $result = GetGlobalConnectionOptions();
        $result['client_encoding'] = 'utf8';
        GetApplication()->GetUserAuthentication()->applyIdentityToConnectionOptions($result);
        return $result;
    }

    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class administratifs_personnel01_administratifs_imprimante_poster_tmpPage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Imprimante Poster Tmp');
            $this->SetMenuLabel('Imprimante Poster Tmp');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."imprimante_poster_tmp"');
            $this->dataset->addFields(
                array(
                    new StringField('ï»¿Nom_etudiant'),
                    new StringField('Nom_prof'),
                    new IntegerField('taille_largeur'),
                    new IntegerField('taille_longueur'),
                    new StringField('papier'),
                    new IntegerField('prix'),
                    new StringField('Date'),
                    new StringField('RIG'),
                    new StringField('Facture'),
                    new IntegerField('id_etudiant'),
                    new IntegerField('id_professeur'),
                    new IntegerField('id_imprimante', true, true, true),
                    new IntegerField('montant_total'),
                    new IntegerField('type_papier')
                )
            );
            $this->dataset->AddLookupField('id_etudiant', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('id_professeur', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA2', 'LT2'), 'LT2');
            $this->dataset->AddLookupField('type_papier', 'administratifs.imprimante_poster_papiers', new IntegerField('id_papier'), new StringField('papier', false, false, false, false, 'LA3', 'LT3'), 'LT3');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'ï»¿Nom_etudiant', 'ï»¿Nom_etudiant', 'ï»¿Nom Etudiant'),
                new FilterColumn($this->dataset, 'Nom_prof', 'Nom_prof', 'Nom Prof'),
                new FilterColumn($this->dataset, 'taille_largeur', 'taille_largeur', 'Taille Largeur'),
                new FilterColumn($this->dataset, 'taille_longueur', 'taille_longueur', 'Taille Longueur'),
                new FilterColumn($this->dataset, 'papier', 'papier', 'Papier'),
                new FilterColumn($this->dataset, 'prix', 'prix', 'Prix'),
                new FilterColumn($this->dataset, 'Date', 'Date', 'Date'),
                new FilterColumn($this->dataset, 'RIG', 'RIG', 'RIG'),
                new FilterColumn($this->dataset, 'Facture', 'Facture', 'Facture'),
                new FilterColumn($this->dataset, 'id_etudiant', 'LA1', 'Id Etudiant'),
                new FilterColumn($this->dataset, 'id_professeur', 'LA2', 'Id Professeur'),
                new FilterColumn($this->dataset, 'id_imprimante', 'id_imprimante', 'Id Imprimante'),
                new FilterColumn($this->dataset, 'montant_total', 'montant_total', 'Montant Total'),
                new FilterColumn($this->dataset, 'type_papier', 'LA3', 'Type Papier')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['ï»¿Nom_etudiant'])
                ->addColumn($columns['Nom_prof'])
                ->addColumn($columns['taille_largeur'])
                ->addColumn($columns['taille_longueur'])
                ->addColumn($columns['papier'])
                ->addColumn($columns['prix'])
                ->addColumn($columns['Date'])
                ->addColumn($columns['RIG'])
                ->addColumn($columns['Facture'])
                ->addColumn($columns['id_etudiant'])
                ->addColumn($columns['id_professeur'])
                ->addColumn($columns['id_imprimante'])
                ->addColumn($columns['montant_total'])
                ->addColumn($columns['type_papier']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_etudiant')
                ->setOptionsFor('id_professeur')
                ->setOptionsFor('type_papier');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('ï»¿nom_etudiant_edit');
            
            $filterBuilder->addColumn(
                $columns['ï»¿Nom_etudiant'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('nom_prof_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['Nom_prof'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('taille_largeur_edit');
            
            $filterBuilder->addColumn(
                $columns['taille_largeur'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('taille_longueur_edit');
            
            $filterBuilder->addColumn(
                $columns['taille_longueur'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('papier_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['papier'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('prix_edit');
            
            $filterBuilder->addColumn(
                $columns['prix'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('date_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['Date'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('rig_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['RIG'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('facture_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['Facture'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_etudiant_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel01_administratifs_imprimante_poster_tmp_id_etudiant_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_etudiant', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel01_administratifs_imprimante_poster_tmp_id_etudiant_search');
            
            $text_editor = new TextEdit('id_etudiant');
            
            $filterBuilder->addColumn(
                $columns['id_etudiant'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_professeur_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel01_administratifs_imprimante_poster_tmp_id_professeur_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_professeur', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel01_administratifs_imprimante_poster_tmp_id_professeur_search');
            
            $text_editor = new TextEdit('id_professeur');
            
            $filterBuilder->addColumn(
                $columns['id_professeur'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_imprimante_edit');
            
            $filterBuilder->addColumn(
                $columns['id_imprimante'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('montant_total_edit');
            
            $filterBuilder->addColumn(
                $columns['montant_total'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('type_papier_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel01_administratifs_imprimante_poster_tmp_type_papier_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('type_papier', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel01_administratifs_imprimante_poster_tmp_type_papier_search');
            
            $text_editor = new TextEdit('type_papier');
            
            $filterBuilder->addColumn(
                $columns['type_papier'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for ï»¿Nom_etudiant field
            //
            $column = new TextViewColumn('ï»¿Nom_etudiant', 'ï»¿Nom_etudiant', 'ï»¿Nom Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for Nom_prof field
            //
            $column = new TextViewColumn('Nom_prof', 'Nom_prof', 'Nom Prof', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for taille_largeur field
            //
            $column = new NumberViewColumn('taille_largeur', 'taille_largeur', 'Taille Largeur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for taille_longueur field
            //
            $column = new NumberViewColumn('taille_longueur', 'taille_longueur', 'Taille Longueur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for papier field
            //
            $column = new TextViewColumn('papier', 'papier', 'Papier', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for prix field
            //
            $column = new NumberViewColumn('prix', 'prix', 'Prix', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for Date field
            //
            $column = new TextViewColumn('Date', 'Date', 'Date', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for RIG field
            //
            $column = new TextViewColumn('RIG', 'RIG', 'RIG', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for Facture field
            //
            $column = new TextViewColumn('Facture', 'Facture', 'Facture', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_etudiant', 'LA1', 'Id Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur', 'LA2', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_imprimante field
            //
            $column = new NumberViewColumn('id_imprimante', 'id_imprimante', 'Id Imprimante', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for montant_total field
            //
            $column = new NumberViewColumn('montant_total', 'montant_total', 'Montant Total', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for papier field
            //
            $column = new TextViewColumn('type_papier', 'LA3', 'Type Papier', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for ï»¿Nom_etudiant field
            //
            $column = new TextViewColumn('ï»¿Nom_etudiant', 'ï»¿Nom_etudiant', 'ï»¿Nom Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for Nom_prof field
            //
            $column = new TextViewColumn('Nom_prof', 'Nom_prof', 'Nom Prof', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for taille_largeur field
            //
            $column = new NumberViewColumn('taille_largeur', 'taille_largeur', 'Taille Largeur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for taille_longueur field
            //
            $column = new NumberViewColumn('taille_longueur', 'taille_longueur', 'Taille Longueur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for papier field
            //
            $column = new TextViewColumn('papier', 'papier', 'Papier', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for prix field
            //
            $column = new NumberViewColumn('prix', 'prix', 'Prix', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for Date field
            //
            $column = new TextViewColumn('Date', 'Date', 'Date', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for RIG field
            //
            $column = new TextViewColumn('RIG', 'RIG', 'RIG', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for Facture field
            //
            $column = new TextViewColumn('Facture', 'Facture', 'Facture', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_etudiant', 'LA1', 'Id Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur', 'LA2', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_imprimante field
            //
            $column = new NumberViewColumn('id_imprimante', 'id_imprimante', 'Id Imprimante', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for montant_total field
            //
            $column = new NumberViewColumn('montant_total', 'montant_total', 'Montant Total', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for papier field
            //
            $column = new TextViewColumn('type_papier', 'LA3', 'Type Papier', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for ï»¿Nom_etudiant field
            //
            $editor = new TextEdit('ï»¿nom_etudiant_edit');
            $editColumn = new CustomEditColumn('ï»¿Nom Etudiant', 'ï»¿Nom_etudiant', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for Nom_prof field
            //
            $editor = new TextEdit('nom_prof_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Nom Prof', 'Nom_prof', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for taille_largeur field
            //
            $editor = new TextEdit('taille_largeur_edit');
            $editColumn = new CustomEditColumn('Taille Largeur', 'taille_largeur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for taille_longueur field
            //
            $editor = new TextEdit('taille_longueur_edit');
            $editColumn = new CustomEditColumn('Taille Longueur', 'taille_longueur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for papier field
            //
            $editor = new TextEdit('papier_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Papier', 'papier', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for prix field
            //
            $editor = new TextEdit('prix_edit');
            $editColumn = new CustomEditColumn('Prix', 'prix', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for Date field
            //
            $editor = new TextEdit('date_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Date', 'Date', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for RIG field
            //
            $editor = new TextEdit('rig_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('RIG', 'RIG', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for Facture field
            //
            $editor = new TextEdit('facture_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Facture', 'Facture', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_etudiant field
            //
            $editor = new DynamicCombobox('id_etudiant_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Etudiant', 'id_etudiant', 'LA1', 'edit_administratifs_personnel01_administratifs_imprimante_poster_tmp_id_etudiant_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_professeur field
            //
            $editor = new DynamicCombobox('id_professeur_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Professeur', 'id_professeur', 'LA2', 'edit_administratifs_personnel01_administratifs_imprimante_poster_tmp_id_professeur_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for montant_total field
            //
            $editor = new TextEdit('montant_total_edit');
            $editColumn = new CustomEditColumn('Montant Total', 'montant_total', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for type_papier field
            //
            $editor = new DynamicCombobox('type_papier_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."imprimante_poster_papiers"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_papier', true, true),
                    new StringField('papier')
                )
            );
            $lookupDataset->setOrderByField('papier', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Type Papier', 'type_papier', 'LA3', 'edit_administratifs_personnel01_administratifs_imprimante_poster_tmp_type_papier_search', $editor, $this->dataset, $lookupDataset, 'id_papier', 'papier', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for ï»¿Nom_etudiant field
            //
            $editor = new TextEdit('ï»¿nom_etudiant_edit');
            $editColumn = new CustomEditColumn('ï»¿Nom Etudiant', 'ï»¿Nom_etudiant', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for Nom_prof field
            //
            $editor = new TextEdit('nom_prof_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Nom Prof', 'Nom_prof', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for taille_largeur field
            //
            $editor = new TextEdit('taille_largeur_edit');
            $editColumn = new CustomEditColumn('Taille Largeur', 'taille_largeur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for taille_longueur field
            //
            $editor = new TextEdit('taille_longueur_edit');
            $editColumn = new CustomEditColumn('Taille Longueur', 'taille_longueur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for papier field
            //
            $editor = new TextEdit('papier_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Papier', 'papier', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for prix field
            //
            $editor = new TextEdit('prix_edit');
            $editColumn = new CustomEditColumn('Prix', 'prix', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for Date field
            //
            $editor = new TextEdit('date_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Date', 'Date', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for RIG field
            //
            $editor = new TextEdit('rig_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('RIG', 'RIG', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for Facture field
            //
            $editor = new TextEdit('facture_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Facture', 'Facture', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_etudiant field
            //
            $editor = new DynamicCombobox('id_etudiant_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Etudiant', 'id_etudiant', 'LA1', 'multi_edit_administratifs_personnel01_administratifs_imprimante_poster_tmp_id_etudiant_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_professeur field
            //
            $editor = new DynamicCombobox('id_professeur_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Professeur', 'id_professeur', 'LA2', 'multi_edit_administratifs_personnel01_administratifs_imprimante_poster_tmp_id_professeur_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for montant_total field
            //
            $editor = new TextEdit('montant_total_edit');
            $editColumn = new CustomEditColumn('Montant Total', 'montant_total', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for type_papier field
            //
            $editor = new DynamicCombobox('type_papier_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."imprimante_poster_papiers"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_papier', true, true),
                    new StringField('papier')
                )
            );
            $lookupDataset->setOrderByField('papier', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Type Papier', 'type_papier', 'LA3', 'multi_edit_administratifs_personnel01_administratifs_imprimante_poster_tmp_type_papier_search', $editor, $this->dataset, $lookupDataset, 'id_papier', 'papier', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for ï»¿Nom_etudiant field
            //
            $editor = new TextEdit('ï»¿nom_etudiant_edit');
            $editColumn = new CustomEditColumn('ï»¿Nom Etudiant', 'ï»¿Nom_etudiant', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for Nom_prof field
            //
            $editor = new TextEdit('nom_prof_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Nom Prof', 'Nom_prof', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for taille_largeur field
            //
            $editor = new TextEdit('taille_largeur_edit');
            $editColumn = new CustomEditColumn('Taille Largeur', 'taille_largeur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for taille_longueur field
            //
            $editor = new TextEdit('taille_longueur_edit');
            $editColumn = new CustomEditColumn('Taille Longueur', 'taille_longueur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for papier field
            //
            $editor = new TextEdit('papier_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Papier', 'papier', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for prix field
            //
            $editor = new TextEdit('prix_edit');
            $editColumn = new CustomEditColumn('Prix', 'prix', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for Date field
            //
            $editor = new TextEdit('date_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Date', 'Date', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for RIG field
            //
            $editor = new TextEdit('rig_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('RIG', 'RIG', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for Facture field
            //
            $editor = new TextEdit('facture_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Facture', 'Facture', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_etudiant field
            //
            $editor = new DynamicCombobox('id_etudiant_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Etudiant', 'id_etudiant', 'LA1', 'insert_administratifs_personnel01_administratifs_imprimante_poster_tmp_id_etudiant_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_professeur field
            //
            $editor = new DynamicCombobox('id_professeur_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Professeur', 'id_professeur', 'LA2', 'insert_administratifs_personnel01_administratifs_imprimante_poster_tmp_id_professeur_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for montant_total field
            //
            $editor = new TextEdit('montant_total_edit');
            $editColumn = new CustomEditColumn('Montant Total', 'montant_total', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for type_papier field
            //
            $editor = new DynamicCombobox('type_papier_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."imprimante_poster_papiers"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_papier', true, true),
                    new StringField('papier')
                )
            );
            $lookupDataset->setOrderByField('papier', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Type Papier', 'type_papier', 'LA3', 'insert_administratifs_personnel01_administratifs_imprimante_poster_tmp_type_papier_search', $editor, $this->dataset, $lookupDataset, 'id_papier', 'papier', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for ï»¿Nom_etudiant field
            //
            $column = new TextViewColumn('ï»¿Nom_etudiant', 'ï»¿Nom_etudiant', 'ï»¿Nom Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for Nom_prof field
            //
            $column = new TextViewColumn('Nom_prof', 'Nom_prof', 'Nom Prof', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for taille_largeur field
            //
            $column = new NumberViewColumn('taille_largeur', 'taille_largeur', 'Taille Largeur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for taille_longueur field
            //
            $column = new NumberViewColumn('taille_longueur', 'taille_longueur', 'Taille Longueur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for papier field
            //
            $column = new TextViewColumn('papier', 'papier', 'Papier', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for prix field
            //
            $column = new NumberViewColumn('prix', 'prix', 'Prix', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for Date field
            //
            $column = new TextViewColumn('Date', 'Date', 'Date', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for RIG field
            //
            $column = new TextViewColumn('RIG', 'RIG', 'RIG', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for Facture field
            //
            $column = new TextViewColumn('Facture', 'Facture', 'Facture', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_etudiant', 'LA1', 'Id Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur', 'LA2', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_imprimante field
            //
            $column = new NumberViewColumn('id_imprimante', 'id_imprimante', 'Id Imprimante', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for montant_total field
            //
            $column = new NumberViewColumn('montant_total', 'montant_total', 'Montant Total', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for papier field
            //
            $column = new TextViewColumn('type_papier', 'LA3', 'Type Papier', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for ï»¿Nom_etudiant field
            //
            $column = new TextViewColumn('ï»¿Nom_etudiant', 'ï»¿Nom_etudiant', 'ï»¿Nom Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for Nom_prof field
            //
            $column = new TextViewColumn('Nom_prof', 'Nom_prof', 'Nom Prof', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for taille_largeur field
            //
            $column = new NumberViewColumn('taille_largeur', 'taille_largeur', 'Taille Largeur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for taille_longueur field
            //
            $column = new NumberViewColumn('taille_longueur', 'taille_longueur', 'Taille Longueur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for papier field
            //
            $column = new TextViewColumn('papier', 'papier', 'Papier', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for prix field
            //
            $column = new NumberViewColumn('prix', 'prix', 'Prix', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for Date field
            //
            $column = new TextViewColumn('Date', 'Date', 'Date', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for RIG field
            //
            $column = new TextViewColumn('RIG', 'RIG', 'RIG', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for Facture field
            //
            $column = new TextViewColumn('Facture', 'Facture', 'Facture', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_etudiant', 'LA1', 'Id Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur', 'LA2', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_imprimante field
            //
            $column = new NumberViewColumn('id_imprimante', 'id_imprimante', 'Id Imprimante', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for montant_total field
            //
            $column = new NumberViewColumn('montant_total', 'montant_total', 'Montant Total', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for papier field
            //
            $column = new TextViewColumn('type_papier', 'LA3', 'Type Papier', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for ï»¿Nom_etudiant field
            //
            $column = new TextViewColumn('ï»¿Nom_etudiant', 'ï»¿Nom_etudiant', 'ï»¿Nom Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for Nom_prof field
            //
            $column = new TextViewColumn('Nom_prof', 'Nom_prof', 'Nom Prof', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for taille_largeur field
            //
            $column = new NumberViewColumn('taille_largeur', 'taille_largeur', 'Taille Largeur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for taille_longueur field
            //
            $column = new NumberViewColumn('taille_longueur', 'taille_longueur', 'Taille Longueur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for papier field
            //
            $column = new TextViewColumn('papier', 'papier', 'Papier', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for prix field
            //
            $column = new NumberViewColumn('prix', 'prix', 'Prix', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for Date field
            //
            $column = new TextViewColumn('Date', 'Date', 'Date', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for RIG field
            //
            $column = new TextViewColumn('RIG', 'RIG', 'RIG', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for Facture field
            //
            $column = new TextViewColumn('Facture', 'Facture', 'Facture', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_etudiant', 'LA1', 'Id Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur', 'LA2', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for montant_total field
            //
            $column = new NumberViewColumn('montant_total', 'montant_total', 'Montant Total', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for papier field
            //
            $column = new TextViewColumn('type_papier', 'LA3', 'Type Papier', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(true);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel01_administratifs_imprimante_poster_tmp_id_etudiant_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel01_administratifs_imprimante_poster_tmp_id_professeur_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."imprimante_poster_papiers"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_papier', true, true),
                    new StringField('papier')
                )
            );
            $lookupDataset->setOrderByField('papier', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel01_administratifs_imprimante_poster_tmp_type_papier_search', 'id_papier', 'papier', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel01_administratifs_imprimante_poster_tmp_id_etudiant_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel01_administratifs_imprimante_poster_tmp_id_professeur_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."imprimante_poster_papiers"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_papier', true, true),
                    new StringField('papier')
                )
            );
            $lookupDataset->setOrderByField('papier', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel01_administratifs_imprimante_poster_tmp_type_papier_search', 'id_papier', 'papier', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel01_administratifs_imprimante_poster_tmp_id_etudiant_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel01_administratifs_imprimante_poster_tmp_id_professeur_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."imprimante_poster_papiers"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_papier', true, true),
                    new StringField('papier')
                )
            );
            $lookupDataset->setOrderByField('papier', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel01_administratifs_imprimante_poster_tmp_type_papier_search', 'id_papier', 'papier', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel01_administratifs_imprimante_poster_tmp_id_etudiant_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel01_administratifs_imprimante_poster_tmp_id_professeur_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."imprimante_poster_papiers"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_papier', true, true),
                    new StringField('papier')
                )
            );
            $lookupDataset->setOrderByField('papier', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel01_administratifs_imprimante_poster_tmp_type_papier_search', 'id_papier', 'papier', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }
    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class administratifs_personnel01_administratifs_imprimante_poster_tmp01Page extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Imprimante Poster Tmp');
            $this->SetMenuLabel('Imprimante Poster Tmp');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."imprimante_poster_tmp"');
            $this->dataset->addFields(
                array(
                    new StringField('ï»¿Nom_etudiant'),
                    new StringField('Nom_prof'),
                    new IntegerField('taille_largeur'),
                    new IntegerField('taille_longueur'),
                    new StringField('papier'),
                    new IntegerField('prix'),
                    new StringField('Date'),
                    new StringField('RIG'),
                    new StringField('Facture'),
                    new IntegerField('id_etudiant'),
                    new IntegerField('id_professeur'),
                    new IntegerField('id_imprimante', true, true, true),
                    new IntegerField('montant_total'),
                    new IntegerField('type_papier')
                )
            );
            $this->dataset->AddLookupField('id_etudiant', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('id_professeur', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA2', 'LT2'), 'LT2');
            $this->dataset->AddLookupField('type_papier', 'administratifs.imprimante_poster_papiers', new IntegerField('id_papier'), new StringField('papier', false, false, false, false, 'LA3', 'LT3'), 'LT3');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'ï»¿Nom_etudiant', 'ï»¿Nom_etudiant', 'ï»¿Nom Etudiant'),
                new FilterColumn($this->dataset, 'Nom_prof', 'Nom_prof', 'Nom Prof'),
                new FilterColumn($this->dataset, 'taille_largeur', 'taille_largeur', 'Taille Largeur'),
                new FilterColumn($this->dataset, 'taille_longueur', 'taille_longueur', 'Taille Longueur'),
                new FilterColumn($this->dataset, 'papier', 'papier', 'Papier'),
                new FilterColumn($this->dataset, 'prix', 'prix', 'Prix'),
                new FilterColumn($this->dataset, 'Date', 'Date', 'Date'),
                new FilterColumn($this->dataset, 'RIG', 'RIG', 'RIG'),
                new FilterColumn($this->dataset, 'Facture', 'Facture', 'Facture'),
                new FilterColumn($this->dataset, 'id_etudiant', 'LA1', 'Id Etudiant'),
                new FilterColumn($this->dataset, 'id_professeur', 'LA2', 'Id Professeur'),
                new FilterColumn($this->dataset, 'id_imprimante', 'id_imprimante', 'Id Imprimante'),
                new FilterColumn($this->dataset, 'montant_total', 'montant_total', 'Montant Total'),
                new FilterColumn($this->dataset, 'type_papier', 'LA3', 'Type Papier')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['ï»¿Nom_etudiant'])
                ->addColumn($columns['Nom_prof'])
                ->addColumn($columns['taille_largeur'])
                ->addColumn($columns['taille_longueur'])
                ->addColumn($columns['papier'])
                ->addColumn($columns['prix'])
                ->addColumn($columns['Date'])
                ->addColumn($columns['RIG'])
                ->addColumn($columns['Facture'])
                ->addColumn($columns['id_etudiant'])
                ->addColumn($columns['id_professeur'])
                ->addColumn($columns['id_imprimante'])
                ->addColumn($columns['montant_total'])
                ->addColumn($columns['type_papier']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_etudiant')
                ->setOptionsFor('id_professeur')
                ->setOptionsFor('type_papier');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('ï»¿nom_etudiant_edit');
            
            $filterBuilder->addColumn(
                $columns['ï»¿Nom_etudiant'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('nom_prof_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['Nom_prof'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('taille_largeur_edit');
            
            $filterBuilder->addColumn(
                $columns['taille_largeur'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('taille_longueur_edit');
            
            $filterBuilder->addColumn(
                $columns['taille_longueur'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('papier_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['papier'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('prix_edit');
            
            $filterBuilder->addColumn(
                $columns['prix'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('date_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['Date'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('rig_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['RIG'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('facture_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['Facture'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_etudiant_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel01_administratifs_imprimante_poster_tmp01_id_etudiant_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_etudiant', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel01_administratifs_imprimante_poster_tmp01_id_etudiant_search');
            
            $text_editor = new TextEdit('id_etudiant');
            
            $filterBuilder->addColumn(
                $columns['id_etudiant'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_professeur_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel01_administratifs_imprimante_poster_tmp01_id_professeur_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_professeur', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel01_administratifs_imprimante_poster_tmp01_id_professeur_search');
            
            $text_editor = new TextEdit('id_professeur');
            
            $filterBuilder->addColumn(
                $columns['id_professeur'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_imprimante_edit');
            
            $filterBuilder->addColumn(
                $columns['id_imprimante'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('montant_total_edit');
            
            $filterBuilder->addColumn(
                $columns['montant_total'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('type_papier_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel01_administratifs_imprimante_poster_tmp01_type_papier_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('type_papier', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel01_administratifs_imprimante_poster_tmp01_type_papier_search');
            
            $text_editor = new TextEdit('type_papier');
            
            $filterBuilder->addColumn(
                $columns['type_papier'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for ï»¿Nom_etudiant field
            //
            $column = new TextViewColumn('ï»¿Nom_etudiant', 'ï»¿Nom_etudiant', 'ï»¿Nom Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for Nom_prof field
            //
            $column = new TextViewColumn('Nom_prof', 'Nom_prof', 'Nom Prof', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for taille_largeur field
            //
            $column = new NumberViewColumn('taille_largeur', 'taille_largeur', 'Taille Largeur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for taille_longueur field
            //
            $column = new NumberViewColumn('taille_longueur', 'taille_longueur', 'Taille Longueur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for papier field
            //
            $column = new TextViewColumn('papier', 'papier', 'Papier', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for prix field
            //
            $column = new NumberViewColumn('prix', 'prix', 'Prix', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for Date field
            //
            $column = new TextViewColumn('Date', 'Date', 'Date', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for RIG field
            //
            $column = new TextViewColumn('RIG', 'RIG', 'RIG', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for Facture field
            //
            $column = new TextViewColumn('Facture', 'Facture', 'Facture', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_etudiant', 'LA1', 'Id Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur', 'LA2', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_imprimante field
            //
            $column = new NumberViewColumn('id_imprimante', 'id_imprimante', 'Id Imprimante', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for montant_total field
            //
            $column = new NumberViewColumn('montant_total', 'montant_total', 'Montant Total', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for papier field
            //
            $column = new TextViewColumn('type_papier', 'LA3', 'Type Papier', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for ï»¿Nom_etudiant field
            //
            $column = new TextViewColumn('ï»¿Nom_etudiant', 'ï»¿Nom_etudiant', 'ï»¿Nom Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for Nom_prof field
            //
            $column = new TextViewColumn('Nom_prof', 'Nom_prof', 'Nom Prof', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for taille_largeur field
            //
            $column = new NumberViewColumn('taille_largeur', 'taille_largeur', 'Taille Largeur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for taille_longueur field
            //
            $column = new NumberViewColumn('taille_longueur', 'taille_longueur', 'Taille Longueur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for papier field
            //
            $column = new TextViewColumn('papier', 'papier', 'Papier', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for prix field
            //
            $column = new NumberViewColumn('prix', 'prix', 'Prix', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for Date field
            //
            $column = new TextViewColumn('Date', 'Date', 'Date', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for RIG field
            //
            $column = new TextViewColumn('RIG', 'RIG', 'RIG', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for Facture field
            //
            $column = new TextViewColumn('Facture', 'Facture', 'Facture', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_etudiant', 'LA1', 'Id Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur', 'LA2', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_imprimante field
            //
            $column = new NumberViewColumn('id_imprimante', 'id_imprimante', 'Id Imprimante', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for montant_total field
            //
            $column = new NumberViewColumn('montant_total', 'montant_total', 'Montant Total', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for papier field
            //
            $column = new TextViewColumn('type_papier', 'LA3', 'Type Papier', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for ï»¿Nom_etudiant field
            //
            $editor = new TextEdit('ï»¿nom_etudiant_edit');
            $editColumn = new CustomEditColumn('ï»¿Nom Etudiant', 'ï»¿Nom_etudiant', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for Nom_prof field
            //
            $editor = new TextEdit('nom_prof_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Nom Prof', 'Nom_prof', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for taille_largeur field
            //
            $editor = new TextEdit('taille_largeur_edit');
            $editColumn = new CustomEditColumn('Taille Largeur', 'taille_largeur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for taille_longueur field
            //
            $editor = new TextEdit('taille_longueur_edit');
            $editColumn = new CustomEditColumn('Taille Longueur', 'taille_longueur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for papier field
            //
            $editor = new TextEdit('papier_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Papier', 'papier', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for prix field
            //
            $editor = new TextEdit('prix_edit');
            $editColumn = new CustomEditColumn('Prix', 'prix', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for Date field
            //
            $editor = new TextEdit('date_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Date', 'Date', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for RIG field
            //
            $editor = new TextEdit('rig_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('RIG', 'RIG', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for Facture field
            //
            $editor = new TextEdit('facture_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Facture', 'Facture', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_etudiant field
            //
            $editor = new DynamicCombobox('id_etudiant_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Etudiant', 'id_etudiant', 'LA1', 'edit_administratifs_personnel01_administratifs_imprimante_poster_tmp01_id_etudiant_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_professeur field
            //
            $editor = new DynamicCombobox('id_professeur_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Professeur', 'id_professeur', 'LA2', 'edit_administratifs_personnel01_administratifs_imprimante_poster_tmp01_id_professeur_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for montant_total field
            //
            $editor = new TextEdit('montant_total_edit');
            $editColumn = new CustomEditColumn('Montant Total', 'montant_total', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for type_papier field
            //
            $editor = new DynamicCombobox('type_papier_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."imprimante_poster_papiers"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_papier', true, true),
                    new StringField('papier')
                )
            );
            $lookupDataset->setOrderByField('papier', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Type Papier', 'type_papier', 'LA3', 'edit_administratifs_personnel01_administratifs_imprimante_poster_tmp01_type_papier_search', $editor, $this->dataset, $lookupDataset, 'id_papier', 'papier', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for ï»¿Nom_etudiant field
            //
            $editor = new TextEdit('ï»¿nom_etudiant_edit');
            $editColumn = new CustomEditColumn('ï»¿Nom Etudiant', 'ï»¿Nom_etudiant', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for Nom_prof field
            //
            $editor = new TextEdit('nom_prof_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Nom Prof', 'Nom_prof', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for taille_largeur field
            //
            $editor = new TextEdit('taille_largeur_edit');
            $editColumn = new CustomEditColumn('Taille Largeur', 'taille_largeur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for taille_longueur field
            //
            $editor = new TextEdit('taille_longueur_edit');
            $editColumn = new CustomEditColumn('Taille Longueur', 'taille_longueur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for papier field
            //
            $editor = new TextEdit('papier_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Papier', 'papier', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for prix field
            //
            $editor = new TextEdit('prix_edit');
            $editColumn = new CustomEditColumn('Prix', 'prix', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for Date field
            //
            $editor = new TextEdit('date_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Date', 'Date', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for RIG field
            //
            $editor = new TextEdit('rig_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('RIG', 'RIG', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for Facture field
            //
            $editor = new TextEdit('facture_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Facture', 'Facture', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_etudiant field
            //
            $editor = new DynamicCombobox('id_etudiant_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Etudiant', 'id_etudiant', 'LA1', 'multi_edit_administratifs_personnel01_administratifs_imprimante_poster_tmp01_id_etudiant_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_professeur field
            //
            $editor = new DynamicCombobox('id_professeur_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Professeur', 'id_professeur', 'LA2', 'multi_edit_administratifs_personnel01_administratifs_imprimante_poster_tmp01_id_professeur_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for montant_total field
            //
            $editor = new TextEdit('montant_total_edit');
            $editColumn = new CustomEditColumn('Montant Total', 'montant_total', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for type_papier field
            //
            $editor = new DynamicCombobox('type_papier_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."imprimante_poster_papiers"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_papier', true, true),
                    new StringField('papier')
                )
            );
            $lookupDataset->setOrderByField('papier', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Type Papier', 'type_papier', 'LA3', 'multi_edit_administratifs_personnel01_administratifs_imprimante_poster_tmp01_type_papier_search', $editor, $this->dataset, $lookupDataset, 'id_papier', 'papier', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for ï»¿Nom_etudiant field
            //
            $editor = new TextEdit('ï»¿nom_etudiant_edit');
            $editColumn = new CustomEditColumn('ï»¿Nom Etudiant', 'ï»¿Nom_etudiant', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for Nom_prof field
            //
            $editor = new TextEdit('nom_prof_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Nom Prof', 'Nom_prof', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for taille_largeur field
            //
            $editor = new TextEdit('taille_largeur_edit');
            $editColumn = new CustomEditColumn('Taille Largeur', 'taille_largeur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for taille_longueur field
            //
            $editor = new TextEdit('taille_longueur_edit');
            $editColumn = new CustomEditColumn('Taille Longueur', 'taille_longueur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for papier field
            //
            $editor = new TextEdit('papier_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Papier', 'papier', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for prix field
            //
            $editor = new TextEdit('prix_edit');
            $editColumn = new CustomEditColumn('Prix', 'prix', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for Date field
            //
            $editor = new TextEdit('date_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Date', 'Date', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for RIG field
            //
            $editor = new TextEdit('rig_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('RIG', 'RIG', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for Facture field
            //
            $editor = new TextEdit('facture_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Facture', 'Facture', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_etudiant field
            //
            $editor = new DynamicCombobox('id_etudiant_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Etudiant', 'id_etudiant', 'LA1', 'insert_administratifs_personnel01_administratifs_imprimante_poster_tmp01_id_etudiant_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_professeur field
            //
            $editor = new DynamicCombobox('id_professeur_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Professeur', 'id_professeur', 'LA2', 'insert_administratifs_personnel01_administratifs_imprimante_poster_tmp01_id_professeur_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for montant_total field
            //
            $editor = new TextEdit('montant_total_edit');
            $editColumn = new CustomEditColumn('Montant Total', 'montant_total', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for type_papier field
            //
            $editor = new DynamicCombobox('type_papier_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."imprimante_poster_papiers"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_papier', true, true),
                    new StringField('papier')
                )
            );
            $lookupDataset->setOrderByField('papier', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Type Papier', 'type_papier', 'LA3', 'insert_administratifs_personnel01_administratifs_imprimante_poster_tmp01_type_papier_search', $editor, $this->dataset, $lookupDataset, 'id_papier', 'papier', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for ï»¿Nom_etudiant field
            //
            $column = new TextViewColumn('ï»¿Nom_etudiant', 'ï»¿Nom_etudiant', 'ï»¿Nom Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for Nom_prof field
            //
            $column = new TextViewColumn('Nom_prof', 'Nom_prof', 'Nom Prof', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for taille_largeur field
            //
            $column = new NumberViewColumn('taille_largeur', 'taille_largeur', 'Taille Largeur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for taille_longueur field
            //
            $column = new NumberViewColumn('taille_longueur', 'taille_longueur', 'Taille Longueur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for papier field
            //
            $column = new TextViewColumn('papier', 'papier', 'Papier', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for prix field
            //
            $column = new NumberViewColumn('prix', 'prix', 'Prix', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for Date field
            //
            $column = new TextViewColumn('Date', 'Date', 'Date', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for RIG field
            //
            $column = new TextViewColumn('RIG', 'RIG', 'RIG', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for Facture field
            //
            $column = new TextViewColumn('Facture', 'Facture', 'Facture', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_etudiant', 'LA1', 'Id Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur', 'LA2', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_imprimante field
            //
            $column = new NumberViewColumn('id_imprimante', 'id_imprimante', 'Id Imprimante', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for montant_total field
            //
            $column = new NumberViewColumn('montant_total', 'montant_total', 'Montant Total', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for papier field
            //
            $column = new TextViewColumn('type_papier', 'LA3', 'Type Papier', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for ï»¿Nom_etudiant field
            //
            $column = new TextViewColumn('ï»¿Nom_etudiant', 'ï»¿Nom_etudiant', 'ï»¿Nom Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for Nom_prof field
            //
            $column = new TextViewColumn('Nom_prof', 'Nom_prof', 'Nom Prof', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for taille_largeur field
            //
            $column = new NumberViewColumn('taille_largeur', 'taille_largeur', 'Taille Largeur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for taille_longueur field
            //
            $column = new NumberViewColumn('taille_longueur', 'taille_longueur', 'Taille Longueur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for papier field
            //
            $column = new TextViewColumn('papier', 'papier', 'Papier', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for prix field
            //
            $column = new NumberViewColumn('prix', 'prix', 'Prix', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for Date field
            //
            $column = new TextViewColumn('Date', 'Date', 'Date', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for RIG field
            //
            $column = new TextViewColumn('RIG', 'RIG', 'RIG', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for Facture field
            //
            $column = new TextViewColumn('Facture', 'Facture', 'Facture', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_etudiant', 'LA1', 'Id Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur', 'LA2', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_imprimante field
            //
            $column = new NumberViewColumn('id_imprimante', 'id_imprimante', 'Id Imprimante', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for montant_total field
            //
            $column = new NumberViewColumn('montant_total', 'montant_total', 'Montant Total', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for papier field
            //
            $column = new TextViewColumn('type_papier', 'LA3', 'Type Papier', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for ï»¿Nom_etudiant field
            //
            $column = new TextViewColumn('ï»¿Nom_etudiant', 'ï»¿Nom_etudiant', 'ï»¿Nom Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for Nom_prof field
            //
            $column = new TextViewColumn('Nom_prof', 'Nom_prof', 'Nom Prof', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for taille_largeur field
            //
            $column = new NumberViewColumn('taille_largeur', 'taille_largeur', 'Taille Largeur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for taille_longueur field
            //
            $column = new NumberViewColumn('taille_longueur', 'taille_longueur', 'Taille Longueur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for papier field
            //
            $column = new TextViewColumn('papier', 'papier', 'Papier', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for prix field
            //
            $column = new NumberViewColumn('prix', 'prix', 'Prix', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for Date field
            //
            $column = new TextViewColumn('Date', 'Date', 'Date', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for RIG field
            //
            $column = new TextViewColumn('RIG', 'RIG', 'RIG', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for Facture field
            //
            $column = new TextViewColumn('Facture', 'Facture', 'Facture', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_etudiant', 'LA1', 'Id Etudiant', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur', 'LA2', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for montant_total field
            //
            $column = new NumberViewColumn('montant_total', 'montant_total', 'Montant Total', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for papier field
            //
            $column = new TextViewColumn('type_papier', 'LA3', 'Type Papier', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(true);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel01_administratifs_imprimante_poster_tmp01_id_etudiant_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel01_administratifs_imprimante_poster_tmp01_id_professeur_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."imprimante_poster_papiers"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_papier', true, true),
                    new StringField('papier')
                )
            );
            $lookupDataset->setOrderByField('papier', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel01_administratifs_imprimante_poster_tmp01_type_papier_search', 'id_papier', 'papier', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel01_administratifs_imprimante_poster_tmp01_id_etudiant_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel01_administratifs_imprimante_poster_tmp01_id_professeur_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."imprimante_poster_papiers"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_papier', true, true),
                    new StringField('papier')
                )
            );
            $lookupDataset->setOrderByField('papier', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel01_administratifs_imprimante_poster_tmp01_type_papier_search', 'id_papier', 'papier', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel01_administratifs_imprimante_poster_tmp01_id_etudiant_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel01_administratifs_imprimante_poster_tmp01_id_professeur_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."imprimante_poster_papiers"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_papier', true, true),
                    new StringField('papier')
                )
            );
            $lookupDataset->setOrderByField('papier', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel01_administratifs_imprimante_poster_tmp01_type_papier_search', 'id_papier', 'papier', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel01_administratifs_imprimante_poster_tmp01_id_etudiant_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel01_administratifs_imprimante_poster_tmp01_id_professeur_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."imprimante_poster_papiers"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_papier', true, true),
                    new StringField('papier')
                )
            );
            $lookupDataset->setOrderByField('papier', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel01_administratifs_imprimante_poster_tmp01_type_papier_search', 'id_papier', 'papier', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }
    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class administratifs_personnel01_administratifs_journalPage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Journal');
            $this->SetMenuLabel('Journal');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."journal"');
            $this->dataset->addFields(
                array(
                    new IntegerField('id_journal', true, true, true),
                    new DateField('date'),
                    new StringField('description'),
                    new IntegerField('id_pers')
                )
            );
            $this->dataset->AddLookupField('id_pers', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA1', 'LT1'), 'LT1');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'id_journal', 'id_journal', 'Id Journal'),
                new FilterColumn($this->dataset, 'date', 'date', 'Date'),
                new FilterColumn($this->dataset, 'description', 'description', 'Description'),
                new FilterColumn($this->dataset, 'id_pers', 'LA1', 'Id Pers')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['id_journal'])
                ->addColumn($columns['date'])
                ->addColumn($columns['description'])
                ->addColumn($columns['id_pers']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('date')
                ->setOptionsFor('id_pers');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('id_journal_edit');
            
            $filterBuilder->addColumn(
                $columns['id_journal'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('date_edit', false, 'Y-m-d');
            
            $filterBuilder->addColumn(
                $columns['date'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('description');
            
            $filterBuilder->addColumn(
                $columns['description'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_pers_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel01_administratifs_journal_id_pers_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_pers', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel01_administratifs_journal_id_pers_search');
            
            $text_editor = new TextEdit('id_pers');
            
            $filterBuilder->addColumn(
                $columns['id_pers'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for id_journal field
            //
            $column = new NumberViewColumn('id_journal', 'id_journal', 'Id Journal', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date field
            //
            $column = new DateTimeViewColumn('date', 'date', 'Date', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers', 'LA1', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for id_journal field
            //
            $column = new NumberViewColumn('id_journal', 'id_journal', 'Id Journal', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date field
            //
            $column = new DateTimeViewColumn('date', 'date', 'Date', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers', 'LA1', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for date field
            //
            $editor = new DateTimeEdit('date_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Date', 'date', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for description field
            //
            $editor = new TextAreaEdit('description_edit', 50, 8);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_pers field
            //
            $editor = new DynamicCombobox('id_pers_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Pers', 'id_pers', 'LA1', 'edit_administratifs_personnel01_administratifs_journal_id_pers_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for date field
            //
            $editor = new DateTimeEdit('date_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Date', 'date', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for description field
            //
            $editor = new TextAreaEdit('description_edit', 50, 8);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_pers field
            //
            $editor = new DynamicCombobox('id_pers_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Pers', 'id_pers', 'LA1', 'multi_edit_administratifs_personnel01_administratifs_journal_id_pers_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for date field
            //
            $editor = new DateTimeEdit('date_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Date', 'date', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for description field
            //
            $editor = new TextAreaEdit('description_edit', 50, 8);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_pers field
            //
            $editor = new DynamicCombobox('id_pers_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Pers', 'id_pers', 'LA1', 'insert_administratifs_personnel01_administratifs_journal_id_pers_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for id_journal field
            //
            $column = new NumberViewColumn('id_journal', 'id_journal', 'Id Journal', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for date field
            //
            $column = new DateTimeViewColumn('date', 'date', 'Date', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddPrintColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers', 'LA1', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for id_journal field
            //
            $column = new NumberViewColumn('id_journal', 'id_journal', 'Id Journal', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for date field
            //
            $column = new DateTimeViewColumn('date', 'date', 'Date', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddExportColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers', 'LA1', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for date field
            //
            $column = new DateTimeViewColumn('date', 'date', 'Date', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddCompareColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers', 'LA1', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(true);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel01_administratifs_journal_id_pers_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel01_administratifs_journal_id_pers_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel01_administratifs_journal_id_pers_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel01_administratifs_journal_id_pers_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }
    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class administratifs_personnel01_administratifs_personnelPage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Personnel');
            $this->SetMenuLabel('Personnel');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $this->dataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $this->dataset->AddLookupField('id_loc', 'administratifs.locals', new IntegerField('id_loc'), new StringField('no_loc', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('id_statut', 'administratifs.statut', new IntegerField('id_statut'), new StringField('nom_statut', false, false, false, false, 'LA2', 'LT2'), 'LT2');
            $this->dataset->AddLookupField('id_groupe', 'administratifs.groupe', new IntegerField('id_groupe'), new StringField('nom_groupe', false, false, false, false, 'LA3', 'LT3'), 'LT3');
            $this->dataset->AddLookupField('num_sigle', 'administratifs.sigle', new IntegerField('num_sigle'), new StringField('sigle_programme', false, false, false, false, 'LA4', 'LT4'), 'LT4');
            $this->dataset->AddLookupField('id_prof_reponsables', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA5', 'LT5'), 'LT5');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'nom', 'nom', 'Nom'),
                new FilterColumn($this->dataset, 'prenom', 'prenom', 'Prenom'),
                new FilterColumn($this->dataset, 'no_tel_trav', 'no_tel_trav', 'No Tel Trav'),
                new FilterColumn($this->dataset, 'no_tel_mais', 'no_tel_mais', 'No Tel Mais'),
                new FilterColumn($this->dataset, 'id_loc', 'LA1', 'Id Loc'),
                new FilterColumn($this->dataset, 'id_statut', 'LA2', 'Id Statut'),
                new FilterColumn($this->dataset, 'id_groupe', 'LA3', 'Id Groupe'),
                new FilterColumn($this->dataset, 'sujets', 'sujets', 'Sujets'),
                new FilterColumn($this->dataset, 'id_pers', 'id_pers', 'Id Pers'),
                new FilterColumn($this->dataset, 'num_sigle', 'LA4', 'Num Sigle'),
                new FilterColumn($this->dataset, 'courriel', 'courriel', 'Courriel'),
                new FilterColumn($this->dataset, 'code_perm', 'code_perm', 'Code Perm'),
                new FilterColumn($this->dataset, 'actif', 'actif', 'Actif'),
                new FilterColumn($this->dataset, 'codems', 'codems', 'Codems'),
                new FilterColumn($this->dataset, 'id_prof_reponsables', 'LA5', 'Id Prof Reponsables')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['nom'])
                ->addColumn($columns['prenom'])
                ->addColumn($columns['no_tel_trav'])
                ->addColumn($columns['no_tel_mais'])
                ->addColumn($columns['id_loc'])
                ->addColumn($columns['id_statut'])
                ->addColumn($columns['id_groupe'])
                ->addColumn($columns['sujets'])
                ->addColumn($columns['id_pers'])
                ->addColumn($columns['num_sigle'])
                ->addColumn($columns['courriel'])
                ->addColumn($columns['code_perm'])
                ->addColumn($columns['actif'])
                ->addColumn($columns['codems'])
                ->addColumn($columns['id_prof_reponsables']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_loc')
                ->setOptionsFor('id_statut')
                ->setOptionsFor('id_groupe')
                ->setOptionsFor('num_sigle')
                ->setOptionsFor('id_prof_reponsables');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('nom_edit');
            
            $filterBuilder->addColumn(
                $columns['nom'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('prenom_edit');
            $main_editor->SetMaxLength(30);
            
            $filterBuilder->addColumn(
                $columns['prenom'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_tel_trav');
            
            $filterBuilder->addColumn(
                $columns['no_tel_trav'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_tel_mais');
            
            $filterBuilder->addColumn(
                $columns['no_tel_mais'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel01_administratifs_personnel_id_loc_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_loc', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel01_administratifs_personnel_id_loc_search');
            
            $text_editor = new TextEdit('id_loc');
            
            $filterBuilder->addColumn(
                $columns['id_loc'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_statut_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel01_administratifs_personnel_id_statut_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_statut', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel01_administratifs_personnel_id_statut_search');
            
            $text_editor = new TextEdit('id_statut');
            
            $filterBuilder->addColumn(
                $columns['id_statut'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_groupe_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel01_administratifs_personnel_id_groupe_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_groupe', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel01_administratifs_personnel_id_groupe_search');
            
            $text_editor = new TextEdit('id_groupe');
            
            $filterBuilder->addColumn(
                $columns['id_groupe'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('sujets');
            
            $filterBuilder->addColumn(
                $columns['sujets'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_pers_edit');
            
            $filterBuilder->addColumn(
                $columns['id_pers'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('num_sigle_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel01_administratifs_personnel_num_sigle_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('num_sigle', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel01_administratifs_personnel_num_sigle_search');
            
            $filterBuilder->addColumn(
                $columns['num_sigle'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('courriel');
            
            $filterBuilder->addColumn(
                $columns['courriel'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('code_perm_edit');
            $main_editor->SetMaxLength(30);
            
            $filterBuilder->addColumn(
                $columns['code_perm'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('actif_edit');
            
            $filterBuilder->addColumn(
                $columns['actif'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('codems');
            
            $filterBuilder->addColumn(
                $columns['codems'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_prof_reponsables_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel01_administratifs_personnel_id_prof_reponsables_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_prof_reponsables', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel01_administratifs_personnel_id_prof_reponsables_search');
            
            $text_editor = new TextEdit('id_prof_reponsables');
            
            $filterBuilder->addColumn(
                $columns['id_prof_reponsables'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('nom', 'nom', 'Nom', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for prenom field
            //
            $column = new TextViewColumn('prenom', 'prenom', 'Prenom', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_tel_trav field
            //
            $column = new TextViewColumn('no_tel_trav', 'no_tel_trav', 'No Tel Trav', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_tel_mais field
            //
            $column = new TextViewColumn('no_tel_mais', 'no_tel_mais', 'No Tel Mais', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom_statut field
            //
            $column = new TextViewColumn('id_statut', 'LA2', 'Id Statut', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'LA3', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for sujets field
            //
            $column = new TextViewColumn('sujets', 'sujets', 'Sujets', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for sigle_programme field
            //
            $column = new NumberViewColumn('num_sigle', 'LA4', 'Num Sigle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for courriel field
            //
            $column = new TextViewColumn('courriel', 'courriel', 'Courriel', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for code_perm field
            //
            $column = new TextViewColumn('code_perm', 'code_perm', 'Code Perm', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for actif field
            //
            $column = new NumberViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for codems field
            //
            $column = new TextViewColumn('codems', 'codems', 'Codems', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_prof_reponsables', 'LA5', 'Id Prof Reponsables', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('nom', 'nom', 'Nom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for prenom field
            //
            $column = new TextViewColumn('prenom', 'prenom', 'Prenom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_tel_trav field
            //
            $column = new TextViewColumn('no_tel_trav', 'no_tel_trav', 'No Tel Trav', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_tel_mais field
            //
            $column = new TextViewColumn('no_tel_mais', 'no_tel_mais', 'No Tel Mais', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom_statut field
            //
            $column = new TextViewColumn('id_statut', 'LA2', 'Id Statut', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'LA3', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for sujets field
            //
            $column = new TextViewColumn('sujets', 'sujets', 'Sujets', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for sigle_programme field
            //
            $column = new NumberViewColumn('num_sigle', 'LA4', 'Num Sigle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for courriel field
            //
            $column = new TextViewColumn('courriel', 'courriel', 'Courriel', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for code_perm field
            //
            $column = new TextViewColumn('code_perm', 'code_perm', 'Code Perm', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for actif field
            //
            $column = new NumberViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for codems field
            //
            $column = new TextViewColumn('codems', 'codems', 'Codems', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_prof_reponsables', 'LA5', 'Id Prof Reponsables', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for nom field
            //
            $editor = new TextEdit('nom_edit');
            $editColumn = new CustomEditColumn('Nom', 'nom', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for prenom field
            //
            $editor = new TextEdit('prenom_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Prenom', 'prenom', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_tel_trav field
            //
            $editor = new TextAreaEdit('no_tel_trav_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Tel Trav', 'no_tel_trav', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_tel_mais field
            //
            $editor = new TextAreaEdit('no_tel_mais_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Tel Mais', 'no_tel_mais', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'edit_administratifs_personnel01_administratifs_personnel_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_statut field
            //
            $editor = new DynamicCombobox('id_statut_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."statut"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_statut', true, true, true),
                    new StringField('nom_statut', true)
                )
            );
            $lookupDataset->setOrderByField('nom_statut', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Statut', 'id_statut', 'LA2', 'edit_administratifs_personnel01_administratifs_personnel_id_statut_search', $editor, $this->dataset, $lookupDataset, 'id_statut', 'nom_statut', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_groupe field
            //
            $editor = new DynamicCombobox('id_groupe_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Groupe', 'id_groupe', 'LA3', 'edit_administratifs_personnel01_administratifs_personnel_id_groupe_search', $editor, $this->dataset, $lookupDataset, 'id_groupe', 'nom_groupe', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for sujets field
            //
            $editor = new TextAreaEdit('sujets_edit', 50, 8);
            $editColumn = new CustomEditColumn('Sujets', 'sujets', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for num_sigle field
            //
            $editor = new DynamicCombobox('num_sigle_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Num Sigle', 'num_sigle', 'LA4', 'edit_administratifs_personnel01_administratifs_personnel_num_sigle_search', $editor, $this->dataset, $lookupDataset, 'num_sigle', 'sigle_programme', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for courriel field
            //
            $editor = new TextAreaEdit('courriel_edit', 50, 8);
            $editColumn = new CustomEditColumn('Courriel', 'courriel', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for code_perm field
            //
            $editor = new TextEdit('code_perm_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Code Perm', 'code_perm', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for actif field
            //
            $editor = new TextEdit('actif_edit');
            $editColumn = new CustomEditColumn('Actif', 'actif', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for codems field
            //
            $editor = new TextAreaEdit('codems_edit', 50, 8);
            $editColumn = new CustomEditColumn('Codems', 'codems', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_prof_reponsables field
            //
            $editor = new DynamicCombobox('id_prof_reponsables_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Prof Reponsables', 'id_prof_reponsables', 'LA5', 'edit_administratifs_personnel01_administratifs_personnel_id_prof_reponsables_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for nom field
            //
            $editor = new TextEdit('nom_edit');
            $editColumn = new CustomEditColumn('Nom', 'nom', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for prenom field
            //
            $editor = new TextEdit('prenom_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Prenom', 'prenom', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_tel_trav field
            //
            $editor = new TextAreaEdit('no_tel_trav_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Tel Trav', 'no_tel_trav', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_tel_mais field
            //
            $editor = new TextAreaEdit('no_tel_mais_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Tel Mais', 'no_tel_mais', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'multi_edit_administratifs_personnel01_administratifs_personnel_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_statut field
            //
            $editor = new DynamicCombobox('id_statut_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."statut"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_statut', true, true, true),
                    new StringField('nom_statut', true)
                )
            );
            $lookupDataset->setOrderByField('nom_statut', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Statut', 'id_statut', 'LA2', 'multi_edit_administratifs_personnel01_administratifs_personnel_id_statut_search', $editor, $this->dataset, $lookupDataset, 'id_statut', 'nom_statut', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_groupe field
            //
            $editor = new DynamicCombobox('id_groupe_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Groupe', 'id_groupe', 'LA3', 'multi_edit_administratifs_personnel01_administratifs_personnel_id_groupe_search', $editor, $this->dataset, $lookupDataset, 'id_groupe', 'nom_groupe', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for sujets field
            //
            $editor = new TextAreaEdit('sujets_edit', 50, 8);
            $editColumn = new CustomEditColumn('Sujets', 'sujets', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for num_sigle field
            //
            $editor = new DynamicCombobox('num_sigle_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Num Sigle', 'num_sigle', 'LA4', 'multi_edit_administratifs_personnel01_administratifs_personnel_num_sigle_search', $editor, $this->dataset, $lookupDataset, 'num_sigle', 'sigle_programme', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for courriel field
            //
            $editor = new TextAreaEdit('courriel_edit', 50, 8);
            $editColumn = new CustomEditColumn('Courriel', 'courriel', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for code_perm field
            //
            $editor = new TextEdit('code_perm_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Code Perm', 'code_perm', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for actif field
            //
            $editor = new TextEdit('actif_edit');
            $editColumn = new CustomEditColumn('Actif', 'actif', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for codems field
            //
            $editor = new TextAreaEdit('codems_edit', 50, 8);
            $editColumn = new CustomEditColumn('Codems', 'codems', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_prof_reponsables field
            //
            $editor = new DynamicCombobox('id_prof_reponsables_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Prof Reponsables', 'id_prof_reponsables', 'LA5', 'multi_edit_administratifs_personnel01_administratifs_personnel_id_prof_reponsables_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for nom field
            //
            $editor = new TextEdit('nom_edit');
            $editColumn = new CustomEditColumn('Nom', 'nom', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for prenom field
            //
            $editor = new TextEdit('prenom_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Prenom', 'prenom', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_tel_trav field
            //
            $editor = new TextAreaEdit('no_tel_trav_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Tel Trav', 'no_tel_trav', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_tel_mais field
            //
            $editor = new TextAreaEdit('no_tel_mais_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Tel Mais', 'no_tel_mais', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'insert_administratifs_personnel01_administratifs_personnel_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_statut field
            //
            $editor = new DynamicCombobox('id_statut_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."statut"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_statut', true, true, true),
                    new StringField('nom_statut', true)
                )
            );
            $lookupDataset->setOrderByField('nom_statut', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Statut', 'id_statut', 'LA2', 'insert_administratifs_personnel01_administratifs_personnel_id_statut_search', $editor, $this->dataset, $lookupDataset, 'id_statut', 'nom_statut', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_groupe field
            //
            $editor = new DynamicCombobox('id_groupe_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Groupe', 'id_groupe', 'LA3', 'insert_administratifs_personnel01_administratifs_personnel_id_groupe_search', $editor, $this->dataset, $lookupDataset, 'id_groupe', 'nom_groupe', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for sujets field
            //
            $editor = new TextAreaEdit('sujets_edit', 50, 8);
            $editColumn = new CustomEditColumn('Sujets', 'sujets', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for num_sigle field
            //
            $editor = new DynamicCombobox('num_sigle_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Num Sigle', 'num_sigle', 'LA4', 'insert_administratifs_personnel01_administratifs_personnel_num_sigle_search', $editor, $this->dataset, $lookupDataset, 'num_sigle', 'sigle_programme', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for courriel field
            //
            $editor = new TextAreaEdit('courriel_edit', 50, 8);
            $editColumn = new CustomEditColumn('Courriel', 'courriel', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for code_perm field
            //
            $editor = new TextEdit('code_perm_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Code Perm', 'code_perm', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for actif field
            //
            $editor = new TextEdit('actif_edit');
            $editColumn = new CustomEditColumn('Actif', 'actif', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for codems field
            //
            $editor = new TextAreaEdit('codems_edit', 50, 8);
            $editColumn = new CustomEditColumn('Codems', 'codems', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_prof_reponsables field
            //
            $editor = new DynamicCombobox('id_prof_reponsables_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Prof Reponsables', 'id_prof_reponsables', 'LA5', 'insert_administratifs_personnel01_administratifs_personnel_id_prof_reponsables_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('nom', 'nom', 'Nom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for prenom field
            //
            $column = new TextViewColumn('prenom', 'prenom', 'Prenom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_tel_trav field
            //
            $column = new TextViewColumn('no_tel_trav', 'no_tel_trav', 'No Tel Trav', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_tel_mais field
            //
            $column = new TextViewColumn('no_tel_mais', 'no_tel_mais', 'No Tel Mais', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom_statut field
            //
            $column = new TextViewColumn('id_statut', 'LA2', 'Id Statut', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'LA3', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for sujets field
            //
            $column = new TextViewColumn('sujets', 'sujets', 'Sujets', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for sigle_programme field
            //
            $column = new NumberViewColumn('num_sigle', 'LA4', 'Num Sigle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for courriel field
            //
            $column = new TextViewColumn('courriel', 'courriel', 'Courriel', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for code_perm field
            //
            $column = new TextViewColumn('code_perm', 'code_perm', 'Code Perm', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for actif field
            //
            $column = new NumberViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for codems field
            //
            $column = new TextViewColumn('codems', 'codems', 'Codems', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_prof_reponsables', 'LA5', 'Id Prof Reponsables', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('nom', 'nom', 'Nom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for prenom field
            //
            $column = new TextViewColumn('prenom', 'prenom', 'Prenom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_tel_trav field
            //
            $column = new TextViewColumn('no_tel_trav', 'no_tel_trav', 'No Tel Trav', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_tel_mais field
            //
            $column = new TextViewColumn('no_tel_mais', 'no_tel_mais', 'No Tel Mais', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom_statut field
            //
            $column = new TextViewColumn('id_statut', 'LA2', 'Id Statut', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'LA3', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for sujets field
            //
            $column = new TextViewColumn('sujets', 'sujets', 'Sujets', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for sigle_programme field
            //
            $column = new NumberViewColumn('num_sigle', 'LA4', 'Num Sigle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for courriel field
            //
            $column = new TextViewColumn('courriel', 'courriel', 'Courriel', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for code_perm field
            //
            $column = new TextViewColumn('code_perm', 'code_perm', 'Code Perm', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for actif field
            //
            $column = new NumberViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for codems field
            //
            $column = new TextViewColumn('codems', 'codems', 'Codems', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_prof_reponsables', 'LA5', 'Id Prof Reponsables', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('nom', 'nom', 'Nom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for prenom field
            //
            $column = new TextViewColumn('prenom', 'prenom', 'Prenom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_tel_trav field
            //
            $column = new TextViewColumn('no_tel_trav', 'no_tel_trav', 'No Tel Trav', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_tel_mais field
            //
            $column = new TextViewColumn('no_tel_mais', 'no_tel_mais', 'No Tel Mais', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom_statut field
            //
            $column = new TextViewColumn('id_statut', 'LA2', 'Id Statut', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'LA3', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for sujets field
            //
            $column = new TextViewColumn('sujets', 'sujets', 'Sujets', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for sigle_programme field
            //
            $column = new NumberViewColumn('num_sigle', 'LA4', 'Num Sigle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for courriel field
            //
            $column = new TextViewColumn('courriel', 'courriel', 'Courriel', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for code_perm field
            //
            $column = new TextViewColumn('code_perm', 'code_perm', 'Code Perm', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for actif field
            //
            $column = new NumberViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for codems field
            //
            $column = new TextViewColumn('codems', 'codems', 'Codems', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_prof_reponsables', 'LA5', 'Id Prof Reponsables', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(true);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel01_administratifs_personnel_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."statut"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_statut', true, true, true),
                    new StringField('nom_statut', true)
                )
            );
            $lookupDataset->setOrderByField('nom_statut', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel01_administratifs_personnel_id_statut_search', 'id_statut', 'nom_statut', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel01_administratifs_personnel_id_groupe_search', 'id_groupe', 'nom_groupe', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel01_administratifs_personnel_num_sigle_search', 'num_sigle', 'sigle_programme', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel01_administratifs_personnel_id_prof_reponsables_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel01_administratifs_personnel_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."statut"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_statut', true, true, true),
                    new StringField('nom_statut', true)
                )
            );
            $lookupDataset->setOrderByField('nom_statut', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel01_administratifs_personnel_id_statut_search', 'id_statut', 'nom_statut', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel01_administratifs_personnel_id_groupe_search', 'id_groupe', 'nom_groupe', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel01_administratifs_personnel_id_groupe_search', 'id_groupe', 'nom_groupe', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel01_administratifs_personnel_num_sigle_search', 'num_sigle', 'sigle_programme', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel01_administratifs_personnel_num_sigle_search', 'num_sigle', 'sigle_programme', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel01_administratifs_personnel_id_prof_reponsables_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel01_administratifs_personnel_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."statut"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_statut', true, true, true),
                    new StringField('nom_statut', true)
                )
            );
            $lookupDataset->setOrderByField('nom_statut', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel01_administratifs_personnel_id_statut_search', 'id_statut', 'nom_statut', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel01_administratifs_personnel_id_groupe_search', 'id_groupe', 'nom_groupe', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel01_administratifs_personnel_num_sigle_search', 'num_sigle', 'sigle_programme', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel01_administratifs_personnel_id_prof_reponsables_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel01_administratifs_personnel_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."statut"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_statut', true, true, true),
                    new StringField('nom_statut', true)
                )
            );
            $lookupDataset->setOrderByField('nom_statut', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel01_administratifs_personnel_id_statut_search', 'id_statut', 'nom_statut', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel01_administratifs_personnel_id_groupe_search', 'id_groupe', 'nom_groupe', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel01_administratifs_personnel_num_sigle_search', 'num_sigle', 'sigle_programme', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel01_administratifs_personnel_id_prof_reponsables_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }
    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class administratifs_personnel01_cle_departement_scta_cle_empruntPage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Scta Cle Emprunt');
            $this->SetMenuLabel('Scta Cle Emprunt');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"cle_departement"."scta_cle_emprunt"');
            $this->dataset->addFields(
                array(
                    new StringField('actif'),
                    new DateTimeField('date_d_emprunt'),
                    new DateTimeField('date_de_retour'),
                    new IntegerField('depot'),
                    new IntegerField('remboursement_du_depot'),
                    new StringField('rubrique'),
                    new StringField('rubrique_2'),
                    new StringField('utilisateur_note'),
                    new IntegerField('id_cle'),
                    new IntegerField('id_pers'),
                    new IntegerField('id_cle_emprunt', true, true, true),
                    new IntegerField('id_grp_f_sci'),
                    new DateField('date_due'),
                    new IntegerField('archivage'),
                    new IntegerField('num_bureau'),
                    new StringField('num_formulaire'),
                    new StringField('otrs')
                )
            );
            $this->dataset->AddLookupField('id_cle', 'cle_departement.cle_cles', new IntegerField('id'), new IntegerField('boite', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('id_pers', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA2', 'LT2'), 'LT2');
            $this->dataset->AddLookupField('id_grp_f_sci', 'administratifs.grp_faculte_sciences', new IntegerField('id_grp_f_sci'), new StringField('description', false, false, false, false, 'LA3', 'LT3'), 'LT3');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'actif', 'actif', 'Actif'),
                new FilterColumn($this->dataset, 'date_d_emprunt', 'date_d_emprunt', 'Date D Emprunt'),
                new FilterColumn($this->dataset, 'date_de_retour', 'date_de_retour', 'Date De Retour'),
                new FilterColumn($this->dataset, 'depot', 'depot', 'Depot'),
                new FilterColumn($this->dataset, 'remboursement_du_depot', 'remboursement_du_depot', 'Remboursement Du Depot'),
                new FilterColumn($this->dataset, 'rubrique', 'rubrique', 'Rubrique'),
                new FilterColumn($this->dataset, 'rubrique_2', 'rubrique_2', 'Rubrique 2'),
                new FilterColumn($this->dataset, 'utilisateur_note', 'utilisateur_note', 'Utilisateur Note'),
                new FilterColumn($this->dataset, 'id_cle', 'LA1', 'Id Cle'),
                new FilterColumn($this->dataset, 'id_pers', 'LA2', 'Id Pers'),
                new FilterColumn($this->dataset, 'id_cle_emprunt', 'id_cle_emprunt', 'Id Cle Emprunt'),
                new FilterColumn($this->dataset, 'id_grp_f_sci', 'LA3', 'Id Grp F Sci'),
                new FilterColumn($this->dataset, 'date_due', 'date_due', 'Date Due'),
                new FilterColumn($this->dataset, 'archivage', 'archivage', 'Archivage'),
                new FilterColumn($this->dataset, 'num_bureau', 'num_bureau', 'Num Bureau'),
                new FilterColumn($this->dataset, 'num_formulaire', 'num_formulaire', 'Num Formulaire'),
                new FilterColumn($this->dataset, 'otrs', 'otrs', 'Otrs')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['actif'])
                ->addColumn($columns['date_d_emprunt'])
                ->addColumn($columns['date_de_retour'])
                ->addColumn($columns['depot'])
                ->addColumn($columns['remboursement_du_depot'])
                ->addColumn($columns['rubrique'])
                ->addColumn($columns['rubrique_2'])
                ->addColumn($columns['utilisateur_note'])
                ->addColumn($columns['id_cle'])
                ->addColumn($columns['id_pers'])
                ->addColumn($columns['id_cle_emprunt'])
                ->addColumn($columns['id_grp_f_sci'])
                ->addColumn($columns['date_due'])
                ->addColumn($columns['archivage'])
                ->addColumn($columns['num_bureau'])
                ->addColumn($columns['num_formulaire'])
                ->addColumn($columns['otrs']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('date_d_emprunt')
                ->setOptionsFor('date_de_retour')
                ->setOptionsFor('id_cle')
                ->setOptionsFor('id_pers')
                ->setOptionsFor('id_grp_f_sci')
                ->setOptionsFor('date_due');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('actif_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['actif'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('date_d_emprunt_edit', false, 'Y-m-d H:i:s');
            
            $filterBuilder->addColumn(
                $columns['date_d_emprunt'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('date_de_retour_edit', false, 'Y-m-d H:i:s');
            
            $filterBuilder->addColumn(
                $columns['date_de_retour'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('depot_edit');
            
            $filterBuilder->addColumn(
                $columns['depot'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('remboursement_du_depot_edit');
            
            $filterBuilder->addColumn(
                $columns['remboursement_du_depot'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('rubrique_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['rubrique'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('rubrique_2_edit');
            
            $filterBuilder->addColumn(
                $columns['rubrique_2'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('utilisateur_note');
            
            $filterBuilder->addColumn(
                $columns['utilisateur_note'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_cle_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel01_cle_departement_scta_cle_emprunt_id_cle_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_cle', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel01_cle_departement_scta_cle_emprunt_id_cle_search');
            
            $filterBuilder->addColumn(
                $columns['id_cle'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_pers_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel01_cle_departement_scta_cle_emprunt_id_pers_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_pers', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel01_cle_departement_scta_cle_emprunt_id_pers_search');
            
            $text_editor = new TextEdit('id_pers');
            
            $filterBuilder->addColumn(
                $columns['id_pers'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_cle_emprunt_edit');
            
            $filterBuilder->addColumn(
                $columns['id_cle_emprunt'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_grp_f_sci_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel01_cle_departement_scta_cle_emprunt_id_grp_f_sci_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_grp_f_sci', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel01_cle_departement_scta_cle_emprunt_id_grp_f_sci_search');
            
            $text_editor = new TextEdit('id_grp_f_sci');
            
            $filterBuilder->addColumn(
                $columns['id_grp_f_sci'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('date_due_edit', false, 'Y-m-d');
            
            $filterBuilder->addColumn(
                $columns['date_due'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('archivage_edit');
            
            $filterBuilder->addColumn(
                $columns['archivage'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('num_bureau_edit');
            
            $filterBuilder->addColumn(
                $columns['num_bureau'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('num_formulaire_edit');
            
            $filterBuilder->addColumn(
                $columns['num_formulaire'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('otrs');
            
            $filterBuilder->addColumn(
                $columns['otrs'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for actif field
            //
            $column = new TextViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_d_emprunt field
            //
            $column = new DateTimeViewColumn('date_d_emprunt', 'date_d_emprunt', 'Date D Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Date De Retour', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for depot field
            //
            $column = new NumberViewColumn('depot', 'depot', 'Depot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for remboursement_du_depot field
            //
            $column = new NumberViewColumn('remboursement_du_depot', 'remboursement_du_depot', 'Remboursement Du Depot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for rubrique field
            //
            $column = new TextViewColumn('rubrique', 'rubrique', 'Rubrique', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for rubrique_2 field
            //
            $column = new TextViewColumn('rubrique_2', 'rubrique_2', 'Rubrique 2', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for utilisateur_note field
            //
            $column = new TextViewColumn('utilisateur_note', 'utilisateur_note', 'Utilisateur Note', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for boite field
            //
            $column = new NumberViewColumn('id_cle', 'LA1', 'Id Cle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers', 'LA2', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_cle_emprunt field
            //
            $column = new NumberViewColumn('id_cle_emprunt', 'id_cle_emprunt', 'Id Cle Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for description field
            //
            $column = new TextViewColumn('id_grp_f_sci', 'LA3', 'Id Grp F Sci', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_due field
            //
            $column = new DateTimeViewColumn('date_due', 'date_due', 'Date Due', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for archivage field
            //
            $column = new NumberViewColumn('archivage', 'archivage', 'Archivage', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for num_bureau field
            //
            $column = new NumberViewColumn('num_bureau', 'num_bureau', 'Num Bureau', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for num_formulaire field
            //
            $column = new NumberViewColumn('num_formulaire', 'num_formulaire', 'Num Formulaire', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for otrs field
            //
            $column = new TextViewColumn('otrs', 'otrs', 'Otrs', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for actif field
            //
            $column = new TextViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_d_emprunt field
            //
            $column = new DateTimeViewColumn('date_d_emprunt', 'date_d_emprunt', 'Date D Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Date De Retour', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for depot field
            //
            $column = new NumberViewColumn('depot', 'depot', 'Depot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for remboursement_du_depot field
            //
            $column = new NumberViewColumn('remboursement_du_depot', 'remboursement_du_depot', 'Remboursement Du Depot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for rubrique field
            //
            $column = new TextViewColumn('rubrique', 'rubrique', 'Rubrique', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for rubrique_2 field
            //
            $column = new TextViewColumn('rubrique_2', 'rubrique_2', 'Rubrique 2', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for utilisateur_note field
            //
            $column = new TextViewColumn('utilisateur_note', 'utilisateur_note', 'Utilisateur Note', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for boite field
            //
            $column = new NumberViewColumn('id_cle', 'LA1', 'Id Cle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers', 'LA2', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_cle_emprunt field
            //
            $column = new NumberViewColumn('id_cle_emprunt', 'id_cle_emprunt', 'Id Cle Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('id_grp_f_sci', 'LA3', 'Id Grp F Sci', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_due field
            //
            $column = new DateTimeViewColumn('date_due', 'date_due', 'Date Due', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for archivage field
            //
            $column = new NumberViewColumn('archivage', 'archivage', 'Archivage', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for num_bureau field
            //
            $column = new NumberViewColumn('num_bureau', 'num_bureau', 'Num Bureau', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for num_formulaire field
            //
            $column = new NumberViewColumn('num_formulaire', 'num_formulaire', 'Num Formulaire', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for otrs field
            //
            $column = new TextViewColumn('otrs', 'otrs', 'Otrs', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for actif field
            //
            $editor = new TextEdit('actif_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Actif', 'actif', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_d_emprunt field
            //
            $editor = new DateTimeEdit('date_d_emprunt_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Date D Emprunt', 'date_d_emprunt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_de_retour field
            //
            $editor = new DateTimeEdit('date_de_retour_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Date De Retour', 'date_de_retour', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for depot field
            //
            $editor = new TextEdit('depot_edit');
            $editColumn = new CustomEditColumn('Depot', 'depot', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for remboursement_du_depot field
            //
            $editor = new TextEdit('remboursement_du_depot_edit');
            $editColumn = new CustomEditColumn('Remboursement Du Depot', 'remboursement_du_depot', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for rubrique field
            //
            $editor = new TextEdit('rubrique_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Rubrique', 'rubrique', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for rubrique_2 field
            //
            $editor = new TextEdit('rubrique_2_edit');
            $editColumn = new CustomEditColumn('Rubrique 2', 'rubrique_2', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for utilisateur_note field
            //
            $editor = new TextAreaEdit('utilisateur_note_edit', 50, 8);
            $editColumn = new CustomEditColumn('Utilisateur Note', 'utilisateur_note', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_cle field
            //
            $editor = new DynamicCombobox('id_cle_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"cle_departement"."cle_cles"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new IntegerField('boite'),
                    new StringField('crochet'),
                    new StringField('num_cle'),
                    new StringField('description'),
                    new StringField('no_local'),
                    new StringField('ref_local'),
                    new IntegerField('id_local'),
                    new StringField('nb_total'),
                    new StringField('nb_circulation'),
                    new StringField('nb_disponible')
                )
            );
            $lookupDataset->setOrderByField('boite', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Cle', 'id_cle', 'LA1', 'edit_administratifs_personnel01_cle_departement_scta_cle_emprunt_id_cle_search', $editor, $this->dataset, $lookupDataset, 'id', 'boite', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_pers field
            //
            $editor = new DynamicCombobox('id_pers_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Pers', 'id_pers', 'LA2', 'edit_administratifs_personnel01_cle_departement_scta_cle_emprunt_id_pers_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_grp_f_sci field
            //
            $editor = new DynamicCombobox('id_grp_f_sci_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."grp_faculte_sciences"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_grp_f_sci', true, true),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('description', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Grp F Sci', 'id_grp_f_sci', 'LA3', 'edit_administratifs_personnel01_cle_departement_scta_cle_emprunt_id_grp_f_sci_search', $editor, $this->dataset, $lookupDataset, 'id_grp_f_sci', 'description', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_due field
            //
            $editor = new DateTimeEdit('date_due_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Date Due', 'date_due', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for archivage field
            //
            $editor = new TextEdit('archivage_edit');
            $editColumn = new CustomEditColumn('Archivage', 'archivage', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for num_bureau field
            //
            $editor = new TextEdit('num_bureau_edit');
            $editColumn = new CustomEditColumn('Num Bureau', 'num_bureau', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for num_formulaire field
            //
            $editor = new TextEdit('num_formulaire_edit');
            $editColumn = new CustomEditColumn('Num Formulaire', 'num_formulaire', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for otrs field
            //
            $editor = new TextAreaEdit('otrs_edit', 50, 8);
            $editColumn = new CustomEditColumn('Otrs', 'otrs', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for actif field
            //
            $editor = new TextEdit('actif_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Actif', 'actif', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_d_emprunt field
            //
            $editor = new DateTimeEdit('date_d_emprunt_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Date D Emprunt', 'date_d_emprunt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_de_retour field
            //
            $editor = new DateTimeEdit('date_de_retour_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Date De Retour', 'date_de_retour', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for depot field
            //
            $editor = new TextEdit('depot_edit');
            $editColumn = new CustomEditColumn('Depot', 'depot', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for remboursement_du_depot field
            //
            $editor = new TextEdit('remboursement_du_depot_edit');
            $editColumn = new CustomEditColumn('Remboursement Du Depot', 'remboursement_du_depot', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for rubrique field
            //
            $editor = new TextEdit('rubrique_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Rubrique', 'rubrique', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for rubrique_2 field
            //
            $editor = new TextEdit('rubrique_2_edit');
            $editColumn = new CustomEditColumn('Rubrique 2', 'rubrique_2', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for utilisateur_note field
            //
            $editor = new TextAreaEdit('utilisateur_note_edit', 50, 8);
            $editColumn = new CustomEditColumn('Utilisateur Note', 'utilisateur_note', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_cle field
            //
            $editor = new DynamicCombobox('id_cle_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"cle_departement"."cle_cles"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new IntegerField('boite'),
                    new StringField('crochet'),
                    new StringField('num_cle'),
                    new StringField('description'),
                    new StringField('no_local'),
                    new StringField('ref_local'),
                    new IntegerField('id_local'),
                    new StringField('nb_total'),
                    new StringField('nb_circulation'),
                    new StringField('nb_disponible')
                )
            );
            $lookupDataset->setOrderByField('boite', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Cle', 'id_cle', 'LA1', 'multi_edit_administratifs_personnel01_cle_departement_scta_cle_emprunt_id_cle_search', $editor, $this->dataset, $lookupDataset, 'id', 'boite', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_pers field
            //
            $editor = new DynamicCombobox('id_pers_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Pers', 'id_pers', 'LA2', 'multi_edit_administratifs_personnel01_cle_departement_scta_cle_emprunt_id_pers_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_grp_f_sci field
            //
            $editor = new DynamicCombobox('id_grp_f_sci_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."grp_faculte_sciences"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_grp_f_sci', true, true),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('description', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Grp F Sci', 'id_grp_f_sci', 'LA3', 'multi_edit_administratifs_personnel01_cle_departement_scta_cle_emprunt_id_grp_f_sci_search', $editor, $this->dataset, $lookupDataset, 'id_grp_f_sci', 'description', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_due field
            //
            $editor = new DateTimeEdit('date_due_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Date Due', 'date_due', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for archivage field
            //
            $editor = new TextEdit('archivage_edit');
            $editColumn = new CustomEditColumn('Archivage', 'archivage', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for num_bureau field
            //
            $editor = new TextEdit('num_bureau_edit');
            $editColumn = new CustomEditColumn('Num Bureau', 'num_bureau', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for num_formulaire field
            //
            $editor = new TextEdit('num_formulaire_edit');
            $editColumn = new CustomEditColumn('Num Formulaire', 'num_formulaire', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for otrs field
            //
            $editor = new TextAreaEdit('otrs_edit', 50, 8);
            $editColumn = new CustomEditColumn('Otrs', 'otrs', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for actif field
            //
            $editor = new TextEdit('actif_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Actif', 'actif', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_d_emprunt field
            //
            $editor = new DateTimeEdit('date_d_emprunt_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Date D Emprunt', 'date_d_emprunt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_de_retour field
            //
            $editor = new DateTimeEdit('date_de_retour_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Date De Retour', 'date_de_retour', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for depot field
            //
            $editor = new TextEdit('depot_edit');
            $editColumn = new CustomEditColumn('Depot', 'depot', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for remboursement_du_depot field
            //
            $editor = new TextEdit('remboursement_du_depot_edit');
            $editColumn = new CustomEditColumn('Remboursement Du Depot', 'remboursement_du_depot', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for rubrique field
            //
            $editor = new TextEdit('rubrique_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Rubrique', 'rubrique', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for rubrique_2 field
            //
            $editor = new TextEdit('rubrique_2_edit');
            $editColumn = new CustomEditColumn('Rubrique 2', 'rubrique_2', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for utilisateur_note field
            //
            $editor = new TextAreaEdit('utilisateur_note_edit', 50, 8);
            $editColumn = new CustomEditColumn('Utilisateur Note', 'utilisateur_note', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_cle field
            //
            $editor = new DynamicCombobox('id_cle_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"cle_departement"."cle_cles"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new IntegerField('boite'),
                    new StringField('crochet'),
                    new StringField('num_cle'),
                    new StringField('description'),
                    new StringField('no_local'),
                    new StringField('ref_local'),
                    new IntegerField('id_local'),
                    new StringField('nb_total'),
                    new StringField('nb_circulation'),
                    new StringField('nb_disponible')
                )
            );
            $lookupDataset->setOrderByField('boite', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Cle', 'id_cle', 'LA1', 'insert_administratifs_personnel01_cle_departement_scta_cle_emprunt_id_cle_search', $editor, $this->dataset, $lookupDataset, 'id', 'boite', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_pers field
            //
            $editor = new DynamicCombobox('id_pers_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Pers', 'id_pers', 'LA2', 'insert_administratifs_personnel01_cle_departement_scta_cle_emprunt_id_pers_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_grp_f_sci field
            //
            $editor = new DynamicCombobox('id_grp_f_sci_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."grp_faculte_sciences"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_grp_f_sci', true, true),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('description', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Grp F Sci', 'id_grp_f_sci', 'LA3', 'insert_administratifs_personnel01_cle_departement_scta_cle_emprunt_id_grp_f_sci_search', $editor, $this->dataset, $lookupDataset, 'id_grp_f_sci', 'description', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_due field
            //
            $editor = new DateTimeEdit('date_due_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Date Due', 'date_due', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for archivage field
            //
            $editor = new TextEdit('archivage_edit');
            $editColumn = new CustomEditColumn('Archivage', 'archivage', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for num_bureau field
            //
            $editor = new TextEdit('num_bureau_edit');
            $editColumn = new CustomEditColumn('Num Bureau', 'num_bureau', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for num_formulaire field
            //
            $editor = new TextEdit('num_formulaire_edit');
            $editColumn = new CustomEditColumn('Num Formulaire', 'num_formulaire', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for otrs field
            //
            $editor = new TextAreaEdit('otrs_edit', 50, 8);
            $editColumn = new CustomEditColumn('Otrs', 'otrs', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for actif field
            //
            $column = new TextViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_d_emprunt field
            //
            $column = new DateTimeViewColumn('date_d_emprunt', 'date_d_emprunt', 'Date D Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Date De Retour', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddPrintColumn($column);
            
            //
            // View column for depot field
            //
            $column = new NumberViewColumn('depot', 'depot', 'Depot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for remboursement_du_depot field
            //
            $column = new NumberViewColumn('remboursement_du_depot', 'remboursement_du_depot', 'Remboursement Du Depot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for rubrique field
            //
            $column = new TextViewColumn('rubrique', 'rubrique', 'Rubrique', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for rubrique_2 field
            //
            $column = new TextViewColumn('rubrique_2', 'rubrique_2', 'Rubrique 2', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for utilisateur_note field
            //
            $column = new TextViewColumn('utilisateur_note', 'utilisateur_note', 'Utilisateur Note', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for boite field
            //
            $column = new NumberViewColumn('id_cle', 'LA1', 'Id Cle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers', 'LA2', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_cle_emprunt field
            //
            $column = new NumberViewColumn('id_cle_emprunt', 'id_cle_emprunt', 'Id Cle Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('id_grp_f_sci', 'LA3', 'Id Grp F Sci', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_due field
            //
            $column = new DateTimeViewColumn('date_due', 'date_due', 'Date Due', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddPrintColumn($column);
            
            //
            // View column for archivage field
            //
            $column = new NumberViewColumn('archivage', 'archivage', 'Archivage', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for num_bureau field
            //
            $column = new NumberViewColumn('num_bureau', 'num_bureau', 'Num Bureau', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for num_formulaire field
            //
            $column = new NumberViewColumn('num_formulaire', 'num_formulaire', 'Num Formulaire', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for otrs field
            //
            $column = new TextViewColumn('otrs', 'otrs', 'Otrs', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for actif field
            //
            $column = new TextViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_d_emprunt field
            //
            $column = new DateTimeViewColumn('date_d_emprunt', 'date_d_emprunt', 'Date D Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddExportColumn($column);
            
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Date De Retour', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddExportColumn($column);
            
            //
            // View column for depot field
            //
            $column = new NumberViewColumn('depot', 'depot', 'Depot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for remboursement_du_depot field
            //
            $column = new NumberViewColumn('remboursement_du_depot', 'remboursement_du_depot', 'Remboursement Du Depot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for rubrique field
            //
            $column = new TextViewColumn('rubrique', 'rubrique', 'Rubrique', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for rubrique_2 field
            //
            $column = new TextViewColumn('rubrique_2', 'rubrique_2', 'Rubrique 2', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for utilisateur_note field
            //
            $column = new TextViewColumn('utilisateur_note', 'utilisateur_note', 'Utilisateur Note', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for boite field
            //
            $column = new NumberViewColumn('id_cle', 'LA1', 'Id Cle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers', 'LA2', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_cle_emprunt field
            //
            $column = new NumberViewColumn('id_cle_emprunt', 'id_cle_emprunt', 'Id Cle Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('id_grp_f_sci', 'LA3', 'Id Grp F Sci', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_due field
            //
            $column = new DateTimeViewColumn('date_due', 'date_due', 'Date Due', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddExportColumn($column);
            
            //
            // View column for archivage field
            //
            $column = new NumberViewColumn('archivage', 'archivage', 'Archivage', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for num_bureau field
            //
            $column = new NumberViewColumn('num_bureau', 'num_bureau', 'Num Bureau', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for num_formulaire field
            //
            $column = new NumberViewColumn('num_formulaire', 'num_formulaire', 'Num Formulaire', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for otrs field
            //
            $column = new TextViewColumn('otrs', 'otrs', 'Otrs', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for actif field
            //
            $column = new TextViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_d_emprunt field
            //
            $column = new DateTimeViewColumn('date_d_emprunt', 'date_d_emprunt', 'Date D Emprunt', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Date De Retour', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $grid->AddCompareColumn($column);
            
            //
            // View column for depot field
            //
            $column = new NumberViewColumn('depot', 'depot', 'Depot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for remboursement_du_depot field
            //
            $column = new NumberViewColumn('remboursement_du_depot', 'remboursement_du_depot', 'Remboursement Du Depot', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for rubrique field
            //
            $column = new TextViewColumn('rubrique', 'rubrique', 'Rubrique', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for rubrique_2 field
            //
            $column = new TextViewColumn('rubrique_2', 'rubrique_2', 'Rubrique 2', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for utilisateur_note field
            //
            $column = new TextViewColumn('utilisateur_note', 'utilisateur_note', 'Utilisateur Note', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for boite field
            //
            $column = new NumberViewColumn('id_cle', 'LA1', 'Id Cle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers', 'LA2', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('id_grp_f_sci', 'LA3', 'Id Grp F Sci', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_due field
            //
            $column = new DateTimeViewColumn('date_due', 'date_due', 'Date Due', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddCompareColumn($column);
            
            //
            // View column for archivage field
            //
            $column = new NumberViewColumn('archivage', 'archivage', 'Archivage', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for num_bureau field
            //
            $column = new NumberViewColumn('num_bureau', 'num_bureau', 'Num Bureau', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for num_formulaire field
            //
            $column = new NumberViewColumn('num_formulaire', 'num_formulaire', 'Num Formulaire', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for otrs field
            //
            $column = new TextViewColumn('otrs', 'otrs', 'Otrs', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(true);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"cle_departement"."cle_cles"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new IntegerField('boite'),
                    new StringField('crochet'),
                    new StringField('num_cle'),
                    new StringField('description'),
                    new StringField('no_local'),
                    new StringField('ref_local'),
                    new IntegerField('id_local'),
                    new StringField('nb_total'),
                    new StringField('nb_circulation'),
                    new StringField('nb_disponible')
                )
            );
            $lookupDataset->setOrderByField('boite', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel01_cle_departement_scta_cle_emprunt_id_cle_search', 'id', 'boite', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel01_cle_departement_scta_cle_emprunt_id_pers_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."grp_faculte_sciences"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_grp_f_sci', true, true),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('description', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel01_cle_departement_scta_cle_emprunt_id_grp_f_sci_search', 'id_grp_f_sci', 'description', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"cle_departement"."cle_cles"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new IntegerField('boite'),
                    new StringField('crochet'),
                    new StringField('num_cle'),
                    new StringField('description'),
                    new StringField('no_local'),
                    new StringField('ref_local'),
                    new IntegerField('id_local'),
                    new StringField('nb_total'),
                    new StringField('nb_circulation'),
                    new StringField('nb_disponible')
                )
            );
            $lookupDataset->setOrderByField('boite', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel01_cle_departement_scta_cle_emprunt_id_cle_search', 'id', 'boite', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel01_cle_departement_scta_cle_emprunt_id_pers_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."grp_faculte_sciences"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_grp_f_sci', true, true),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('description', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel01_cle_departement_scta_cle_emprunt_id_grp_f_sci_search', 'id_grp_f_sci', 'description', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"cle_departement"."cle_cles"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new IntegerField('boite'),
                    new StringField('crochet'),
                    new StringField('num_cle'),
                    new StringField('description'),
                    new StringField('no_local'),
                    new StringField('ref_local'),
                    new IntegerField('id_local'),
                    new StringField('nb_total'),
                    new StringField('nb_circulation'),
                    new StringField('nb_disponible')
                )
            );
            $lookupDataset->setOrderByField('boite', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel01_cle_departement_scta_cle_emprunt_id_cle_search', 'id', 'boite', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel01_cle_departement_scta_cle_emprunt_id_pers_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."grp_faculte_sciences"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_grp_f_sci', true, true),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('description', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel01_cle_departement_scta_cle_emprunt_id_grp_f_sci_search', 'id_grp_f_sci', 'description', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"cle_departement"."cle_cles"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new IntegerField('boite'),
                    new StringField('crochet'),
                    new StringField('num_cle'),
                    new StringField('description'),
                    new StringField('no_local'),
                    new StringField('ref_local'),
                    new IntegerField('id_local'),
                    new StringField('nb_total'),
                    new StringField('nb_circulation'),
                    new StringField('nb_disponible')
                )
            );
            $lookupDataset->setOrderByField('boite', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel01_cle_departement_scta_cle_emprunt_id_cle_search', 'id', 'boite', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel01_cle_departement_scta_cle_emprunt_id_pers_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."grp_faculte_sciences"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_grp_f_sci', true, true),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('description', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel01_cle_departement_scta_cle_emprunt_id_grp_f_sci_search', 'id_grp_f_sci', 'description', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }
    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class administratifs_personnel01_materiel_achats_logicielsPage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Achats Logiciels');
            $this->SetMenuLabel('Achats Logiciels');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."achats_logiciels"');
            $this->dataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new IntegerField('rig'),
                    new IntegerField('appel_service'),
                    new IntegerField('id_professeur'),
                    new IntegerField('id_ordinateur'),
                    new IntegerField('id_logiciel'),
                    new StringField('cle_logiciel_numero_serie'),
                    new StringField('commentaires'),
                    new IntegerField('id_professeur_new')
                )
            );
            $this->dataset->AddLookupField('id_professeur', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('id_ordinateur', 'materiel.mat_informatique', new IntegerField('id_mat_inf'), new IntegerField('id_loc', false, false, false, false, 'LA2', 'LT2'), 'LT2');
            $this->dataset->AddLookupField('id_logiciel', 'materiel.logiciel', new IntegerField('id_logiciels'), new StringField('nom_logiciel', false, false, false, false, 'LA3', 'LT3'), 'LT3');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'id', 'id', 'Id'),
                new FilterColumn($this->dataset, 'rig', 'rig', 'Rig'),
                new FilterColumn($this->dataset, 'appel_service', 'appel_service', 'Appel Service'),
                new FilterColumn($this->dataset, 'id_professeur', 'LA1', 'Id Professeur'),
                new FilterColumn($this->dataset, 'id_ordinateur', 'LA2', 'Id Ordinateur'),
                new FilterColumn($this->dataset, 'id_logiciel', 'LA3', 'Id Logiciel'),
                new FilterColumn($this->dataset, 'cle_logiciel_numero_serie', 'cle_logiciel_numero_serie', 'Cle Logiciel Numero Serie'),
                new FilterColumn($this->dataset, 'commentaires', 'commentaires', 'Commentaires'),
                new FilterColumn($this->dataset, 'id_professeur_new', 'id_professeur_new', 'Id Professeur New')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['id'])
                ->addColumn($columns['rig'])
                ->addColumn($columns['appel_service'])
                ->addColumn($columns['id_professeur'])
                ->addColumn($columns['id_ordinateur'])
                ->addColumn($columns['id_logiciel'])
                ->addColumn($columns['cle_logiciel_numero_serie'])
                ->addColumn($columns['commentaires'])
                ->addColumn($columns['id_professeur_new']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_professeur')
                ->setOptionsFor('id_ordinateur')
                ->setOptionsFor('id_logiciel');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('id_edit');
            
            $filterBuilder->addColumn(
                $columns['id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('rig_edit');
            
            $filterBuilder->addColumn(
                $columns['rig'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('appel_service_edit');
            
            $filterBuilder->addColumn(
                $columns['appel_service'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_professeur_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel01_materiel_achats_logiciels_id_professeur_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_professeur', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel01_materiel_achats_logiciels_id_professeur_search');
            
            $text_editor = new TextEdit('id_professeur');
            
            $filterBuilder->addColumn(
                $columns['id_professeur'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_ordinateur_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel01_materiel_achats_logiciels_id_ordinateur_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_ordinateur', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel01_materiel_achats_logiciels_id_ordinateur_search');
            
            $filterBuilder->addColumn(
                $columns['id_ordinateur'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_logiciel_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel01_materiel_achats_logiciels_id_logiciel_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_logiciel', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel01_materiel_achats_logiciels_id_logiciel_search');
            
            $text_editor = new TextEdit('id_logiciel');
            
            $filterBuilder->addColumn(
                $columns['id_logiciel'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('cle_logiciel_numero_serie_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['cle_logiciel_numero_serie'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('commentaires_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['commentaires'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_professeur_new_edit');
            
            $filterBuilder->addColumn(
                $columns['id_professeur_new'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for rig field
            //
            $column = new NumberViewColumn('rig', 'rig', 'Rig', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for appel_service field
            //
            $column = new NumberViewColumn('appel_service', 'appel_service', 'Appel Service', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur', 'LA1', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_loc field
            //
            $column = new NumberViewColumn('id_ordinateur', 'LA2', 'Id Ordinateur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom_logiciel field
            //
            $column = new TextViewColumn('id_logiciel', 'LA3', 'Id Logiciel', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for cle_logiciel_numero_serie field
            //
            $column = new TextViewColumn('cle_logiciel_numero_serie', 'cle_logiciel_numero_serie', 'Cle Logiciel Numero Serie', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_professeur_new field
            //
            $column = new NumberViewColumn('id_professeur_new', 'id_professeur_new', 'Id Professeur New', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for rig field
            //
            $column = new NumberViewColumn('rig', 'rig', 'Rig', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for appel_service field
            //
            $column = new NumberViewColumn('appel_service', 'appel_service', 'Appel Service', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur', 'LA1', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_loc field
            //
            $column = new NumberViewColumn('id_ordinateur', 'LA2', 'Id Ordinateur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom_logiciel field
            //
            $column = new TextViewColumn('id_logiciel', 'LA3', 'Id Logiciel', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for cle_logiciel_numero_serie field
            //
            $column = new TextViewColumn('cle_logiciel_numero_serie', 'cle_logiciel_numero_serie', 'Cle Logiciel Numero Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_professeur_new field
            //
            $column = new NumberViewColumn('id_professeur_new', 'id_professeur_new', 'Id Professeur New', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for rig field
            //
            $editor = new TextEdit('rig_edit');
            $editColumn = new CustomEditColumn('Rig', 'rig', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for appel_service field
            //
            $editor = new TextEdit('appel_service_edit');
            $editColumn = new CustomEditColumn('Appel Service', 'appel_service', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_professeur field
            //
            $editor = new DynamicCombobox('id_professeur_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Professeur', 'id_professeur', 'LA1', 'edit_administratifs_personnel01_materiel_achats_logiciels_id_professeur_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_ordinateur field
            //
            $editor = new DynamicCombobox('id_ordinateur_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_informatique"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_mat_inf', true, true, true),
                    new IntegerField('id_loc'),
                    new StringField('no_uqam'),
                    new StringField('syst_expl'),
                    new StringField('marque'),
                    new StringField('description'),
                    new IntegerField('id_grp'),
                    new StringField('fournisseur'),
                    new StringField('no_serie'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new StringField('prix'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d'),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new StringField('adresse_ip'),
                    new IntegerField('id_adresse_ip'),
                    new IntegerField('id_pers'),
                    new StringField('disponible'),
                    new IntegerField('disponible_web'),
                    new StringField('local'),
                    new IntegerField('id'),
                    new IntegerField('id_pers_new'),
                    new IntegerField('id_inf', false, false, true)
                )
            );
            $lookupDataset->setOrderByField('id_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Ordinateur', 'id_ordinateur', 'LA2', 'edit_administratifs_personnel01_materiel_achats_logiciels_id_ordinateur_search', $editor, $this->dataset, $lookupDataset, 'id_mat_inf', 'id_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_logiciel field
            //
            $editor = new DynamicCombobox('id_logiciel_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."logiciel"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_logiciels', true, true),
                    new StringField('nom_logiciel', true),
                    new StringField('version_logiciel', true),
                    new StringField('systeme_operation', true),
                    new StringField('version', true)
                )
            );
            $lookupDataset->setOrderByField('nom_logiciel', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Logiciel', 'id_logiciel', 'LA3', 'edit_administratifs_personnel01_materiel_achats_logiciels_id_logiciel_search', $editor, $this->dataset, $lookupDataset, 'id_logiciels', 'nom_logiciel', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for cle_logiciel_numero_serie field
            //
            $editor = new TextEdit('cle_logiciel_numero_serie_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Cle Logiciel Numero Serie', 'cle_logiciel_numero_serie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextEdit('commentaires_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_professeur_new field
            //
            $editor = new TextEdit('id_professeur_new_edit');
            $editColumn = new CustomEditColumn('Id Professeur New', 'id_professeur_new', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for rig field
            //
            $editor = new TextEdit('rig_edit');
            $editColumn = new CustomEditColumn('Rig', 'rig', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for appel_service field
            //
            $editor = new TextEdit('appel_service_edit');
            $editColumn = new CustomEditColumn('Appel Service', 'appel_service', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_professeur field
            //
            $editor = new DynamicCombobox('id_professeur_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Professeur', 'id_professeur', 'LA1', 'multi_edit_administratifs_personnel01_materiel_achats_logiciels_id_professeur_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_ordinateur field
            //
            $editor = new DynamicCombobox('id_ordinateur_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_informatique"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_mat_inf', true, true, true),
                    new IntegerField('id_loc'),
                    new StringField('no_uqam'),
                    new StringField('syst_expl'),
                    new StringField('marque'),
                    new StringField('description'),
                    new IntegerField('id_grp'),
                    new StringField('fournisseur'),
                    new StringField('no_serie'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new StringField('prix'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d'),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new StringField('adresse_ip'),
                    new IntegerField('id_adresse_ip'),
                    new IntegerField('id_pers'),
                    new StringField('disponible'),
                    new IntegerField('disponible_web'),
                    new StringField('local'),
                    new IntegerField('id'),
                    new IntegerField('id_pers_new'),
                    new IntegerField('id_inf', false, false, true)
                )
            );
            $lookupDataset->setOrderByField('id_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Ordinateur', 'id_ordinateur', 'LA2', 'multi_edit_administratifs_personnel01_materiel_achats_logiciels_id_ordinateur_search', $editor, $this->dataset, $lookupDataset, 'id_mat_inf', 'id_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_logiciel field
            //
            $editor = new DynamicCombobox('id_logiciel_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."logiciel"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_logiciels', true, true),
                    new StringField('nom_logiciel', true),
                    new StringField('version_logiciel', true),
                    new StringField('systeme_operation', true),
                    new StringField('version', true)
                )
            );
            $lookupDataset->setOrderByField('nom_logiciel', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Logiciel', 'id_logiciel', 'LA3', 'multi_edit_administratifs_personnel01_materiel_achats_logiciels_id_logiciel_search', $editor, $this->dataset, $lookupDataset, 'id_logiciels', 'nom_logiciel', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for cle_logiciel_numero_serie field
            //
            $editor = new TextEdit('cle_logiciel_numero_serie_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Cle Logiciel Numero Serie', 'cle_logiciel_numero_serie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextEdit('commentaires_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_professeur_new field
            //
            $editor = new TextEdit('id_professeur_new_edit');
            $editColumn = new CustomEditColumn('Id Professeur New', 'id_professeur_new', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for rig field
            //
            $editor = new TextEdit('rig_edit');
            $editColumn = new CustomEditColumn('Rig', 'rig', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for appel_service field
            //
            $editor = new TextEdit('appel_service_edit');
            $editColumn = new CustomEditColumn('Appel Service', 'appel_service', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_professeur field
            //
            $editor = new DynamicCombobox('id_professeur_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Professeur', 'id_professeur', 'LA1', 'insert_administratifs_personnel01_materiel_achats_logiciels_id_professeur_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_ordinateur field
            //
            $editor = new DynamicCombobox('id_ordinateur_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_informatique"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_mat_inf', true, true, true),
                    new IntegerField('id_loc'),
                    new StringField('no_uqam'),
                    new StringField('syst_expl'),
                    new StringField('marque'),
                    new StringField('description'),
                    new IntegerField('id_grp'),
                    new StringField('fournisseur'),
                    new StringField('no_serie'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new StringField('prix'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d'),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new StringField('adresse_ip'),
                    new IntegerField('id_adresse_ip'),
                    new IntegerField('id_pers'),
                    new StringField('disponible'),
                    new IntegerField('disponible_web'),
                    new StringField('local'),
                    new IntegerField('id'),
                    new IntegerField('id_pers_new'),
                    new IntegerField('id_inf', false, false, true)
                )
            );
            $lookupDataset->setOrderByField('id_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Ordinateur', 'id_ordinateur', 'LA2', 'insert_administratifs_personnel01_materiel_achats_logiciels_id_ordinateur_search', $editor, $this->dataset, $lookupDataset, 'id_mat_inf', 'id_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_logiciel field
            //
            $editor = new DynamicCombobox('id_logiciel_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."logiciel"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_logiciels', true, true),
                    new StringField('nom_logiciel', true),
                    new StringField('version_logiciel', true),
                    new StringField('systeme_operation', true),
                    new StringField('version', true)
                )
            );
            $lookupDataset->setOrderByField('nom_logiciel', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Logiciel', 'id_logiciel', 'LA3', 'insert_administratifs_personnel01_materiel_achats_logiciels_id_logiciel_search', $editor, $this->dataset, $lookupDataset, 'id_logiciels', 'nom_logiciel', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for cle_logiciel_numero_serie field
            //
            $editor = new TextEdit('cle_logiciel_numero_serie_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Cle Logiciel Numero Serie', 'cle_logiciel_numero_serie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextEdit('commentaires_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_professeur_new field
            //
            $editor = new TextEdit('id_professeur_new_edit');
            $editColumn = new CustomEditColumn('Id Professeur New', 'id_professeur_new', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for rig field
            //
            $column = new NumberViewColumn('rig', 'rig', 'Rig', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for appel_service field
            //
            $column = new NumberViewColumn('appel_service', 'appel_service', 'Appel Service', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur', 'LA1', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_loc field
            //
            $column = new NumberViewColumn('id_ordinateur', 'LA2', 'Id Ordinateur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom_logiciel field
            //
            $column = new TextViewColumn('id_logiciel', 'LA3', 'Id Logiciel', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for cle_logiciel_numero_serie field
            //
            $column = new TextViewColumn('cle_logiciel_numero_serie', 'cle_logiciel_numero_serie', 'Cle Logiciel Numero Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_professeur_new field
            //
            $column = new NumberViewColumn('id_professeur_new', 'id_professeur_new', 'Id Professeur New', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for rig field
            //
            $column = new NumberViewColumn('rig', 'rig', 'Rig', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for appel_service field
            //
            $column = new NumberViewColumn('appel_service', 'appel_service', 'Appel Service', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur', 'LA1', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_loc field
            //
            $column = new NumberViewColumn('id_ordinateur', 'LA2', 'Id Ordinateur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for nom_logiciel field
            //
            $column = new TextViewColumn('id_logiciel', 'LA3', 'Id Logiciel', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for cle_logiciel_numero_serie field
            //
            $column = new TextViewColumn('cle_logiciel_numero_serie', 'cle_logiciel_numero_serie', 'Cle Logiciel Numero Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_professeur_new field
            //
            $column = new NumberViewColumn('id_professeur_new', 'id_professeur_new', 'Id Professeur New', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for rig field
            //
            $column = new NumberViewColumn('rig', 'rig', 'Rig', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for appel_service field
            //
            $column = new NumberViewColumn('appel_service', 'appel_service', 'Appel Service', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeur', 'LA1', 'Id Professeur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_loc field
            //
            $column = new NumberViewColumn('id_ordinateur', 'LA2', 'Id Ordinateur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom_logiciel field
            //
            $column = new TextViewColumn('id_logiciel', 'LA3', 'Id Logiciel', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for cle_logiciel_numero_serie field
            //
            $column = new TextViewColumn('cle_logiciel_numero_serie', 'cle_logiciel_numero_serie', 'Cle Logiciel Numero Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_professeur_new field
            //
            $column = new NumberViewColumn('id_professeur_new', 'id_professeur_new', 'Id Professeur New', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(true);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel01_materiel_achats_logiciels_id_professeur_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_informatique"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_mat_inf', true, true, true),
                    new IntegerField('id_loc'),
                    new StringField('no_uqam'),
                    new StringField('syst_expl'),
                    new StringField('marque'),
                    new StringField('description'),
                    new IntegerField('id_grp'),
                    new StringField('fournisseur'),
                    new StringField('no_serie'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new StringField('prix'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d'),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new StringField('adresse_ip'),
                    new IntegerField('id_adresse_ip'),
                    new IntegerField('id_pers'),
                    new StringField('disponible'),
                    new IntegerField('disponible_web'),
                    new StringField('local'),
                    new IntegerField('id'),
                    new IntegerField('id_pers_new'),
                    new IntegerField('id_inf', false, false, true)
                )
            );
            $lookupDataset->setOrderByField('id_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel01_materiel_achats_logiciels_id_ordinateur_search', 'id_mat_inf', 'id_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."logiciel"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_logiciels', true, true),
                    new StringField('nom_logiciel', true),
                    new StringField('version_logiciel', true),
                    new StringField('systeme_operation', true),
                    new StringField('version', true)
                )
            );
            $lookupDataset->setOrderByField('nom_logiciel', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel01_materiel_achats_logiciels_id_logiciel_search', 'id_logiciels', 'nom_logiciel', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel01_materiel_achats_logiciels_id_professeur_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_informatique"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_mat_inf', true, true, true),
                    new IntegerField('id_loc'),
                    new StringField('no_uqam'),
                    new StringField('syst_expl'),
                    new StringField('marque'),
                    new StringField('description'),
                    new IntegerField('id_grp'),
                    new StringField('fournisseur'),
                    new StringField('no_serie'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new StringField('prix'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d'),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new StringField('adresse_ip'),
                    new IntegerField('id_adresse_ip'),
                    new IntegerField('id_pers'),
                    new StringField('disponible'),
                    new IntegerField('disponible_web'),
                    new StringField('local'),
                    new IntegerField('id'),
                    new IntegerField('id_pers_new'),
                    new IntegerField('id_inf', false, false, true)
                )
            );
            $lookupDataset->setOrderByField('id_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel01_materiel_achats_logiciels_id_ordinateur_search', 'id_mat_inf', 'id_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."logiciel"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_logiciels', true, true),
                    new StringField('nom_logiciel', true),
                    new StringField('version_logiciel', true),
                    new StringField('systeme_operation', true),
                    new StringField('version', true)
                )
            );
            $lookupDataset->setOrderByField('nom_logiciel', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel01_materiel_achats_logiciels_id_logiciel_search', 'id_logiciels', 'nom_logiciel', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel01_materiel_achats_logiciels_id_professeur_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_informatique"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_mat_inf', true, true, true),
                    new IntegerField('id_loc'),
                    new StringField('no_uqam'),
                    new StringField('syst_expl'),
                    new StringField('marque'),
                    new StringField('description'),
                    new IntegerField('id_grp'),
                    new StringField('fournisseur'),
                    new StringField('no_serie'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new StringField('prix'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d'),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new StringField('adresse_ip'),
                    new IntegerField('id_adresse_ip'),
                    new IntegerField('id_pers'),
                    new StringField('disponible'),
                    new IntegerField('disponible_web'),
                    new StringField('local'),
                    new IntegerField('id'),
                    new IntegerField('id_pers_new'),
                    new IntegerField('id_inf', false, false, true)
                )
            );
            $lookupDataset->setOrderByField('id_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel01_materiel_achats_logiciels_id_ordinateur_search', 'id_mat_inf', 'id_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."logiciel"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_logiciels', true, true),
                    new StringField('nom_logiciel', true),
                    new StringField('version_logiciel', true),
                    new StringField('systeme_operation', true),
                    new StringField('version', true)
                )
            );
            $lookupDataset->setOrderByField('nom_logiciel', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel01_materiel_achats_logiciels_id_logiciel_search', 'id_logiciels', 'nom_logiciel', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel01_materiel_achats_logiciels_id_professeur_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_informatique"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_mat_inf', true, true, true),
                    new IntegerField('id_loc'),
                    new StringField('no_uqam'),
                    new StringField('syst_expl'),
                    new StringField('marque'),
                    new StringField('description'),
                    new IntegerField('id_grp'),
                    new StringField('fournisseur'),
                    new StringField('no_serie'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new StringField('prix'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d'),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new StringField('adresse_ip'),
                    new IntegerField('id_adresse_ip'),
                    new IntegerField('id_pers'),
                    new StringField('disponible'),
                    new IntegerField('disponible_web'),
                    new StringField('local'),
                    new IntegerField('id'),
                    new IntegerField('id_pers_new'),
                    new IntegerField('id_inf', false, false, true)
                )
            );
            $lookupDataset->setOrderByField('id_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel01_materiel_achats_logiciels_id_ordinateur_search', 'id_mat_inf', 'id_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."logiciel"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_logiciels', true, true),
                    new StringField('nom_logiciel', true),
                    new StringField('version_logiciel', true),
                    new StringField('systeme_operation', true),
                    new StringField('version', true)
                )
            );
            $lookupDataset->setOrderByField('nom_logiciel', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel01_materiel_achats_logiciels_id_logiciel_search', 'id_logiciels', 'nom_logiciel', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }
    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class administratifs_personnel01_materiel_commandesPage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Commandes');
            $this->SetMenuLabel('Commandes');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."commandes"');
            $this->dataset->addFields(
                array(
                    new StringField('description'),
                    new StringField('date_achat'),
                    new StringField('req_achat'),
                    new StringField('compagnie'),
                    new IntegerField('vendeur'),
                    new StringField('siteweb'),
                    new IntegerField('id_professeurs'),
                    new StringField('po_externe'),
                    new StringField('soumissions'),
                    new StringField('no_serie'),
                    new StringField('document_supplementaire'),
                    new StringField('bon_commande_uqam'),
                    new StringField('commentaires'),
                    new StringField('num_uqam'),
                    new StringField('num_scientifique'),
                    new IntegerField('id_pers_new'),
                    new IntegerField('id_commandes', true, true, true)
                )
            );
            $this->dataset->AddLookupField('id_professeurs', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA1', 'LT1'), 'LT1');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'description', 'description', 'Description'),
                new FilterColumn($this->dataset, 'date_achat', 'date_achat', 'Date Achat'),
                new FilterColumn($this->dataset, 'req_achat', 'req_achat', 'Req Achat'),
                new FilterColumn($this->dataset, 'compagnie', 'compagnie', 'Compagnie'),
                new FilterColumn($this->dataset, 'vendeur', 'vendeur', 'Vendeur'),
                new FilterColumn($this->dataset, 'siteweb', 'siteweb', 'Siteweb'),
                new FilterColumn($this->dataset, 'id_professeurs', 'LA1', 'Id Professeurs'),
                new FilterColumn($this->dataset, 'po_externe', 'po_externe', 'Po Externe'),
                new FilterColumn($this->dataset, 'soumissions', 'soumissions', 'Soumissions'),
                new FilterColumn($this->dataset, 'no_serie', 'no_serie', 'No Serie'),
                new FilterColumn($this->dataset, 'document_supplementaire', 'document_supplementaire', 'Document Supplementaire'),
                new FilterColumn($this->dataset, 'bon_commande_uqam', 'bon_commande_uqam', 'Bon Commande Uqam'),
                new FilterColumn($this->dataset, 'commentaires', 'commentaires', 'Commentaires'),
                new FilterColumn($this->dataset, 'num_uqam', 'num_uqam', 'Num Uqam'),
                new FilterColumn($this->dataset, 'num_scientifique', 'num_scientifique', 'Num Scientifique'),
                new FilterColumn($this->dataset, 'id_pers_new', 'id_pers_new', 'Id Pers New'),
                new FilterColumn($this->dataset, 'id_commandes', 'id_commandes', 'Id Commandes')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['description'])
                ->addColumn($columns['date_achat'])
                ->addColumn($columns['req_achat'])
                ->addColumn($columns['compagnie'])
                ->addColumn($columns['vendeur'])
                ->addColumn($columns['siteweb'])
                ->addColumn($columns['id_professeurs'])
                ->addColumn($columns['po_externe'])
                ->addColumn($columns['soumissions'])
                ->addColumn($columns['no_serie'])
                ->addColumn($columns['document_supplementaire'])
                ->addColumn($columns['bon_commande_uqam'])
                ->addColumn($columns['commentaires'])
                ->addColumn($columns['num_uqam'])
                ->addColumn($columns['num_scientifique'])
                ->addColumn($columns['id_pers_new'])
                ->addColumn($columns['id_commandes']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_professeurs');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('description_edit');
            $main_editor->SetMaxLength(90);
            
            $filterBuilder->addColumn(
                $columns['description'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('date_achat_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['date_achat'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('req_achat_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['req_achat'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('compagnie_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['compagnie'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('vendeur_edit');
            
            $filterBuilder->addColumn(
                $columns['vendeur'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('siteweb_edit');
            $main_editor->SetMaxLength(70);
            
            $filterBuilder->addColumn(
                $columns['siteweb'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_professeurs_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel01_materiel_commandes_id_professeurs_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_professeurs', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel01_materiel_commandes_id_professeurs_search');
            
            $text_editor = new TextEdit('id_professeurs');
            
            $filterBuilder->addColumn(
                $columns['id_professeurs'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('po_externe');
            
            $filterBuilder->addColumn(
                $columns['po_externe'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('soumissions');
            
            $filterBuilder->addColumn(
                $columns['soumissions'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_serie_edit');
            
            $filterBuilder->addColumn(
                $columns['no_serie'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('document_supplementaire');
            
            $filterBuilder->addColumn(
                $columns['document_supplementaire'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('bon_commande_uqam');
            
            $filterBuilder->addColumn(
                $columns['bon_commande_uqam'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('commentaires');
            
            $filterBuilder->addColumn(
                $columns['commentaires'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('num_uqam_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['num_uqam'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('num_scientifique_edit');
            
            $filterBuilder->addColumn(
                $columns['num_scientifique'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_pers_new_edit');
            
            $filterBuilder->addColumn(
                $columns['id_pers_new'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_commandes_edit');
            
            $filterBuilder->addColumn(
                $columns['id_commandes'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for req_achat field
            //
            $column = new TextViewColumn('req_achat', 'req_achat', 'Req Achat', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for compagnie field
            //
            $column = new TextViewColumn('compagnie', 'compagnie', 'Compagnie', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for vendeur field
            //
            $column = new NumberViewColumn('vendeur', 'vendeur', 'Vendeur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for siteweb field
            //
            $column = new TextViewColumn('siteweb', 'siteweb', 'Siteweb', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeurs', 'LA1', 'Id Professeurs', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for po_externe field
            //
            $column = new TextViewColumn('po_externe', 'po_externe', 'Po Externe', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for soumissions field
            //
            $column = new TextViewColumn('soumissions', 'soumissions', 'Soumissions', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for document_supplementaire field
            //
            $column = new TextViewColumn('document_supplementaire', 'document_supplementaire', 'Document Supplementaire', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for bon_commande_uqam field
            //
            $column = new TextViewColumn('bon_commande_uqam', 'bon_commande_uqam', 'Bon Commande Uqam', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for num_uqam field
            //
            $column = new TextViewColumn('num_uqam', 'num_uqam', 'Num Uqam', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for num_scientifique field
            //
            $column = new TextViewColumn('num_scientifique', 'num_scientifique', 'Num Scientifique', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_pers_new field
            //
            $column = new NumberViewColumn('id_pers_new', 'id_pers_new', 'Id Pers New', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_commandes field
            //
            $column = new NumberViewColumn('id_commandes', 'id_commandes', 'Id Commandes', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for req_achat field
            //
            $column = new TextViewColumn('req_achat', 'req_achat', 'Req Achat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for compagnie field
            //
            $column = new TextViewColumn('compagnie', 'compagnie', 'Compagnie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for vendeur field
            //
            $column = new NumberViewColumn('vendeur', 'vendeur', 'Vendeur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for siteweb field
            //
            $column = new TextViewColumn('siteweb', 'siteweb', 'Siteweb', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeurs', 'LA1', 'Id Professeurs', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for po_externe field
            //
            $column = new TextViewColumn('po_externe', 'po_externe', 'Po Externe', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for soumissions field
            //
            $column = new TextViewColumn('soumissions', 'soumissions', 'Soumissions', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for document_supplementaire field
            //
            $column = new TextViewColumn('document_supplementaire', 'document_supplementaire', 'Document Supplementaire', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for bon_commande_uqam field
            //
            $column = new TextViewColumn('bon_commande_uqam', 'bon_commande_uqam', 'Bon Commande Uqam', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for num_uqam field
            //
            $column = new TextViewColumn('num_uqam', 'num_uqam', 'Num Uqam', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for num_scientifique field
            //
            $column = new TextViewColumn('num_scientifique', 'num_scientifique', 'Num Scientifique', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_pers_new field
            //
            $column = new NumberViewColumn('id_pers_new', 'id_pers_new', 'Id Pers New', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_commandes field
            //
            $column = new NumberViewColumn('id_commandes', 'id_commandes', 'Id Commandes', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for description field
            //
            $editor = new TextEdit('description_edit');
            $editor->SetMaxLength(90);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_achat field
            //
            $editor = new TextEdit('date_achat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Achat', 'date_achat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for req_achat field
            //
            $editor = new TextEdit('req_achat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Req Achat', 'req_achat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for compagnie field
            //
            $editor = new TextEdit('compagnie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Compagnie', 'compagnie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for vendeur field
            //
            $editor = new TextEdit('vendeur_edit');
            $editColumn = new CustomEditColumn('Vendeur', 'vendeur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for siteweb field
            //
            $editor = new TextEdit('siteweb_edit');
            $editor->SetMaxLength(70);
            $editColumn = new CustomEditColumn('Siteweb', 'siteweb', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_professeurs field
            //
            $editor = new DynamicCombobox('id_professeurs_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Professeurs', 'id_professeurs', 'LA1', 'edit_administratifs_personnel01_materiel_commandes_id_professeurs_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for po_externe field
            //
            $editor = new TextAreaEdit('po_externe_edit', 50, 8);
            $editColumn = new CustomEditColumn('Po Externe', 'po_externe', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for soumissions field
            //
            $editor = new TextAreaEdit('soumissions_edit', 50, 8);
            $editColumn = new CustomEditColumn('Soumissions', 'soumissions', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_serie field
            //
            $editor = new TextEdit('no_serie_edit');
            $editColumn = new CustomEditColumn('No Serie', 'no_serie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for document_supplementaire field
            //
            $editor = new TextAreaEdit('document_supplementaire_edit', 50, 8);
            $editColumn = new CustomEditColumn('Document Supplementaire', 'document_supplementaire', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for bon_commande_uqam field
            //
            $editor = new TextAreaEdit('bon_commande_uqam_edit', 50, 8);
            $editColumn = new CustomEditColumn('Bon Commande Uqam', 'bon_commande_uqam', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextAreaEdit('commentaires_edit', 50, 8);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for num_uqam field
            //
            $editor = new TextEdit('num_uqam_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Num Uqam', 'num_uqam', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for num_scientifique field
            //
            $editor = new TextEdit('num_scientifique_edit');
            $editColumn = new CustomEditColumn('Num Scientifique', 'num_scientifique', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_pers_new field
            //
            $editor = new TextEdit('id_pers_new_edit');
            $editColumn = new CustomEditColumn('Id Pers New', 'id_pers_new', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for description field
            //
            $editor = new TextEdit('description_edit');
            $editor->SetMaxLength(90);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_achat field
            //
            $editor = new TextEdit('date_achat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Achat', 'date_achat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for req_achat field
            //
            $editor = new TextEdit('req_achat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Req Achat', 'req_achat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for compagnie field
            //
            $editor = new TextEdit('compagnie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Compagnie', 'compagnie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for vendeur field
            //
            $editor = new TextEdit('vendeur_edit');
            $editColumn = new CustomEditColumn('Vendeur', 'vendeur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for siteweb field
            //
            $editor = new TextEdit('siteweb_edit');
            $editor->SetMaxLength(70);
            $editColumn = new CustomEditColumn('Siteweb', 'siteweb', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_professeurs field
            //
            $editor = new DynamicCombobox('id_professeurs_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Professeurs', 'id_professeurs', 'LA1', 'multi_edit_administratifs_personnel01_materiel_commandes_id_professeurs_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for po_externe field
            //
            $editor = new TextAreaEdit('po_externe_edit', 50, 8);
            $editColumn = new CustomEditColumn('Po Externe', 'po_externe', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for soumissions field
            //
            $editor = new TextAreaEdit('soumissions_edit', 50, 8);
            $editColumn = new CustomEditColumn('Soumissions', 'soumissions', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_serie field
            //
            $editor = new TextEdit('no_serie_edit');
            $editColumn = new CustomEditColumn('No Serie', 'no_serie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for document_supplementaire field
            //
            $editor = new TextAreaEdit('document_supplementaire_edit', 50, 8);
            $editColumn = new CustomEditColumn('Document Supplementaire', 'document_supplementaire', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for bon_commande_uqam field
            //
            $editor = new TextAreaEdit('bon_commande_uqam_edit', 50, 8);
            $editColumn = new CustomEditColumn('Bon Commande Uqam', 'bon_commande_uqam', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextAreaEdit('commentaires_edit', 50, 8);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for num_uqam field
            //
            $editor = new TextEdit('num_uqam_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Num Uqam', 'num_uqam', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for num_scientifique field
            //
            $editor = new TextEdit('num_scientifique_edit');
            $editColumn = new CustomEditColumn('Num Scientifique', 'num_scientifique', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_pers_new field
            //
            $editor = new TextEdit('id_pers_new_edit');
            $editColumn = new CustomEditColumn('Id Pers New', 'id_pers_new', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for description field
            //
            $editor = new TextEdit('description_edit');
            $editor->SetMaxLength(90);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_achat field
            //
            $editor = new TextEdit('date_achat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Achat', 'date_achat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for req_achat field
            //
            $editor = new TextEdit('req_achat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Req Achat', 'req_achat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for compagnie field
            //
            $editor = new TextEdit('compagnie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Compagnie', 'compagnie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for vendeur field
            //
            $editor = new TextEdit('vendeur_edit');
            $editColumn = new CustomEditColumn('Vendeur', 'vendeur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for siteweb field
            //
            $editor = new TextEdit('siteweb_edit');
            $editor->SetMaxLength(70);
            $editColumn = new CustomEditColumn('Siteweb', 'siteweb', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_professeurs field
            //
            $editor = new DynamicCombobox('id_professeurs_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Professeurs', 'id_professeurs', 'LA1', 'insert_administratifs_personnel01_materiel_commandes_id_professeurs_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for po_externe field
            //
            $editor = new TextAreaEdit('po_externe_edit', 50, 8);
            $editColumn = new CustomEditColumn('Po Externe', 'po_externe', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for soumissions field
            //
            $editor = new TextAreaEdit('soumissions_edit', 50, 8);
            $editColumn = new CustomEditColumn('Soumissions', 'soumissions', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_serie field
            //
            $editor = new TextEdit('no_serie_edit');
            $editColumn = new CustomEditColumn('No Serie', 'no_serie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for document_supplementaire field
            //
            $editor = new TextAreaEdit('document_supplementaire_edit', 50, 8);
            $editColumn = new CustomEditColumn('Document Supplementaire', 'document_supplementaire', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for bon_commande_uqam field
            //
            $editor = new TextAreaEdit('bon_commande_uqam_edit', 50, 8);
            $editColumn = new CustomEditColumn('Bon Commande Uqam', 'bon_commande_uqam', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextAreaEdit('commentaires_edit', 50, 8);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for num_uqam field
            //
            $editor = new TextEdit('num_uqam_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Num Uqam', 'num_uqam', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for num_scientifique field
            //
            $editor = new TextEdit('num_scientifique_edit');
            $editColumn = new CustomEditColumn('Num Scientifique', 'num_scientifique', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_pers_new field
            //
            $editor = new TextEdit('id_pers_new_edit');
            $editColumn = new CustomEditColumn('Id Pers New', 'id_pers_new', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for req_achat field
            //
            $column = new TextViewColumn('req_achat', 'req_achat', 'Req Achat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for compagnie field
            //
            $column = new TextViewColumn('compagnie', 'compagnie', 'Compagnie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for vendeur field
            //
            $column = new NumberViewColumn('vendeur', 'vendeur', 'Vendeur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for siteweb field
            //
            $column = new TextViewColumn('siteweb', 'siteweb', 'Siteweb', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeurs', 'LA1', 'Id Professeurs', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for po_externe field
            //
            $column = new TextViewColumn('po_externe', 'po_externe', 'Po Externe', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for soumissions field
            //
            $column = new TextViewColumn('soumissions', 'soumissions', 'Soumissions', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for document_supplementaire field
            //
            $column = new TextViewColumn('document_supplementaire', 'document_supplementaire', 'Document Supplementaire', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for bon_commande_uqam field
            //
            $column = new TextViewColumn('bon_commande_uqam', 'bon_commande_uqam', 'Bon Commande Uqam', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for num_uqam field
            //
            $column = new TextViewColumn('num_uqam', 'num_uqam', 'Num Uqam', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for num_scientifique field
            //
            $column = new TextViewColumn('num_scientifique', 'num_scientifique', 'Num Scientifique', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_pers_new field
            //
            $column = new NumberViewColumn('id_pers_new', 'id_pers_new', 'Id Pers New', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_commandes field
            //
            $column = new NumberViewColumn('id_commandes', 'id_commandes', 'Id Commandes', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for req_achat field
            //
            $column = new TextViewColumn('req_achat', 'req_achat', 'Req Achat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for compagnie field
            //
            $column = new TextViewColumn('compagnie', 'compagnie', 'Compagnie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for vendeur field
            //
            $column = new NumberViewColumn('vendeur', 'vendeur', 'Vendeur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for siteweb field
            //
            $column = new TextViewColumn('siteweb', 'siteweb', 'Siteweb', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeurs', 'LA1', 'Id Professeurs', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for po_externe field
            //
            $column = new TextViewColumn('po_externe', 'po_externe', 'Po Externe', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for soumissions field
            //
            $column = new TextViewColumn('soumissions', 'soumissions', 'Soumissions', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for document_supplementaire field
            //
            $column = new TextViewColumn('document_supplementaire', 'document_supplementaire', 'Document Supplementaire', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for bon_commande_uqam field
            //
            $column = new TextViewColumn('bon_commande_uqam', 'bon_commande_uqam', 'Bon Commande Uqam', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for num_uqam field
            //
            $column = new TextViewColumn('num_uqam', 'num_uqam', 'Num Uqam', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for num_scientifique field
            //
            $column = new TextViewColumn('num_scientifique', 'num_scientifique', 'Num Scientifique', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_pers_new field
            //
            $column = new NumberViewColumn('id_pers_new', 'id_pers_new', 'Id Pers New', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for id_commandes field
            //
            $column = new NumberViewColumn('id_commandes', 'id_commandes', 'Id Commandes', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for req_achat field
            //
            $column = new TextViewColumn('req_achat', 'req_achat', 'Req Achat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for compagnie field
            //
            $column = new TextViewColumn('compagnie', 'compagnie', 'Compagnie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for vendeur field
            //
            $column = new NumberViewColumn('vendeur', 'vendeur', 'Vendeur', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for siteweb field
            //
            $column = new TextViewColumn('siteweb', 'siteweb', 'Siteweb', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_professeurs', 'LA1', 'Id Professeurs', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for po_externe field
            //
            $column = new TextViewColumn('po_externe', 'po_externe', 'Po Externe', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for soumissions field
            //
            $column = new TextViewColumn('soumissions', 'soumissions', 'Soumissions', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for document_supplementaire field
            //
            $column = new TextViewColumn('document_supplementaire', 'document_supplementaire', 'Document Supplementaire', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for bon_commande_uqam field
            //
            $column = new TextViewColumn('bon_commande_uqam', 'bon_commande_uqam', 'Bon Commande Uqam', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for num_uqam field
            //
            $column = new TextViewColumn('num_uqam', 'num_uqam', 'Num Uqam', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for num_scientifique field
            //
            $column = new TextViewColumn('num_scientifique', 'num_scientifique', 'Num Scientifique', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_pers_new field
            //
            $column = new NumberViewColumn('id_pers_new', 'id_pers_new', 'Id Pers New', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(true);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel01_materiel_commandes_id_professeurs_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel01_materiel_commandes_id_professeurs_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel01_materiel_commandes_id_professeurs_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel01_materiel_commandes_id_professeurs_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel01_materiel_commandes_id_professeurs_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel01_materiel_commandes_id_professeurs_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }
    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class administratifs_personnel01_materiel_mat_informatiquePage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Mat Informatique');
            $this->SetMenuLabel('Mat Informatique');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_informatique"');
            $this->dataset->addFields(
                array(
                    new IntegerField('id_mat_inf', true, true, true),
                    new IntegerField('id_loc'),
                    new StringField('no_uqam'),
                    new StringField('syst_expl'),
                    new StringField('marque'),
                    new StringField('description'),
                    new IntegerField('id_grp'),
                    new StringField('fournisseur'),
                    new StringField('no_serie'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new StringField('prix'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d'),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new StringField('adresse_ip'),
                    new IntegerField('id_adresse_ip'),
                    new IntegerField('id_pers'),
                    new StringField('disponible'),
                    new IntegerField('disponible_web'),
                    new StringField('local'),
                    new IntegerField('id'),
                    new IntegerField('id_pers_new'),
                    new IntegerField('id_inf', false, false, true)
                )
            );
            $this->dataset->AddLookupField('id_loc', 'administratifs.locals', new IntegerField('id_loc'), new StringField('no_loc', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('id_pers_new', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA2', 'LT2'), 'LT2');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'id_mat_inf', 'id_mat_inf', 'Id Mat Inf'),
                new FilterColumn($this->dataset, 'id_loc', 'LA1', 'Id Loc'),
                new FilterColumn($this->dataset, 'no_uqam', 'no_uqam', 'No Uqam'),
                new FilterColumn($this->dataset, 'syst_expl', 'syst_expl', 'Syst Expl'),
                new FilterColumn($this->dataset, 'marque', 'marque', 'Marque'),
                new FilterColumn($this->dataset, 'description', 'description', 'Description'),
                new FilterColumn($this->dataset, 'id_grp', 'id_grp', 'Id Grp'),
                new FilterColumn($this->dataset, 'fournisseur', 'fournisseur', 'Fournisseur'),
                new FilterColumn($this->dataset, 'no_serie', 'no_serie', 'No Serie'),
                new FilterColumn($this->dataset, 'duree_vie', 'duree_vie', 'Duree Vie'),
                new FilterColumn($this->dataset, 'etat', 'etat', 'Etat'),
                new FilterColumn($this->dataset, 'no_requis', 'no_requis', 'No Requis'),
                new FilterColumn($this->dataset, 'no_comman', 'no_comman', 'No Comman'),
                new FilterColumn($this->dataset, 'prix', 'prix', 'Prix'),
                new FilterColumn($this->dataset, 'date_achat', 'date_achat', 'Date Achat'),
                new FilterColumn($this->dataset, 'date_recept', 'date_recept', 'Date Recept'),
                new FilterColumn($this->dataset, 'date_fin_d', 'date_fin_d', 'Date Fin D'),
                new FilterColumn($this->dataset, 'code_compt', 'code_compt', 'Code Compt'),
                new FilterColumn($this->dataset, 'commentaires', 'commentaires', 'Commentaires'),
                new FilterColumn($this->dataset, 'adresse_ip', 'adresse_ip', 'Adresse Ip'),
                new FilterColumn($this->dataset, 'id_adresse_ip', 'id_adresse_ip', 'Id Adresse Ip'),
                new FilterColumn($this->dataset, 'id_pers', 'id_pers', 'Id Pers'),
                new FilterColumn($this->dataset, 'disponible', 'disponible', 'Disponible'),
                new FilterColumn($this->dataset, 'disponible_web', 'disponible_web', 'Disponible Web'),
                new FilterColumn($this->dataset, 'local', 'local', 'Local'),
                new FilterColumn($this->dataset, 'id', 'id', 'Id'),
                new FilterColumn($this->dataset, 'id_pers_new', 'LA2', 'Id Pers New'),
                new FilterColumn($this->dataset, 'id_inf', 'id_inf', 'Id Inf')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['id_mat_inf'])
                ->addColumn($columns['id_loc'])
                ->addColumn($columns['no_uqam'])
                ->addColumn($columns['syst_expl'])
                ->addColumn($columns['marque'])
                ->addColumn($columns['description'])
                ->addColumn($columns['id_grp'])
                ->addColumn($columns['fournisseur'])
                ->addColumn($columns['no_serie'])
                ->addColumn($columns['duree_vie'])
                ->addColumn($columns['etat'])
                ->addColumn($columns['no_requis'])
                ->addColumn($columns['no_comman'])
                ->addColumn($columns['prix'])
                ->addColumn($columns['date_achat'])
                ->addColumn($columns['date_recept'])
                ->addColumn($columns['date_fin_d'])
                ->addColumn($columns['code_compt'])
                ->addColumn($columns['commentaires'])
                ->addColumn($columns['adresse_ip'])
                ->addColumn($columns['id_adresse_ip'])
                ->addColumn($columns['id_pers'])
                ->addColumn($columns['disponible'])
                ->addColumn($columns['disponible_web'])
                ->addColumn($columns['local'])
                ->addColumn($columns['id'])
                ->addColumn($columns['id_pers_new'])
                ->addColumn($columns['id_inf']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_loc')
                ->setOptionsFor('id_pers_new');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('id_mat_inf_edit');
            
            $filterBuilder->addColumn(
                $columns['id_mat_inf'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel01_materiel_mat_informatique_id_loc_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_loc', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel01_materiel_mat_informatique_id_loc_search');
            
            $text_editor = new TextEdit('id_loc');
            
            $filterBuilder->addColumn(
                $columns['id_loc'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_uqam');
            
            $filterBuilder->addColumn(
                $columns['no_uqam'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('syst_expl_edit');
            $main_editor->SetMaxLength(40);
            
            $filterBuilder->addColumn(
                $columns['syst_expl'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('marque_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['marque'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('description_edit');
            $main_editor->SetMaxLength(90);
            
            $filterBuilder->addColumn(
                $columns['description'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_grp_edit');
            
            $filterBuilder->addColumn(
                $columns['id_grp'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('fournisseur_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['fournisseur'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_serie_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['no_serie'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('duree_vie_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['duree_vie'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('etat_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['etat'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_requis_edit');
            
            $filterBuilder->addColumn(
                $columns['no_requis'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_comman_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['no_comman'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('prix');
            
            $filterBuilder->addColumn(
                $columns['prix'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('date_achat');
            
            $filterBuilder->addColumn(
                $columns['date_achat'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('date_recept');
            
            $filterBuilder->addColumn(
                $columns['date_recept'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('date_fin_d_edit');
            $main_editor->SetMaxLength(40);
            
            $filterBuilder->addColumn(
                $columns['date_fin_d'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('code_compt_edit');
            
            $filterBuilder->addColumn(
                $columns['code_compt'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('commentaires_edit');
            $main_editor->SetMaxLength(70);
            
            $filterBuilder->addColumn(
                $columns['commentaires'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('adresse_ip_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['adresse_ip'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_adresse_ip_edit');
            
            $filterBuilder->addColumn(
                $columns['id_adresse_ip'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_pers_edit');
            
            $filterBuilder->addColumn(
                $columns['id_pers'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('disponible');
            
            $filterBuilder->addColumn(
                $columns['disponible'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('disponible_web_edit');
            
            $filterBuilder->addColumn(
                $columns['disponible_web'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('local_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['local'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_edit');
            
            $filterBuilder->addColumn(
                $columns['id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_pers_new_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel01_materiel_mat_informatique_id_pers_new_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_pers_new', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel01_materiel_mat_informatique_id_pers_new_search');
            
            $text_editor = new TextEdit('id_pers_new');
            
            $filterBuilder->addColumn(
                $columns['id_pers_new'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_inf_edit');
            
            $filterBuilder->addColumn(
                $columns['id_inf'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for id_mat_inf field
            //
            $column = new NumberViewColumn('id_mat_inf', 'id_mat_inf', 'Id Mat Inf', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_uqam field
            //
            $column = new TextViewColumn('no_uqam', 'no_uqam', 'No Uqam', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for syst_expl field
            //
            $column = new TextViewColumn('syst_expl', 'syst_expl', 'Syst Expl', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for marque field
            //
            $column = new TextViewColumn('marque', 'marque', 'Marque', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_grp field
            //
            $column = new NumberViewColumn('id_grp', 'id_grp', 'Id Grp', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for fournisseur field
            //
            $column = new TextViewColumn('fournisseur', 'fournisseur', 'Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for duree_vie field
            //
            $column = new TextViewColumn('duree_vie', 'duree_vie', 'Duree Vie', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for etat field
            //
            $column = new TextViewColumn('etat', 'etat', 'Etat', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_requis field
            //
            $column = new NumberViewColumn('no_requis', 'no_requis', 'No Requis', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_comman field
            //
            $column = new TextViewColumn('no_comman', 'no_comman', 'No Comman', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for prix field
            //
            $column = new TextViewColumn('prix', 'prix', 'Prix', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_recept field
            //
            $column = new TextViewColumn('date_recept', 'date_recept', 'Date Recept', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_fin_d field
            //
            $column = new TextViewColumn('date_fin_d', 'date_fin_d', 'Date Fin D', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for code_compt field
            //
            $column = new NumberViewColumn('code_compt', 'code_compt', 'Code Compt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for adresse_ip field
            //
            $column = new TextViewColumn('adresse_ip', 'adresse_ip', 'Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_adresse_ip field
            //
            $column = new NumberViewColumn('id_adresse_ip', 'id_adresse_ip', 'Id Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for disponible field
            //
            $column = new TextViewColumn('disponible', 'disponible', 'Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for disponible_web field
            //
            $column = new NumberViewColumn('disponible_web', 'disponible_web', 'Disponible Web', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for local field
            //
            $column = new TextViewColumn('local', 'local', 'Local', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers_new', 'LA2', 'Id Pers New', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_inf field
            //
            $column = new NumberViewColumn('id_inf', 'id_inf', 'Id Inf', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for id_mat_inf field
            //
            $column = new NumberViewColumn('id_mat_inf', 'id_mat_inf', 'Id Mat Inf', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_uqam field
            //
            $column = new TextViewColumn('no_uqam', 'no_uqam', 'No Uqam', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for syst_expl field
            //
            $column = new TextViewColumn('syst_expl', 'syst_expl', 'Syst Expl', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for marque field
            //
            $column = new TextViewColumn('marque', 'marque', 'Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_grp field
            //
            $column = new NumberViewColumn('id_grp', 'id_grp', 'Id Grp', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for fournisseur field
            //
            $column = new TextViewColumn('fournisseur', 'fournisseur', 'Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for duree_vie field
            //
            $column = new TextViewColumn('duree_vie', 'duree_vie', 'Duree Vie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for etat field
            //
            $column = new TextViewColumn('etat', 'etat', 'Etat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_requis field
            //
            $column = new NumberViewColumn('no_requis', 'no_requis', 'No Requis', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_comman field
            //
            $column = new TextViewColumn('no_comman', 'no_comman', 'No Comman', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for prix field
            //
            $column = new TextViewColumn('prix', 'prix', 'Prix', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_recept field
            //
            $column = new TextViewColumn('date_recept', 'date_recept', 'Date Recept', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_fin_d field
            //
            $column = new TextViewColumn('date_fin_d', 'date_fin_d', 'Date Fin D', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for code_compt field
            //
            $column = new NumberViewColumn('code_compt', 'code_compt', 'Code Compt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for adresse_ip field
            //
            $column = new TextViewColumn('adresse_ip', 'adresse_ip', 'Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_adresse_ip field
            //
            $column = new NumberViewColumn('id_adresse_ip', 'id_adresse_ip', 'Id Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for disponible field
            //
            $column = new TextViewColumn('disponible', 'disponible', 'Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for disponible_web field
            //
            $column = new NumberViewColumn('disponible_web', 'disponible_web', 'Disponible Web', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for local field
            //
            $column = new TextViewColumn('local', 'local', 'Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers_new', 'LA2', 'Id Pers New', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_inf field
            //
            $column = new NumberViewColumn('id_inf', 'id_inf', 'Id Inf', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'edit_administratifs_personnel01_materiel_mat_informatique_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_uqam field
            //
            $editor = new TextAreaEdit('no_uqam_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Uqam', 'no_uqam', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for syst_expl field
            //
            $editor = new TextEdit('syst_expl_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Syst Expl', 'syst_expl', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for marque field
            //
            $editor = new TextEdit('marque_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Marque', 'marque', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for description field
            //
            $editor = new TextEdit('description_edit');
            $editor->SetMaxLength(90);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_grp field
            //
            $editor = new TextEdit('id_grp_edit');
            $editColumn = new CustomEditColumn('Id Grp', 'id_grp', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for fournisseur field
            //
            $editor = new TextEdit('fournisseur_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Fournisseur', 'fournisseur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_serie field
            //
            $editor = new TextEdit('no_serie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Serie', 'no_serie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for duree_vie field
            //
            $editor = new TextEdit('duree_vie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Duree Vie', 'duree_vie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for etat field
            //
            $editor = new TextEdit('etat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Etat', 'etat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_requis field
            //
            $editor = new TextEdit('no_requis_edit');
            $editColumn = new CustomEditColumn('No Requis', 'no_requis', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_comman field
            //
            $editor = new TextEdit('no_comman_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Comman', 'no_comman', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for prix field
            //
            $editor = new TextAreaEdit('prix_edit', 50, 8);
            $editColumn = new CustomEditColumn('Prix', 'prix', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_achat field
            //
            $editor = new TextAreaEdit('date_achat_edit', 50, 8);
            $editColumn = new CustomEditColumn('Date Achat', 'date_achat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_recept field
            //
            $editor = new TextAreaEdit('date_recept_edit', 50, 8);
            $editColumn = new CustomEditColumn('Date Recept', 'date_recept', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_fin_d field
            //
            $editor = new TextEdit('date_fin_d_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Date Fin D', 'date_fin_d', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for code_compt field
            //
            $editor = new TextEdit('code_compt_edit');
            $editColumn = new CustomEditColumn('Code Compt', 'code_compt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextEdit('commentaires_edit');
            $editor->SetMaxLength(70);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for adresse_ip field
            //
            $editor = new TextEdit('adresse_ip_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Adresse Ip', 'adresse_ip', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_adresse_ip field
            //
            $editor = new TextEdit('id_adresse_ip_edit');
            $editColumn = new CustomEditColumn('Id Adresse Ip', 'id_adresse_ip', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_pers field
            //
            $editor = new TextEdit('id_pers_edit');
            $editColumn = new CustomEditColumn('Id Pers', 'id_pers', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for disponible field
            //
            $editor = new TextAreaEdit('disponible_edit', 50, 8);
            $editColumn = new CustomEditColumn('Disponible', 'disponible', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for disponible_web field
            //
            $editor = new TextEdit('disponible_web_edit');
            $editColumn = new CustomEditColumn('Disponible Web', 'disponible_web', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for local field
            //
            $editor = new TextEdit('local_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Local', 'local', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id field
            //
            $editor = new TextEdit('id_edit');
            $editColumn = new CustomEditColumn('Id', 'id', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_pers_new field
            //
            $editor = new DynamicCombobox('id_pers_new_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Pers New', 'id_pers_new', 'LA2', 'edit_administratifs_personnel01_materiel_mat_informatique_id_pers_new_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'multi_edit_administratifs_personnel01_materiel_mat_informatique_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_uqam field
            //
            $editor = new TextAreaEdit('no_uqam_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Uqam', 'no_uqam', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for syst_expl field
            //
            $editor = new TextEdit('syst_expl_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Syst Expl', 'syst_expl', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for marque field
            //
            $editor = new TextEdit('marque_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Marque', 'marque', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for description field
            //
            $editor = new TextEdit('description_edit');
            $editor->SetMaxLength(90);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_grp field
            //
            $editor = new TextEdit('id_grp_edit');
            $editColumn = new CustomEditColumn('Id Grp', 'id_grp', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for fournisseur field
            //
            $editor = new TextEdit('fournisseur_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Fournisseur', 'fournisseur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_serie field
            //
            $editor = new TextEdit('no_serie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Serie', 'no_serie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for duree_vie field
            //
            $editor = new TextEdit('duree_vie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Duree Vie', 'duree_vie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for etat field
            //
            $editor = new TextEdit('etat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Etat', 'etat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_requis field
            //
            $editor = new TextEdit('no_requis_edit');
            $editColumn = new CustomEditColumn('No Requis', 'no_requis', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_comman field
            //
            $editor = new TextEdit('no_comman_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Comman', 'no_comman', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for prix field
            //
            $editor = new TextAreaEdit('prix_edit', 50, 8);
            $editColumn = new CustomEditColumn('Prix', 'prix', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_achat field
            //
            $editor = new TextAreaEdit('date_achat_edit', 50, 8);
            $editColumn = new CustomEditColumn('Date Achat', 'date_achat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_recept field
            //
            $editor = new TextAreaEdit('date_recept_edit', 50, 8);
            $editColumn = new CustomEditColumn('Date Recept', 'date_recept', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_fin_d field
            //
            $editor = new TextEdit('date_fin_d_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Date Fin D', 'date_fin_d', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for code_compt field
            //
            $editor = new TextEdit('code_compt_edit');
            $editColumn = new CustomEditColumn('Code Compt', 'code_compt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextEdit('commentaires_edit');
            $editor->SetMaxLength(70);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for adresse_ip field
            //
            $editor = new TextEdit('adresse_ip_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Adresse Ip', 'adresse_ip', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_adresse_ip field
            //
            $editor = new TextEdit('id_adresse_ip_edit');
            $editColumn = new CustomEditColumn('Id Adresse Ip', 'id_adresse_ip', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_pers field
            //
            $editor = new TextEdit('id_pers_edit');
            $editColumn = new CustomEditColumn('Id Pers', 'id_pers', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for disponible field
            //
            $editor = new TextAreaEdit('disponible_edit', 50, 8);
            $editColumn = new CustomEditColumn('Disponible', 'disponible', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for disponible_web field
            //
            $editor = new TextEdit('disponible_web_edit');
            $editColumn = new CustomEditColumn('Disponible Web', 'disponible_web', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for local field
            //
            $editor = new TextEdit('local_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Local', 'local', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id field
            //
            $editor = new TextEdit('id_edit');
            $editColumn = new CustomEditColumn('Id', 'id', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_pers_new field
            //
            $editor = new DynamicCombobox('id_pers_new_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Pers New', 'id_pers_new', 'LA2', 'multi_edit_administratifs_personnel01_materiel_mat_informatique_id_pers_new_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'insert_administratifs_personnel01_materiel_mat_informatique_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_uqam field
            //
            $editor = new TextAreaEdit('no_uqam_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Uqam', 'no_uqam', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for syst_expl field
            //
            $editor = new TextEdit('syst_expl_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Syst Expl', 'syst_expl', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for marque field
            //
            $editor = new TextEdit('marque_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Marque', 'marque', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for description field
            //
            $editor = new TextEdit('description_edit');
            $editor->SetMaxLength(90);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_grp field
            //
            $editor = new TextEdit('id_grp_edit');
            $editColumn = new CustomEditColumn('Id Grp', 'id_grp', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for fournisseur field
            //
            $editor = new TextEdit('fournisseur_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Fournisseur', 'fournisseur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_serie field
            //
            $editor = new TextEdit('no_serie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Serie', 'no_serie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for duree_vie field
            //
            $editor = new TextEdit('duree_vie_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Duree Vie', 'duree_vie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for etat field
            //
            $editor = new TextEdit('etat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Etat', 'etat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_requis field
            //
            $editor = new TextEdit('no_requis_edit');
            $editColumn = new CustomEditColumn('No Requis', 'no_requis', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_comman field
            //
            $editor = new TextEdit('no_comman_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Comman', 'no_comman', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for prix field
            //
            $editor = new TextAreaEdit('prix_edit', 50, 8);
            $editColumn = new CustomEditColumn('Prix', 'prix', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_achat field
            //
            $editor = new TextAreaEdit('date_achat_edit', 50, 8);
            $editColumn = new CustomEditColumn('Date Achat', 'date_achat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_recept field
            //
            $editor = new TextAreaEdit('date_recept_edit', 50, 8);
            $editColumn = new CustomEditColumn('Date Recept', 'date_recept', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_fin_d field
            //
            $editor = new TextEdit('date_fin_d_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Date Fin D', 'date_fin_d', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for code_compt field
            //
            $editor = new TextEdit('code_compt_edit');
            $editColumn = new CustomEditColumn('Code Compt', 'code_compt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextEdit('commentaires_edit');
            $editor->SetMaxLength(70);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for adresse_ip field
            //
            $editor = new TextEdit('adresse_ip_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Adresse Ip', 'adresse_ip', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_adresse_ip field
            //
            $editor = new TextEdit('id_adresse_ip_edit');
            $editColumn = new CustomEditColumn('Id Adresse Ip', 'id_adresse_ip', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_pers field
            //
            $editor = new TextEdit('id_pers_edit');
            $editColumn = new CustomEditColumn('Id Pers', 'id_pers', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for disponible field
            //
            $editor = new TextAreaEdit('disponible_edit', 50, 8);
            $editColumn = new CustomEditColumn('Disponible', 'disponible', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for disponible_web field
            //
            $editor = new TextEdit('disponible_web_edit');
            $editColumn = new CustomEditColumn('Disponible Web', 'disponible_web', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for local field
            //
            $editor = new TextEdit('local_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Local', 'local', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id field
            //
            $editor = new TextEdit('id_edit');
            $editColumn = new CustomEditColumn('Id', 'id', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_pers_new field
            //
            $editor = new DynamicCombobox('id_pers_new_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Pers New', 'id_pers_new', 'LA2', 'insert_administratifs_personnel01_materiel_mat_informatique_id_pers_new_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for id_mat_inf field
            //
            $column = new NumberViewColumn('id_mat_inf', 'id_mat_inf', 'Id Mat Inf', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_uqam field
            //
            $column = new TextViewColumn('no_uqam', 'no_uqam', 'No Uqam', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for syst_expl field
            //
            $column = new TextViewColumn('syst_expl', 'syst_expl', 'Syst Expl', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for marque field
            //
            $column = new TextViewColumn('marque', 'marque', 'Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_grp field
            //
            $column = new NumberViewColumn('id_grp', 'id_grp', 'Id Grp', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for fournisseur field
            //
            $column = new TextViewColumn('fournisseur', 'fournisseur', 'Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for duree_vie field
            //
            $column = new TextViewColumn('duree_vie', 'duree_vie', 'Duree Vie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for etat field
            //
            $column = new TextViewColumn('etat', 'etat', 'Etat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_requis field
            //
            $column = new NumberViewColumn('no_requis', 'no_requis', 'No Requis', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_comman field
            //
            $column = new TextViewColumn('no_comman', 'no_comman', 'No Comman', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for prix field
            //
            $column = new TextViewColumn('prix', 'prix', 'Prix', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_recept field
            //
            $column = new TextViewColumn('date_recept', 'date_recept', 'Date Recept', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_fin_d field
            //
            $column = new TextViewColumn('date_fin_d', 'date_fin_d', 'Date Fin D', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for code_compt field
            //
            $column = new NumberViewColumn('code_compt', 'code_compt', 'Code Compt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for adresse_ip field
            //
            $column = new TextViewColumn('adresse_ip', 'adresse_ip', 'Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_adresse_ip field
            //
            $column = new NumberViewColumn('id_adresse_ip', 'id_adresse_ip', 'Id Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for disponible field
            //
            $column = new TextViewColumn('disponible', 'disponible', 'Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for disponible_web field
            //
            $column = new NumberViewColumn('disponible_web', 'disponible_web', 'Disponible Web', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for local field
            //
            $column = new TextViewColumn('local', 'local', 'Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers_new', 'LA2', 'Id Pers New', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_inf field
            //
            $column = new NumberViewColumn('id_inf', 'id_inf', 'Id Inf', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for id_mat_inf field
            //
            $column = new NumberViewColumn('id_mat_inf', 'id_mat_inf', 'Id Mat Inf', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_uqam field
            //
            $column = new TextViewColumn('no_uqam', 'no_uqam', 'No Uqam', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for syst_expl field
            //
            $column = new TextViewColumn('syst_expl', 'syst_expl', 'Syst Expl', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for marque field
            //
            $column = new TextViewColumn('marque', 'marque', 'Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_grp field
            //
            $column = new NumberViewColumn('id_grp', 'id_grp', 'Id Grp', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for fournisseur field
            //
            $column = new TextViewColumn('fournisseur', 'fournisseur', 'Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for duree_vie field
            //
            $column = new TextViewColumn('duree_vie', 'duree_vie', 'Duree Vie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for etat field
            //
            $column = new TextViewColumn('etat', 'etat', 'Etat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_requis field
            //
            $column = new NumberViewColumn('no_requis', 'no_requis', 'No Requis', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for no_comman field
            //
            $column = new TextViewColumn('no_comman', 'no_comman', 'No Comman', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for prix field
            //
            $column = new TextViewColumn('prix', 'prix', 'Prix', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_recept field
            //
            $column = new TextViewColumn('date_recept', 'date_recept', 'Date Recept', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_fin_d field
            //
            $column = new TextViewColumn('date_fin_d', 'date_fin_d', 'Date Fin D', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for code_compt field
            //
            $column = new NumberViewColumn('code_compt', 'code_compt', 'Code Compt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for adresse_ip field
            //
            $column = new TextViewColumn('adresse_ip', 'adresse_ip', 'Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_adresse_ip field
            //
            $column = new NumberViewColumn('id_adresse_ip', 'id_adresse_ip', 'Id Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for disponible field
            //
            $column = new TextViewColumn('disponible', 'disponible', 'Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for disponible_web field
            //
            $column = new NumberViewColumn('disponible_web', 'disponible_web', 'Disponible Web', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for local field
            //
            $column = new TextViewColumn('local', 'local', 'Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers_new', 'LA2', 'Id Pers New', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_inf field
            //
            $column = new NumberViewColumn('id_inf', 'id_inf', 'Id Inf', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_uqam field
            //
            $column = new TextViewColumn('no_uqam', 'no_uqam', 'No Uqam', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for syst_expl field
            //
            $column = new TextViewColumn('syst_expl', 'syst_expl', 'Syst Expl', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for marque field
            //
            $column = new TextViewColumn('marque', 'marque', 'Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_grp field
            //
            $column = new NumberViewColumn('id_grp', 'id_grp', 'Id Grp', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for fournisseur field
            //
            $column = new TextViewColumn('fournisseur', 'fournisseur', 'Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for duree_vie field
            //
            $column = new TextViewColumn('duree_vie', 'duree_vie', 'Duree Vie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for etat field
            //
            $column = new TextViewColumn('etat', 'etat', 'Etat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_requis field
            //
            $column = new NumberViewColumn('no_requis', 'no_requis', 'No Requis', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_comman field
            //
            $column = new TextViewColumn('no_comman', 'no_comman', 'No Comman', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for prix field
            //
            $column = new TextViewColumn('prix', 'prix', 'Prix', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_recept field
            //
            $column = new TextViewColumn('date_recept', 'date_recept', 'Date Recept', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_fin_d field
            //
            $column = new TextViewColumn('date_fin_d', 'date_fin_d', 'Date Fin D', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for code_compt field
            //
            $column = new NumberViewColumn('code_compt', 'code_compt', 'Code Compt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for adresse_ip field
            //
            $column = new TextViewColumn('adresse_ip', 'adresse_ip', 'Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_adresse_ip field
            //
            $column = new NumberViewColumn('id_adresse_ip', 'id_adresse_ip', 'Id Adresse Ip', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for disponible field
            //
            $column = new TextViewColumn('disponible', 'disponible', 'Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for disponible_web field
            //
            $column = new NumberViewColumn('disponible_web', 'disponible_web', 'Disponible Web', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for local field
            //
            $column = new TextViewColumn('local', 'local', 'Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers_new', 'LA2', 'Id Pers New', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(true);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel01_materiel_mat_informatique_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_personnel01_materiel_mat_informatique_id_pers_new_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel01_materiel_mat_informatique_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel01_materiel_mat_informatique_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_personnel01_materiel_mat_informatique_id_pers_new_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel01_materiel_mat_informatique_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_personnel01_materiel_mat_informatique_id_pers_new_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel01_materiel_mat_informatique_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_personnel01_materiel_mat_informatique_id_pers_new_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }
    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class administratifs_personnel01_materiel_mat_sciPage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Mat Sci');
            $this->SetMenuLabel('Mat Sci');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."mat_sci"');
            $this->dataset->addFields(
                array(
                    new IntegerField('id_mat_sci', true, true, true),
                    new StringField('no_identif', true),
                    new StringField('transaction', true),
                    new StringField('nom_l_e'),
                    new IntegerField('id_equipement'),
                    new StringField('marque'),
                    new StringField('manufacture', true),
                    new StringField('modele'),
                    new StringField('fournisseur'),
                    new StringField('id_fournisseur', true),
                    new StringField('no_serie'),
                    new StringField('caracteristique'),
                    new StringField('utilisation'),
                    new StringField('duree_vie'),
                    new StringField('etat'),
                    new StringField('fonction'),
                    new StringField('utilisateur'),
                    new StringField('cours'),
                    new IntegerField('no_requis'),
                    new StringField('no_comman'),
                    new IntegerField('quantite'),
                    new IntegerField('prix_unitaire'),
                    new IntegerField('cout_total'),
                    new StringField('date_achat'),
                    new StringField('date_recept'),
                    new StringField('date_fin_d', true),
                    new IntegerField('code_compt'),
                    new StringField('commentaires'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_charge'),
                    new IntegerField('disponible'),
                    new StringField('disponible_web'),
                    new StringField('documents_facture'),
                    new StringField('document_bon_commande'),
                    new StringField('document_manuel_utilisation'),
                    new StringField('autres_documents'),
                    new IntegerField('id_marque'),
                    new IntegerField('id_manufacturier'),
                    new IntegerField('id_modele'),
                    new IntegerField('id_groupe'),
                    new IntegerField('id_pers')
                )
            );
            $this->dataset->AddLookupField('id_loc', 'administratifs.locals', new IntegerField('id_loc'), new StringField('no_loc', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('id_charge', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA2', 'LT2'), 'LT2');
            $this->dataset->AddLookupField('id_marque', 'materiel.marques', new IntegerField('id_marque'), new StringField('description', false, false, false, false, 'LA3', 'LT3'), 'LT3');
            $this->dataset->AddLookupField('id_manufacturier', 'materiel.manufacturier', new IntegerField('id_marque'), new StringField('description', false, false, false, false, 'LA4', 'LT4'), 'LT4');
            $this->dataset->AddLookupField('id_groupe', 'administratifs.groupe', new IntegerField('id_groupe'), new StringField('nom_groupe', false, false, false, false, 'LA5', 'LT5'), 'LT5');
            $this->dataset->AddLookupField('id_pers', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA6', 'LT6'), 'LT6');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'id_mat_sci', 'id_mat_sci', 'Id Mat Sci'),
                new FilterColumn($this->dataset, 'no_identif', 'no_identif', 'No Identif'),
                new FilterColumn($this->dataset, 'transaction', 'transaction', 'Transaction'),
                new FilterColumn($this->dataset, 'nom_l_e', 'nom_l_e', 'Nom L E'),
                new FilterColumn($this->dataset, 'id_equipement', 'id_equipement', 'Id Equipement'),
                new FilterColumn($this->dataset, 'marque', 'marque', 'Marque'),
                new FilterColumn($this->dataset, 'manufacture', 'manufacture', 'Manufacture'),
                new FilterColumn($this->dataset, 'modele', 'modele', 'Modele'),
                new FilterColumn($this->dataset, 'fournisseur', 'fournisseur', 'Fournisseur'),
                new FilterColumn($this->dataset, 'id_fournisseur', 'id_fournisseur', 'Id Fournisseur'),
                new FilterColumn($this->dataset, 'no_serie', 'no_serie', 'No Serie'),
                new FilterColumn($this->dataset, 'caracteristique', 'caracteristique', 'Caracteristique'),
                new FilterColumn($this->dataset, 'utilisation', 'utilisation', 'Utilisation'),
                new FilterColumn($this->dataset, 'duree_vie', 'duree_vie', 'Duree Vie'),
                new FilterColumn($this->dataset, 'etat', 'etat', 'Etat'),
                new FilterColumn($this->dataset, 'fonction', 'fonction', 'Fonction'),
                new FilterColumn($this->dataset, 'utilisateur', 'utilisateur', 'Utilisateur'),
                new FilterColumn($this->dataset, 'cours', 'cours', 'Cours'),
                new FilterColumn($this->dataset, 'no_requis', 'no_requis', 'No Requis'),
                new FilterColumn($this->dataset, 'no_comman', 'no_comman', 'No Comman'),
                new FilterColumn($this->dataset, 'quantite', 'quantite', 'Quantite'),
                new FilterColumn($this->dataset, 'prix_unitaire', 'prix_unitaire', 'Prix Unitaire'),
                new FilterColumn($this->dataset, 'cout_total', 'cout_total', 'Cout Total'),
                new FilterColumn($this->dataset, 'date_achat', 'date_achat', 'Date Achat'),
                new FilterColumn($this->dataset, 'date_recept', 'date_recept', 'Date Recept'),
                new FilterColumn($this->dataset, 'date_fin_d', 'date_fin_d', 'Date Fin D'),
                new FilterColumn($this->dataset, 'code_compt', 'code_compt', 'Code Compt'),
                new FilterColumn($this->dataset, 'commentaires', 'commentaires', 'Commentaires'),
                new FilterColumn($this->dataset, 'id_loc', 'LA1', 'Id Loc'),
                new FilterColumn($this->dataset, 'id_charge', 'LA2', 'Id Charge'),
                new FilterColumn($this->dataset, 'disponible', 'disponible', 'Disponible'),
                new FilterColumn($this->dataset, 'disponible_web', 'disponible_web', 'Disponible Web'),
                new FilterColumn($this->dataset, 'documents_facture', 'documents_facture', 'Documents Facture'),
                new FilterColumn($this->dataset, 'document_bon_commande', 'document_bon_commande', 'Document Bon Commande'),
                new FilterColumn($this->dataset, 'document_manuel_utilisation', 'document_manuel_utilisation', 'Document Manuel Utilisation'),
                new FilterColumn($this->dataset, 'autres_documents', 'autres_documents', 'Autres Documents'),
                new FilterColumn($this->dataset, 'id_marque', 'LA3', 'Id Marque'),
                new FilterColumn($this->dataset, 'id_manufacturier', 'LA4', 'Id Manufacturier'),
                new FilterColumn($this->dataset, 'id_modele', 'id_modele', 'Id Modele'),
                new FilterColumn($this->dataset, 'id_groupe', 'LA5', 'Id Groupe'),
                new FilterColumn($this->dataset, 'id_pers', 'LA6', 'Id Pers')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['id_mat_sci'])
                ->addColumn($columns['no_identif'])
                ->addColumn($columns['transaction'])
                ->addColumn($columns['nom_l_e'])
                ->addColumn($columns['id_equipement'])
                ->addColumn($columns['marque'])
                ->addColumn($columns['manufacture'])
                ->addColumn($columns['modele'])
                ->addColumn($columns['fournisseur'])
                ->addColumn($columns['id_fournisseur'])
                ->addColumn($columns['no_serie'])
                ->addColumn($columns['caracteristique'])
                ->addColumn($columns['utilisation'])
                ->addColumn($columns['duree_vie'])
                ->addColumn($columns['etat'])
                ->addColumn($columns['fonction'])
                ->addColumn($columns['utilisateur'])
                ->addColumn($columns['cours'])
                ->addColumn($columns['no_requis'])
                ->addColumn($columns['no_comman'])
                ->addColumn($columns['quantite'])
                ->addColumn($columns['prix_unitaire'])
                ->addColumn($columns['cout_total'])
                ->addColumn($columns['date_achat'])
                ->addColumn($columns['date_recept'])
                ->addColumn($columns['date_fin_d'])
                ->addColumn($columns['code_compt'])
                ->addColumn($columns['commentaires'])
                ->addColumn($columns['id_loc'])
                ->addColumn($columns['id_charge'])
                ->addColumn($columns['disponible'])
                ->addColumn($columns['disponible_web'])
                ->addColumn($columns['documents_facture'])
                ->addColumn($columns['document_bon_commande'])
                ->addColumn($columns['document_manuel_utilisation'])
                ->addColumn($columns['autres_documents'])
                ->addColumn($columns['id_marque'])
                ->addColumn($columns['id_manufacturier'])
                ->addColumn($columns['id_modele'])
                ->addColumn($columns['id_groupe'])
                ->addColumn($columns['id_pers']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_loc')
                ->setOptionsFor('id_charge')
                ->setOptionsFor('id_marque')
                ->setOptionsFor('id_manufacturier')
                ->setOptionsFor('id_groupe')
                ->setOptionsFor('id_pers');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('id_mat_sci_edit');
            
            $filterBuilder->addColumn(
                $columns['id_mat_sci'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_identif_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['no_identif'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('transaction_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['transaction'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('nom_l_e_edit');
            $main_editor->SetMaxLength(80);
            
            $filterBuilder->addColumn(
                $columns['nom_l_e'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_equipement_edit');
            
            $filterBuilder->addColumn(
                $columns['id_equipement'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('marque_edit');
            $main_editor->SetMaxLength(30);
            
            $filterBuilder->addColumn(
                $columns['marque'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('manufacture_edit');
            $main_editor->SetMaxLength(40);
            
            $filterBuilder->addColumn(
                $columns['manufacture'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('modele_edit');
            $main_editor->SetMaxLength(30);
            
            $filterBuilder->addColumn(
                $columns['modele'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('fournisseur_edit');
            $main_editor->SetMaxLength(40);
            
            $filterBuilder->addColumn(
                $columns['fournisseur'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_fournisseur_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['id_fournisseur'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_serie_edit');
            $main_editor->SetMaxLength(30);
            
            $filterBuilder->addColumn(
                $columns['no_serie'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('caracteristique_edit');
            $main_editor->SetMaxLength(50);
            
            $filterBuilder->addColumn(
                $columns['caracteristique'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('utilisation_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['utilisation'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('duree_vie_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['duree_vie'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('etat_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['etat'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('fonction_edit');
            $main_editor->SetMaxLength(40);
            
            $filterBuilder->addColumn(
                $columns['fonction'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('utilisateur_edit');
            $main_editor->SetMaxLength(60);
            
            $filterBuilder->addColumn(
                $columns['utilisateur'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('cours_edit');
            $main_editor->SetMaxLength(40);
            
            $filterBuilder->addColumn(
                $columns['cours'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_requis_edit');
            
            $filterBuilder->addColumn(
                $columns['no_requis'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_comman_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['no_comman'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('quantite_edit');
            
            $filterBuilder->addColumn(
                $columns['quantite'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('prix_unitaire_edit');
            
            $filterBuilder->addColumn(
                $columns['prix_unitaire'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('cout_total_edit');
            
            $filterBuilder->addColumn(
                $columns['cout_total'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('date_achat_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['date_achat'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('date_recept_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['date_recept'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('date_fin_d_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['date_fin_d'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('code_compt_edit');
            
            $filterBuilder->addColumn(
                $columns['code_compt'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('commentaires');
            
            $filterBuilder->addColumn(
                $columns['commentaires'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel01_materiel_mat_sci_id_loc_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_loc', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel01_materiel_mat_sci_id_loc_search');
            
            $text_editor = new TextEdit('id_loc');
            
            $filterBuilder->addColumn(
                $columns['id_loc'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_charge_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel01_materiel_mat_sci_id_charge_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_charge', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel01_materiel_mat_sci_id_charge_search');
            
            $text_editor = new TextEdit('id_charge');
            
            $filterBuilder->addColumn(
                $columns['id_charge'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('disponible_edit');
            
            $filterBuilder->addColumn(
                $columns['disponible'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('disponible_web_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['disponible_web'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('documents_facture_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['documents_facture'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('document_bon_commande_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['document_bon_commande'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('document_manuel_utilisation_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['document_manuel_utilisation'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('autres_documents_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['autres_documents'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_marque_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel01_materiel_mat_sci_id_marque_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_marque', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel01_materiel_mat_sci_id_marque_search');
            
            $text_editor = new TextEdit('id_marque');
            
            $filterBuilder->addColumn(
                $columns['id_marque'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_manufacturier_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel01_materiel_mat_sci_id_manufacturier_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_manufacturier', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel01_materiel_mat_sci_id_manufacturier_search');
            
            $text_editor = new TextEdit('id_manufacturier');
            
            $filterBuilder->addColumn(
                $columns['id_manufacturier'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_modele_edit');
            
            $filterBuilder->addColumn(
                $columns['id_modele'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_groupe_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel01_materiel_mat_sci_id_groupe_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_groupe', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel01_materiel_mat_sci_id_groupe_search');
            
            $text_editor = new TextEdit('id_groupe');
            
            $filterBuilder->addColumn(
                $columns['id_groupe'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_pers_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_personnel01_materiel_mat_sci_id_pers_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_pers', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_personnel01_materiel_mat_sci_id_pers_search');
            
            $text_editor = new TextEdit('id_pers');
            
            $filterBuilder->addColumn(
                $columns['id_pers'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for id_mat_sci field
            //
            $column = new NumberViewColumn('id_mat_sci', 'id_mat_sci', 'Id Mat Sci', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_identif field
            //
            $column = new TextViewColumn('no_identif', 'no_identif', 'No Identif', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for transaction field
            //
            $column = new TextViewColumn('transaction', 'transaction', 'Transaction', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom_l_e field
            //
            $column = new TextViewColumn('nom_l_e', 'nom_l_e', 'Nom L E', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_equipement field
            //
            $column = new NumberViewColumn('id_equipement', 'id_equipement', 'Id Equipement', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for marque field
            //
            $column = new TextViewColumn('marque', 'marque', 'Marque', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for manufacture field
            //
            $column = new TextViewColumn('manufacture', 'manufacture', 'Manufacture', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for modele field
            //
            $column = new TextViewColumn('modele', 'modele', 'Modele', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for fournisseur field
            //
            $column = new TextViewColumn('fournisseur', 'fournisseur', 'Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_fournisseur field
            //
            $column = new TextViewColumn('id_fournisseur', 'id_fournisseur', 'Id Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for caracteristique field
            //
            $column = new TextViewColumn('caracteristique', 'caracteristique', 'Caracteristique', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for utilisation field
            //
            $column = new TextViewColumn('utilisation', 'utilisation', 'Utilisation', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for duree_vie field
            //
            $column = new TextViewColumn('duree_vie', 'duree_vie', 'Duree Vie', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for etat field
            //
            $column = new TextViewColumn('etat', 'etat', 'Etat', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for fonction field
            //
            $column = new TextViewColumn('fonction', 'fonction', 'Fonction', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for utilisateur field
            //
            $column = new TextViewColumn('utilisateur', 'utilisateur', 'Utilisateur', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for cours field
            //
            $column = new TextViewColumn('cours', 'cours', 'Cours', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_requis field
            //
            $column = new NumberViewColumn('no_requis', 'no_requis', 'No Requis', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_comman field
            //
            $column = new TextViewColumn('no_comman', 'no_comman', 'No Comman', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for quantite field
            //
            $column = new NumberViewColumn('quantite', 'quantite', 'Quantite', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for prix_unitaire field
            //
            $column = new NumberViewColumn('prix_unitaire', 'prix_unitaire', 'Prix Unitaire', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for cout_total field
            //
            $column = new NumberViewColumn('cout_total', 'cout_total', 'Cout Total', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_recept field
            //
            $column = new TextViewColumn('date_recept', 'date_recept', 'Date Recept', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_fin_d field
            //
            $column = new TextViewColumn('date_fin_d', 'date_fin_d', 'Date Fin D', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for code_compt field
            //
            $column = new NumberViewColumn('code_compt', 'code_compt', 'Code Compt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_charge', 'LA2', 'Id Charge', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for disponible field
            //
            $column = new NumberViewColumn('disponible', 'disponible', 'Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for disponible_web field
            //
            $column = new TextViewColumn('disponible_web', 'disponible_web', 'Disponible Web', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for documents_facture field
            //
            $column = new TextViewColumn('documents_facture', 'documents_facture', 'Documents Facture', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for document_bon_commande field
            //
            $column = new TextViewColumn('document_bon_commande', 'document_bon_commande', 'Document Bon Commande', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for document_manuel_utilisation field
            //
            $column = new TextViewColumn('document_manuel_utilisation', 'document_manuel_utilisation', 'Document Manuel Utilisation', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for autres_documents field
            //
            $column = new TextViewColumn('autres_documents', 'autres_documents', 'Autres Documents', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for description field
            //
            $column = new TextViewColumn('id_marque', 'LA3', 'Id Marque', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for description field
            //
            $column = new TextViewColumn('id_manufacturier', 'LA4', 'Id Manufacturier', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_modele field
            //
            $column = new NumberViewColumn('id_modele', 'id_modele', 'Id Modele', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'LA5', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers', 'LA6', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for id_mat_sci field
            //
            $column = new NumberViewColumn('id_mat_sci', 'id_mat_sci', 'Id Mat Sci', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_identif field
            //
            $column = new TextViewColumn('no_identif', 'no_identif', 'No Identif', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for transaction field
            //
            $column = new TextViewColumn('transaction', 'transaction', 'Transaction', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom_l_e field
            //
            $column = new TextViewColumn('nom_l_e', 'nom_l_e', 'Nom L E', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_equipement field
            //
            $column = new NumberViewColumn('id_equipement', 'id_equipement', 'Id Equipement', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for marque field
            //
            $column = new TextViewColumn('marque', 'marque', 'Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for manufacture field
            //
            $column = new TextViewColumn('manufacture', 'manufacture', 'Manufacture', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for modele field
            //
            $column = new TextViewColumn('modele', 'modele', 'Modele', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for fournisseur field
            //
            $column = new TextViewColumn('fournisseur', 'fournisseur', 'Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_fournisseur field
            //
            $column = new TextViewColumn('id_fournisseur', 'id_fournisseur', 'Id Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for caracteristique field
            //
            $column = new TextViewColumn('caracteristique', 'caracteristique', 'Caracteristique', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for utilisation field
            //
            $column = new TextViewColumn('utilisation', 'utilisation', 'Utilisation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for duree_vie field
            //
            $column = new TextViewColumn('duree_vie', 'duree_vie', 'Duree Vie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for etat field
            //
            $column = new TextViewColumn('etat', 'etat', 'Etat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for fonction field
            //
            $column = new TextViewColumn('fonction', 'fonction', 'Fonction', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for utilisateur field
            //
            $column = new TextViewColumn('utilisateur', 'utilisateur', 'Utilisateur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for cours field
            //
            $column = new TextViewColumn('cours', 'cours', 'Cours', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_requis field
            //
            $column = new NumberViewColumn('no_requis', 'no_requis', 'No Requis', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_comman field
            //
            $column = new TextViewColumn('no_comman', 'no_comman', 'No Comman', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for quantite field
            //
            $column = new NumberViewColumn('quantite', 'quantite', 'Quantite', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for prix_unitaire field
            //
            $column = new NumberViewColumn('prix_unitaire', 'prix_unitaire', 'Prix Unitaire', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for cout_total field
            //
            $column = new NumberViewColumn('cout_total', 'cout_total', 'Cout Total', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_recept field
            //
            $column = new TextViewColumn('date_recept', 'date_recept', 'Date Recept', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_fin_d field
            //
            $column = new TextViewColumn('date_fin_d', 'date_fin_d', 'Date Fin D', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for code_compt field
            //
            $column = new NumberViewColumn('code_compt', 'code_compt', 'Code Compt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_charge', 'LA2', 'Id Charge', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for disponible field
            //
            $column = new NumberViewColumn('disponible', 'disponible', 'Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for disponible_web field
            //
            $column = new TextViewColumn('disponible_web', 'disponible_web', 'Disponible Web', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for documents_facture field
            //
            $column = new TextViewColumn('documents_facture', 'documents_facture', 'Documents Facture', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for document_bon_commande field
            //
            $column = new TextViewColumn('document_bon_commande', 'document_bon_commande', 'Document Bon Commande', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for document_manuel_utilisation field
            //
            $column = new TextViewColumn('document_manuel_utilisation', 'document_manuel_utilisation', 'Document Manuel Utilisation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for autres_documents field
            //
            $column = new TextViewColumn('autres_documents', 'autres_documents', 'Autres Documents', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('id_marque', 'LA3', 'Id Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('id_manufacturier', 'LA4', 'Id Manufacturier', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_modele field
            //
            $column = new NumberViewColumn('id_modele', 'id_modele', 'Id Modele', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'LA5', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_pers', 'LA6', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for no_identif field
            //
            $editor = new TextEdit('no_identif_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('No Identif', 'no_identif', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for transaction field
            //
            $editor = new TextEdit('transaction_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Transaction', 'transaction', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for nom_l_e field
            //
            $editor = new TextEdit('nom_l_e_edit');
            $editor->SetMaxLength(80);
            $editColumn = new CustomEditColumn('Nom L E', 'nom_l_e', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_equipement field
            //
            $editor = new TextEdit('id_equipement_edit');
            $editColumn = new CustomEditColumn('Id Equipement', 'id_equipement', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for marque field
            //
            $editor = new TextEdit('marque_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Marque', 'marque', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for manufacture field
            //
            $editor = new TextEdit('manufacture_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Manufacture', 'manufacture', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for modele field
            //
            $editor = new TextEdit('modele_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Modele', 'modele', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for fournisseur field
            //
            $editor = new TextEdit('fournisseur_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Fournisseur', 'fournisseur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_fournisseur field
            //
            $editor = new TextEdit('id_fournisseur_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Fournisseur', 'id_fournisseur', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_serie field
            //
            $editor = new TextEdit('no_serie_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('No Serie', 'no_serie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for caracteristique field
            //
            $editor = new TextEdit('caracteristique_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Caracteristique', 'caracteristique', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for utilisation field
            //
            $editor = new TextEdit('utilisation_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Utilisation', 'utilisation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for duree_vie field
            //
            $editor = new TextEdit('duree_vie_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Duree Vie', 'duree_vie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for etat field
            //
            $editor = new TextEdit('etat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Etat', 'etat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for fonction field
            //
            $editor = new TextEdit('fonction_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Fonction', 'fonction', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for utilisateur field
            //
            $editor = new TextEdit('utilisateur_edit');
            $editor->SetMaxLength(60);
            $editColumn = new CustomEditColumn('Utilisateur', 'utilisateur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for cours field
            //
            $editor = new TextEdit('cours_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Cours', 'cours', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_requis field
            //
            $editor = new TextEdit('no_requis_edit');
            $editColumn = new CustomEditColumn('No Requis', 'no_requis', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_comman field
            //
            $editor = new TextEdit('no_comman_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('No Comman', 'no_comman', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for quantite field
            //
            $editor = new TextEdit('quantite_edit');
            $editColumn = new CustomEditColumn('Quantite', 'quantite', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for prix_unitaire field
            //
            $editor = new TextEdit('prix_unitaire_edit');
            $editColumn = new CustomEditColumn('Prix Unitaire', 'prix_unitaire', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for cout_total field
            //
            $editor = new TextEdit('cout_total_edit');
            $editColumn = new CustomEditColumn('Cout Total', 'cout_total', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_achat field
            //
            $editor = new TextEdit('date_achat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Achat', 'date_achat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_recept field
            //
            $editor = new TextEdit('date_recept_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Recept', 'date_recept', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_fin_d field
            //
            $editor = new TextEdit('date_fin_d_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Fin D', 'date_fin_d', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for code_compt field
            //
            $editor = new TextEdit('code_compt_edit');
            $editColumn = new CustomEditColumn('Code Compt', 'code_compt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextAreaEdit('commentaires_edit', 50, 8);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'edit_administratifs_personnel01_materiel_mat_sci_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_charge field
            //
            $editor = new DynamicCombobox('id_charge_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Charge', 'id_charge', 'LA2', 'edit_administratifs_personnel01_materiel_mat_sci_id_charge_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for disponible field
            //
            $editor = new TextEdit('disponible_edit');
            $editColumn = new CustomEditColumn('Disponible', 'disponible', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for disponible_web field
            //
            $editor = new TextEdit('disponible_web_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Disponible Web', 'disponible_web', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for documents_facture field
            //
            $editor = new TextEdit('documents_facture_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Documents Facture', 'documents_facture', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for document_bon_commande field
            //
            $editor = new TextEdit('document_bon_commande_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Document Bon Commande', 'document_bon_commande', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for document_manuel_utilisation field
            //
            $editor = new TextEdit('document_manuel_utilisation_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Document Manuel Utilisation', 'document_manuel_utilisation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for autres_documents field
            //
            $editor = new TextEdit('autres_documents_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Autres Documents', 'autres_documents', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_marque field
            //
            $editor = new DynamicCombobox('id_marque_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."marques"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_marque', true, true),
                    new StringField('description', true)
                )
            );
            $lookupDataset->setOrderByField('description', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Marque', 'id_marque', 'LA3', 'edit_administratifs_personnel01_materiel_mat_sci_id_marque_search', $editor, $this->dataset, $lookupDataset, 'id_marque', 'description', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_manufacturier field
            //
            $editor = new DynamicCombobox('id_manufacturier_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."manufacturier"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_marque', true, true),
                    new StringField('description', true)
                )
            );
            $lookupDataset->setOrderByField('description', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Manufacturier', 'id_manufacturier', 'LA4', 'edit_administratifs_personnel01_materiel_mat_sci_id_manufacturier_search', $editor, $this->dataset, $lookupDataset, 'id_marque', 'description', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_modele field
            //
            $editor = new TextEdit('id_modele_edit');
            $editColumn = new CustomEditColumn('Id Modele', 'id_modele', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_groupe field
            //
            $editor = new DynamicCombobox('id_groupe_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Groupe', 'id_groupe', 'LA5', 'edit_administratifs_personnel01_materiel_mat_sci_id_groupe_search', $editor, $this->dataset, $lookupDataset, 'id_groupe', 'nom_groupe', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_pers field
            //
            $editor = new DynamicCombobox('id_pers_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Pers', 'id_pers', 'LA6', 'edit_administratifs_personnel01_materiel_mat_sci_id_pers_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for no_identif field
            //
            $editor = new TextEdit('no_identif_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('No Identif', 'no_identif', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for transaction field
            //
            $editor = new TextEdit('transaction_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Transaction', 'transaction', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for nom_l_e field
            //
            $editor = new TextEdit('nom_l_e_edit');
            $editor->SetMaxLength(80);
            $editColumn = new CustomEditColumn('Nom L E', 'nom_l_e', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_equipement field
            //
            $editor = new TextEdit('id_equipement_edit');
            $editColumn = new CustomEditColumn('Id Equipement', 'id_equipement', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for marque field
            //
            $editor = new TextEdit('marque_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Marque', 'marque', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for manufacture field
            //
            $editor = new TextEdit('manufacture_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Manufacture', 'manufacture', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for modele field
            //
            $editor = new TextEdit('modele_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Modele', 'modele', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for fournisseur field
            //
            $editor = new TextEdit('fournisseur_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Fournisseur', 'fournisseur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_fournisseur field
            //
            $editor = new TextEdit('id_fournisseur_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Fournisseur', 'id_fournisseur', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_serie field
            //
            $editor = new TextEdit('no_serie_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('No Serie', 'no_serie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for caracteristique field
            //
            $editor = new TextEdit('caracteristique_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Caracteristique', 'caracteristique', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for utilisation field
            //
            $editor = new TextEdit('utilisation_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Utilisation', 'utilisation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for duree_vie field
            //
            $editor = new TextEdit('duree_vie_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Duree Vie', 'duree_vie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for etat field
            //
            $editor = new TextEdit('etat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Etat', 'etat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for fonction field
            //
            $editor = new TextEdit('fonction_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Fonction', 'fonction', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for utilisateur field
            //
            $editor = new TextEdit('utilisateur_edit');
            $editor->SetMaxLength(60);
            $editColumn = new CustomEditColumn('Utilisateur', 'utilisateur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for cours field
            //
            $editor = new TextEdit('cours_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Cours', 'cours', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_requis field
            //
            $editor = new TextEdit('no_requis_edit');
            $editColumn = new CustomEditColumn('No Requis', 'no_requis', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_comman field
            //
            $editor = new TextEdit('no_comman_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('No Comman', 'no_comman', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for quantite field
            //
            $editor = new TextEdit('quantite_edit');
            $editColumn = new CustomEditColumn('Quantite', 'quantite', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for prix_unitaire field
            //
            $editor = new TextEdit('prix_unitaire_edit');
            $editColumn = new CustomEditColumn('Prix Unitaire', 'prix_unitaire', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for cout_total field
            //
            $editor = new TextEdit('cout_total_edit');
            $editColumn = new CustomEditColumn('Cout Total', 'cout_total', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_achat field
            //
            $editor = new TextEdit('date_achat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Achat', 'date_achat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_recept field
            //
            $editor = new TextEdit('date_recept_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Recept', 'date_recept', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_fin_d field
            //
            $editor = new TextEdit('date_fin_d_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Fin D', 'date_fin_d', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for code_compt field
            //
            $editor = new TextEdit('code_compt_edit');
            $editColumn = new CustomEditColumn('Code Compt', 'code_compt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextAreaEdit('commentaires_edit', 50, 8);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'multi_edit_administratifs_personnel01_materiel_mat_sci_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_charge field
            //
            $editor = new DynamicCombobox('id_charge_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Charge', 'id_charge', 'LA2', 'multi_edit_administratifs_personnel01_materiel_mat_sci_id_charge_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for disponible field
            //
            $editor = new TextEdit('disponible_edit');
            $editColumn = new CustomEditColumn('Disponible', 'disponible', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for disponible_web field
            //
            $editor = new TextEdit('disponible_web_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Disponible Web', 'disponible_web', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for documents_facture field
            //
            $editor = new TextEdit('documents_facture_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Documents Facture', 'documents_facture', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for document_bon_commande field
            //
            $editor = new TextEdit('document_bon_commande_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Document Bon Commande', 'document_bon_commande', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for document_manuel_utilisation field
            //
            $editor = new TextEdit('document_manuel_utilisation_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Document Manuel Utilisation', 'document_manuel_utilisation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for autres_documents field
            //
            $editor = new TextEdit('autres_documents_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Autres Documents', 'autres_documents', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_modele field
            //
            $editor = new TextEdit('id_modele_edit');
            $editColumn = new CustomEditColumn('Id Modele', 'id_modele', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_groupe field
            //
            $editor = new DynamicCombobox('id_groupe_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Groupe', 'id_groupe', 'LA5', 'multi_edit_administratifs_personnel01_materiel_mat_sci_id_groupe_search', $editor, $this->dataset, $lookupDataset, 'id_groupe', 'nom_groupe', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_pers field
            //
            $editor = new DynamicCombobox('id_pers_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Pers', 'id_pers', 'LA6', 'multi_edit_administratifs_personnel01_materiel_mat_sci_id_pers_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for no_identif field
            //
            $editor = new TextEdit('no_identif_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('No Identif', 'no_identif', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for transaction field
            //
            $editor = new TextEdit('transaction_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Transaction', 'transaction', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for nom_l_e field
            //
            $editor = new TextEdit('nom_l_e_edit');
            $editor->SetMaxLength(80);
            $editColumn = new CustomEditColumn('Nom L E', 'nom_l_e', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_equipement field
            //
            $editor = new TextEdit('id_equipement_edit');
            $editColumn = new CustomEditColumn('Id Equipement', 'id_equipement', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for marque field
            //
            $editor = new TextEdit('marque_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Marque', 'marque', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for manufacture field
            //
            $editor = new TextEdit('manufacture_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Manufacture', 'manufacture', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for modele field
            //
            $editor = new TextEdit('modele_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Modele', 'modele', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for fournisseur field
            //
            $editor = new TextEdit('fournisseur_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Fournisseur', 'fournisseur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_fournisseur field
            //
            $editor = new TextEdit('id_fournisseur_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Id Fournisseur', 'id_fournisseur', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_serie field
            //
            $editor = new TextEdit('no_serie_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('No Serie', 'no_serie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for caracteristique field
            //
            $editor = new TextEdit('caracteristique_edit');
            $editor->SetMaxLength(50);
            $editColumn = new CustomEditColumn('Caracteristique', 'caracteristique', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for utilisation field
            //
            $editor = new TextEdit('utilisation_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Utilisation', 'utilisation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for duree_vie field
            //
            $editor = new TextEdit('duree_vie_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Duree Vie', 'duree_vie', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for etat field
            //
            $editor = new TextEdit('etat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Etat', 'etat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for fonction field
            //
            $editor = new TextEdit('fonction_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Fonction', 'fonction', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for utilisateur field
            //
            $editor = new TextEdit('utilisateur_edit');
            $editor->SetMaxLength(60);
            $editColumn = new CustomEditColumn('Utilisateur', 'utilisateur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for cours field
            //
            $editor = new TextEdit('cours_edit');
            $editor->SetMaxLength(40);
            $editColumn = new CustomEditColumn('Cours', 'cours', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_requis field
            //
            $editor = new TextEdit('no_requis_edit');
            $editColumn = new CustomEditColumn('No Requis', 'no_requis', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_comman field
            //
            $editor = new TextEdit('no_comman_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('No Comman', 'no_comman', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for quantite field
            //
            $editor = new TextEdit('quantite_edit');
            $editColumn = new CustomEditColumn('Quantite', 'quantite', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for prix_unitaire field
            //
            $editor = new TextEdit('prix_unitaire_edit');
            $editColumn = new CustomEditColumn('Prix Unitaire', 'prix_unitaire', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for cout_total field
            //
            $editor = new TextEdit('cout_total_edit');
            $editColumn = new CustomEditColumn('Cout Total', 'cout_total', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_achat field
            //
            $editor = new TextEdit('date_achat_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Achat', 'date_achat', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_recept field
            //
            $editor = new TextEdit('date_recept_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Recept', 'date_recept', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_fin_d field
            //
            $editor = new TextEdit('date_fin_d_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Date Fin D', 'date_fin_d', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for code_compt field
            //
            $editor = new TextEdit('code_compt_edit');
            $editColumn = new CustomEditColumn('Code Compt', 'code_compt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for commentaires field
            //
            $editor = new TextAreaEdit('commentaires_edit', 50, 8);
            $editColumn = new CustomEditColumn('Commentaires', 'commentaires', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'insert_administratifs_personnel01_materiel_mat_sci_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_charge field
            //
            $editor = new DynamicCombobox('id_charge_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Charge', 'id_charge', 'LA2', 'insert_administratifs_personnel01_materiel_mat_sci_id_charge_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for disponible field
            //
            $editor = new TextEdit('disponible_edit');
            $editColumn = new CustomEditColumn('Disponible', 'disponible', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for disponible_web field
            //
            $editor = new TextEdit('disponible_web_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Disponible Web', 'disponible_web', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for documents_facture field
            //
            $editor = new TextEdit('documents_facture_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Documents Facture', 'documents_facture', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for document_bon_commande field
            //
            $editor = new TextEdit('document_bon_commande_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Document Bon Commande', 'document_bon_commande', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for document_manuel_utilisation field
            //
            $editor = new TextEdit('document_manuel_utilisation_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Document Manuel Utilisation', 'document_manuel_utilisation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for autres_documents field
            //
            $editor = new TextEdit('autres_documents_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Autres Documents', 'autres_documents', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_marque field
            //
            $editor = new DynamicCombobox('id_marque_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."marques"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_marque', true, true),
                    new StringField('description', true)
                )
            );
            $lookupDataset->setOrderByField('description', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Marque', 'id_marque', 'LA3', 'insert_administratifs_personnel01_materiel_mat_sci_id_marque_search', $editor, $this->dataset, $lookupDataset, 'id_marque', 'description', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_manufacturier field
            //
            $editor = new DynamicCombobox('id_manufacturier_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"materiel"."manufacturier"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_marque', true, true),
                    new StringField('description', true)
                )
            );
            $lookupDataset->setOrderByField('description', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Manufacturier', 'id_manufacturier', 'LA4', 'insert_administratifs_personnel01_materiel_mat_sci_id_manufacturier_search', $editor, $this->dataset, $lookupDataset, 'id_marque', 'description', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_modele field
            //
            $editor = new TextEdit('id_modele_edit');
            $editColumn = new CustomEditColumn('Id Modele', 'id_modele', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_groupe field
            //
            $editor = new DynamicCombobox('id_groupe_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Groupe', 'id_groupe', 'LA5', 'insert_administratifs_personnel01_materiel_mat_sci_id_groupe_search', $editor, $this->dataset, $lookupDataset, 'id_groupe', 'nom_groupe', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_pers field
            //
            $editor = new DynamicCombobox('id_pers_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Pers', 'id_pers', 'LA6', 'insert_administratifs_personnel01_materiel_mat_sci_id_pers_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for id_mat_sci field
            //
            $column = new NumberViewColumn('id_mat_sci', 'id_mat_sci', 'Id Mat Sci', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_identif field
            //
            $column = new TextViewColumn('no_identif', 'no_identif', 'No Identif', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for transaction field
            //
            $column = new TextViewColumn('transaction', 'transaction', 'Transaction', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom_l_e field
            //
            $column = new TextViewColumn('nom_l_e', 'nom_l_e', 'Nom L E', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_equipement field
            //
            $column = new NumberViewColumn('id_equipement', 'id_equipement', 'Id Equipement', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for marque field
            //
            $column = new TextViewColumn('marque', 'marque', 'Marque', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for manufacture field
            //
            $column = new TextViewColumn('manufacture', 'manufacture', 'Manufacture', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for modele field
            //
            $column = new TextViewColumn('modele', 'modele', 'Modele', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for fournisseur field
            //
            $column = new TextViewColumn('fournisseur', 'fournisseur', 'Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_fournisseur field
            //
            $column = new TextViewColumn('id_fournisseur', 'id_fournisseur', 'Id Fournisseur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_serie field
            //
            $column = new TextViewColumn('no_serie', 'no_serie', 'No Serie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for caracteristique field
            //
            $column = new TextViewColumn('caracteristique', 'caracteristique', 'Caracteristique', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for utilisation field
            //
            $column = new TextViewColumn('utilisation', 'utilisation', 'Utilisation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for duree_vie field
            //
            $column = new TextViewColumn('duree_vie', 'duree_vie', 'Duree Vie', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for etat field
            //
            $column = new TextViewColumn('etat', 'etat', 'Etat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for fonction field
            //
            $column = new TextViewColumn('fonction', 'fonction', 'Fonction', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for utilisateur field
            //
            $column = new TextViewColumn('utilisateur', 'utilisateur', 'Utilisateur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for cours field
            //
            $column = new TextViewColumn('cours', 'cours', 'Cours', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_requis field
            //
            $column = new NumberViewColumn('no_requis', 'no_requis', 'No Requis', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_comman field
            //
            $column = new TextViewColumn('no_comman', 'no_comman', 'No Comman', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for quantite field
            //
            $column = new NumberViewColumn('quantite', 'quantite', 'Quantite', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for prix_unitaire field
            //
            $column = new NumberViewColumn('prix_unitaire', 'prix_unitaire', 'Prix Unitaire', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for cout_total field
            //
            $column = new NumberViewColumn('cout_total', 'cout_total', 'Cout Total', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_achat field
            //
            $column = new TextViewColumn('date_achat', 'date_achat', 'Date Achat', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_recept field
            //
            $column = new TextViewColumn('date_recept', 'date_recept', 'Date Recept', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_fin_d field
            //
            $column = new TextViewColumn('date_fin_d', 'date_fin_d', 'Date Fin D', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for code_compt field
            //
            $column = new NumberViewColumn('code_compt', 'code_compt', 'Code Compt', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for commentaires field
            //
            $column = new TextViewColumn('commentaires', 'commentaires', 'Commentaires', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_charge', 'LA2', 'Id Charge', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for disponible field
            //
            $column = new NumberViewColumn('disponible', 'disponible', 'Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $c