<?php

//  define('SHOW_VARIABLES', 1);
//  define('DEBUG_LEVEL', 1);

//  error_reporting(E_ALL ^ E_NOTICE);
//  ini_set('display_errors', 'On');

set_include_path('.' . PATH_SEPARATOR . get_include_path());


include_once dirname(__FILE__) . '/' . 'components/utils/system_utils.php';
include_once dirname(__FILE__) . '/' . 'components/mail/mailer.php';
include_once dirname(__FILE__) . '/' . 'components/mail/phpmailer_based_mailer.php';
require_once dirname(__FILE__) . '/' . 'database_engine/pgsql_engine.php';

//  SystemUtils::DisableMagicQuotesRuntime();

SystemUtils::SetTimeZoneIfNeed('America/New_York');

function GetGlobalConnectionOptions()
{
    return
        array(
          'server' => 'postgresql.uqam.ca',
          'port' => '5432',
          'username' => 'ohara_jf',
          'password' => 'pg_jf_scta!!',
          'database' => 'departement',
          'client_encoding' => 'utf8'
        );
}

function HasAdminPage()
{
    return true;
}

function HasHomePage()
{
    return true;
}

function GetHomeURL()
{
    return 'index.php';
}

function GetHomePageBanner()
{
    return '';
}

function GetPageGroups()
{
    $result = array();
    $result[] = array('caption' => 'Emprunts', 'description' => '');
    $result[] = array('caption' => 'Clés', 'description' => '');
    $result[] = array('caption' => 'Autres', 'description' => '');
    $result[] = array('caption' => 'Default', 'description' => '');
    return $result;
}

function GetPageInfos()
{
    $result = array();
    $result[] = array('caption' => 'Emprunts courants', 'short_caption' => 'Emprunts courants', 'filename' => 'scta_cle_emprunt.php', 'name' => 'cle_departement.scta_cle_emprunt', 'group_name' => 'Emprunts', 'add_separator' => false, 'description' => '');
    $result[] = array('caption' => 'Emprunts archivés', 'short_caption' => 'Emprunts archivés', 'filename' => 'scta_cle_emprunt01.php', 'name' => 'cle_departement.scta_cle_emprunt01', 'group_name' => 'Emprunts', 'add_separator' => false, 'description' => '');
    $result[] = array('caption' => 'Clés', 'short_caption' => 'Clés', 'filename' => 'cle_cles.php', 'name' => 'cle_departement.cle_cles', 'group_name' => 'Clés', 'add_separator' => false, 'description' => '');
    $result[] = array('caption' => 'Locaux', 'short_caption' => 'Locaux', 'filename' => 'locals.php', 'name' => 'administratifs.locals', 'group_name' => 'Default', 'add_separator' => false, 'description' => '');
    $result[] = array('caption' => 'Personnel', 'short_caption' => 'Personnel', 'filename' => 'personnel.php', 'name' => 'administratifs.personnel01', 'group_name' => 'Autres', 'add_separator' => false, 'description' => '');
    $result[] = array('caption' => 'Groupe', 'short_caption' => 'Groupe', 'filename' => 'groupe.php', 'name' => 'administratifs.groupe', 'group_name' => 'Autres', 'add_separator' => false, 'description' => '');
    $result[] = array('caption' => 'Statut', 'short_caption' => 'Statut', 'filename' => 'statut.php', 'name' => 'administratifs.statut', 'group_name' => 'Autres', 'add_separator' => false, 'description' => '');
    $result[] = array('caption' => 'Programme', 'short_caption' => 'Programme', 'filename' => 'sigle.php', 'name' => 'administratifs.sigle', 'group_name' => 'Autres', 'add_separator' => false, 'description' => '');
    $result[] = array('caption' => 'Nom Complet View', 'short_caption' => 'Nom Complet View', 'filename' => 'nom_complet_view.php', 'name' => 'administratifs.nom_complet_view', 'group_name' => 'Default', 'add_separator' => false, 'description' => '');
    return $result;
}

function GetPagesHeader()
{
    return
        '';
}

function GetPagesFooter()
{
    return
        '';
}

function ApplyCommonPageSettings(Page $page, Grid $grid)
{
    $page->SetShowUserAuthBar(true);
    $page->setShowNavigation(true);
    $page->OnGetCustomExportOptions->AddListener('Global_OnGetCustomExportOptions');
    $page->getDataset()->OnGetFieldValue->AddListener('Global_OnGetFieldValue');
    $page->getDataset()->OnGetFieldValue->AddListener('OnGetFieldValue', $page);
    $grid->BeforeUpdateRecord->AddListener('Global_BeforeUpdateHandler');
    $grid->BeforeDeleteRecord->AddListener('Global_BeforeDeleteHandler');
    $grid->BeforeInsertRecord->AddListener('Global_BeforeInsertHandler');
    $grid->AfterUpdateRecord->AddListener('Global_AfterUpdateHandler');
    $grid->AfterDeleteRecord->AddListener('Global_AfterDeleteHandler');
    $grid->AfterInsertRecord->AddListener('Global_AfterInsertHandler');
}

function GetAnsiEncoding() { return 'windows-1252'; }

function Global_AddEnvironmentVariablesHandler(&$variables)
{

}

function Global_CustomHTMLHeaderHandler($page, &$customHtmlHeaderText)
{

}

function Global_GetCustomTemplateHandler($type, $part, $mode, &$result, &$params, $page = null)
{

}

function Global_OnGetCustomExportOptions($page, $exportType, $rowData, &$options)
{

}

function Global_OnGetFieldValue($fieldName, &$value, $tableName)
{

}

function Global_GetCustomPageList(CommonPage $page, PageList $pageList)
{

}

function Global_BeforeInsertHandler($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
{

}

function Global_BeforeUpdateHandler($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
{

}

function Global_BeforeDeleteHandler($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
{

}

function Global_AfterInsertHandler($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
{

}

function Global_AfterUpdateHandler($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
{

}

function Global_AfterDeleteHandler($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
{

}

function GetDefaultDateFormat()
{
    return 'Y-m-d';
}

function GetFirstDayOfWeek()
{
    return 0;
}

function GetPageListType()
{
    return PageList::TYPE_MENU;
}

function GetNullLabel()
{
    return null;
}

function UseMinifiedJS()
{
    return true;
}

function GetOfflineMode()
{
    return false;
}

function GetInactivityTimeout()
{
    return 30000;
}

function GetMailer()
{
    $smtpOptions = new SMTPOptions('mail.uqam.ca', 25, false, '', '', '');
    $mailerOptions = new MailerOptions(MailerType::SMTP, 'scta.info@uqam.ca', 'Info SCTA', $smtpOptions);
    
    return PHPMailerBasedMailer::getInstance($mailerOptions);
}

function sendMailMessage($recipients, $messageSubject, $messageBody, $attachments = '', $cc = '', $bcc = '')
{
    GetMailer()->send($recipients, $messageSubject, $messageBody, $attachments, $cc, $bcc);
}

function createConnection()
{
    $connectionOptions = GetGlobalConnectionOptions();
    $connectionOptions['client_encoding'] = 'utf8';

    $connectionFactory = PgConnectionFactory::getInstance();
    return $connectionFactory->CreateConnection($connectionOptions);
}

/**
 * @param string $pageName
 * @return IPermissionSet
 */
function GetCurrentUserPermissionsForPage($pageName) 
{
    return GetApplication()->GetCurrentUserPermissionSet($pageName);
}
