<?php
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                   ATTENTION!
 * If you see this message in your browser (Internet Explorer, Mozilla Firefox, Google Chrome, etc.)
 * this means that PHP is not properly installed on your web server. Please refer to the PHP manual
 * for more details: http://php.net/manual/install.php 
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

    include_once dirname(__FILE__) . '/components/startup.php';
    include_once dirname(__FILE__) . '/components/application.php';
    include_once dirname(__FILE__) . '/' . 'authorization.php';


    include_once dirname(__FILE__) . '/' . 'database_engine/pgsql_engine.php';
    include_once dirname(__FILE__) . '/' . 'components/page/page_includes.php';

    function GetConnectionOptions()
    {
        $result = GetGlobalConnectionOptions();
        $result['client_encoding'] = 'utf8';
        GetApplication()->GetUserAuthentication()->applyIdentityToConnectionOptions($result);
        return $result;
    }

    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class cle_departement_scta_cle_emprunt_administratifs_personnelPage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Personnel');
            $this->SetMenuLabel('Personnel');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $this->dataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $this->dataset->AddLookupField('id_loc', 'administratifs.locals', new IntegerField('id_loc'), new StringField('no_loc', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('id_statut', 'administratifs.statut', new IntegerField('id_statut'), new StringField('nom_statut', false, false, false, false, 'LA2', 'LT2'), 'LT2');
            $this->dataset->AddLookupField('id_groupe', 'administratifs.groupe', new IntegerField('id_groupe'), new StringField('nom_groupe', false, false, false, false, 'LA3', 'LT3'), 'LT3');
            $this->dataset->AddLookupField('num_sigle', 'administratifs.sigle', new IntegerField('num_sigle'), new StringField('sigle_programme', false, false, false, false, 'LA4', 'LT4'), 'LT4');
            $this->dataset->AddLookupField('id_prof_reponsables', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA5', 'LT5'), 'LT5');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'nom', 'nom', 'Nom'),
                new FilterColumn($this->dataset, 'prenom', 'prenom', 'Prenom'),
                new FilterColumn($this->dataset, 'no_tel_trav', 'no_tel_trav', 'No Tel Trav'),
                new FilterColumn($this->dataset, 'no_tel_mais', 'no_tel_mais', 'No Tel Mais'),
                new FilterColumn($this->dataset, 'id_loc', 'LA1', 'Id Loc'),
                new FilterColumn($this->dataset, 'id_statut', 'LA2', 'Id Statut'),
                new FilterColumn($this->dataset, 'id_groupe', 'LA3', 'Id Groupe'),
                new FilterColumn($this->dataset, 'sujets', 'sujets', 'Sujets'),
                new FilterColumn($this->dataset, 'id_pers', 'id_pers', 'Id Pers'),
                new FilterColumn($this->dataset, 'num_sigle', 'LA4', 'Num Sigle'),
                new FilterColumn($this->dataset, 'courriel', 'courriel', 'Courriel'),
                new FilterColumn($this->dataset, 'code_perm', 'code_perm', 'Code Perm'),
                new FilterColumn($this->dataset, 'actif', 'actif', 'Actif'),
                new FilterColumn($this->dataset, 'codems', 'codems', 'Codems'),
                new FilterColumn($this->dataset, 'id_prof_reponsables', 'LA5', 'Id Prof Reponsables')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['nom'])
                ->addColumn($columns['prenom'])
                ->addColumn($columns['no_tel_trav'])
                ->addColumn($columns['no_tel_mais'])
                ->addColumn($columns['id_loc'])
                ->addColumn($columns['id_statut'])
                ->addColumn($columns['id_groupe'])
                ->addColumn($columns['sujets'])
                ->addColumn($columns['id_pers'])
                ->addColumn($columns['num_sigle'])
                ->addColumn($columns['courriel'])
                ->addColumn($columns['code_perm'])
                ->addColumn($columns['actif'])
                ->addColumn($columns['codems'])
                ->addColumn($columns['id_prof_reponsables']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_loc')
                ->setOptionsFor('id_statut')
                ->setOptionsFor('id_groupe')
                ->setOptionsFor('num_sigle')
                ->setOptionsFor('id_prof_reponsables');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('nom_edit');
            
            $filterBuilder->addColumn(
                $columns['nom'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('prenom_edit');
            $main_editor->SetMaxLength(30);
            
            $filterBuilder->addColumn(
                $columns['prenom'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_tel_trav');
            
            $filterBuilder->addColumn(
                $columns['no_tel_trav'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_tel_mais');
            
            $filterBuilder->addColumn(
                $columns['no_tel_mais'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_cle_departement_scta_cle_emprunt_administratifs_personnel_id_loc_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_loc', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_cle_departement_scta_cle_emprunt_administratifs_personnel_id_loc_search');
            
            $text_editor = new TextEdit('id_loc');
            
            $filterBuilder->addColumn(
                $columns['id_loc'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_statut_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_cle_departement_scta_cle_emprunt_administratifs_personnel_id_statut_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_statut', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_cle_departement_scta_cle_emprunt_administratifs_personnel_id_statut_search');
            
            $text_editor = new TextEdit('id_statut');
            
            $filterBuilder->addColumn(
                $columns['id_statut'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_groupe_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_cle_departement_scta_cle_emprunt_administratifs_personnel_id_groupe_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_groupe', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_cle_departement_scta_cle_emprunt_administratifs_personnel_id_groupe_search');
            
            $text_editor = new TextEdit('id_groupe');
            
            $filterBuilder->addColumn(
                $columns['id_groupe'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('sujets');
            
            $filterBuilder->addColumn(
                $columns['sujets'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_pers_edit');
            
            $filterBuilder->addColumn(
                $columns['id_pers'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('num_sigle_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_cle_departement_scta_cle_emprunt_administratifs_personnel_num_sigle_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('num_sigle', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_cle_departement_scta_cle_emprunt_administratifs_personnel_num_sigle_search');
            
            $filterBuilder->addColumn(
                $columns['num_sigle'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('courriel');
            
            $filterBuilder->addColumn(
                $columns['courriel'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('code_perm_edit');
            $main_editor->SetMaxLength(30);
            
            $filterBuilder->addColumn(
                $columns['code_perm'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('actif_edit');
            
            $filterBuilder->addColumn(
                $columns['actif'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('codems');
            
            $filterBuilder->addColumn(
                $columns['codems'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_prof_reponsables_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_cle_departement_scta_cle_emprunt_administratifs_personnel_id_prof_reponsables_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_prof_reponsables', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_cle_departement_scta_cle_emprunt_administratifs_personnel_id_prof_reponsables_search');
            
            $text_editor = new TextEdit('id_prof_reponsables');
            
            $filterBuilder->addColumn(
                $columns['id_prof_reponsables'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('nom', 'nom', 'Nom', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for prenom field
            //
            $column = new TextViewColumn('prenom', 'prenom', 'Prenom', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_tel_trav field
            //
            $column = new TextViewColumn('no_tel_trav', 'no_tel_trav', 'No Tel Trav', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_tel_mais field
            //
            $column = new TextViewColumn('no_tel_mais', 'no_tel_mais', 'No Tel Mais', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom_statut field
            //
            $column = new TextViewColumn('id_statut', 'LA2', 'Id Statut', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'LA3', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for sujets field
            //
            $column = new TextViewColumn('sujets', 'sujets', 'Sujets', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for sigle_programme field
            //
            $column = new NumberViewColumn('num_sigle', 'LA4', 'Num Sigle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for courriel field
            //
            $column = new TextViewColumn('courriel', 'courriel', 'Courriel', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for code_perm field
            //
            $column = new TextViewColumn('code_perm', 'code_perm', 'Code Perm', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for actif field
            //
            $column = new NumberViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for codems field
            //
            $column = new TextViewColumn('codems', 'codems', 'Codems', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_prof_reponsables', 'LA5', 'Id Prof Reponsables', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('nom', 'nom', 'Nom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for prenom field
            //
            $column = new TextViewColumn('prenom', 'prenom', 'Prenom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_tel_trav field
            //
            $column = new TextViewColumn('no_tel_trav', 'no_tel_trav', 'No Tel Trav', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_tel_mais field
            //
            $column = new TextViewColumn('no_tel_mais', 'no_tel_mais', 'No Tel Mais', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom_statut field
            //
            $column = new TextViewColumn('id_statut', 'LA2', 'Id Statut', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'LA3', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for sujets field
            //
            $column = new TextViewColumn('sujets', 'sujets', 'Sujets', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for sigle_programme field
            //
            $column = new NumberViewColumn('num_sigle', 'LA4', 'Num Sigle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for courriel field
            //
            $column = new TextViewColumn('courriel', 'courriel', 'Courriel', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for code_perm field
            //
            $column = new TextViewColumn('code_perm', 'code_perm', 'Code Perm', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for actif field
            //
            $column = new NumberViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for codems field
            //
            $column = new TextViewColumn('codems', 'codems', 'Codems', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_prof_reponsables', 'LA5', 'Id Prof Reponsables', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for nom field
            //
            $editor = new TextEdit('nom_edit');
            $editColumn = new CustomEditColumn('Nom', 'nom', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for prenom field
            //
            $editor = new TextEdit('prenom_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Prenom', 'prenom', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_tel_trav field
            //
            $editor = new TextAreaEdit('no_tel_trav_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Tel Trav', 'no_tel_trav', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_tel_mais field
            //
            $editor = new TextAreaEdit('no_tel_mais_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Tel Mais', 'no_tel_mais', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'edit_cle_departement_scta_cle_emprunt_administratifs_personnel_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_statut field
            //
            $editor = new DynamicCombobox('id_statut_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."statut"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_statut', true, true, true),
                    new StringField('nom_statut', true)
                )
            );
            $lookupDataset->setOrderByField('nom_statut', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Statut', 'id_statut', 'LA2', 'edit_cle_departement_scta_cle_emprunt_administratifs_personnel_id_statut_search', $editor, $this->dataset, $lookupDataset, 'id_statut', 'nom_statut', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_groupe field
            //
            $editor = new DynamicCombobox('id_groupe_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Groupe', 'id_groupe', 'LA3', 'edit_cle_departement_scta_cle_emprunt_administratifs_personnel_id_groupe_search', $editor, $this->dataset, $lookupDataset, 'id_groupe', 'nom_groupe', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for sujets field
            //
            $editor = new TextAreaEdit('sujets_edit', 50, 8);
            $editColumn = new CustomEditColumn('Sujets', 'sujets', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for num_sigle field
            //
            $editor = new DynamicCombobox('num_sigle_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Num Sigle', 'num_sigle', 'LA4', 'edit_cle_departement_scta_cle_emprunt_administratifs_personnel_num_sigle_search', $editor, $this->dataset, $lookupDataset, 'num_sigle', 'sigle_programme', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for courriel field
            //
            $editor = new TextAreaEdit('courriel_edit', 50, 8);
            $editColumn = new CustomEditColumn('Courriel', 'courriel', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for code_perm field
            //
            $editor = new TextEdit('code_perm_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Code Perm', 'code_perm', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for actif field
            //
            $editor = new TextEdit('actif_edit');
            $editColumn = new CustomEditColumn('Actif', 'actif', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for codems field
            //
            $editor = new TextAreaEdit('codems_edit', 50, 8);
            $editColumn = new CustomEditColumn('Codems', 'codems', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_prof_reponsables field
            //
            $editor = new DynamicCombobox('id_prof_reponsables_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Prof Reponsables', 'id_prof_reponsables', 'LA5', 'edit_cle_departement_scta_cle_emprunt_administratifs_personnel_id_prof_reponsables_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for nom field
            //
            $editor = new TextEdit('nom_edit');
            $editColumn = new CustomEditColumn('Nom', 'nom', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for prenom field
            //
            $editor = new TextEdit('prenom_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Prenom', 'prenom', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_tel_trav field
            //
            $editor = new TextAreaEdit('no_tel_trav_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Tel Trav', 'no_tel_trav', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_tel_mais field
            //
            $editor = new TextAreaEdit('no_tel_mais_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Tel Mais', 'no_tel_mais', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'multi_edit_cle_departement_scta_cle_emprunt_administratifs_personnel_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_statut field
            //
            $editor = new DynamicCombobox('id_statut_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."statut"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_statut', true, true, true),
                    new StringField('nom_statut', true)
                )
            );
            $lookupDataset->setOrderByField('nom_statut', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Statut', 'id_statut', 'LA2', 'multi_edit_cle_departement_scta_cle_emprunt_administratifs_personnel_id_statut_search', $editor, $this->dataset, $lookupDataset, 'id_statut', 'nom_statut', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_groupe field
            //
            $editor = new DynamicCombobox('id_groupe_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Groupe', 'id_groupe', 'LA3', 'multi_edit_cle_departement_scta_cle_emprunt_administratifs_personnel_id_groupe_search', $editor, $this->dataset, $lookupDataset, 'id_groupe', 'nom_groupe', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for sujets field
            //
            $editor = new TextAreaEdit('sujets_edit', 50, 8);
            $editColumn = new CustomEditColumn('Sujets', 'sujets', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for num_sigle field
            //
            $editor = new DynamicCombobox('num_sigle_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Num Sigle', 'num_sigle', 'LA4', 'multi_edit_cle_departement_scta_cle_emprunt_administratifs_personnel_num_sigle_search', $editor, $this->dataset, $lookupDataset, 'num_sigle', 'sigle_programme', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for courriel field
            //
            $editor = new TextAreaEdit('courriel_edit', 50, 8);
            $editColumn = new CustomEditColumn('Courriel', 'courriel', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for code_perm field
            //
            $editor = new TextEdit('code_perm_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Code Perm', 'code_perm', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for actif field
            //
            $editor = new TextEdit('actif_edit');
            $editColumn = new CustomEditColumn('Actif', 'actif', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for codems field
            //
            $editor = new TextAreaEdit('codems_edit', 50, 8);
            $editColumn = new CustomEditColumn('Codems', 'codems', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_prof_reponsables field
            //
            $editor = new DynamicCombobox('id_prof_reponsables_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Prof Reponsables', 'id_prof_reponsables', 'LA5', 'multi_edit_cle_departement_scta_cle_emprunt_administratifs_personnel_id_prof_reponsables_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for nom field
            //
            $editor = new TextEdit('nom_edit');
            $editColumn = new CustomEditColumn('Nom', 'nom', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for prenom field
            //
            $editor = new TextEdit('prenom_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Prenom', 'prenom', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_tel_trav field
            //
            $editor = new TextAreaEdit('no_tel_trav_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Tel Trav', 'no_tel_trav', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_tel_mais field
            //
            $editor = new TextAreaEdit('no_tel_mais_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Tel Mais', 'no_tel_mais', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'insert_cle_departement_scta_cle_emprunt_administratifs_personnel_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_statut field
            //
            $editor = new DynamicCombobox('id_statut_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."statut"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_statut', true, true, true),
                    new StringField('nom_statut', true)
                )
            );
            $lookupDataset->setOrderByField('nom_statut', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Statut', 'id_statut', 'LA2', 'insert_cle_departement_scta_cle_emprunt_administratifs_personnel_id_statut_search', $editor, $this->dataset, $lookupDataset, 'id_statut', 'nom_statut', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_groupe field
            //
            $editor = new DynamicCombobox('id_groupe_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Groupe', 'id_groupe', 'LA3', 'insert_cle_departement_scta_cle_emprunt_administratifs_personnel_id_groupe_search', $editor, $this->dataset, $lookupDataset, 'id_groupe', 'nom_groupe', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for sujets field
            //
            $editor = new TextAreaEdit('sujets_edit', 50, 8);
            $editColumn = new CustomEditColumn('Sujets', 'sujets', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for num_sigle field
            //
            $editor = new DynamicCombobox('num_sigle_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Num Sigle', 'num_sigle', 'LA4', 'insert_cle_departement_scta_cle_emprunt_administratifs_personnel_num_sigle_search', $editor, $this->dataset, $lookupDataset, 'num_sigle', 'sigle_programme', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for courriel field
            //
            $editor = new TextAreaEdit('courriel_edit', 50, 8);
            $editColumn = new CustomEditColumn('Courriel', 'courriel', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for code_perm field
            //
            $editor = new TextEdit('code_perm_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Code Perm', 'code_perm', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for actif field
            //
            $editor = new TextEdit('actif_edit');
            $editColumn = new CustomEditColumn('Actif', 'actif', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for codems field
            //
            $editor = new TextAreaEdit('codems_edit', 50, 8);
            $editColumn = new CustomEditColumn('Codems', 'codems', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_prof_reponsables field
            //
            $editor = new DynamicCombobox('id_prof_reponsables_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Prof Reponsables', 'id_prof_reponsables', 'LA5', 'insert_cle_departement_scta_cle_emprunt_administratifs_personnel_id_prof_reponsables_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('nom', 'nom', 'Nom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for prenom field
            //
            $column = new TextViewColumn('prenom', 'prenom', 'Prenom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_tel_trav field
            //
            $column = new TextViewColumn('no_tel_trav', 'no_tel_trav', 'No Tel Trav', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_tel_mais field
            //
            $column = new TextViewColumn('no_tel_mais', 'no_tel_mais', 'No Tel Mais', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom_statut field
            //
            $column = new TextViewColumn('id_statut', 'LA2', 'Id Statut', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'LA3', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for sujets field
            //
            $column = new TextViewColumn('sujets', 'sujets', 'Sujets', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for sigle_programme field
            //
            $column = new NumberViewColumn('num_sigle', 'LA4', 'Num Sigle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for courriel field
            //
            $column = new TextViewColumn('courriel', 'courriel', 'Courriel', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for code_perm field
            //
            $column = new TextViewColumn('code_perm', 'code_perm', 'Code Perm', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for actif field
            //
            $column = new NumberViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for codems field
            //
            $column = new TextViewColumn('codems', 'codems', 'Codems', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_prof_reponsables', 'LA5', 'Id Prof Reponsables', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('nom', 'nom', 'Nom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for prenom field
            //
            $column = new TextViewColumn('prenom', 'prenom', 'Prenom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_tel_trav field
            //
            $column = new TextViewColumn('no_tel_trav', 'no_tel_trav', 'No Tel Trav', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_tel_mais field
            //
            $column = new TextViewColumn('no_tel_mais', 'no_tel_mais', 'No Tel Mais', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom_statut field
            //
            $column = new TextViewColumn('id_statut', 'LA2', 'Id Statut', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'LA3', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for sujets field
            //
            $column = new TextViewColumn('sujets', 'sujets', 'Sujets', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for sigle_programme field
            //
            $column = new NumberViewColumn('num_sigle', 'LA4', 'Num Sigle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for courriel field
            //
            $column = new TextViewColumn('courriel', 'courriel', 'Courriel', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for code_perm field
            //
            $column = new TextViewColumn('code_perm', 'code_perm', 'Code Perm', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for actif field
            //
            $column = new NumberViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for codems field
            //
            $column = new TextViewColumn('codems', 'codems', 'Codems', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_prof_reponsables', 'LA5', 'Id Prof Reponsables', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('nom', 'nom', 'Nom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for prenom field
            //
            $column = new TextViewColumn('prenom', 'prenom', 'Prenom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_tel_trav field
            //
            $column = new TextViewColumn('no_tel_trav', 'no_tel_trav', 'No Tel Trav', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_tel_mais field
            //
            $column = new TextViewColumn('no_tel_mais', 'no_tel_mais', 'No Tel Mais', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom_statut field
            //
            $column = new TextViewColumn('id_statut', 'LA2', 'Id Statut', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'LA3', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for sujets field
            //
            $column = new TextViewColumn('sujets', 'sujets', 'Sujets', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for sigle_programme field
            //
            $column = new NumberViewColumn('num_sigle', 'LA4', 'Num Sigle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for courriel field
            //
            $column = new TextViewColumn('courriel', 'courriel', 'Courriel', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for code_perm field
            //
            $column = new TextViewColumn('code_perm', 'code_perm', 'Code Perm', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for actif field
            //
            $column = new NumberViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for codems field
            //
            $column = new TextViewColumn('codems', 'codems', 'Codems', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_prof_reponsables', 'LA5', 'Id Prof Reponsables', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(true);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_cle_departement_scta_cle_emprunt_administratifs_personnel_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."statut"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_statut', true, true, true),
                    new StringField('nom_statut', true)
                )
            );
            $lookupDataset->setOrderByField('nom_statut', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_cle_departement_scta_cle_emprunt_administratifs_personnel_id_statut_search', 'id_statut', 'nom_statut', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_cle_departement_scta_cle_emprunt_administratifs_personnel_id_groupe_search', 'id_groupe', 'nom_groupe', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_cle_departement_scta_cle_emprunt_administratifs_personnel_num_sigle_search', 'num_sigle', 'sigle_programme', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_cle_departement_scta_cle_emprunt_administratifs_personnel_id_prof_reponsables_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_cle_departement_scta_cle_emprunt_administratifs_personnel_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."statut"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_statut', true, true, true),
                    new StringField('nom_statut', true)
                )
            );
            $lookupDataset->setOrderByField('nom_statut', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_cle_departement_scta_cle_emprunt_administratifs_personnel_id_statut_search', 'id_statut', 'nom_statut', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_cle_departement_scta_cle_emprunt_administratifs_personnel_id_groupe_search', 'id_groupe', 'nom_groupe', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_cle_departement_scta_cle_emprunt_administratifs_personnel_id_groupe_search', 'id_groupe', 'nom_groupe', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_cle_departement_scta_cle_emprunt_administratifs_personnel_num_sigle_search', 'num_sigle', 'sigle_programme', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_cle_departement_scta_cle_emprunt_administratifs_personnel_num_sigle_search', 'num_sigle', 'sigle_programme', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_cle_departement_scta_cle_emprunt_administratifs_personnel_id_prof_reponsables_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_cle_departement_scta_cle_emprunt_administratifs_personnel_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."statut"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_statut', true, true, true),
                    new StringField('nom_statut', true)
                )
            );
            $lookupDataset->setOrderByField('nom_statut', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_cle_departement_scta_cle_emprunt_administratifs_personnel_id_statut_search', 'id_statut', 'nom_statut', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_cle_departement_scta_cle_emprunt_administratifs_personnel_id_groupe_search', 'id_groupe', 'nom_groupe', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_cle_departement_scta_cle_emprunt_administratifs_personnel_num_sigle_search', 'num_sigle', 'sigle_programme', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_cle_departement_scta_cle_emprunt_administratifs_personnel_id_prof_reponsables_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_cle_departement_scta_cle_emprunt_administratifs_personnel_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."statut"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_statut', true, true, true),
                    new StringField('nom_statut', true)
                )
            );
            $lookupDataset->setOrderByField('nom_statut', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_cle_departement_scta_cle_emprunt_administratifs_personnel_id_statut_search', 'id_statut', 'nom_statut', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_cle_departement_scta_cle_emprunt_administratifs_personnel_id_groupe_search', 'id_groupe', 'nom_groupe', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_cle_departement_scta_cle_emprunt_administratifs_personnel_num_sigle_search', 'num_sigle', 'sigle_programme', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_cle_departement_scta_cle_emprunt_administratifs_personnel_id_prof_reponsables_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }
    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class cle_departement_scta_cle_emprunt_cle_departement_cle_clesPage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Cle Cles');
            $this->SetMenuLabel('Cle Cles');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"cle_departement"."cle_cles"');
            $this->dataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new IntegerField('boite'),
                    new StringField('crochet'),
                    new StringField('num_cle'),
                    new StringField('description'),
                    new StringField('no_local'),
                    new StringField('ref_local'),
                    new IntegerField('id_local'),
                    new StringField('nb_total'),
                    new StringField('nb_circulation'),
                    new StringField('nb_disponible')
                )
            );
            $this->dataset->AddLookupField('id_local', 'administratifs.locals', new IntegerField('id_loc'), new StringField('no_loc', false, false, false, false, 'LA1', 'LT1'), 'LT1');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'id', 'id', 'Id'),
                new FilterColumn($this->dataset, 'boite', 'boite', 'Boite'),
                new FilterColumn($this->dataset, 'crochet', 'crochet', 'Crochet'),
                new FilterColumn($this->dataset, 'num_cle', 'num_cle', 'Num Cle'),
                new FilterColumn($this->dataset, 'description', 'description', 'Description'),
                new FilterColumn($this->dataset, 'no_local', 'no_local', 'No Local'),
                new FilterColumn($this->dataset, 'ref_local', 'ref_local', 'Ref Local'),
                new FilterColumn($this->dataset, 'id_local', 'LA1', 'Id Local'),
                new FilterColumn($this->dataset, 'nb_total', 'nb_total', 'Nb Total'),
                new FilterColumn($this->dataset, 'nb_circulation', 'nb_circulation', 'Nb Circulation'),
                new FilterColumn($this->dataset, 'nb_disponible', 'nb_disponible', 'Nb Disponible')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['id'])
                ->addColumn($columns['boite'])
                ->addColumn($columns['crochet'])
                ->addColumn($columns['num_cle'])
                ->addColumn($columns['description'])
                ->addColumn($columns['no_local'])
                ->addColumn($columns['ref_local'])
                ->addColumn($columns['id_local'])
                ->addColumn($columns['nb_total'])
                ->addColumn($columns['nb_circulation'])
                ->addColumn($columns['nb_disponible']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_local');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('id_edit');
            
            $filterBuilder->addColumn(
                $columns['id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('boite_edit');
            
            $filterBuilder->addColumn(
                $columns['boite'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('crochet_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['crochet'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('num_cle_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['num_cle'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('description_edit');
            $main_editor->SetMaxLength(90);
            
            $filterBuilder->addColumn(
                $columns['description'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_local_edit');
            $main_editor->SetMaxLength(20);
            
            $filterBuilder->addColumn(
                $columns['no_local'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('ref_local_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['ref_local'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_local_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_cle_departement_scta_cle_emprunt_cle_departement_cle_cles_id_local_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_local', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_cle_departement_scta_cle_emprunt_cle_departement_cle_cles_id_local_search');
            
            $text_editor = new TextEdit('id_local');
            
            $filterBuilder->addColumn(
                $columns['id_local'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('nb_total_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['nb_total'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('nb_circulation_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['nb_circulation'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('nb_disponible_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['nb_disponible'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for boite field
            //
            $column = new NumberViewColumn('boite', 'boite', 'Boite', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for crochet field
            //
            $column = new TextViewColumn('crochet', 'crochet', 'Crochet', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for num_cle field
            //
            $column = new TextViewColumn('num_cle', 'num_cle', 'Num Cle', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_local field
            //
            $column = new TextViewColumn('no_local', 'no_local', 'No Local', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for ref_local field
            //
            $column = new TextViewColumn('ref_local', 'ref_local', 'Ref Local', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_local', 'LA1', 'Id Local', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nb_total field
            //
            $column = new TextViewColumn('nb_total', 'nb_total', 'Nb Total', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nb_circulation field
            //
            $column = new TextViewColumn('nb_circulation', 'nb_circulation', 'Nb Circulation', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nb_disponible field
            //
            $column = new TextViewColumn('nb_disponible', 'nb_disponible', 'Nb Disponible', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for boite field
            //
            $column = new NumberViewColumn('boite', 'boite', 'Boite', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for crochet field
            //
            $column = new TextViewColumn('crochet', 'crochet', 'Crochet', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for num_cle field
            //
            $column = new TextViewColumn('num_cle', 'num_cle', 'Num Cle', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_local field
            //
            $column = new TextViewColumn('no_local', 'no_local', 'No Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for ref_local field
            //
            $column = new TextViewColumn('ref_local', 'ref_local', 'Ref Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_local', 'LA1', 'Id Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nb_total field
            //
            $column = new TextViewColumn('nb_total', 'nb_total', 'Nb Total', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nb_circulation field
            //
            $column = new TextViewColumn('nb_circulation', 'nb_circulation', 'Nb Circulation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nb_disponible field
            //
            $column = new TextViewColumn('nb_disponible', 'nb_disponible', 'Nb Disponible', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for id field
            //
            $editor = new TextEdit('id_edit');
            $editColumn = new CustomEditColumn('Id', 'id', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for boite field
            //
            $editor = new TextEdit('boite_edit');
            $editColumn = new CustomEditColumn('Boite', 'boite', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for crochet field
            //
            $editor = new TextEdit('crochet_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Crochet', 'crochet', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for num_cle field
            //
            $editor = new TextEdit('num_cle_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Num Cle', 'num_cle', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for description field
            //
            $editor = new TextEdit('description_edit');
            $editor->SetMaxLength(90);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_local field
            //
            $editor = new TextEdit('no_local_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Local', 'no_local', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for ref_local field
            //
            $editor = new TextEdit('ref_local_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Ref Local', 'ref_local', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_local field
            //
            $editor = new DynamicCombobox('id_local_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Local', 'id_local', 'LA1', 'edit_cle_departement_scta_cle_emprunt_cle_departement_cle_cles_id_local_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for nb_total field
            //
            $editor = new TextEdit('nb_total_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Nb Total', 'nb_total', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for nb_circulation field
            //
            $editor = new TextEdit('nb_circulation_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Nb Circulation', 'nb_circulation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for nb_disponible field
            //
            $editor = new TextEdit('nb_disponible_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Nb Disponible', 'nb_disponible', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for boite field
            //
            $editor = new TextEdit('boite_edit');
            $editColumn = new CustomEditColumn('Boite', 'boite', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for crochet field
            //
            $editor = new TextEdit('crochet_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Crochet', 'crochet', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for num_cle field
            //
            $editor = new TextEdit('num_cle_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Num Cle', 'num_cle', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for description field
            //
            $editor = new TextEdit('description_edit');
            $editor->SetMaxLength(90);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_local field
            //
            $editor = new TextEdit('no_local_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Local', 'no_local', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for ref_local field
            //
            $editor = new TextEdit('ref_local_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Ref Local', 'ref_local', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_local field
            //
            $editor = new DynamicCombobox('id_local_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Local', 'id_local', 'LA1', 'multi_edit_cle_departement_scta_cle_emprunt_cle_departement_cle_cles_id_local_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for nb_total field
            //
            $editor = new TextEdit('nb_total_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Nb Total', 'nb_total', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for nb_circulation field
            //
            $editor = new TextEdit('nb_circulation_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Nb Circulation', 'nb_circulation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for nb_disponible field
            //
            $editor = new TextEdit('nb_disponible_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Nb Disponible', 'nb_disponible', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for id field
            //
            $editor = new TextEdit('id_edit');
            $editColumn = new CustomEditColumn('Id', 'id', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for boite field
            //
            $editor = new TextEdit('boite_edit');
            $editColumn = new CustomEditColumn('Boite', 'boite', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for crochet field
            //
            $editor = new TextEdit('crochet_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Crochet', 'crochet', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for num_cle field
            //
            $editor = new TextEdit('num_cle_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('Num Cle', 'num_cle', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for description field
            //
            $editor = new TextEdit('description_edit');
            $editor->SetMaxLength(90);
            $editColumn = new CustomEditColumn('Description', 'description', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_local field
            //
            $editor = new TextEdit('no_local_edit');
            $editor->SetMaxLength(20);
            $editColumn = new CustomEditColumn('No Local', 'no_local', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for ref_local field
            //
            $editor = new TextEdit('ref_local_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Ref Local', 'ref_local', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_local field
            //
            $editor = new DynamicCombobox('id_local_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Local', 'id_local', 'LA1', 'insert_cle_departement_scta_cle_emprunt_cle_departement_cle_cles_id_local_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for nb_total field
            //
            $editor = new TextEdit('nb_total_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Nb Total', 'nb_total', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for nb_circulation field
            //
            $editor = new TextEdit('nb_circulation_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Nb Circulation', 'nb_circulation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for nb_disponible field
            //
            $editor = new TextEdit('nb_disponible_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Nb Disponible', 'nb_disponible', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for boite field
            //
            $column = new NumberViewColumn('boite', 'boite', 'Boite', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for crochet field
            //
            $column = new TextViewColumn('crochet', 'crochet', 'Crochet', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for num_cle field
            //
            $column = new TextViewColumn('num_cle', 'num_cle', 'Num Cle', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_local field
            //
            $column = new TextViewColumn('no_local', 'no_local', 'No Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for ref_local field
            //
            $column = new TextViewColumn('ref_local', 'ref_local', 'Ref Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_local', 'LA1', 'Id Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nb_total field
            //
            $column = new TextViewColumn('nb_total', 'nb_total', 'Nb Total', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nb_circulation field
            //
            $column = new TextViewColumn('nb_circulation', 'nb_circulation', 'Nb Circulation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nb_disponible field
            //
            $column = new TextViewColumn('nb_disponible', 'nb_disponible', 'Nb Disponible', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for boite field
            //
            $column = new NumberViewColumn('boite', 'boite', 'Boite', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for crochet field
            //
            $column = new TextViewColumn('crochet', 'crochet', 'Crochet', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for num_cle field
            //
            $column = new TextViewColumn('num_cle', 'num_cle', 'Num Cle', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_local field
            //
            $column = new TextViewColumn('no_local', 'no_local', 'No Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for ref_local field
            //
            $column = new TextViewColumn('ref_local', 'ref_local', 'Ref Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_local', 'LA1', 'Id Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nb_total field
            //
            $column = new TextViewColumn('nb_total', 'nb_total', 'Nb Total', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nb_circulation field
            //
            $column = new TextViewColumn('nb_circulation', 'nb_circulation', 'Nb Circulation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nb_disponible field
            //
            $column = new TextViewColumn('nb_disponible', 'nb_disponible', 'Nb Disponible', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for id field
            //
            $column = new NumberViewColumn('id', 'id', 'Id', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for boite field
            //
            $column = new NumberViewColumn('boite', 'boite', 'Boite', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for crochet field
            //
            $column = new TextViewColumn('crochet', 'crochet', 'Crochet', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for num_cle field
            //
            $column = new TextViewColumn('num_cle', 'num_cle', 'Num Cle', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for description field
            //
            $column = new TextViewColumn('description', 'description', 'Description', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_local field
            //
            $column = new TextViewColumn('no_local', 'no_local', 'No Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for ref_local field
            //
            $column = new TextViewColumn('ref_local', 'ref_local', 'Ref Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_local', 'LA1', 'Id Local', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nb_total field
            //
            $column = new TextViewColumn('nb_total', 'nb_total', 'Nb Total', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nb_circulation field
            //
            $column = new TextViewColumn('nb_circulation', 'nb_circulation', 'Nb Circulation', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nb_disponible field
            //
            $column = new TextViewColumn('nb_disponible', 'nb_disponible', 'Nb Disponible', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(true);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_cle_departement_scta_cle_emprunt_cle_departement_cle_cles_id_local_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_cle_departement_scta_cle_emprunt_cle_departement_cle_cles_id_local_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_cle_departement_scta_cle_emprunt_cle_departement_cle_cles_id_local_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_cle_departement_scta_cle_emprunt_cle_departement_cle_cles_id_local_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }
    
    // OnBeforePageExecute event handler
    
    
    
    class cle_departement_scta_cle_empruntPage extends Page
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Emprunts courants');
            $this->SetMenuLabel('Emprunts courants');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"cle_departement"."scta_cle_emprunt"');
            $this->dataset->addFields(
                array(
                    new StringField('actif'),
                    new DateTimeField('date_d_emprunt'),
                    new DateTimeField('date_de_retour'),
                    new IntegerField('depot'),
                    new IntegerField('remboursement_du_depot'),
                    new StringField('rubrique'),
                    new StringField('rubrique_2'),
                    new StringField('utilisateur_note'),
                    new IntegerField('id_cle'),
                    new IntegerField('id_pers'),
                    new IntegerField('id_cle_emprunt', true, true, true),
                    new IntegerField('id_grp_f_sci'),
                    new DateField('date_due'),
                    new IntegerField('archivage'),
                    new IntegerField('num_bureau'),
                    new StringField('num_formulaire'),
                    new StringField('otrs')
                )
            );
            $this->dataset->AddLookupField('id_pers', '(select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */)', new IntegerField('id_pers'), new StringField('nom_complet', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('id_cle', '(select distinct c.id as id_cle,
                 concat (c.num_cle,\'  (\' ,l.no_loc,\')\') as cle_local
            from  administratifs.locals l, cle_departement.cle_cles c
            where c.id_local = l.id_loc)', new IntegerField('id_cle'), new StringField('cle_local', false, false, false, false, 'LA2', 'LT2'), 'LT2');
            $this->dataset->AddLookupField('id_grp_f_sci', 'administratifs.grp_faculte_sciences', new IntegerField('id_grp_f_sci'), new StringField('description', false, false, false, false, 'LA3', 'LT3'), 'LT3');
            $this->dataset->AddLookupField('archivage', 'administratifs.oui_non', new IntegerField('id_oui_non'), new StringField('oui_non', false, false, false, false, 'LA4', 'LT4'), 'LT4');
            $this->dataset->AddCustomCondition(EnvVariablesUtils::EvaluateVariableTemplate($this->GetColumnVariableContainer(), '((archivage = 0)or (archivage is Null)) and (date_de_retour is Null)'));
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'id_pers', 'LA1', 'Utilisateur'),
                new FilterColumn($this->dataset, 'utilisateur_note', 'utilisateur_note', ' Note'),
                new FilterColumn($this->dataset, 'id_cle', 'LA2', 'Clé (Local)'),
                new FilterColumn($this->dataset, 'date_d_emprunt', 'date_d_emprunt', 'Début emprunt'),
                new FilterColumn($this->dataset, 'date_de_retour', 'date_de_retour', 'Fin emprunt'),
                new FilterColumn($this->dataset, 'depot', 'depot', 'Depôt'),
                new FilterColumn($this->dataset, 'remboursement_du_depot', 'remboursement_du_depot', 'Dépot remboursé'),
                new FilterColumn($this->dataset, 'id_cle_emprunt', 'id_cle_emprunt', 'Id Cle Emprunt'),
                new FilterColumn($this->dataset, 'actif', 'actif', 'Actif'),
                new FilterColumn($this->dataset, 'rubrique', 'rubrique', 'Rubrique'),
                new FilterColumn($this->dataset, 'rubrique_2', 'rubrique_2', 'Rubrique 2'),
                new FilterColumn($this->dataset, 'id_grp_f_sci', 'LA3', 'Id Grp F Sci'),
                new FilterColumn($this->dataset, 'date_due', 'date_due', 'Date Due'),
                new FilterColumn($this->dataset, 'archivage', 'LA4', 'Archivage'),
                new FilterColumn($this->dataset, 'num_bureau', 'num_bureau', 'No. bureau'),
                new FilterColumn($this->dataset, 'num_formulaire', 'num_formulaire', 'No. formulaire'),
                new FilterColumn($this->dataset, 'otrs', 'otrs', 'No. OTRS')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['id_pers'])
                ->addColumn($columns['utilisateur_note'])
                ->addColumn($columns['id_cle'])
                ->addColumn($columns['date_d_emprunt'])
                ->addColumn($columns['date_de_retour'])
                ->addColumn($columns['depot'])
                ->addColumn($columns['remboursement_du_depot'])
                ->addColumn($columns['archivage'])
                ->addColumn($columns['num_bureau'])
                ->addColumn($columns['num_formulaire'])
                ->addColumn($columns['otrs']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_pers')
                ->setOptionsFor('id_cle')
                ->setOptionsFor('date_d_emprunt')
                ->setOptionsFor('date_de_retour')
                ->setOptionsFor('archivage');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new DynamicCombobox('id_pers_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_cle_departement_scta_cle_emprunt_id_pers_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_pers', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_cle_departement_scta_cle_emprunt_id_pers_search');
            
            $text_editor = new TextEdit('id_pers');
            
            $filterBuilder->addColumn(
                $columns['id_pers'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('utilisateur_note');
            
            $filterBuilder->addColumn(
                $columns['utilisateur_note'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_cle_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_cle_departement_scta_cle_emprunt_id_cle_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_cle', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_cle_departement_scta_cle_emprunt_id_cle_search');
            
            $filterBuilder->addColumn(
                $columns['id_cle'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('date_d_emprunt_edit', false, 'Y-m-d H:i:s');
            
            $filterBuilder->addColumn(
                $columns['date_d_emprunt'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('date_de_retour_edit', false, 'Y-m-d H:i:s');
            
            $filterBuilder->addColumn(
                $columns['date_de_retour'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('depot_edit');
            
            $filterBuilder->addColumn(
                $columns['depot'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('remboursement_du_depot_edit');
            
            $filterBuilder->addColumn(
                $columns['remboursement_du_depot'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('archivage_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_cle_departement_scta_cle_emprunt_archivage_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('archivage', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_cle_departement_scta_cle_emprunt_archivage_search');
            
            $filterBuilder->addColumn(
                $columns['archivage'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('num_bureau_edit');
            
            $filterBuilder->addColumn(
                $columns['num_bureau'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('num_formulaire_edit');
            
            $filterBuilder->addColumn(
                $columns['num_formulaire'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('otrs');
            
            $filterBuilder->addColumn(
                $columns['otrs'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            if (GetCurrentUserPermissionsForPage('cle_departement.scta_cle_emprunt.administratifs.personnel')->HasViewGrant() && $withDetails)
            {
            //
            // View column for cle_departement_scta_cle_emprunt_administratifs_personnel detail
            //
            $column = new DetailColumn(array('id_pers'), 'cle_departement.scta_cle_emprunt.administratifs.personnel', 'cle_departement_scta_cle_emprunt_administratifs_personnel_handler', $this->dataset, 'Personnel');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            }
            
            if (GetCurrentUserPermissionsForPage('cle_departement.scta_cle_emprunt.cle_departement.cle_cles')->HasViewGrant() && $withDetails)
            {
            //
            // View column for cle_departement_scta_cle_emprunt_cle_departement_cle_cles detail
            //
            $column = new DetailColumn(array('id_cle'), 'cle_departement.scta_cle_emprunt.cle_departement.cle_cles', 'cle_departement_scta_cle_emprunt_cle_departement_cle_cles_handler', $this->dataset, 'Cle Cles');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            }
            
            //
            // View column for nom_complet field
            //
            $column = new TextViewColumn('id_pers', 'LA1', 'Utilisateur', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for utilisateur_note field
            //
            $column = new TextViewColumn('utilisateur_note', 'utilisateur_note', ' Note', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for cle_local field
            //
            $column = new TextViewColumn('id_cle', 'LA2', 'Clé (Local)', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_d_emprunt field
            //
            $column = new DateTimeViewColumn('date_d_emprunt', 'date_d_emprunt', 'Début emprunt', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Fin emprunt', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for depot field
            //
            $column = new NumberViewColumn('depot', 'depot', 'Depôt', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for remboursement_du_depot field
            //
            $column = new NumberViewColumn('remboursement_du_depot', 'remboursement_du_depot', 'Dépot remboursé', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for oui_non field
            //
            $column = new TextViewColumn('archivage', 'LA4', 'Archivage', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for num_bureau field
            //
            $column = new NumberViewColumn('num_bureau', 'num_bureau', 'No. bureau', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for num_formulaire field
            //
            $column = new StringTransformViewColumn('num_formulaire', 'num_formulaire', 'No. formulaire', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setStringTransformFunction('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for otrs field
            //
            $column = new StringTransformViewColumn('otrs', 'otrs', 'No. OTRS', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setStringTransformFunction('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for nom_complet field
            //
            $column = new TextViewColumn('id_pers', 'LA1', 'Utilisateur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for utilisateur_note field
            //
            $column = new TextViewColumn('utilisateur_note', 'utilisateur_note', ' Note', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for cle_local field
            //
            $column = new TextViewColumn('id_cle', 'LA2', 'Clé (Local)', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_d_emprunt field
            //
            $column = new DateTimeViewColumn('date_d_emprunt', 'date_d_emprunt', 'Début emprunt', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Fin emprunt', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for depot field
            //
            $column = new NumberViewColumn('depot', 'depot', 'Depôt', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for remboursement_du_depot field
            //
            $column = new NumberViewColumn('remboursement_du_depot', 'remboursement_du_depot', 'Dépot remboursé', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for oui_non field
            //
            $column = new TextViewColumn('archivage', 'LA4', 'Archivage', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for num_bureau field
            //
            $column = new NumberViewColumn('num_bureau', 'num_bureau', 'No. bureau', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for num_formulaire field
            //
            $column = new StringTransformViewColumn('num_formulaire', 'num_formulaire', 'No. formulaire', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setStringTransformFunction('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for otrs field
            //
            $column = new StringTransformViewColumn('otrs', 'otrs', 'No. OTRS', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setStringTransformFunction('');
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for id_pers field
            //
            $editor = new DynamicCombobox('id_pers_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Utilisateur', 'id_pers', 'LA1', 'edit_cle_departement_scta_cle_emprunt_id_pers_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom_complet', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for utilisateur_note field
            //
            $editor = new TextAreaEdit('utilisateur_note_edit', 50, 8);
            $editColumn = new CustomEditColumn(' Note', 'utilisateur_note', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_cle field
            //
            $editor = new DynamicCombobox('id_cle_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'select distinct c.id as id_cle,
                 concat (c.num_cle,\'  (\' ,l.no_loc,\')\') as cle_local
            from  administratifs.locals l, cle_departement.cle_cles c
            where c.id_local = l.id_loc';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'cle_local');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_cle', false, true),
                    new StringField('cle_local')
                )
            );
            $lookupDataset->setOrderByField('cle_local', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Clé (Local)', 'id_cle', 'LA2', 'edit_cle_departement_scta_cle_emprunt_id_cle_search', $editor, $this->dataset, $lookupDataset, 'id_cle', 'cle_local', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_d_emprunt field
            //
            $editor = new DateTimeEdit('date_d_emprunt_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Début emprunt', 'date_d_emprunt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_de_retour field
            //
            $editor = new DateTimeEdit('date_de_retour_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Fin emprunt', 'date_de_retour', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for depot field
            //
            $editor = new TextEdit('depot_edit');
            $editColumn = new CustomEditColumn('Depôt', 'depot', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for remboursement_du_depot field
            //
            $editor = new TextEdit('remboursement_du_depot_edit');
            $editColumn = new CustomEditColumn('Dépot remboursé', 'remboursement_du_depot', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for archivage field
            //
            $editor = new DynamicCombobox('archivage_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."oui_non"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_oui_non', true, true),
                    new StringField('oui_non')
                )
            );
            $lookupDataset->setOrderByField('oui_non', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Archivage', 'archivage', 'LA4', 'edit_cle_departement_scta_cle_emprunt_archivage_search', $editor, $this->dataset, $lookupDataset, 'id_oui_non', 'oui_non', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for num_bureau field
            //
            $editor = new TextEdit('num_bureau_edit');
            $editColumn = new CustomEditColumn('No. bureau', 'num_bureau', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for num_formulaire field
            //
            $editor = new TextEdit('num_formulaire_edit');
            $editColumn = new CustomEditColumn('No. formulaire', 'num_formulaire', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for otrs field
            //
            $editor = new TextAreaEdit('otrs_edit', 50, 8);
            $editColumn = new CustomEditColumn('No. OTRS', 'otrs', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for id_pers field
            //
            $editor = new DynamicCombobox('id_pers_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Utilisateur', 'id_pers', 'LA1', 'multi_edit_cle_departement_scta_cle_emprunt_id_pers_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom_complet', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for utilisateur_note field
            //
            $editor = new TextAreaEdit('utilisateur_note_edit', 50, 8);
            $editColumn = new CustomEditColumn(' Note', 'utilisateur_note', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_cle field
            //
            $editor = new DynamicCombobox('id_cle_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'select distinct c.id as id_cle,
                 concat (c.num_cle,\'  (\' ,l.no_loc,\')\') as cle_local
            from  administratifs.locals l, cle_departement.cle_cles c
            where c.id_local = l.id_loc';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'cle_local');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_cle', false, true),
                    new StringField('cle_local')
                )
            );
            $lookupDataset->setOrderByField('cle_local', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Clé (Local)', 'id_cle', 'LA2', 'multi_edit_cle_departement_scta_cle_emprunt_id_cle_search', $editor, $this->dataset, $lookupDataset, 'id_cle', 'cle_local', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_d_emprunt field
            //
            $editor = new DateTimeEdit('date_d_emprunt_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Début emprunt', 'date_d_emprunt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_de_retour field
            //
            $editor = new DateTimeEdit('date_de_retour_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Fin emprunt', 'date_de_retour', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for depot field
            //
            $editor = new TextEdit('depot_edit');
            $editColumn = new CustomEditColumn('Depôt', 'depot', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for remboursement_du_depot field
            //
            $editor = new TextEdit('remboursement_du_depot_edit');
            $editColumn = new CustomEditColumn('Dépot remboursé', 'remboursement_du_depot', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for archivage field
            //
            $editor = new DynamicCombobox('archivage_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."oui_non"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_oui_non', true, true),
                    new StringField('oui_non')
                )
            );
            $lookupDataset->setOrderByField('oui_non', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Archivage', 'archivage', 'LA4', 'multi_edit_cle_departement_scta_cle_emprunt_archivage_search', $editor, $this->dataset, $lookupDataset, 'id_oui_non', 'oui_non', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for num_bureau field
            //
            $editor = new TextEdit('num_bureau_edit');
            $editColumn = new CustomEditColumn('No. bureau', 'num_bureau', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for num_formulaire field
            //
            $editor = new TextEdit('num_formulaire_edit');
            $editColumn = new CustomEditColumn('No. formulaire', 'num_formulaire', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for otrs field
            //
            $editor = new TextAreaEdit('otrs_edit', 50, 8);
            $editColumn = new CustomEditColumn('No. OTRS', 'otrs', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for id_pers field
            //
            $editor = new DynamicCombobox('id_pers_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Utilisateur', 'id_pers', 'LA1', 'insert_cle_departement_scta_cle_emprunt_id_pers_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom_complet', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for utilisateur_note field
            //
            $editor = new TextAreaEdit('utilisateur_note_edit', 50, 8);
            $editColumn = new CustomEditColumn(' Note', 'utilisateur_note', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_cle field
            //
            $editor = new DynamicCombobox('id_cle_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'select distinct c.id as id_cle,
                 concat (c.num_cle,\'  (\' ,l.no_loc,\')\') as cle_local
            from  administratifs.locals l, cle_departement.cle_cles c
            where c.id_local = l.id_loc';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'cle_local');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_cle', false, true),
                    new StringField('cle_local')
                )
            );
            $lookupDataset->setOrderByField('cle_local', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Clé (Local)', 'id_cle', 'LA2', 'insert_cle_departement_scta_cle_emprunt_id_cle_search', $editor, $this->dataset, $lookupDataset, 'id_cle', 'cle_local', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_d_emprunt field
            //
            $editor = new DateTimeEdit('date_d_emprunt_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Début emprunt', 'date_d_emprunt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $editColumn->SetInsertDefaultValue('%CURRENT_DATE%');
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_de_retour field
            //
            $editor = new DateTimeEdit('date_de_retour_edit', false, 'Y-m-d H:i:s');
            $editColumn = new CustomEditColumn('Fin emprunt', 'date_de_retour', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for depot field
            //
            $editor = new TextEdit('depot_edit');
            $editColumn = new CustomEditColumn('Depôt', 'depot', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $editColumn->SetInsertDefaultValue('0.00');
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for remboursement_du_depot field
            //
            $editor = new TextEdit('remboursement_du_depot_edit');
            $editColumn = new CustomEditColumn('Dépot remboursé', 'remboursement_du_depot', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $editColumn->SetInsertDefaultValue('0.00');
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for archivage field
            //
            $editor = new DynamicCombobox('archivage_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."oui_non"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_oui_non', true, true),
                    new StringField('oui_non')
                )
            );
            $lookupDataset->setOrderByField('oui_non', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Archivage', 'archivage', 'LA4', 'insert_cle_departement_scta_cle_emprunt_archivage_search', $editor, $this->dataset, $lookupDataset, 'id_oui_non', 'oui_non', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for num_bureau field
            //
            $editor = new TextEdit('num_bureau_edit');
            $editColumn = new CustomEditColumn('No. bureau', 'num_bureau', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for num_formulaire field
            //
            $editor = new TextEdit('num_formulaire_edit');
            $editColumn = new CustomEditColumn('No. formulaire', 'num_formulaire', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for otrs field
            //
            $editor = new TextAreaEdit('otrs_edit', 50, 8);
            $editColumn = new CustomEditColumn('No. OTRS', 'otrs', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for nom_complet field
            //
            $column = new TextViewColumn('id_pers', 'LA1', 'Utilisateur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for utilisateur_note field
            //
            $column = new TextViewColumn('utilisateur_note', 'utilisateur_note', ' Note', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for cle_local field
            //
            $column = new TextViewColumn('id_cle', 'LA2', 'Clé (Local)', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_d_emprunt field
            //
            $column = new DateTimeViewColumn('date_d_emprunt', 'date_d_emprunt', 'Début emprunt', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Fin emprunt', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddPrintColumn($column);
            
            //
            // View column for depot field
            //
            $column = new NumberViewColumn('depot', 'depot', 'Depôt', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for remboursement_du_depot field
            //
            $column = new NumberViewColumn('remboursement_du_depot', 'remboursement_du_depot', 'Dépot remboursé', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for oui_non field
            //
            $column = new TextViewColumn('archivage', 'LA4', 'Archivage', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for num_bureau field
            //
            $column = new NumberViewColumn('num_bureau', 'num_bureau', 'No. bureau', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for num_formulaire field
            //
            $column = new StringTransformViewColumn('num_formulaire', 'num_formulaire', 'No. formulaire', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setStringTransformFunction('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for otrs field
            //
            $column = new StringTransformViewColumn('otrs', 'otrs', 'No. OTRS', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setStringTransformFunction('');
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for nom_complet field
            //
            $column = new TextViewColumn('id_pers', 'LA1', 'Utilisateur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for utilisateur_note field
            //
            $column = new TextViewColumn('utilisateur_note', 'utilisateur_note', ' Note', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for cle_local field
            //
            $column = new TextViewColumn('id_cle', 'LA2', 'Clé (Local)', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_d_emprunt field
            //
            $column = new DateTimeViewColumn('date_d_emprunt', 'date_d_emprunt', 'Début emprunt', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddExportColumn($column);
            
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Fin emprunt', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddExportColumn($column);
            
            //
            // View column for depot field
            //
            $column = new NumberViewColumn('depot', 'depot', 'Depôt', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for remboursement_du_depot field
            //
            $column = new NumberViewColumn('remboursement_du_depot', 'remboursement_du_depot', 'Dépot remboursé', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for oui_non field
            //
            $column = new TextViewColumn('archivage', 'LA4', 'Archivage', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for num_bureau field
            //
            $column = new NumberViewColumn('num_bureau', 'num_bureau', 'No. bureau', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for num_formulaire field
            //
            $column = new StringTransformViewColumn('num_formulaire', 'num_formulaire', 'No. formulaire', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setStringTransformFunction('');
            $grid->AddExportColumn($column);
            
            //
            // View column for otrs field
            //
            $column = new StringTransformViewColumn('otrs', 'otrs', 'No. OTRS', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setStringTransformFunction('');
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for nom_complet field
            //
            $column = new TextViewColumn('id_pers', 'LA1', 'Utilisateur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for utilisateur_note field
            //
            $column = new TextViewColumn('utilisateur_note', 'utilisateur_note', ' Note', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for cle_local field
            //
            $column = new TextViewColumn('id_cle', 'LA2', 'Clé (Local)', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_d_emprunt field
            //
            $column = new DateTimeViewColumn('date_d_emprunt', 'date_d_emprunt', 'Début emprunt', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Fin emprunt', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddCompareColumn($column);
            
            //
            // View column for depot field
            //
            $column = new NumberViewColumn('depot', 'depot', 'Depôt', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for remboursement_du_depot field
            //
            $column = new NumberViewColumn('remboursement_du_depot', 'remboursement_du_depot', 'Dépot remboursé', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for oui_non field
            //
            $column = new TextViewColumn('archivage', 'LA4', 'Archivage', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for num_bureau field
            //
            $column = new NumberViewColumn('num_bureau', 'num_bureau', 'No. bureau', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for num_formulaire field
            //
            $column = new StringTransformViewColumn('num_formulaire', 'num_formulaire', 'No. formulaire', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setStringTransformFunction('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for otrs field
            //
            $column = new StringTransformViewColumn('otrs', 'otrs', 'No. OTRS', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setStringTransformFunction('');
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function CreateMasterDetailRecordGrid()
        {
            $result = new Grid($this, $this->dataset);
            
            $this->AddFieldColumns($result, false);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            
            $result->SetAllowDeleteSelected(false);
            $result->SetShowUpdateLink(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(false);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $this->setupGridColumnGroup($result);
            $this->attachGridEventHandlers($result);
            
            return $result;
        }
        
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(true);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowAddMultipleRecords(false);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->setAddNewChoices(array(2));
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $detailPage = new cle_departement_scta_cle_emprunt_administratifs_personnelPage('cle_departement_scta_cle_emprunt_administratifs_personnel', $this, array('id_pers'), array('id_pers'), $this->GetForeignKeyFields(), $this->CreateMasterDetailRecordGrid(), $this->dataset, GetCurrentUserPermissionsForPage('cle_departement.scta_cle_emprunt.administratifs.personnel'), 'UTF-8');
            $detailPage->SetRecordPermission(GetCurrentUserRecordPermissionsForDataSource('cle_departement.scta_cle_emprunt.administratifs.personnel'));
            $detailPage->SetHttpHandlerName('cle_departement_scta_cle_emprunt_administratifs_personnel_handler');
            $handler = new PageHTTPHandler('cle_departement_scta_cle_emprunt_administratifs_personnel_handler', $detailPage);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $detailPage = new cle_departement_scta_cle_emprunt_cle_departement_cle_clesPage('cle_departement_scta_cle_emprunt_cle_departement_cle_cles', $this, array('id'), array('id_cle'), $this->GetForeignKeyFields(), $this->CreateMasterDetailRecordGrid(), $this->dataset, GetCurrentUserPermissionsForPage('cle_departement.scta_cle_emprunt.cle_departement.cle_cles'), 'UTF-8');
            $detailPage->SetRecordPermission(GetCurrentUserRecordPermissionsForDataSource('cle_departement.scta_cle_emprunt.cle_departement.cle_cles'));
            $detailPage->SetHttpHandlerName('cle_departement_scta_cle_emprunt_cle_departement_cle_cles_handler');
            $handler = new PageHTTPHandler('cle_departement_scta_cle_emprunt_cle_departement_cle_cles_handler', $detailPage);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_cle_departement_scta_cle_emprunt_id_pers_search', 'id_pers', 'nom_complet', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'select distinct c.id as id_cle,
                 concat (c.num_cle,\'  (\' ,l.no_loc,\')\') as cle_local
            from  administratifs.locals l, cle_departement.cle_cles c
            where c.id_local = l.id_loc';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'cle_local');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_cle', false, true),
                    new StringField('cle_local')
                )
            );
            $lookupDataset->setOrderByField('cle_local', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_cle_departement_scta_cle_emprunt_id_cle_search', 'id_cle', 'cle_local', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."oui_non"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_oui_non', true, true),
                    new StringField('oui_non')
                )
            );
            $lookupDataset->setOrderByField('oui_non', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_cle_departement_scta_cle_emprunt_archivage_search', 'id_oui_non', 'oui_non', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_cle_departement_scta_cle_emprunt_id_pers_search', 'id_pers', 'nom_complet', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_cle_departement_scta_cle_emprunt_id_pers_search', 'id_pers', 'nom_complet', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'select distinct c.id as id_cle,
                 concat (c.num_cle,\'  (\' ,l.no_loc,\')\') as cle_local
            from  administratifs.locals l, cle_departement.cle_cles c
            where c.id_local = l.id_loc';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'cle_local');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_cle', false, true),
                    new StringField('cle_local')
                )
            );
            $lookupDataset->setOrderByField('cle_local', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_cle_departement_scta_cle_emprunt_id_cle_search', 'id_cle', 'cle_local', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."oui_non"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_oui_non', true, true),
                    new StringField('oui_non')
                )
            );
            $lookupDataset->setOrderByField('oui_non', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_cle_departement_scta_cle_emprunt_archivage_search', 'id_oui_non', 'oui_non', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_cle_departement_scta_cle_emprunt_id_pers_search', 'id_pers', 'nom_complet', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'select distinct c.id as id_cle,
                 concat (c.num_cle,\'  (\' ,l.no_loc,\')\') as cle_local
            from  administratifs.locals l, cle_departement.cle_cles c
            where c.id_local = l.id_loc';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'cle_local');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_cle', false, true),
                    new StringField('cle_local')
                )
            );
            $lookupDataset->setOrderByField('cle_local', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_cle_departement_scta_cle_emprunt_id_cle_search', 'id_cle', 'cle_local', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."oui_non"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_oui_non', true, true),
                    new StringField('oui_non')
                )
            );
            $lookupDataset->setOrderByField('oui_non', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_cle_departement_scta_cle_emprunt_archivage_search', 'id_oui_non', 'oui_non', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_cle_departement_scta_cle_emprunt_id_pers_search', 'id_pers', 'nom_complet', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'select distinct c.id as id_cle,
                 concat (c.num_cle,\'  (\' ,l.no_loc,\')\') as cle_local
            from  administratifs.locals l, cle_departement.cle_cles c
            where c.id_local = l.id_loc';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'cle_local');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_cle', false, true),
                    new StringField('cle_local')
                )
            );
            $lookupDataset->setOrderByField('cle_local', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_cle_departement_scta_cle_emprunt_id_cle_search', 'id_cle', 'cle_local', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."oui_non"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_oui_non', true, true),
                    new StringField('oui_non')
                )
            );
            $lookupDataset->setOrderByField('oui_non', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_cle_departement_scta_cle_emprunt_archivage_search', 'id_oui_non', 'oui_non', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }

    SetUpUserAuthorization();

    try
    {
        $Page = new cle_departement_scta_cle_empruntPage("cle_departement_scta_cle_emprunt", "scta_cle_emprunt.php", GetCurrentUserPermissionsForPage("cle_departement.scta_cle_emprunt"), 'UTF-8');
        $Page->SetRecordPermission(GetCurrentUserRecordPermissionsForDataSource("cle_departement.scta_cle_emprunt"));
        GetApplication()->SetMainPage($Page);
        GetApplication()->Run();
    }
    catch(Exception $e)
    {
        ShowErrorPage($e);
    }
	
