<?php
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                   ATTENTION!
 * If you see this message in your browser (Internet Explorer, Mozilla Firefox, Google Chrome, etc.)
 * this means that PHP is not properly installed on your web server. Please refer to the PHP manual
 * for more details: http://php.net/manual/install.php 
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

    include_once dirname(__FILE__) . '/components/startup.php';
    include_once dirname(__FILE__) . '/components/application.php';
    include_once dirname(__FILE__) . '/' . 'authorization.php';


    include_once dirname(__FILE__) . '/' . 'database_engine/pgsql_engine.php';
    include_once dirname(__FILE__) . '/' . 'components/page/page_includes.php';

    function GetConnectionOptions()
    {
        $result = GetGlobalConnectionOptions();
        $result['client_encoding'] = 'utf8';
        GetApplication()->GetUserAuthentication()->applyIdentityToConnectionOptions($result);
        return $result;
    }

    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class cle_departement_scta_cle_emprunt01Page extends Page
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Emprunts archivés');
            $this->SetMenuLabel('Emprunts archivés');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"cle_departement"."scta_cle_emprunt"');
            $this->dataset->addFields(
                array(
                    new StringField('actif'),
                    new DateTimeField('date_d_emprunt'),
                    new DateTimeField('date_de_retour'),
                    new IntegerField('depot'),
                    new IntegerField('remboursement_du_depot'),
                    new StringField('rubrique'),
                    new StringField('rubrique_2'),
                    new StringField('utilisateur_note'),
                    new IntegerField('id_cle'),
                    new IntegerField('id_pers'),
                    new IntegerField('id_cle_emprunt', true, true, true),
                    new IntegerField('id_grp_f_sci'),
                    new DateField('date_due'),
                    new IntegerField('archivage'),
                    new IntegerField('num_bureau'),
                    new StringField('num_formulaire'),
                    new StringField('otrs')
                )
            );
            $this->dataset->AddLookupField('id_pers', '(select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */)', new IntegerField('id_pers'), new StringField('nom_complet', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('id_cle', '(select distinct c.id as id_cle,
                 concat (c.num_cle,\'  (\' ,l.no_loc,\')\') as cle_local
            from  administratifs.locals l, cle_departement.cle_cles c
            where c.id_local = l.id_loc)', new IntegerField('id_cle'), new StringField('cle_local', false, false, false, false, 'LA2', 'LT2'), 'LT2');
            $this->dataset->AddLookupField('id_grp_f_sci', 'administratifs.grp_faculte_sciences', new IntegerField('id_grp_f_sci'), new StringField('description', false, false, false, false, 'LA3', 'LT3'), 'LT3');
            $this->dataset->AddLookupField('archivage', 'administratifs.oui_non', new IntegerField('id_oui_non'), new StringField('oui_non', false, false, false, false, 'LA4', 'LT4'), 'LT4');
            $this->dataset->AddCustomCondition(EnvVariablesUtils::EvaluateVariableTemplate($this->GetColumnVariableContainer(), '(archivage=1) or (date_de_retour is not Null) '));
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'id_pers', 'LA1', 'Utilisateur'),
                new FilterColumn($this->dataset, 'utilisateur_note', 'utilisateur_note', 'Note'),
                new FilterColumn($this->dataset, 'id_cle', 'LA2', 'Clé (local)'),
                new FilterColumn($this->dataset, 'date_d_emprunt', 'date_d_emprunt', 'Début emprunt'),
                new FilterColumn($this->dataset, 'date_de_retour', 'date_de_retour', 'Fin d\'emprunt'),
                new FilterColumn($this->dataset, 'depot', 'depot', 'Dépot'),
                new FilterColumn($this->dataset, 'remboursement_du_depot', 'remboursement_du_depot', 'Dépot remboursé'),
                new FilterColumn($this->dataset, 'id_cle_emprunt', 'id_cle_emprunt', 'Id Cle Emprunt'),
                new FilterColumn($this->dataset, 'actif', 'actif', 'Actif'),
                new FilterColumn($this->dataset, 'rubrique', 'rubrique', 'Rubrique'),
                new FilterColumn($this->dataset, 'rubrique_2', 'rubrique_2', 'Rubrique 2'),
                new FilterColumn($this->dataset, 'id_grp_f_sci', 'LA3', 'Id Grp F Sci'),
                new FilterColumn($this->dataset, 'date_due', 'date_due', 'Date Due'),
                new FilterColumn($this->dataset, 'archivage', 'LA4', 'Archivage'),
                new FilterColumn($this->dataset, 'num_bureau', 'num_bureau', 'No. bureau'),
                new FilterColumn($this->dataset, 'num_formulaire', 'num_formulaire', 'No. formulaire'),
                new FilterColumn($this->dataset, 'otrs', 'otrs', 'No. OTRS')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['id_pers'])
                ->addColumn($columns['utilisateur_note'])
                ->addColumn($columns['id_cle'])
                ->addColumn($columns['date_d_emprunt'])
                ->addColumn($columns['date_de_retour'])
                ->addColumn($columns['depot'])
                ->addColumn($columns['remboursement_du_depot'])
                ->addColumn($columns['archivage'])
                ->addColumn($columns['num_bureau'])
                ->addColumn($columns['num_formulaire'])
                ->addColumn($columns['otrs']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_pers')
                ->setOptionsFor('id_cle')
                ->setOptionsFor('date_d_emprunt')
                ->setOptionsFor('date_de_retour')
                ->setOptionsFor('archivage');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new DynamicCombobox('id_pers_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_cle_departement_scta_cle_emprunt01_id_pers_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_pers', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_cle_departement_scta_cle_emprunt01_id_pers_search');
            
            $text_editor = new TextEdit('id_pers');
            
            $filterBuilder->addColumn(
                $columns['id_pers'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('utilisateur_note');
            
            $filterBuilder->addColumn(
                $columns['utilisateur_note'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_cle_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_cle_departement_scta_cle_emprunt01_id_cle_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_cle', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_cle_departement_scta_cle_emprunt01_id_cle_search');
            
            $filterBuilder->addColumn(
                $columns['id_cle'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('date_d_emprunt_edit', false, 'Y-m-d');
            
            $filterBuilder->addColumn(
                $columns['date_d_emprunt'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DateTimeEdit('date_de_retour_edit', false, 'Y-m-d');
            
            $filterBuilder->addColumn(
                $columns['date_de_retour'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::DATE_EQUALS => $main_editor,
                    FilterConditionOperator::DATE_DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::TODAY => null,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('depot_edit');
            
            $filterBuilder->addColumn(
                $columns['depot'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('remboursement_du_depot_edit');
            
            $filterBuilder->addColumn(
                $columns['remboursement_du_depot'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('archivage_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_cle_departement_scta_cle_emprunt01_archivage_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('archivage', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_cle_departement_scta_cle_emprunt01_archivage_search');
            
            $filterBuilder->addColumn(
                $columns['archivage'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('num_bureau_edit');
            
            $filterBuilder->addColumn(
                $columns['num_bureau'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('num_formulaire_edit');
            
            $filterBuilder->addColumn(
                $columns['num_formulaire'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('otrs');
            
            $filterBuilder->addColumn(
                $columns['otrs'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for nom_complet field
            //
            $column = new TextViewColumn('id_pers', 'LA1', 'Utilisateur', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for utilisateur_note field
            //
            $column = new TextViewColumn('utilisateur_note', 'utilisateur_note', 'Note', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for cle_local field
            //
            $column = new TextViewColumn('id_cle', 'LA2', 'Clé (local)', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_d_emprunt field
            //
            $column = new DateTimeViewColumn('date_d_emprunt', 'date_d_emprunt', 'Début emprunt', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Fin d\'emprunt', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for depot field
            //
            $column = new NumberViewColumn('depot', 'depot', 'Dépot', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for remboursement_du_depot field
            //
            $column = new NumberViewColumn('remboursement_du_depot', 'remboursement_du_depot', 'Dépot remboursé', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for oui_non field
            //
            $column = new TextViewColumn('archivage', 'LA4', 'Archivage', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for num_bureau field
            //
            $column = new NumberViewColumn('num_bureau', 'num_bureau', 'No. bureau', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for num_formulaire field
            //
            $column = new NumberViewColumn('num_formulaire', 'num_formulaire', 'No. formulaire', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator('');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for otrs field
            //
            $column = new TextViewColumn('otrs', 'otrs', 'No. OTRS', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for nom_complet field
            //
            $column = new TextViewColumn('id_pers', 'LA1', 'Utilisateur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for utilisateur_note field
            //
            $column = new TextViewColumn('utilisateur_note', 'utilisateur_note', 'Note', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for cle_local field
            //
            $column = new TextViewColumn('id_cle', 'LA2', 'Clé (local)', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_d_emprunt field
            //
            $column = new DateTimeViewColumn('date_d_emprunt', 'date_d_emprunt', 'Début emprunt', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Fin d\'emprunt', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for depot field
            //
            $column = new NumberViewColumn('depot', 'depot', 'Dépot', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for remboursement_du_depot field
            //
            $column = new NumberViewColumn('remboursement_du_depot', 'remboursement_du_depot', 'Dépot remboursé', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for oui_non field
            //
            $column = new TextViewColumn('archivage', 'LA4', 'Archivage', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for num_bureau field
            //
            $column = new NumberViewColumn('num_bureau', 'num_bureau', 'No. bureau', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for num_formulaire field
            //
            $column = new NumberViewColumn('num_formulaire', 'num_formulaire', 'No. formulaire', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator('');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for otrs field
            //
            $column = new TextViewColumn('otrs', 'otrs', 'No. OTRS', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for id_pers field
            //
            $editor = new DynamicCombobox('id_pers_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Utilisateur', 'id_pers', 'LA1', 'edit_cle_departement_scta_cle_emprunt01_id_pers_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom_complet', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for utilisateur_note field
            //
            $editor = new TextAreaEdit('utilisateur_note_edit', 50, 8);
            $editColumn = new CustomEditColumn('Note', 'utilisateur_note', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_cle field
            //
            $editor = new DynamicCombobox('id_cle_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'select distinct c.id as id_cle,
                 concat (c.num_cle,\'  (\' ,l.no_loc,\')\') as cle_local
            from  administratifs.locals l, cle_departement.cle_cles c
            where c.id_local = l.id_loc';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'cle_local');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_cle', false, true),
                    new StringField('cle_local')
                )
            );
            $lookupDataset->setOrderByField('cle_local', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Clé (local)', 'id_cle', 'LA2', 'edit_cle_departement_scta_cle_emprunt01_id_cle_search', $editor, $this->dataset, $lookupDataset, 'id_cle', 'cle_local', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_d_emprunt field
            //
            $editor = new DateTimeEdit('date_d_emprunt_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Début emprunt', 'date_d_emprunt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_de_retour field
            //
            $editor = new DateTimeEdit('date_de_retour_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Fin d\'emprunt', 'date_de_retour', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for depot field
            //
            $editor = new TextEdit('depot_edit');
            $editColumn = new CustomEditColumn('Dépot', 'depot', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for remboursement_du_depot field
            //
            $editor = new TextEdit('remboursement_du_depot_edit');
            $editColumn = new CustomEditColumn('Dépot remboursé', 'remboursement_du_depot', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for archivage field
            //
            $editor = new DynamicCombobox('archivage_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."oui_non"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_oui_non', true, true),
                    new StringField('oui_non')
                )
            );
            $lookupDataset->setOrderByField('oui_non', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Archivage', 'archivage', 'LA4', 'edit_cle_departement_scta_cle_emprunt01_archivage_search', $editor, $this->dataset, $lookupDataset, 'id_oui_non', 'oui_non', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for num_bureau field
            //
            $editor = new TextEdit('num_bureau_edit');
            $editColumn = new CustomEditColumn('No. bureau', 'num_bureau', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for num_formulaire field
            //
            $editor = new TextEdit('num_formulaire_edit');
            $editColumn = new CustomEditColumn('No. formulaire', 'num_formulaire', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for otrs field
            //
            $editor = new TextAreaEdit('otrs_edit', 50, 8);
            $editColumn = new CustomEditColumn('No. OTRS', 'otrs', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for id_pers field
            //
            $editor = new DynamicCombobox('id_pers_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Utilisateur', 'id_pers', 'LA1', 'multi_edit_cle_departement_scta_cle_emprunt01_id_pers_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom_complet', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for utilisateur_note field
            //
            $editor = new TextAreaEdit('utilisateur_note_edit', 50, 8);
            $editColumn = new CustomEditColumn('Note', 'utilisateur_note', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_cle field
            //
            $editor = new DynamicCombobox('id_cle_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'select distinct c.id as id_cle,
                 concat (c.num_cle,\'  (\' ,l.no_loc,\')\') as cle_local
            from  administratifs.locals l, cle_departement.cle_cles c
            where c.id_local = l.id_loc';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'cle_local');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_cle', false, true),
                    new StringField('cle_local')
                )
            );
            $lookupDataset->setOrderByField('cle_local', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Clé (local)', 'id_cle', 'LA2', 'multi_edit_cle_departement_scta_cle_emprunt01_id_cle_search', $editor, $this->dataset, $lookupDataset, 'id_cle', 'cle_local', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_d_emprunt field
            //
            $editor = new DateTimeEdit('date_d_emprunt_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Début emprunt', 'date_d_emprunt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for date_de_retour field
            //
            $editor = new DateTimeEdit('date_de_retour_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Fin d\'emprunt', 'date_de_retour', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for depot field
            //
            $editor = new TextEdit('depot_edit');
            $editColumn = new CustomEditColumn('Dépot', 'depot', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for remboursement_du_depot field
            //
            $editor = new TextEdit('remboursement_du_depot_edit');
            $editColumn = new CustomEditColumn('Dépot remboursé', 'remboursement_du_depot', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for archivage field
            //
            $editor = new DynamicCombobox('archivage_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."oui_non"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_oui_non', true, true),
                    new StringField('oui_non')
                )
            );
            $lookupDataset->setOrderByField('oui_non', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Archivage', 'archivage', 'LA4', 'multi_edit_cle_departement_scta_cle_emprunt01_archivage_search', $editor, $this->dataset, $lookupDataset, 'id_oui_non', 'oui_non', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for num_bureau field
            //
            $editor = new TextEdit('num_bureau_edit');
            $editColumn = new CustomEditColumn('No. bureau', 'num_bureau', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for num_formulaire field
            //
            $editor = new TextEdit('num_formulaire_edit');
            $editColumn = new CustomEditColumn('No. formulaire', 'num_formulaire', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for otrs field
            //
            $editor = new TextAreaEdit('otrs_edit', 50, 8);
            $editColumn = new CustomEditColumn('No. OTRS', 'otrs', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for id_pers field
            //
            $editor = new DynamicCombobox('id_pers_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Utilisateur', 'id_pers', 'LA1', 'insert_cle_departement_scta_cle_emprunt01_id_pers_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom_complet', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for utilisateur_note field
            //
            $editor = new TextAreaEdit('utilisateur_note_edit', 50, 8);
            $editColumn = new CustomEditColumn('Note', 'utilisateur_note', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_cle field
            //
            $editor = new DynamicCombobox('id_cle_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'select distinct c.id as id_cle,
                 concat (c.num_cle,\'  (\' ,l.no_loc,\')\') as cle_local
            from  administratifs.locals l, cle_departement.cle_cles c
            where c.id_local = l.id_loc';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'cle_local');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_cle', false, true),
                    new StringField('cle_local')
                )
            );
            $lookupDataset->setOrderByField('cle_local', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Clé (local)', 'id_cle', 'LA2', 'insert_cle_departement_scta_cle_emprunt01_id_cle_search', $editor, $this->dataset, $lookupDataset, 'id_cle', 'cle_local', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_d_emprunt field
            //
            $editor = new DateTimeEdit('date_d_emprunt_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Début emprunt', 'date_d_emprunt', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_de_retour field
            //
            $editor = new DateTimeEdit('date_de_retour_edit', false, 'Y-m-d');
            $editColumn = new CustomEditColumn('Fin d\'emprunt', 'date_de_retour', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for depot field
            //
            $editor = new TextEdit('depot_edit');
            $editColumn = new CustomEditColumn('Dépot', 'depot', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for remboursement_du_depot field
            //
            $editor = new TextEdit('remboursement_du_depot_edit');
            $editColumn = new CustomEditColumn('Dépot remboursé', 'remboursement_du_depot', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for archivage field
            //
            $editor = new DynamicCombobox('archivage_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."oui_non"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_oui_non', true, true),
                    new StringField('oui_non')
                )
            );
            $lookupDataset->setOrderByField('oui_non', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Archivage', 'archivage', 'LA4', 'insert_cle_departement_scta_cle_emprunt01_archivage_search', $editor, $this->dataset, $lookupDataset, 'id_oui_non', 'oui_non', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for num_bureau field
            //
            $editor = new TextEdit('num_bureau_edit');
            $editColumn = new CustomEditColumn('No. bureau', 'num_bureau', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for num_formulaire field
            //
            $editor = new TextEdit('num_formulaire_edit');
            $editColumn = new CustomEditColumn('No. formulaire', 'num_formulaire', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for otrs field
            //
            $editor = new TextAreaEdit('otrs_edit', 50, 8);
            $editColumn = new CustomEditColumn('No. OTRS', 'otrs', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for nom_complet field
            //
            $column = new TextViewColumn('id_pers', 'LA1', 'Utilisateur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for utilisateur_note field
            //
            $column = new TextViewColumn('utilisateur_note', 'utilisateur_note', 'Note', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for cle_local field
            //
            $column = new TextViewColumn('id_cle', 'LA2', 'Clé (local)', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_d_emprunt field
            //
            $column = new DateTimeViewColumn('date_d_emprunt', 'date_d_emprunt', 'Début emprunt', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Fin d\'emprunt', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddPrintColumn($column);
            
            //
            // View column for depot field
            //
            $column = new NumberViewColumn('depot', 'depot', 'Dépot', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for remboursement_du_depot field
            //
            $column = new NumberViewColumn('remboursement_du_depot', 'remboursement_du_depot', 'Dépot remboursé', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for oui_non field
            //
            $column = new TextViewColumn('archivage', 'LA4', 'Archivage', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for num_bureau field
            //
            $column = new NumberViewColumn('num_bureau', 'num_bureau', 'No. bureau', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for num_formulaire field
            //
            $column = new NumberViewColumn('num_formulaire', 'num_formulaire', 'No. formulaire', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator('');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for otrs field
            //
            $column = new TextViewColumn('otrs', 'otrs', 'No. OTRS', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for nom_complet field
            //
            $column = new TextViewColumn('id_pers', 'LA1', 'Utilisateur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for utilisateur_note field
            //
            $column = new TextViewColumn('utilisateur_note', 'utilisateur_note', 'Note', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for cle_local field
            //
            $column = new TextViewColumn('id_cle', 'LA2', 'Clé (local)', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_d_emprunt field
            //
            $column = new DateTimeViewColumn('date_d_emprunt', 'date_d_emprunt', 'Début emprunt', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddExportColumn($column);
            
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Fin d\'emprunt', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddExportColumn($column);
            
            //
            // View column for depot field
            //
            $column = new NumberViewColumn('depot', 'depot', 'Dépot', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for remboursement_du_depot field
            //
            $column = new NumberViewColumn('remboursement_du_depot', 'remboursement_du_depot', 'Dépot remboursé', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddExportColumn($column);
            
            //
            // View column for oui_non field
            //
            $column = new TextViewColumn('archivage', 'LA4', 'Archivage', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for num_bureau field
            //
            $column = new NumberViewColumn('num_bureau', 'num_bureau', 'No. bureau', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for num_formulaire field
            //
            $column = new NumberViewColumn('num_formulaire', 'num_formulaire', 'No. formulaire', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator('');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for otrs field
            //
            $column = new TextViewColumn('otrs', 'otrs', 'No. OTRS', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for nom_complet field
            //
            $column = new TextViewColumn('id_pers', 'LA1', 'Utilisateur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for utilisateur_note field
            //
            $column = new TextViewColumn('utilisateur_note', 'utilisateur_note', 'Note', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for cle_local field
            //
            $column = new TextViewColumn('id_cle', 'LA2', 'Clé (local)', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_d_emprunt field
            //
            $column = new DateTimeViewColumn('date_d_emprunt', 'date_d_emprunt', 'Début emprunt', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddCompareColumn($column);
            
            //
            // View column for date_de_retour field
            //
            $column = new DateTimeViewColumn('date_de_retour', 'date_de_retour', 'Fin d\'emprunt', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetDateTimeFormat('Y-m-d');
            $grid->AddCompareColumn($column);
            
            //
            // View column for depot field
            //
            $column = new NumberViewColumn('depot', 'depot', 'Dépot', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for remboursement_du_depot field
            //
            $column = new NumberViewColumn('remboursement_du_depot', 'remboursement_du_depot', 'Dépot remboursé', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(4);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('.');
            $grid->AddCompareColumn($column);
            
            //
            // View column for oui_non field
            //
            $column = new TextViewColumn('archivage', 'LA4', 'Archivage', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for num_bureau field
            //
            $column = new NumberViewColumn('num_bureau', 'num_bureau', 'No. bureau', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for num_formulaire field
            //
            $column = new NumberViewColumn('num_formulaire', 'num_formulaire', 'No. formulaire', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator('');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for otrs field
            //
            $column = new TextViewColumn('otrs', 'otrs', 'No. OTRS', $this->dataset);
            $column->setNullLabel('');
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(true);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_cle_departement_scta_cle_emprunt01_id_pers_search', 'id_pers', 'nom_complet', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'select distinct c.id as id_cle,
                 concat (c.num_cle,\'  (\' ,l.no_loc,\')\') as cle_local
            from  administratifs.locals l, cle_departement.cle_cles c
            where c.id_local = l.id_loc';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'cle_local');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_cle', false, true),
                    new StringField('cle_local')
                )
            );
            $lookupDataset->setOrderByField('cle_local', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_cle_departement_scta_cle_emprunt01_id_cle_search', 'id_cle', 'cle_local', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."oui_non"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_oui_non', true, true),
                    new StringField('oui_non')
                )
            );
            $lookupDataset->setOrderByField('oui_non', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_cle_departement_scta_cle_emprunt01_archivage_search', 'id_oui_non', 'oui_non', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_cle_departement_scta_cle_emprunt01_id_pers_search', 'id_pers', 'nom_complet', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_cle_departement_scta_cle_emprunt01_id_pers_search', 'id_pers', 'nom_complet', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'select distinct c.id as id_cle,
                 concat (c.num_cle,\'  (\' ,l.no_loc,\')\') as cle_local
            from  administratifs.locals l, cle_departement.cle_cles c
            where c.id_local = l.id_loc';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'cle_local');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_cle', false, true),
                    new StringField('cle_local')
                )
            );
            $lookupDataset->setOrderByField('cle_local', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_cle_departement_scta_cle_emprunt01_id_cle_search', 'id_cle', 'cle_local', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."oui_non"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_oui_non', true, true),
                    new StringField('oui_non')
                )
            );
            $lookupDataset->setOrderByField('oui_non', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_cle_departement_scta_cle_emprunt01_archivage_search', 'id_oui_non', 'oui_non', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_cle_departement_scta_cle_emprunt01_id_pers_search', 'id_pers', 'nom_complet', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'select distinct c.id as id_cle,
                 concat (c.num_cle,\'  (\' ,l.no_loc,\')\') as cle_local
            from  administratifs.locals l, cle_departement.cle_cles c
            where c.id_local = l.id_loc';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'cle_local');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_cle', false, true),
                    new StringField('cle_local')
                )
            );
            $lookupDataset->setOrderByField('cle_local', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_cle_departement_scta_cle_emprunt01_id_cle_search', 'id_cle', 'cle_local', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."oui_non"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_oui_non', true, true),
                    new StringField('oui_non')
                )
            );
            $lookupDataset->setOrderByField('oui_non', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_cle_departement_scta_cle_emprunt01_archivage_search', 'id_oui_non', 'oui_non', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'select * from (
                        
                        select distinct
                             p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,
                             
                             case when si.sigle_programme <> \'\' then \': \'
                             else \'\'
                             end,
                             si.sigle_programme,\'"  «\', p.courriel,\'» (\',p.code_perm,p.codems,
                             \') [\',p1.prenom,\' \',p1.nom,\']\'
                             
                                  
                             
                             
                             ) nom_complet
                        from   
                            administratifs.personnel p 
                            join administratifs.statut s
                                on s.id_statut=p.id_statut
                           left join administratifs.sigle si
                                on si.num_sigle = p.num_sigle
                           left join administratifs.personnel p1
                                on p1.id_pers=p.id_prof_reponsables
                             
                        ) nomcomplet
            
            /*select * from (
            
            select distinct
                 p.id_pers, concat (\'"\',p.prenom,\' \' ,p.nom,\', \',s.nom_statut,\' \',\'"  «\', 
                 p.courriel,\'» (\',p.code_perm,p.codems,\') [\',p1.prenom,\' \',p1.nom,\']\'
                 
                      
                 
                 
                 ) nom_complet
            from   
                administratifs.personnel p 
                join administratifs.statut s
                    on s.id_statut=p.id_statut */
            /*   left join administratifs.sigle si
                    on si.num_sigle = p.num_sigle */
            /*   left join administratifs.personnel p1
                    on p1.id_pers=p.id_prof_reponsables
                 
            ) nomcomplet
            
            */';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'nomcomplet');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_pers', false, true),
                    new StringField('nom_complet', false, true)
                )
            );
            $lookupDataset->setOrderByField('nom_complet', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_cle_departement_scta_cle_emprunt01_id_pers_search', 'id_pers', 'nom_complet', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'select distinct c.id as id_cle,
                 concat (c.num_cle,\'  (\' ,l.no_loc,\')\') as cle_local
            from  administratifs.locals l, cle_departement.cle_cles c
            where c.id_local = l.id_loc';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              PgConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'cle_local');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_cle', false, true),
                    new StringField('cle_local')
                )
            );
            $lookupDataset->setOrderByField('cle_local', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_cle_departement_scta_cle_emprunt01_id_cle_search', 'id_cle', 'cle_local', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."oui_non"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_oui_non', true, true),
                    new StringField('oui_non')
                )
            );
            $lookupDataset->setOrderByField('oui_non', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_cle_departement_scta_cle_emprunt01_archivage_search', 'id_oui_non', 'oui_non', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }

    SetUpUserAuthorization();

    try
    {
        $Page = new cle_departement_scta_cle_emprunt01Page("cle_departement_scta_cle_emprunt01", "scta_cle_emprunt01.php", GetCurrentUserPermissionsForPage("cle_departement.scta_cle_emprunt01"), 'UTF-8');
        $Page->SetRecordPermission(GetCurrentUserRecordPermissionsForDataSource("cle_departement.scta_cle_emprunt01"));
        GetApplication()->SetMainPage($Page);
        GetApplication()->Run();
    }
    catch(Exception $e)
    {
        ShowErrorPage($e);
    }
	
