<?php
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                   ATTENTION!
 * If you see this message in your browser (Internet Explorer, Mozilla Firefox, Google Chrome, etc.)
 * this means that PHP is not properly installed on your web server. Please refer to the PHP manual
 * for more details: http://php.net/manual/install.php 
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

    include_once dirname(__FILE__) . '/components/startup.php';
    include_once dirname(__FILE__) . '/components/application.php';
    include_once dirname(__FILE__) . '/' . 'authorization.php';


    include_once dirname(__FILE__) . '/' . 'database_engine/pgsql_engine.php';
    include_once dirname(__FILE__) . '/' . 'components/page/page_includes.php';

    function GetConnectionOptions()
    {
        $result = GetGlobalConnectionOptions();
        $result['client_encoding'] = 'utf8';
        GetApplication()->GetUserAuthentication()->applyIdentityToConnectionOptions($result);
        return $result;
    }

    
    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class administratifs_statut_administratifs_personnelPage extends DetailPage
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Personnel');
            $this->SetMenuLabel('Personnel');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $this->dataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $this->dataset->AddLookupField('id_loc', 'administratifs.locals', new IntegerField('id_loc'), new StringField('no_loc', false, false, false, false, 'LA1', 'LT1'), 'LT1');
            $this->dataset->AddLookupField('id_statut', 'administratifs.statut', new IntegerField('id_statut'), new StringField('nom_statut', false, false, false, false, 'LA2', 'LT2'), 'LT2');
            $this->dataset->AddLookupField('id_groupe', 'administratifs.groupe', new IntegerField('id_groupe'), new StringField('nom_groupe', false, false, false, false, 'LA3', 'LT3'), 'LT3');
            $this->dataset->AddLookupField('num_sigle', 'administratifs.sigle', new IntegerField('num_sigle'), new StringField('sigle_programme', false, false, false, false, 'LA4', 'LT4'), 'LT4');
            $this->dataset->AddLookupField('id_prof_reponsables', 'administratifs.personnel', new IntegerField('id_pers'), new StringField('nom', false, false, false, false, 'LA5', 'LT5'), 'LT5');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'nom', 'nom', 'Nom'),
                new FilterColumn($this->dataset, 'prenom', 'prenom', 'Prenom'),
                new FilterColumn($this->dataset, 'no_tel_trav', 'no_tel_trav', 'No Tel Trav'),
                new FilterColumn($this->dataset, 'no_tel_mais', 'no_tel_mais', 'No Tel Mais'),
                new FilterColumn($this->dataset, 'id_loc', 'LA1', 'Id Loc'),
                new FilterColumn($this->dataset, 'id_statut', 'LA2', 'Id Statut'),
                new FilterColumn($this->dataset, 'id_groupe', 'LA3', 'Id Groupe'),
                new FilterColumn($this->dataset, 'sujets', 'sujets', 'Sujets'),
                new FilterColumn($this->dataset, 'id_pers', 'id_pers', 'Id Pers'),
                new FilterColumn($this->dataset, 'num_sigle', 'LA4', 'Num Sigle'),
                new FilterColumn($this->dataset, 'courriel', 'courriel', 'Courriel'),
                new FilterColumn($this->dataset, 'code_perm', 'code_perm', 'Code Perm'),
                new FilterColumn($this->dataset, 'actif', 'actif', 'Actif'),
                new FilterColumn($this->dataset, 'codems', 'codems', 'Codems'),
                new FilterColumn($this->dataset, 'id_prof_reponsables', 'LA5', 'Id Prof Reponsables')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['nom'])
                ->addColumn($columns['prenom'])
                ->addColumn($columns['no_tel_trav'])
                ->addColumn($columns['no_tel_mais'])
                ->addColumn($columns['id_loc'])
                ->addColumn($columns['id_statut'])
                ->addColumn($columns['id_groupe'])
                ->addColumn($columns['sujets'])
                ->addColumn($columns['id_pers'])
                ->addColumn($columns['num_sigle'])
                ->addColumn($columns['courriel'])
                ->addColumn($columns['code_perm'])
                ->addColumn($columns['actif'])
                ->addColumn($columns['codems'])
                ->addColumn($columns['id_prof_reponsables']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('id_loc')
                ->setOptionsFor('id_statut')
                ->setOptionsFor('id_groupe')
                ->setOptionsFor('num_sigle')
                ->setOptionsFor('id_prof_reponsables');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('nom_edit');
            
            $filterBuilder->addColumn(
                $columns['nom'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('prenom_edit');
            $main_editor->SetMaxLength(30);
            
            $filterBuilder->addColumn(
                $columns['prenom'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_tel_trav');
            
            $filterBuilder->addColumn(
                $columns['no_tel_trav'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('no_tel_mais');
            
            $filterBuilder->addColumn(
                $columns['no_tel_mais'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_statut_administratifs_personnel_id_loc_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_loc', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_statut_administratifs_personnel_id_loc_search');
            
            $text_editor = new TextEdit('id_loc');
            
            $filterBuilder->addColumn(
                $columns['id_loc'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_statut_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_statut_administratifs_personnel_id_statut_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_statut', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_statut_administratifs_personnel_id_statut_search');
            
            $text_editor = new TextEdit('id_statut');
            
            $filterBuilder->addColumn(
                $columns['id_statut'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_groupe_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_statut_administratifs_personnel_id_groupe_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_groupe', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_statut_administratifs_personnel_id_groupe_search');
            
            $text_editor = new TextEdit('id_groupe');
            
            $filterBuilder->addColumn(
                $columns['id_groupe'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('sujets');
            
            $filterBuilder->addColumn(
                $columns['sujets'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('id_pers_edit');
            
            $filterBuilder->addColumn(
                $columns['id_pers'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('num_sigle_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_statut_administratifs_personnel_num_sigle_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('num_sigle', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_statut_administratifs_personnel_num_sigle_search');
            
            $filterBuilder->addColumn(
                $columns['num_sigle'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('courriel');
            
            $filterBuilder->addColumn(
                $columns['courriel'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('code_perm_edit');
            $main_editor->SetMaxLength(30);
            
            $filterBuilder->addColumn(
                $columns['code_perm'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('actif_edit');
            
            $filterBuilder->addColumn(
                $columns['actif'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('codems');
            
            $filterBuilder->addColumn(
                $columns['codems'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('id_prof_reponsables_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_administratifs_statut_administratifs_personnel_id_prof_reponsables_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('id_prof_reponsables', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_administratifs_statut_administratifs_personnel_id_prof_reponsables_search');
            
            $text_editor = new TextEdit('id_prof_reponsables');
            
            $filterBuilder->addColumn(
                $columns['id_prof_reponsables'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('nom', 'nom', 'Nom', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for prenom field
            //
            $column = new TextViewColumn('prenom', 'prenom', 'Prenom', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_tel_trav field
            //
            $column = new TextViewColumn('no_tel_trav', 'no_tel_trav', 'No Tel Trav', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_tel_mais field
            //
            $column = new TextViewColumn('no_tel_mais', 'no_tel_mais', 'No Tel Mais', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom_statut field
            //
            $column = new TextViewColumn('id_statut', 'LA2', 'Id Statut', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'LA3', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for sujets field
            //
            $column = new TextViewColumn('sujets', 'sujets', 'Sujets', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for sigle_programme field
            //
            $column = new NumberViewColumn('num_sigle', 'LA4', 'Num Sigle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for courriel field
            //
            $column = new TextViewColumn('courriel', 'courriel', 'Courriel', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for code_perm field
            //
            $column = new TextViewColumn('code_perm', 'code_perm', 'Code Perm', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for actif field
            //
            $column = new NumberViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for codems field
            //
            $column = new TextViewColumn('codems', 'codems', 'Codems', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_prof_reponsables', 'LA5', 'Id Prof Reponsables', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('nom', 'nom', 'Nom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for prenom field
            //
            $column = new TextViewColumn('prenom', 'prenom', 'Prenom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_tel_trav field
            //
            $column = new TextViewColumn('no_tel_trav', 'no_tel_trav', 'No Tel Trav', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_tel_mais field
            //
            $column = new TextViewColumn('no_tel_mais', 'no_tel_mais', 'No Tel Mais', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom_statut field
            //
            $column = new TextViewColumn('id_statut', 'LA2', 'Id Statut', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'LA3', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for sujets field
            //
            $column = new TextViewColumn('sujets', 'sujets', 'Sujets', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for sigle_programme field
            //
            $column = new NumberViewColumn('num_sigle', 'LA4', 'Num Sigle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for courriel field
            //
            $column = new TextViewColumn('courriel', 'courriel', 'Courriel', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for code_perm field
            //
            $column = new TextViewColumn('code_perm', 'code_perm', 'Code Perm', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for actif field
            //
            $column = new NumberViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for codems field
            //
            $column = new TextViewColumn('codems', 'codems', 'Codems', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_prof_reponsables', 'LA5', 'Id Prof Reponsables', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for nom field
            //
            $editor = new TextEdit('nom_edit');
            $editColumn = new CustomEditColumn('Nom', 'nom', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for prenom field
            //
            $editor = new TextEdit('prenom_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Prenom', 'prenom', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_tel_trav field
            //
            $editor = new TextAreaEdit('no_tel_trav_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Tel Trav', 'no_tel_trav', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for no_tel_mais field
            //
            $editor = new TextAreaEdit('no_tel_mais_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Tel Mais', 'no_tel_mais', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'edit_administratifs_statut_administratifs_personnel_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_statut field
            //
            $editor = new DynamicCombobox('id_statut_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."statut"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_statut', true, true, true),
                    new StringField('nom_statut', true)
                )
            );
            $lookupDataset->setOrderByField('nom_statut', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Statut', 'id_statut', 'LA2', 'edit_administratifs_statut_administratifs_personnel_id_statut_search', $editor, $this->dataset, $lookupDataset, 'id_statut', 'nom_statut', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_groupe field
            //
            $editor = new DynamicCombobox('id_groupe_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Groupe', 'id_groupe', 'LA3', 'edit_administratifs_statut_administratifs_personnel_id_groupe_search', $editor, $this->dataset, $lookupDataset, 'id_groupe', 'nom_groupe', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for sujets field
            //
            $editor = new TextAreaEdit('sujets_edit', 50, 8);
            $editColumn = new CustomEditColumn('Sujets', 'sujets', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for num_sigle field
            //
            $editor = new DynamicCombobox('num_sigle_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Num Sigle', 'num_sigle', 'LA4', 'edit_administratifs_statut_administratifs_personnel_num_sigle_search', $editor, $this->dataset, $lookupDataset, 'num_sigle', 'sigle_programme', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for courriel field
            //
            $editor = new TextAreaEdit('courriel_edit', 50, 8);
            $editColumn = new CustomEditColumn('Courriel', 'courriel', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for code_perm field
            //
            $editor = new TextEdit('code_perm_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Code Perm', 'code_perm', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for actif field
            //
            $editor = new TextEdit('actif_edit');
            $editColumn = new CustomEditColumn('Actif', 'actif', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for codems field
            //
            $editor = new TextAreaEdit('codems_edit', 50, 8);
            $editColumn = new CustomEditColumn('Codems', 'codems', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for id_prof_reponsables field
            //
            $editor = new DynamicCombobox('id_prof_reponsables_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Prof Reponsables', 'id_prof_reponsables', 'LA5', 'edit_administratifs_statut_administratifs_personnel_id_prof_reponsables_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for nom field
            //
            $editor = new TextEdit('nom_edit');
            $editColumn = new CustomEditColumn('Nom', 'nom', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for prenom field
            //
            $editor = new TextEdit('prenom_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Prenom', 'prenom', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_tel_trav field
            //
            $editor = new TextAreaEdit('no_tel_trav_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Tel Trav', 'no_tel_trav', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for no_tel_mais field
            //
            $editor = new TextAreaEdit('no_tel_mais_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Tel Mais', 'no_tel_mais', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'multi_edit_administratifs_statut_administratifs_personnel_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_statut field
            //
            $editor = new DynamicCombobox('id_statut_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."statut"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_statut', true, true, true),
                    new StringField('nom_statut', true)
                )
            );
            $lookupDataset->setOrderByField('nom_statut', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Statut', 'id_statut', 'LA2', 'multi_edit_administratifs_statut_administratifs_personnel_id_statut_search', $editor, $this->dataset, $lookupDataset, 'id_statut', 'nom_statut', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_groupe field
            //
            $editor = new DynamicCombobox('id_groupe_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Groupe', 'id_groupe', 'LA3', 'multi_edit_administratifs_statut_administratifs_personnel_id_groupe_search', $editor, $this->dataset, $lookupDataset, 'id_groupe', 'nom_groupe', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for sujets field
            //
            $editor = new TextAreaEdit('sujets_edit', 50, 8);
            $editColumn = new CustomEditColumn('Sujets', 'sujets', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for num_sigle field
            //
            $editor = new DynamicCombobox('num_sigle_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Num Sigle', 'num_sigle', 'LA4', 'multi_edit_administratifs_statut_administratifs_personnel_num_sigle_search', $editor, $this->dataset, $lookupDataset, 'num_sigle', 'sigle_programme', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for courriel field
            //
            $editor = new TextAreaEdit('courriel_edit', 50, 8);
            $editColumn = new CustomEditColumn('Courriel', 'courriel', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for code_perm field
            //
            $editor = new TextEdit('code_perm_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Code Perm', 'code_perm', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for actif field
            //
            $editor = new TextEdit('actif_edit');
            $editColumn = new CustomEditColumn('Actif', 'actif', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for codems field
            //
            $editor = new TextAreaEdit('codems_edit', 50, 8);
            $editColumn = new CustomEditColumn('Codems', 'codems', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for id_prof_reponsables field
            //
            $editor = new DynamicCombobox('id_prof_reponsables_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Prof Reponsables', 'id_prof_reponsables', 'LA5', 'multi_edit_administratifs_statut_administratifs_personnel_id_prof_reponsables_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for nom field
            //
            $editor = new TextEdit('nom_edit');
            $editColumn = new CustomEditColumn('Nom', 'nom', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for prenom field
            //
            $editor = new TextEdit('prenom_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Prenom', 'prenom', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_tel_trav field
            //
            $editor = new TextAreaEdit('no_tel_trav_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Tel Trav', 'no_tel_trav', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for no_tel_mais field
            //
            $editor = new TextAreaEdit('no_tel_mais_edit', 50, 8);
            $editColumn = new CustomEditColumn('No Tel Mais', 'no_tel_mais', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_loc field
            //
            $editor = new DynamicCombobox('id_loc_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Loc', 'id_loc', 'LA1', 'insert_administratifs_statut_administratifs_personnel_id_loc_search', $editor, $this->dataset, $lookupDataset, 'id_loc', 'no_loc', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_statut field
            //
            $editor = new DynamicCombobox('id_statut_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."statut"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_statut', true, true, true),
                    new StringField('nom_statut', true)
                )
            );
            $lookupDataset->setOrderByField('nom_statut', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Statut', 'id_statut', 'LA2', 'insert_administratifs_statut_administratifs_personnel_id_statut_search', $editor, $this->dataset, $lookupDataset, 'id_statut', 'nom_statut', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_groupe field
            //
            $editor = new DynamicCombobox('id_groupe_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Groupe', 'id_groupe', 'LA3', 'insert_administratifs_statut_administratifs_personnel_id_groupe_search', $editor, $this->dataset, $lookupDataset, 'id_groupe', 'nom_groupe', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for sujets field
            //
            $editor = new TextAreaEdit('sujets_edit', 50, 8);
            $editColumn = new CustomEditColumn('Sujets', 'sujets', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for num_sigle field
            //
            $editor = new DynamicCombobox('num_sigle_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Num Sigle', 'num_sigle', 'LA4', 'insert_administratifs_statut_administratifs_personnel_num_sigle_search', $editor, $this->dataset, $lookupDataset, 'num_sigle', 'sigle_programme', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for courriel field
            //
            $editor = new TextAreaEdit('courriel_edit', 50, 8);
            $editColumn = new CustomEditColumn('Courriel', 'courriel', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for code_perm field
            //
            $editor = new TextEdit('code_perm_edit');
            $editor->SetMaxLength(30);
            $editColumn = new CustomEditColumn('Code Perm', 'code_perm', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for actif field
            //
            $editor = new TextEdit('actif_edit');
            $editColumn = new CustomEditColumn('Actif', 'actif', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for codems field
            //
            $editor = new TextAreaEdit('codems_edit', 50, 8);
            $editColumn = new CustomEditColumn('Codems', 'codems', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for id_prof_reponsables field
            //
            $editor = new DynamicCombobox('id_prof_reponsables_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Id Prof Reponsables', 'id_prof_reponsables', 'LA5', 'insert_administratifs_statut_administratifs_personnel_id_prof_reponsables_search', $editor, $this->dataset, $lookupDataset, 'id_pers', 'nom', '');
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('nom', 'nom', 'Nom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for prenom field
            //
            $column = new TextViewColumn('prenom', 'prenom', 'Prenom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_tel_trav field
            //
            $column = new TextViewColumn('no_tel_trav', 'no_tel_trav', 'No Tel Trav', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_tel_mais field
            //
            $column = new TextViewColumn('no_tel_mais', 'no_tel_mais', 'No Tel Mais', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom_statut field
            //
            $column = new TextViewColumn('id_statut', 'LA2', 'Id Statut', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'LA3', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for sujets field
            //
            $column = new TextViewColumn('sujets', 'sujets', 'Sujets', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for sigle_programme field
            //
            $column = new NumberViewColumn('num_sigle', 'LA4', 'Num Sigle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for courriel field
            //
            $column = new TextViewColumn('courriel', 'courriel', 'Courriel', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for code_perm field
            //
            $column = new TextViewColumn('code_perm', 'code_perm', 'Code Perm', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for actif field
            //
            $column = new NumberViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for codems field
            //
            $column = new TextViewColumn('codems', 'codems', 'Codems', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_prof_reponsables', 'LA5', 'Id Prof Reponsables', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('nom', 'nom', 'Nom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for prenom field
            //
            $column = new TextViewColumn('prenom', 'prenom', 'Prenom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_tel_trav field
            //
            $column = new TextViewColumn('no_tel_trav', 'no_tel_trav', 'No Tel Trav', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_tel_mais field
            //
            $column = new TextViewColumn('no_tel_mais', 'no_tel_mais', 'No Tel Mais', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom_statut field
            //
            $column = new TextViewColumn('id_statut', 'LA2', 'Id Statut', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'LA3', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for sujets field
            //
            $column = new TextViewColumn('sujets', 'sujets', 'Sujets', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for id_pers field
            //
            $column = new NumberViewColumn('id_pers', 'id_pers', 'Id Pers', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for sigle_programme field
            //
            $column = new NumberViewColumn('num_sigle', 'LA4', 'Num Sigle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for courriel field
            //
            $column = new TextViewColumn('courriel', 'courriel', 'Courriel', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for code_perm field
            //
            $column = new TextViewColumn('code_perm', 'code_perm', 'Code Perm', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for actif field
            //
            $column = new NumberViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for codems field
            //
            $column = new TextViewColumn('codems', 'codems', 'Codems', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_prof_reponsables', 'LA5', 'Id Prof Reponsables', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('nom', 'nom', 'Nom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for prenom field
            //
            $column = new TextViewColumn('prenom', 'prenom', 'Prenom', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_tel_trav field
            //
            $column = new TextViewColumn('no_tel_trav', 'no_tel_trav', 'No Tel Trav', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_tel_mais field
            //
            $column = new TextViewColumn('no_tel_mais', 'no_tel_mais', 'No Tel Mais', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for no_loc field
            //
            $column = new TextViewColumn('id_loc', 'LA1', 'Id Loc', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom_statut field
            //
            $column = new TextViewColumn('id_statut', 'LA2', 'Id Statut', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom_groupe field
            //
            $column = new TextViewColumn('id_groupe', 'LA3', 'Id Groupe', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for sujets field
            //
            $column = new TextViewColumn('sujets', 'sujets', 'Sujets', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for sigle_programme field
            //
            $column = new NumberViewColumn('num_sigle', 'LA4', 'Num Sigle', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for courriel field
            //
            $column = new TextViewColumn('courriel', 'courriel', 'Courriel', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for code_perm field
            //
            $column = new TextViewColumn('code_perm', 'code_perm', 'Code Perm', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for actif field
            //
            $column = new NumberViewColumn('actif', 'actif', 'Actif', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for codems field
            //
            $column = new TextViewColumn('codems', 'codems', 'Codems', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $grid->AddCompareColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('id_prof_reponsables', 'LA5', 'Id Prof Reponsables', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(true);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_statut_administratifs_personnel_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."statut"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_statut', true, true, true),
                    new StringField('nom_statut', true)
                )
            );
            $lookupDataset->setOrderByField('nom_statut', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_statut_administratifs_personnel_id_statut_search', 'id_statut', 'nom_statut', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_statut_administratifs_personnel_id_groupe_search', 'id_groupe', 'nom_groupe', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_statut_administratifs_personnel_num_sigle_search', 'num_sigle', 'sigle_programme', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_administratifs_statut_administratifs_personnel_id_prof_reponsables_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_statut_administratifs_personnel_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."statut"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_statut', true, true, true),
                    new StringField('nom_statut', true)
                )
            );
            $lookupDataset->setOrderByField('nom_statut', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_statut_administratifs_personnel_id_statut_search', 'id_statut', 'nom_statut', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_statut_administratifs_personnel_id_groupe_search', 'id_groupe', 'nom_groupe', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_statut_administratifs_personnel_id_groupe_search', 'id_groupe', 'nom_groupe', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_statut_administratifs_personnel_num_sigle_search', 'num_sigle', 'sigle_programme', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_statut_administratifs_personnel_num_sigle_search', 'num_sigle', 'sigle_programme', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_administratifs_statut_administratifs_personnel_id_prof_reponsables_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_statut_administratifs_personnel_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."statut"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_statut', true, true, true),
                    new StringField('nom_statut', true)
                )
            );
            $lookupDataset->setOrderByField('nom_statut', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_statut_administratifs_personnel_id_statut_search', 'id_statut', 'nom_statut', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_statut_administratifs_personnel_id_groupe_search', 'id_groupe', 'nom_groupe', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_statut_administratifs_personnel_num_sigle_search', 'num_sigle', 'sigle_programme', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_administratifs_statut_administratifs_personnel_id_prof_reponsables_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."locals"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_loc', true, true, true),
                    new StringField('no_loc', true),
                    new StringField('unite'),
                    new IntegerField('sup_plan'),
                    new IntegerField('no_plc_tot'),
                    new IntegerField('no_plc_dsp'),
                    new IntegerField('no_plc_occ'),
                    new StringField('fonction'),
                    new StringField('type_lab'),
                    new StringField('util_lab'),
                    new IntegerField('id_resp'),
                    new StringField('nom_loc'),
                    new StringField('nom_resp'),
                    new StringField('type_occ'),
                    new IntegerField('taux_occ'),
                    new StringField('geom'),
                    new StringField('description')
                )
            );
            $lookupDataset->setOrderByField('no_loc', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_statut_administratifs_personnel_id_loc_search', 'id_loc', 'no_loc', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."statut"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_statut', true, true, true),
                    new StringField('nom_statut', true)
                )
            );
            $lookupDataset->setOrderByField('nom_statut', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_statut_administratifs_personnel_id_statut_search', 'id_statut', 'nom_statut', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."groupe"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('id_groupe', true, true),
                    new StringField('nom_groupe'),
                    new StringField('droit'),
                    new StringField('lien1'),
                    new StringField('lien2'),
                    new StringField('lien3'),
                    new StringField('lien4'),
                    new StringField('lien5'),
                    new StringField('lien6'),
                    new StringField('lien7')
                )
            );
            $lookupDataset->setOrderByField('nom_groupe', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_statut_administratifs_personnel_id_groupe_search', 'id_groupe', 'nom_groupe', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."sigle"');
            $lookupDataset->addFields(
                array(
                    new IntegerField('num_sigle', true, true, true),
                    new StringField('sigle_programme'),
                    new StringField('descriptif', true)
                )
            );
            $lookupDataset->setOrderByField('sigle_programme', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_statut_administratifs_personnel_num_sigle_search', 'num_sigle', 'sigle_programme', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."personnel"');
            $lookupDataset->addFields(
                array(
                    new StringField('nom', true),
                    new StringField('prenom', true),
                    new StringField('no_tel_trav'),
                    new StringField('no_tel_mais'),
                    new IntegerField('id_loc'),
                    new IntegerField('id_statut'),
                    new IntegerField('id_groupe'),
                    new StringField('sujets'),
                    new IntegerField('id_pers', true, true, true),
                    new IntegerField('num_sigle'),
                    new StringField('courriel'),
                    new StringField('code_perm'),
                    new IntegerField('actif'),
                    new StringField('codems'),
                    new IntegerField('id_prof_reponsables')
                )
            );
            $lookupDataset->setOrderByField('nom', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_administratifs_statut_administratifs_personnel_id_prof_reponsables_search', 'id_pers', 'nom', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }
    
    // OnBeforePageExecute event handler
    
    
    
    class administratifs_statutPage extends Page
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Statut');
            $this->SetMenuLabel('Statut');
    
            $this->dataset = new TableDataset(
                PgConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '"administratifs"."statut"');
            $this->dataset->addFields(
                array(
                    new IntegerField('id_statut', true, true, true),
                    new StringField('nom_statut', true)
                )
            );
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'id_statut', 'id_statut', 'Id Statut'),
                new FilterColumn($this->dataset, 'nom_statut', 'nom_statut', 'Nom Statut')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['nom_statut']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new TextEdit('nom_statut_edit');
            $main_editor->SetMaxLength(60);
            
            $filterBuilder->addColumn(
                $columns['nom_statut'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            if (GetCurrentUserPermissionsForPage('administratifs.statut.administratifs.personnel')->HasViewGrant() && $withDetails)
            {
            //
            // View column for administratifs_statut_administratifs_personnel detail
            //
            $column = new DetailColumn(array('id_statut'), 'administratifs.statut.administratifs.personnel', 'administratifs_statut_administratifs_personnel_handler', $this->dataset, 'Personnel');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            }
            
            //
            // View column for nom_statut field
            //
            $column = new TextViewColumn('nom_statut', 'nom_statut', 'Nom Statut', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for nom_statut field
            //
            $column = new TextViewColumn('nom_statut', 'nom_statut', 'Nom Statut', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for nom_statut field
            //
            $editor = new TextEdit('nom_statut_edit');
            $editor->SetMaxLength(60);
            $editColumn = new CustomEditColumn('Nom Statut', 'nom_statut', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for nom_statut field
            //
            $editor = new TextEdit('nom_statut_edit');
            $editor->SetMaxLength(60);
            $editColumn = new CustomEditColumn('Nom Statut', 'nom_statut', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for nom_statut field
            //
            $editor = new TextEdit('nom_statut_edit');
            $editor->SetMaxLength(60);
            $editColumn = new CustomEditColumn('Nom Statut', 'nom_statut', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for nom_statut field
            //
            $column = new TextViewColumn('nom_statut', 'nom_statut', 'Nom Statut', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for nom_statut field
            //
            $column = new TextViewColumn('nom_statut', 'nom_statut', 'Nom Statut', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for nom_statut field
            //
            $column = new TextViewColumn('nom_statut', 'nom_statut', 'Nom Statut', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function CreateMasterDetailRecordGrid()
        {
            $result = new Grid($this, $this->dataset);
            
            $this->AddFieldColumns($result, false);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            
            $result->SetAllowDeleteSelected(false);
            $result->SetShowUpdateLink(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(false);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $this->setupGridColumnGroup($result);
            $this->attachGridEventHandlers($result);
            
            return $result;
        }
        
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(true);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(false);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $detailPage = new administratifs_statut_administratifs_personnelPage('administratifs_statut_administratifs_personnel', $this, array('id_statut'), array('id_statut'), $this->GetForeignKeyFields(), $this->CreateMasterDetailRecordGrid(), $this->dataset, GetCurrentUserPermissionsForPage('administratifs.statut.administratifs.personnel'), 'UTF-8');
            $detailPage->SetRecordPermission(GetCurrentUserRecordPermissionsForDataSource('administratifs.statut.administratifs.personnel'));
            $detailPage->SetHttpHandlerName('administratifs_statut_administratifs_personnel_handler');
            $handler = new PageHTTPHandler('administratifs_statut_administratifs_personnel_handler', $detailPage);
            GetApplication()->RegisterHTTPHandler($handler);
            
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }

    SetUpUserAuthorization();

    try
    {
        $Page = new administratifs_statutPage("administratifs_statut", "statut.php", GetCurrentUserPermissionsForPage("administratifs.statut"), 'UTF-8');
        $Page->SetRecordPermission(GetCurrentUserRecordPermissionsForDataSource("administratifs.statut"));
        GetApplication()->SetMainPage($Page);
        GetApplication()->Run();
    }
    catch(Exception $e)
    {
        ShowErrorPage($e);
    }
	
